/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.realm;

import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import org.apache.catalina.realm.X509UsernameRetriever;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class X509SubjectThumbprintRetriever
implements X509UsernameRetriever {
    private static final Log log = LogFactory.getLog(X509SubjectThumbprintRetriever.class);

    public String getUsername(X509Certificate clientCert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = clientCert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            return this.hexify(digest);
        }
        catch (Exception e) {
            log.error((Object)("Could not get thumbprint from certificate: " + e.getMessage()));
            return null;
        }
    }

    public String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }
}

