/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.realm;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.JNDIRealm;

public class JNDIRealm
extends org.apache.catalina.realm.JNDIRealm {
    protected String userAccountName = null;
    protected String usernameSuffix = null;

    public String getUserAccountName() {
        return this.userAccountName;
    }

    public void setUserAccountName(String userAccountName) {
        this.userAccountName = userAccountName;
    }

    public String setUsernameSuffix() {
        return this.usernameSuffix;
    }

    public void setUsernameSuffix(String usernameSuffix) {
        this.usernameSuffix = usernameSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(JNDIRealm.JNDIConnection connection, String username, String credentials) throws NamingException {
        if (username == null || username.equals("") || credentials == null || credentials.equals("")) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"username null or empty: returning null principal.");
            }
            return null;
        }
        ClassLoader ocl = null;
        try {
            if (!this.isUseContextClassLoader()) {
                ocl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            }
            if (this.userPatternArray != null) {
                for (int curUserPattern = 0; curUserPattern < this.userPatternArray.length; ++curUserPattern) {
                    JNDIRealm.User user2 = this.getUser(connection, username, credentials, curUserPattern);
                    if (user2 == null) continue;
                    try {
                        if (!this.checkCredentials(connection.context, user2, credentials)) continue;
                        List roles = this.getRoles(connection, user2);
                        if (this.containerLog.isDebugEnabled()) {
                            this.containerLog.debug((Object)("Found roles: " + roles.toString()));
                        }
                        GenericPrincipal genericPrincipal = new GenericPrincipal(user2.getUserName(), credentials, roles);
                        return genericPrincipal;
                    }
                    catch (InvalidNameException ine) {
                        this.containerLog.warn((Object)sm.getString("jndiRealm.exception"), (Throwable)ine);
                    }
                }
                Principal curUserPattern = null;
                return curUserPattern;
            }
            JNDIRealm.User user = this.getUser(connection, username, credentials);
            if (user == null) {
                Principal user2 = null;
                return user2;
            }
            if (!this.checkCredentials(connection.context, user, credentials)) {
                Principal user2 = null;
                return user2;
            }
            List roles = this.getRoles(connection, user);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("Found roles: " + roles.toString()));
            }
            GenericPrincipal genericPrincipal = new GenericPrincipal(user.getUserName(), credentials, roles);
            return genericPrincipal;
        }
        finally {
            if (!this.isUseContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(ocl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JNDIRealm.User getUser(JNDIRealm.JNDIConnection connection, String username, String credentials, int curUserPattern) throws NamingException {
        JNDIRealm.User user = null;
        ArrayList<String> list = new ArrayList<String>();
        if (this.userPassword != null) {
            list.add(this.userPassword);
        }
        if (this.userRoleName != null) {
            list.add(this.userRoleName);
        }
        if (this.userRoleAttribute != null) {
            list.add(this.userRoleAttribute);
        }
        if (this.userAccountName != null) {
            list.add(this.userAccountName);
        }
        String[] attrIds = new String[list.size()];
        list.toArray(attrIds);
        if (this.userPatternArray != null && curUserPattern >= 0) {
            user = this.getUserByPattern(connection, username, credentials, attrIds, curUserPattern);
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("Found user by pattern [" + user + "]"));
            }
        } else {
            boolean thisUserSearchAsUser = this.isUserSearchAsUser();
            try {
                if (thisUserSearchAsUser) {
                    this.userCredentialsAdd(connection.context, username, credentials);
                }
                user = this.getUserBySearch(connection, username, attrIds);
            }
            finally {
                if (thisUserSearchAsUser) {
                    this.userCredentialsRemove(connection.context);
                }
            }
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("Found user by search [" + user + "]"));
            }
        }
        if (this.userPassword == null && credentials != null && user != null) {
            return new JNDIRealm.User(user.getUserName(), user.getDN(), credentials, user.getRoles(), user.getUserRoleId());
        }
        return user;
    }

    protected JNDIRealm.User getUserByPattern(DirContext context, String username, String[] attrIds, String dn) throws NamingException {
        String accountName;
        if (attrIds == null || attrIds.length == 0) {
            if (this.usernameSuffix != null) {
                username = username + this.usernameSuffix;
            }
            return new JNDIRealm.User(username, dn, null, null, null);
        }
        Attributes attrs = null;
        try {
            attrs = context.getAttributes(dn, attrIds);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        if (attrs == null) {
            return null;
        }
        if (this.userAccountName != null && (accountName = this.getAttributeValue(this.userAccountName, attrs)) != null) {
            username = accountName;
        }
        if (this.usernameSuffix != null) {
            username = username + this.usernameSuffix;
        }
        String password = null;
        if (this.userPassword != null) {
            password = this.getAttributeValue(this.userPassword, attrs);
        }
        String userRoleAttrValue = null;
        if (this.userRoleAttribute != null) {
            userRoleAttrValue = this.getAttributeValue(this.userRoleAttribute, attrs);
        }
        ArrayList<String> roles = null;
        if (this.userRoleName != null) {
            roles = this.addAttributeValues(this.userRoleName, attrs, roles);
        }
        return new JNDIRealm.User(username, dn, password, roles, userRoleAttrValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JNDIRealm.User getUserBySearch(JNDIRealm.JNDIConnection connection, String username, String[] attrIds) throws NamingException {
        String accountName;
        Attributes attrs;
        SearchResult result;
        if (username == null) return null;
        if (connection.userSearchFormat == null) {
            return null;
        }
        String filter = connection.userSearchFormat.format(new String[]{this.doFilterEscaping(username)});
        SearchControls constraints = new SearchControls();
        if (this.userSubtree) {
            constraints.setSearchScope(2);
        } else {
            constraints.setSearchScope(1);
        }
        constraints.setCountLimit(this.sizeLimit);
        constraints.setTimeLimit(this.timeLimit);
        if (attrIds == null) {
            attrIds = new String[]{};
        }
        constraints.setReturningAttributes(attrIds);
        NamingEnumeration<SearchResult> results = connection.context.search(this.userBase, filter, constraints);
        try {
            if (results == null || !results.hasMore()) {
                JNDIRealm.User user = null;
                return user;
            }
            result = results.next();
            try {
                if (results.hasMore()) {
                    if (this.containerLog.isInfoEnabled()) {
                        this.containerLog.info((Object)sm.getString("jndiRealm.multipleEntries", new Object[]{username}));
                    }
                    JNDIRealm.User user = null;
                    return user;
                }
            }
            catch (PartialResultException ex) {
                if (!this.adCompat) {
                    throw ex;
                }
            }
        }
        catch (PartialResultException ex) {
            if (!this.adCompat) {
                throw ex;
            }
            JNDIRealm.User user = null;
            return user;
        }
        String dn = this.getDistinguishedName(connection.context, this.userBase, result);
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  entry found for " + username + " with dn " + dn));
        }
        if ((attrs = result.getAttributes()) == null) {
            return null;
        }
        if (this.userAccountName != null && (accountName = this.getAttributeValue(this.userAccountName, attrs)) != null) {
            username = accountName;
        }
        if (this.usernameSuffix != null) {
            username = username + this.usernameSuffix;
        }
        String password = null;
        if (this.userPassword != null) {
            password = this.getAttributeValue(this.userPassword, attrs);
        }
        String userRoleAttrValue = null;
        if (this.userRoleAttribute != null) {
            userRoleAttrValue = this.getAttributeValue(this.userRoleAttribute, attrs);
        }
        ArrayList<String> roles = null;
        if (this.userRoleName == null) return new JNDIRealm.User(username, dn, password, roles, userRoleAttrValue);
        roles = this.addAttributeValues(this.userRoleName, attrs, roles);
        return new JNDIRealm.User(username, dn, password, roles, userRoleAttrValue);
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    private void userCredentialsAdd(DirContext context, String dn, String credentials) throws NamingException {
        context.addToEnvironment("java.naming.security.principal", dn);
        context.addToEnvironment("java.naming.security.credentials", credentials);
    }

    private void userCredentialsRemove(DirContext context) throws NamingException {
        if (this.connectionName != null) {
            context.addToEnvironment("java.naming.security.principal", this.connectionName);
        } else {
            context.removeFromEnvironment("java.naming.security.principal");
        }
        if (this.connectionPassword != null) {
            context.addToEnvironment("java.naming.security.credentials", this.connectionPassword);
        } else {
            context.removeFromEnvironment("java.naming.security.credentials");
        }
    }

    private String getAttributeValue(String attrId, Attributes attrs) throws NamingException {
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)("  retrieving attribute " + attrId));
        }
        if (attrId == null || attrs == null) {
            return null;
        }
        Attribute attr = attrs.get(attrId);
        if (attr == null) {
            return null;
        }
        Object value = attr.get();
        if (value == null) {
            return null;
        }
        String valueString = null;
        valueString = value instanceof byte[] ? new String((byte[])value) : value.toString();
        return valueString;
    }

    private ArrayList<String> addAttributeValues(String attrId, Attributes attrs, ArrayList<String> values) throws NamingException {
        block7: {
            Attribute attr;
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)("  retrieving values for attribute " + attrId));
            }
            if (attrId == null || attrs == null) {
                return values;
            }
            if (values == null) {
                values = new ArrayList();
            }
            if ((attr = attrs.get(attrId)) == null) {
                return values;
            }
            NamingEnumeration<?> e = attr.getAll();
            try {
                while (e.hasMore()) {
                    String value = (String)e.next();
                    values.add(value);
                }
            }
            catch (PartialResultException ex) {
                if (this.adCompat) break block7;
                throw ex;
            }
        }
        return values;
    }
}

