/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.realm;

import com.sas.vfabrictcsvr.realm.KerberosPrincipal;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.realm.RealmBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public class GSSContextEstablishedRealm
extends RealmBase {
    private static final Log log = LogFactory.getLog(GSSContextEstablishedRealm.class);
    protected List<String> roles = null;

    public void setCommonRole(String commonRole) {
        ArrayList<String> roles = new ArrayList<String>();
        if (commonRole != null) {
            roles.add(commonRole);
        }
    }

    protected String getName() {
        return "GSSContextEstablishedRealm";
    }

    public Principal authenticate(GSSContext gssContext, boolean storeCred) {
        if (gssContext.isEstablished()) {
            GSSName gssName = null;
            try {
                gssName = gssContext.getSrcName();
            }
            catch (GSSException e) {
                log.warn((Object)sm.getString("realmBase.gssNameFail"), (Throwable)e);
            }
            if (gssName != null) {
                GSSCredential gssCredential;
                String name;
                block8: {
                    int i;
                    name = gssName.toString();
                    if (this.isStripRealmForGss() && (i = name.indexOf(64)) > 0) {
                        name = name.substring(0, i);
                    }
                    gssCredential = null;
                    if (storeCred && gssContext.getCredDelegState()) {
                        try {
                            gssCredential = gssContext.getDelegCred();
                        }
                        catch (GSSException e) {
                            if (!log.isDebugEnabled()) break block8;
                            log.debug((Object)sm.getString("realmBase.delegatedCredentialFail", new Object[]{name}), (Throwable)e);
                        }
                    }
                }
                return new KerberosPrincipal(name, null, this.roles, null, null, gssCredential, null);
            }
        }
        return null;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }
}

