/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.execution;

import com.sas.vfabrictcsvr.execution.ExecutionInterface;
import com.sas.vfabrictcsvr.execution.ServerConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerProcess {
    private static Logger logger = LogManager.getLogger(ServerProcess.class);
    private String osname = null;
    private OSType ostype = OSType.OS_TYPE_UNKNOWN;
    private final int PROCESS_CONTROL_SUCCESS = 0;
    private final int PROCESS_CONTROL_ERROR = -1;
    protected static final int PROCESS_EXISTS = 10;
    protected static final int PROCESS_DOES_NOT_EXIST = 20;
    protected static final int DEFAULT_SECONDS_WAIT_SERVER_START = 600;
    protected static final int DEFAULT_SECONDS_WAIT_SERVER_STOP = 600;

    public ServerProcess() throws RuntimeException {
        this.setOSType();
        if (this.ostype == OSType.OS_TYPE_UNKNOWN) {
            throw new RuntimeException("Operating system type (" + (Object)((Object)this.ostype) + ") is unknown or unsupported");
        }
        logger.debug("OS name is " + this.osname + " (" + (Object)((Object)this.ostype) + ")");
    }

    private void setOSType() {
        logger.trace("setOSType >>>");
        this.osname = System.getProperty("os.name");
        String osnamelc = this.osname.toLowerCase();
        if (osnamelc.indexOf("win") >= 0) {
            this.ostype = OSType.OS_TYPE_WINDOWS;
        } else if (osnamelc.indexOf("nix") >= 0 || osnamelc.indexOf("nux") >= 0 || osnamelc.indexOf("aix") >= 0 || osnamelc.indexOf("sunos") >= 0) {
            this.ostype = OSType.OS_TYPE_UNIX;
        }
        logger.trace("setOSType <<<");
    }

    protected OSType getOSType() {
        return this.ostype;
    }

    protected String getOSName() {
        return this.osname;
    }

    protected long getPID(File PIDFile) throws IOException {
        logger.trace("getPID >>>");
        long PID = -1L;
        String PIDFileName = new String(PIDFile.getPath());
        if (!PIDFile.exists() || !PIDFile.isFile()) {
            throw new IOException("Process ID file does not exist: " + PIDFileName);
        }
        if (!PIDFile.canRead()) {
            throw new IOException("Unable to read process ID file: " + PIDFileName);
        }
        FileInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            inputStream = new FileInputStream(PIDFile);
            InputStreamReader streamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            reader = new BufferedReader(streamReader);
            String PIDString = reader.readLine();
            PID = Long.valueOf(PIDString);
        }
        catch (IOException exc) {
            logger.error((Object)exc);
            throw new IOException("Unable to read process ID file: " + PIDFileName);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException exc) {
                    logger.error((Object)exc);
                    throw new IOException("Failed to close stream reader for file: " + PIDFileName);
                }
            }
        }
        logger.debug("Returning PID value " + PID);
        logger.trace("getPID <<<");
        return PID;
    }

    protected int deletePIDFile(File PIDFile) {
        logger.trace("deletePIDFile >>>");
        int status = -1;
        String PIDFileName = new String(PIDFile.getPath());
        if (!PIDFile.exists() || !PIDFile.isFile()) {
            logger.error("Process ID file does not exist: " + PIDFileName);
        } else {
            boolean deleted = false;
            deleted = PIDFile.delete();
            status = deleted ? 0 : -1;
        }
        logger.trace("deletePIDFile <<<");
        return status;
    }

    public int terminateProcess(Long ProcessID) {
        logger.trace("terminateProcess >>>");
        int status = -1;
        if (this.ostype == OSType.OS_TYPE_UNIX) {
            status = this.terminateUnixProcess(ProcessID);
        } else if (this.ostype == OSType.OS_TYPE_WINDOWS) {
            status = this.terminateWindowsProcess(ProcessID);
        }
        logger.trace("terminateProcess <<<");
        return status;
    }

    private int terminateUnixProcess(Long ProcessID) {
        logger.trace("terminateUnixProcess >>>");
        int status = -1;
        try {
            logger.debug("Executing command \"kill -15 " + ProcessID + "\"");
            Process process = Runtime.getRuntime().exec("kill -15 " + ProcessID);
            process.waitFor(3L, TimeUnit.SECONDS);
            status = process.exitValue();
            logger.debug("Exit value = " + status);
            if (status != 0) {
                logger.debug("Executing command \"kill -9 " + ProcessID + "\"");
                process = Runtime.getRuntime().exec("kill -9 " + ProcessID);
                process.waitFor(3L, TimeUnit.SECONDS);
                status = process.exitValue();
                logger.debug("Exit value = " + status);
            }
        }
        catch (Exception exc) {
            logger.error((Object)exc);
            logger.error("Unable to terminate process " + ProcessID);
            status = -1;
        }
        logger.trace("terminateUnixProcess <<<");
        return status;
    }

    private int terminateWindowsProcess(Long ProcessID) {
        logger.trace("terminateWindowsProcess >>>");
        int status = -1;
        try {
            Process process = Runtime.getRuntime().exec("taskkill /PID " + ProcessID);
            process.waitFor(3L, TimeUnit.SECONDS);
            status = process.exitValue();
            if (status != 0) {
                process = Runtime.getRuntime().exec("taskkill /F /PID " + ProcessID);
                process.waitFor(3L, TimeUnit.SECONDS);
                status = process.exitValue();
            }
        }
        catch (Exception exc) {
            logger.error((Object)exc);
            logger.error("Unable to terminate process " + ProcessID);
            status = -1;
        }
        logger.trace("terminateWindowsProcess <<<");
        return status;
    }

    public int waitForStartup(Long processID, int TimeOutInSeconds) {
        logger.trace("waitForStartup >>>");
        int status = -1;
        if (TimeOutInSeconds <= 0) {
            TimeOutInSeconds = 1;
        }
        logger.debug("Wait time out set to " + TimeOutInSeconds + " seconds");
        int stateCode = 20;
        int attempt = 0;
        if (processID > 0L) {
            while (stateCode != 10 && TimeOutInSeconds > 0) {
                stateCode = this.getProcessStatus(processID);
                logger.debug("Query " + ++attempt + " on process " + processID + " returned " + (stateCode == 10 ? "PROCESS EXISTS" : "PROCESS DOES NOT EXIST"));
                if (stateCode != 10) {
                    if (ExecutionInterface.verbose && TimeOutInSeconds >= 30 && attempt % 30 == 0) {
                        System.out.println("Wait timeout remaining is " + TimeOutInSeconds + " seconds ...");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException exc) {
                        logger.error((Object)exc);
                    }
                }
                --TimeOutInSeconds;
            }
        }
        if (stateCode == 20 && this.ostype == OSType.OS_TYPE_WINDOWS) {
            stateCode = 10;
        }
        if (stateCode == 10) {
            boolean isReady = false;
            if (ExecutionInterface.serverConfig.healthValve) {
                String healthURL = this.getServerHealthURL();
                if (healthURL == null) {
                    logger.error("Unable to retrieve a URL for the health check");
                } else {
                    attempt = 0;
                    while (!isReady && TimeOutInSeconds > 0) {
                        ++attempt;
                        try {
                            isReady = this.getServerHealth(healthURL);
                            logger.debug("Query " + attempt + " on server health status = " + isReady);
                            if (ExecutionInterface.verbose && TimeOutInSeconds >= 30 && attempt % 30 == 0) {
                                System.out.println("Wait timeout remaining is " + TimeOutInSeconds + " seconds ...");
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException exc) {
                                logger.error((Object)exc);
                            }
                            --TimeOutInSeconds;
                        }
                        catch (RuntimeException exc) {
                            logger.error((Object)exc);
                            break;
                        }
                    }
                    if (isReady) {
                        status = 0;
                    }
                }
            } else {
                logger.debug("No server health check valve configured.  Scanning server log for startup message.");
                File logFile = ExecutionInterface.catalinaOut;
                if (logFile == null) {
                    logger.warn("No server log file name is configured");
                } else {
                    String startupMessage = this.scanLogForStartupMessage(logFile, TimeOutInSeconds);
                    if (startupMessage != null && startupMessage.length() > 0) {
                        logger.debug("Server startup message: " + startupMessage);
                        isReady = true;
                        status = 0;
                    }
                }
            }
        }
        logger.trace("waitForStartup <<<");
        return status;
    }

    public int waitForTermination(Long ProcessID, int TimeOutInSeconds) {
        logger.trace("waitForTermination >>>");
        int status = -1;
        if (TimeOutInSeconds <= 0) {
            TimeOutInSeconds = 1;
        }
        logger.debug("Wait time out set to " + TimeOutInSeconds + " seconds");
        int attempt = 0;
        while (status != 0 && TimeOutInSeconds > 0) {
            int stateCode = this.getProcessStatus(ProcessID);
            logger.debug("Query " + ++attempt + " on process " + ProcessID + " returned " + (stateCode == 10 ? "PROCESS EXISTS" : "PROCESS DOES NOT EXIST"));
            if (stateCode == 20) {
                status = 0;
                continue;
            }
            if (ExecutionInterface.verbose && TimeOutInSeconds >= 30 && attempt % 30 == 0) {
                System.out.println("Wait timeout remaining is " + TimeOutInSeconds + " seconds ...");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exc) {
                logger.error((Object)exc);
            }
            --TimeOutInSeconds;
        }
        logger.trace("waitForTermination <<<");
        return status;
    }

    protected int getProcessStatus(Long ProcessID) {
        logger.trace("getProcessStatus >>>");
        int status = -1;
        String command = null;
        if (this.ostype == OSType.OS_TYPE_UNIX) {
            command = new String("kill -0 " + ProcessID);
        } else if (this.ostype == OSType.OS_TYPE_WINDOWS) {
            command = new String("tasklist /NH /FO CSV /FI \"PID eq " + ProcessID + "\"");
        }
        if (command != null) {
            logger.debug("Command = \"" + command + "\"");
            try {
                BufferedReader outputBuffer;
                String outputValue;
                Process process = Runtime.getRuntime().exec(command);
                process.waitFor(3L, TimeUnit.SECONDS);
                status = process.exitValue();
                if (this.ostype == OSType.OS_TYPE_UNIX) {
                    status = status == 0 ? 10 : 20;
                } else if (this.ostype == OSType.OS_TYPE_WINDOWS && (outputValue = (outputBuffer = new BufferedReader(new InputStreamReader(process.getInputStream()))).readLine()).length() > 0) {
                    status = outputValue.indexOf("No tasks") > 0 ? 20 : 10;
                }
            }
            catch (Exception exc) {
                logger.error((Object)exc);
                logger.error("Unable to retrieve process status for " + ProcessID);
                status = -1;
            }
        }
        logger.trace("getProcessStatus <<<");
        return status;
    }

    private String getServerHealthURL() {
        logger.trace("getServerHealthURL >>>");
        String healthURL = null;
        String hostName = null;
        ServerConfiguration serverConfig = ExecutionInterface.serverConfig;
        try {
            InetAddress inetadd = InetAddress.getLocalHost();
            hostName = inetadd.getCanonicalHostName();
        }
        catch (Exception exc) {
            logger.error((Object)exc);
            logger.error("Unable to determine host name for health check URL");
        }
        if (hostName != null) {
            String protocol = new String(serverConfig.sslEnabled ? "https://" : "http://");
            String hostPort = null;
            if (serverConfig.connectorPort != null) {
                hostPort = serverConfig.connectorPort;
            } else {
                logger.error("Unable to determine port number for health check URL");
            }
            if (hostPort != null) {
                healthURL = new String(protocol + hostName + ":" + hostPort + "/health");
            }
        }
        logger.debug("Server health check URL = " + healthURL);
        logger.trace("getServerHealthURL <<<");
        return healthURL;
    }

    protected boolean getServerHealth(String targetURL) throws RuntimeException {
        logger.trace("getServerHealth >>>");
        boolean isHealthy = false;
        if (targetURL == null || targetURL.length() <= 0) {
            logger.error("A target URL is required and cannot be null");
        } else {
            HttpURLConnection connection = null;
            try {
                URL url = new URL(targetURL);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Content-Language", "en-US");
                connection.setUseCaches(false);
                connection.setConnectTimeout(1000);
                connection.setReadTimeout(1000);
                connection.connect();
                int responseCode = connection.getResponseCode();
                logger.debug("HTTP response code = " + responseCode);
                if (responseCode == 200) {
                    String line;
                    InputStream responseStream = connection.getInputStream();
                    BufferedReader responseReader = new BufferedReader(new InputStreamReader(responseStream));
                    StringBuilder responseData = new StringBuilder();
                    while ((line = responseReader.readLine()) != null) {
                        responseData.append(System.lineSeparator());
                        responseData.append(line);
                        if (!line.matches(".*status.*:.*UP.*")) continue;
                        logger.debug("Server health status is \"UP\"");
                        isHealthy = true;
                    }
                    responseReader.close();
                    if (responseData.length() > 0) {
                        logger.debug("HTTP response data:" + responseData.toString());
                    }
                }
            }
            catch (SocketTimeoutException exc) {
                logger.debug("Wait on server health check status timed out");
            }
            catch (ConnectException exc) {
                isHealthy = false;
            }
            catch (Exception exc) {
                logger.error((Object)exc);
                exc.printStackTrace();
                throw new RuntimeException("An exception occured during the server health check");
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        logger.trace("getServerHealth <<<");
        return isHealthy;
    }

    private String scanLogForStartupMessage(File logFile, int TimeOutInSeconds) {
        logger.trace("scanLogForStartupMessage >>>");
        String startupMessage = null;
        FileInputStream inputStream = null;
        LineNumberReader reader = null;
        try {
            inputStream = new FileInputStream(logFile);
            InputStreamReader streamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            reader = new LineNumberReader(streamReader);
            if (ExecutionInterface.initialLogFileSize > 0L) {
                reader.skip(ExecutionInterface.initialLogFileSize);
                logger.debug("Skipped to offset " + ExecutionInterface.initialLogFileSize + " (line " + reader.getLineNumber() + " in log file " + logFile.getPath());
            }
            String logLine = null;
            boolean bootMsgFound = false;
            int bootMsgLine = -1;
            boolean startMsgFound = false;
            int startMsgLine = -1;
            boolean isReady = false;
            int attempt = 0;
            while (!isReady && TimeOutInSeconds > 0) {
                ++attempt;
                do {
                    if ((logLine = reader.readLine()) == null) continue;
                    if (logLine.matches("^.*Server version name:\\s*Apache Tomcat.*$")) {
                        bootMsgLine = reader.getLineNumber();
                        logger.debug("Found server boot message in server log at line " + bootMsgLine);
                        bootMsgFound = true;
                        startMsgFound = false;
                        startupMessage = null;
                    }
                    if (!logLine.matches("^.*Server startup in \\[\\d+\\] milliseconds.*$")) continue;
                    startMsgLine = reader.getLineNumber();
                    logger.debug("Found server startup message in server log at line " + startMsgLine);
                    startMsgFound = true;
                    startupMessage = logLine;
                } while (logLine != null);
                if (bootMsgFound && startMsgFound) {
                    isReady = true;
                }
                logger.debug("Query " + attempt + " on server health status = " + isReady);
                if (isReady) continue;
                if (ExecutionInterface.verbose && --TimeOutInSeconds >= 30 && attempt % 30 == 0) {
                    System.out.println("Wait timeout remaining is " + TimeOutInSeconds + " seconds ...");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exc) {
                    logger.debug("Sleep was interrupted.  Continuing ...");
                }
            }
        }
        catch (Exception exc) {
            logger.error((Object)exc);
            logger.error("Exception reading server log file " + logFile.getPath());
        }
        logger.trace("scanLogForStartupMessage <<<");
        return startupMessage;
    }

    protected static enum OSType {
        OS_TYPE_UNKNOWN,
        OS_TYPE_WINDOWS,
        OS_TYPE_UNIX;

    }
}

