/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.execution;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerConfiguration {
    private Logger logger = LogManager.getLogger(ServerConfiguration.class);
    private static final int SUCCESS = 0;
    private static final int ERROR = -1;
    private static final String CATALINA_PROPERTIES_FILE_NAME = "catalina.properties";
    private static final String SERVER_XML_FILE_NAME = "server.xml";
    private File catalinaBase;
    private Document xmlDocument = null;
    private boolean xmlLoaded = false;
    private Properties serverProperties = new Properties();
    private boolean propertiesLoaded = false;
    protected String shutdownPort = null;
    protected String connectorPort = null;
    protected String redirectPort = null;
    protected String proxyName = null;
    protected String proxyPort = null;
    protected String defaultHost = null;
    protected String hostName = null;
    protected boolean healthValve = false;
    protected boolean sslEnabled = false;

    public ServerConfiguration(File catalinaBase) throws Exception {
        this.catalinaBase = catalinaBase;
        int status = 0;
        if (!catalinaBase.exists() || !catalinaBase.isDirectory()) {
            throw new Exception("The CATALINA_BASE directory argument is invalid");
        }
        status = this.parseServerXML();
        if (status != 0) {
            throw new Exception("Failed to parse server XML");
        }
        status = this.parseServerProperties();
        if (status != 0) {
            throw new Exception("Failed to parse server properties");
        }
        status = this.loadConfigValues();
        if (status != 0) {
            throw new Exception("Failed to resolve server configuration values");
        }
    }

    private File getServerConfDir() {
        return new File(this.catalinaBase, "conf");
    }

    private File getServerPropertiesFile() {
        return new File(this.getServerConfDir(), CATALINA_PROPERTIES_FILE_NAME);
    }

    private File getServerXMLFile() {
        return new File(this.getServerConfDir(), SERVER_XML_FILE_NAME);
    }

    private int parseServerXML() {
        this.logger.trace("parseServerXML >>>");
        int status = 0;
        File xmlFile = this.getServerXMLFile();
        if (!xmlFile.exists() || !xmlFile.isFile()) {
            this.logger.error("Server XML file does not exist: " + xmlFile.getPath());
            status = -1;
        } else if (!xmlFile.canRead()) {
            this.logger.error("Unable to read server XML file: " + xmlFile.getPath());
            status = -1;
        } else {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setValidating(false);
            dbFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            try {
                DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
                this.xmlDocument = docBuilder.parse(new FileInputStream(xmlFile));
                this.xmlLoaded = true;
            }
            catch (Exception exc) {
                this.logger.error((Object)exc);
                this.logger.error("Failed to parse server XML file: " + xmlFile.getPath());
                status = -1;
            }
        }
        this.logger.trace("parseServerXML <<<");
        return status;
    }

    private NodeList findNodes(String xPathStr) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPathObj = factory.newXPath();
        NodeList list = null;
        try {
            list = (NodeList)xPathObj.evaluate(xPathStr, this.xmlDocument.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException exc) {
            this.logger.error((Object)exc);
            this.logger.error("Unable to evaluate the xpath value" + xPathStr);
        }
        return list;
    }

    private String getAttribute(String xPathStr, String attributName, String attributeValue) {
        this.logger.trace("getAttribute >>>");
        this.logger.debug("xPathStr = " + xPathStr + " :: " + attributName + " = " + attributeValue);
        String value = null;
        if (xPathStr == null || attributName == null) {
            this.logger.error("An xpath and an attribute name are required arguments");
        } else {
            NodeList nl = this.findNodes(xPathStr.toString());
            if (nl != null && nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength() && value == null; ++i) {
                    Element element = (Element)nl.item(i);
                    if (attributeValue != null) {
                        if (!attributeValue.equalsIgnoreCase(element.getAttribute(attributName))) continue;
                        value = element.getAttribute(attributName);
                        continue;
                    }
                    value = element.getAttribute(attributName);
                }
            }
        }
        this.logger.trace("getAttribute <<<");
        return value != null && value.length() > 0 ? value : null;
    }

    private int parseServerProperties() {
        this.logger.trace("parseServerProperties >>>");
        int status = 0;
        File propertiesFile = this.getServerPropertiesFile();
        try {
            FileInputStream fileInput = new FileInputStream(propertiesFile);
            this.serverProperties.load(fileInput);
            this.propertiesLoaded = true;
        }
        catch (FileNotFoundException ex) {
            this.logger.error("Server properties file not found: " + propertiesFile.getPath());
            status = -1;
        }
        catch (IOException ex) {
            this.logger.error("Failed to read server properties from file: " + propertiesFile.getPath());
            status = -1;
        }
        if (this.logger.isDebugEnabled()) {
            Enumeration<?> propertyName = this.serverProperties.propertyNames();
            StringBuilder propertyList = new StringBuilder();
            while (propertyName.hasMoreElements()) {
                String pname = (String)propertyName.nextElement();
                propertyList.append(System.lineSeparator() + "    >> " + pname + " = " + this.serverProperties.getProperty(pname));
            }
            this.logger.debug("Server properties loaded:" + propertyList.toString());
        }
        this.logger.trace("parseServerProperties <<<");
        return status;
    }

    private int loadConfigValues() throws IllegalStateException {
        this.logger.trace("loadConfigValues >>>");
        int status = 0;
        if (!this.xmlLoaded || !this.propertiesLoaded) {
            throw new IllegalStateException("The server's XMl and property files must both be loaded before configuration values are resolved");
        }
        this.shutdownPort = this.getConfigFileValue("/Server", "port");
        this.connectorPort = this.getConfigFileValue("/Server/Service/Connector", "port");
        this.redirectPort = this.getConfigFileValue("/Server/Service/Connector", "redirectPort");
        this.proxyName = this.getConfigFileValue("/Server/Service/Connector", "proxyName");
        this.proxyPort = this.getConfigFileValue("/Server/Service/Connector", "proxyPort");
        this.defaultHost = this.getConfigFileValue("/Server/Service/Engine", "defaultHost");
        this.hostName = this.getConfigFileValue("/Server/Service/Engine/Host", "name");
        String attributeValue = this.getAttribute("/Server/Service/Engine/Host/Valve", "className", "org.apache.catalina.valves.HealthCheckValve");
        this.healthValve = attributeValue != null;
        attributeValue = this.getConfigFileValue("/Server/Service/Connector", "SSLEnabled");
        this.sslEnabled = attributeValue != null && attributeValue.equalsIgnoreCase("true");
        this.logger.debug("shutdownPort  = /Server - port                                       = " + this.shutdownPort);
        this.logger.debug("connectorPort = /Server/Service/Connector - port                     = " + this.connectorPort);
        this.logger.debug("redirectPort  = /Server/Service/Connector - redirectPort             = " + this.redirectPort);
        this.logger.debug("proxyName     = /Server/Service/Connector - proxyName                = " + this.proxyName);
        this.logger.debug("proxyPort     = /Server/Service/Connector - proxyPort                = " + this.proxyPort);
        this.logger.debug("defaultHost   = /Server/Service/Engine - defaultHost                 = " + this.defaultHost);
        this.logger.debug("hostName      = /Server/Service/Engine/Host - name                   = " + this.hostName);
        this.logger.debug("healthValve   = /Server/Service/Engine/Host/Valve - HealthCheckValve = " + this.healthValve);
        this.logger.debug("sslEnabled    = /Server/Service/Connector - SSLEnabled               = " + this.sslEnabled);
        this.logger.trace("loadConfigValues <<<");
        return status;
    }

    private String getConfigFileValue(String xPathStr, String attribute) {
        this.logger.trace("getConfigFileValue >>>");
        String attributeValue = this.getAttribute(xPathStr, attribute, null);
        if (attributeValue != null && attributeValue.matches("\\$\\{.*\\}")) {
            this.logger.debug("Attribute in XML is a property reference: " + attributeValue);
            attributeValue = attributeValue.substring(2, attributeValue.length() - 1);
            String propertyValue = this.serverProperties.getProperty(attributeValue);
            if (propertyValue == null) {
                this.logger.error("Server XML property reference could not be resolved");
                this.logger.error("Unresolved refernece " + xPathStr + " :: " + attribute + " = " + attributeValue);
            } else {
                attributeValue = propertyValue;
            }
        }
        if (this.logger.isDebugEnabled()) {
            if (attributeValue != null && attributeValue.length() > 0) {
                this.logger.debug("Found " + attribute + " = " + attributeValue);
            } else {
                this.logger.debug("Attribute " + attribute + " not found");
            }
        }
        this.logger.trace("getConfigFileValue <<<");
        return attributeValue != null && attributeValue.length() > 0 ? attributeValue : null;
    }
}

