/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.decoder;

import com.sas.vfabrictcsvr.decoder.PropertyDecoder;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class RunDecoder {
    private static Logger logger = LogManager.getLogger(RunDecoder.class);
    private static Options options = new Options();
    private static final String PROPERTY_LOG_LEVEL = "sas.vfabrictcsvr.decoder.log.level";
    private static final String LOG_FILE_NAME = ".." + File.separator + "logs" + File.separator + "vfabric.decoder";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final String LOG_FILE_MAX_SIZE = "10 MB";
    private static final String LOG_FILE_MAX_COUNT = "10";

    public static void main(String[] args) {
        RunDecoder.configureLogging();
        logger.debug("--- Starting RunDecoder main -----------");
        boolean success = true;
        CommandLine cmdLine = null;
        try {
            cmdLine = RunDecoder.parseCommandLine(args);
        }
        catch (ParseException exc) {
            success = false;
            logger.fatal(exc.getMessage());
        }
        if (success) {
            try {
                RunDecoder.validateCommandArgs(cmdLine);
            }
            catch (ParseException exc) {
                success = false;
                logger.fatal(exc.getMessage());
                logger.fatal("Command line argument validation failed");
            }
        }
        if (success) {
            if (cmdLine.hasOption("h")) {
                String header = String.format("%nEncode or decode values for secure storage in property files.%n%n", new Object[0]);
                String footer = String.format("%nCopyright (c) 2021 - 2023 by SAS Institute Inc., Cary, NC USA 27513", new Object[0]);
                HelpFormatter formatter = new HelpFormatter();
                formatter.setLeftPadding(3);
                formatter.setWidth(85);
                formatter.setOptionComparator(null);
                formatter.printHelp("rundecoder", header, options, footer, true);
            } else {
                String result;
                if (cmdLine.hasOption("e") && (result = RunDecoder.encodeValue(cmdLine)) != null && !result.isEmpty()) {
                    System.out.println(result);
                }
                if (cmdLine.hasOption("d") && (result = RunDecoder.decodeValue(cmdLine)) != null && !result.isEmpty()) {
                    System.out.println(result);
                }
            }
        }
        System.exit(success ? 0 : 1);
    }

    private static void configureLogging() {
        Level logLevel = Level.INFO;
        String logLevelProperty = System.getProperty(PROPERTY_LOG_LEVEL);
        if (logLevelProperty != null) {
            switch (logLevelProperty.toUpperCase()) {
                case "FATAL": {
                    logLevel = Level.FATAL;
                    break;
                }
                case "ERROR": {
                    logLevel = Level.ERROR;
                    break;
                }
                case "WARN": {
                    logLevel = Level.WARN;
                    break;
                }
                case "INFO": {
                    logLevel = Level.INFO;
                    break;
                }
                case "DEBUG": {
                    logLevel = Level.DEBUG;
                    break;
                }
                case "TRACE": {
                    logLevel = Level.TRACE;
                    break;
                }
                case "ALL": {
                    logLevel = Level.ALL;
                }
            }
        }
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        config.getLoggerConfig(RunDecoder.class.getName()).setLevel(logLevel);
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern("%d %-5p (%t) [%c] %m%n").build();
        DefaultRolloverStrategy strategy = DefaultRolloverStrategy.newBuilder().withMin("1").withMax(LOG_FILE_MAX_COUNT).build();
        RollingFileAppender vfabAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName("vfabric")).setLayout((Layout)layout)).setConfiguration(config)).withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)LOG_FILE_MAX_SIZE)).withFileName(LOG_FILE_NAME + LOG_FILE_EXTENSION).withFilePattern(LOG_FILE_NAME + ".%i" + LOG_FILE_EXTENSION).withCreateOnDemand(true).withStrategy((RolloverStrategy)strategy).build();
        vfabAppender.start();
        config.addAppender((Appender)vfabAppender);
        lc.getRootLogger().addAppender((Appender)vfabAppender);
        lc.updateLoggers();
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        CommandLine cmdLine;
        if (logger.isDebugEnabled()) {
            logger.debug(RunDecoder.class + " main: ");
            for (String strValue : args) {
                System.out.println("   >> " + strValue);
            }
        }
        options.addOption("e", "encode", false, "ACTION: Encode a plain-text value");
        options.addOption("d", "decode", false, "ACTION: Decode an encoded value");
        options.addOption("h", "help", false, "ACTION: Display this help and usage message");
        options.addOption("c", "config", true, "The predefined encryption configuration to use");
        options.addOption("pw", "password", true, "The password used to encode and/or decode values");
        options.addOption("pwf", "password-file", true, "The file containing the password used to encode and/or decode values");
        options.addOption("v", "value", true, "The value to be encoded or decoded");
        DefaultParser cmdParser = new DefaultParser();
        try {
            cmdLine = cmdParser.parse(options, args);
        }
        catch (ParseException exc) {
            logger.error(exc.getMessage());
            throw new ParseException("Command line parsing failed");
        }
        return cmdLine;
    }

    private static void validateCommandArgs(CommandLine cmdLine) throws ParseException {
        if (!cmdLine.hasOption("h")) {
            File pwFile;
            if (!cmdLine.hasOption("e") && !cmdLine.hasOption("d")) {
                throw new ParseException("An action argument of either encode or decode is required");
            }
            if (cmdLine.hasOption("e") && cmdLine.hasOption("d")) {
                throw new ParseException("Only one action argument of either encode or decode is allowed");
            }
            if (!cmdLine.hasOption("c")) {
                throw new ParseException("An encryption configuration name argument is required");
            }
            if (!cmdLine.hasOption("pw") && !cmdLine.hasOption("pwf")) {
                throw new ParseException("A password argument of either a password or password file is required");
            }
            if (cmdLine.hasOption("pw") && cmdLine.hasOption("pwf")) {
                throw new ParseException("Only one password argument of either a password or a password file is allowed");
            }
            if (cmdLine.hasOption("pwf") && (!(pwFile = new File(cmdLine.getOptionValue("pwf"))).exists() || pwFile.isDirectory())) {
                throw new ParseException("The password file does not exist: " + cmdLine.getOptionValue("pwf"));
            }
            if (!cmdLine.hasOption("v")) {
                throw new ParseException("A value that is to be encoded or decoded is required.");
            }
        }
    }

    private static String encodeValue(CommandLine cmdLine) {
        PropertyDecoder propertyDecoder = new PropertyDecoder();
        String encodedValue = "";
        if (cmdLine.hasOption("pw")) {
            try {
                encodedValue = propertyDecoder.encodeProperty(cmdLine.getOptionValue("c"), cmdLine.getOptionValue("pw"), cmdLine.getOptionValue("v"));
            }
            catch (Exception exc) {
                logger.error((Object)exc);
                logger.error("Failed to encode the value");
            }
        }
        if (cmdLine.hasOption("pwf")) {
            boolean success = true;
            File pwFile = new File(cmdLine.getOptionValue("pwf"));
            try {
                propertyDecoder.loadEncryptionPassword(pwFile);
            }
            catch (Exception exc) {
                logger.error((Object)exc);
                logger.error("Failed to open and read the password file " + pwFile.getPath());
                success = false;
            }
            if (success) {
                try {
                    encodedValue = propertyDecoder.encodeProperty(cmdLine.getOptionValue("c"), cmdLine.getOptionValue("v"));
                }
                catch (Exception exc) {
                    logger.error((Object)exc);
                    logger.error("Failed to encode the value");
                }
            }
        }
        return encodedValue;
    }

    private static String decodeValue(CommandLine cmdLine) {
        PropertyDecoder propertyDecoder = new PropertyDecoder();
        String decodedValue = "";
        if (cmdLine.hasOption("pw")) {
            try {
                decodedValue = propertyDecoder.decodeProperty(cmdLine.getOptionValue("c"), cmdLine.getOptionValue("pw"), cmdLine.getOptionValue("v"));
            }
            catch (Exception exc) {
                logger.error((Object)exc);
                logger.error("Failed to decode the value");
            }
        }
        if (cmdLine.hasOption("pwf")) {
            boolean success = true;
            File pwFile = new File(cmdLine.getOptionValue("pwf"));
            try {
                propertyDecoder.loadEncryptionPassword(pwFile);
            }
            catch (Exception exc) {
                logger.error((Object)exc);
                logger.error("Failed to open and read the password file " + pwFile.getPath());
                success = false;
            }
            if (success) {
                try {
                    decodedValue = propertyDecoder.decodeProperty(cmdLine.getOptionValue("c"), cmdLine.getOptionValue("v"));
                }
                catch (Exception exc) {
                    logger.error((Object)exc);
                    logger.error("Failed to decode the value");
                }
            }
        }
        return decodedValue;
    }
}

