/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.decoder;

import com.sas.vfabrictcsvr.decoder.EncryptDecrypt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.IntrospectionUtils;

public class PropertyDecoder
implements IntrospectionUtils.PropertySource {
    private static Logger logger = LogManager.getLogger(PropertyDecoder.class);
    private File propertiesFile = null;
    private Properties fileProperties = new Properties();
    private String storedPassword;
    public static final String PASSPHRASE_FILE = PropertyDecoder.class.getName() + ".passphrase.file";
    public static final String PROPERTIES_FILE = PropertyDecoder.class.getName() + ".properties.file";

    public PropertyDecoder() {
        logger.trace("PropertyDecoder >>>");
        if (logger.isDebugEnabled()) {
            logger.debug("System properties are:" + System.getProperty("line.separator") + this.getSystemPropertiesList());
        }
        logger.trace("PropertyDecoder <<<");
    }

    private String getSystemPropertiesList() {
        logger.trace("getSystemPropertiesList >>>");
        StringBuilder properties = new StringBuilder();
        Properties allProperties = System.getProperties();
        Set<String> propertyNameList = allProperties.stringPropertyNames();
        for (String propertyName : propertyNameList) {
            String propertyValue = System.getProperty(propertyName);
            if (propertyValue == null) continue;
            properties.append("   >> " + propertyName + " = " + propertyValue + System.getProperty("line.separator"));
        }
        logger.trace("getSystemPropertiesList <<<");
        return properties.toString();
    }

    private boolean getPropertiesFile() {
        logger.trace("getPropertiesFile >>>");
        boolean success = true;
        if (this.propertiesFile == null) {
            String propertiesFileName = System.getProperty(PROPERTIES_FILE);
            if (propertiesFileName == null || propertiesFileName.isEmpty()) {
                logger.warn("No property file name defined");
                logger.warn("Defaulting the property file name to ${catalina.base}/conf/catalina.properties");
                System.setProperty(PROPERTIES_FILE, "${catalina.base}/conf/catalina.properties");
                propertiesFileName = System.getProperty(PROPERTIES_FILE);
            }
            if (success) {
                propertiesFileName = IntrospectionUtils.replaceProperties((String)propertiesFileName, null, (IntrospectionUtils.PropertySource[])new IntrospectionUtils.PropertySource[]{new SystemPropertySource()}, null);
                File newPropertiesFile = new File(propertiesFileName);
                try {
                    this.fileInit(newPropertiesFile);
                }
                catch (Exception exc) {
                    logger.error((Object)exc);
                    logger.error("Failed to initialize the property file decoder");
                    success = false;
                }
            }
        }
        logger.trace("getPropertiesFile <<<");
        return success;
    }

    private void fileInit(File propertiesFileArg) throws Exception {
        logger.trace("fileInit >>>");
        int status = 0;
        if (propertiesFileArg == null) {
            logger.error("Invalid property file argument");
        } else {
            this.propertiesFile = propertiesFileArg;
            logger.debug("Properties file name: " + propertiesFileArg.getCanonicalPath());
            try {
                this.loadProperties(propertiesFileArg);
                this.resolveSubstitutions();
            }
            catch (IOException exc) {
                logger.error((Object)exc);
                status = -1;
                throw new IOException("Unable to retrieve properties");
            }
            if (status == 0) {
                logger.debug("Passphrase property: " + PASSPHRASE_FILE);
                String passwordFileName = this.getProperty(PASSPHRASE_FILE);
                if (passwordFileName == null || passwordFileName.isEmpty()) {
                    throw new IOException("Password file name property " + PASSPHRASE_FILE + " is not defined in " + propertiesFileArg);
                }
                try {
                    File passwordFile = new File(passwordFileName);
                    this.loadEncryptionPassword(passwordFile);
                }
                catch (IOException exc) {
                    logger.error((Object)exc);
                    status = -1;
                    throw new IOException("Unable to retrieve password");
                }
            }
        }
        logger.trace("fileInit <<<");
    }

    private void loadProperties(File propertiesSource) throws Exception {
        logger.trace("loadProperties >>>");
        if (propertiesSource == null) {
            throw new IOException("Invalid property file argument");
        }
        String propertiesFileName = propertiesSource.getPath();
        if (!propertiesSource.exists() || !propertiesSource.isFile()) {
            throw new IOException("Properties file does not exist: " + propertiesFileName);
        }
        if (!propertiesSource.canRead()) {
            throw new IOException("Unable to read properties file: " + propertiesFileName);
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(propertiesSource);
            this.fileProperties.load(inputStream);
        }
        catch (IOException exc) {
            logger.error((Object)exc);
            throw new IOException("Unable to read properties file: " + propertiesFileName);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException exc) {
                    logger.error((Object)exc);
                    throw new IOException("Failed to close input stream for file: " + propertiesFileName);
                }
            }
        }
        logger.trace("loadProperties <<<");
    }

    private void resolveSubstitutions() {
        logger.trace("resolveSubstitutions >>>");
        IntrospectionUtils.PropertySource[] propertySources = new IntrospectionUtils.PropertySource[]{new SystemPropertySource()};
        Set<String> propertyNameList = this.fileProperties.stringPropertyNames();
        for (String propertyName : propertyNameList) {
            String propertyValue = this.fileProperties.getProperty(propertyName);
            if (propertyValue == null) continue;
            try {
                String newValue = IntrospectionUtils.replaceProperties((String)propertyValue, null, (IntrospectionUtils.PropertySource[])propertySources, (ClassLoader)this.getClass().getClassLoader());
                if (propertyValue.equals(newValue)) continue;
                this.fileProperties.setProperty(propertyName, newValue);
                logger.debug("Original value of " + propertyName + " was " + propertyValue);
                logger.debug("New value of " + propertyName + " is " + this.fileProperties.getProperty(propertyName));
            }
            catch (Exception exc) {
                logger.error((Object)exc);
                logger.error("Failed to resolve substitution tags in: " + propertyName + " = " + propertyValue);
            }
        }
        logger.trace("resolveSubstitutions <<<");
    }

    public void loadEncryptionPassword(File passwordSource) throws Exception {
        logger.trace("loadEncryptionPassword >>>");
        if (passwordSource == null) {
            throw new IOException("Invalid password file argument");
        }
        String passwordFileName = passwordSource.getPath();
        if (!passwordSource.exists() || !passwordSource.isFile()) {
            throw new IOException("Encryption password file does not exist: " + passwordFileName);
        }
        if (!passwordSource.canRead()) {
            throw new IOException("Unable to read encryption password file: " + passwordFileName);
        }
        FileInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            inputStream = new FileInputStream(passwordSource);
            InputStreamReader streamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            reader = new BufferedReader(streamReader);
            this.storedPassword = reader.readLine();
        }
        catch (IOException exc) {
            logger.error((Object)exc);
            throw new IOException("Unable to read encryption password file: " + passwordFileName);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException exc) {
                    logger.error((Object)exc);
                    throw new IOException("Failed to close stream reader for file: " + passwordFileName);
                }
            }
        }
        logger.trace("loadEncryptionPassword <<<");
    }

    public String encodeProperty(String configName, String plainText) throws Exception {
        return this.encodeProperty(configName, this.storedPassword, plainText);
    }

    public String encodeProperty(String configName, String encryptionPassword, String plainText) throws Exception {
        logger.trace("encodeProperty >>>");
        boolean success = true;
        if (configName == null || configName.isEmpty()) {
            success = false;
            throw new IllegalArgumentException("An encoding configuration name is required and cannot be empty");
        }
        if (encryptionPassword == null || encryptionPassword.isEmpty()) {
            success = false;
            throw new IllegalArgumentException("An encryption password is required and cannot be empty");
        }
        if (plainText == null || plainText.isEmpty()) {
            success = false;
            throw new IllegalArgumentException("A value to be encoded is required and cannot be empty");
        }
        String encodedText = "";
        EncryptDecrypt encryptHandle = new EncryptDecrypt("Encrypt_Property");
        try {
            encryptHandle.initConfig(configName);
        }
        catch (Exception exc) {
            success = false;
            logger.error((Object)exc);
            throw new Exception("Failed to initialize an encryption handle");
        }
        if (success) {
            byte[] cipherText = encryptHandle.encryptData(encryptionPassword, plainText);
            byte[] hmacVector = encryptHandle.createHMAC(encryptionPassword, cipherText);
            int encBlockSize = encryptHandle.getAlgorithmBlockSize();
            int hmacBlockSize = encryptHandle.getHMACBlockSize();
            byte[] propertyVector = new byte[3 * encBlockSize + cipherText.length + hmacBlockSize];
            int offset = 0;
            if (logger.isDebugEnabled()) {
                logger.debug("Salt vector = " + this.toHexString(encryptHandle.getSaltVector()));
                logger.debug("Init vector = " + this.toHexString(encryptHandle.getInitVector()));
                logger.debug("HMAC salt   = " + this.toHexString(encryptHandle.getHMACSaltVector()));
                logger.debug("Cipher text = " + this.toHexString(cipherText, encBlockSize));
                logger.debug("HMAC vector = " + this.toHexString(hmacVector, encBlockSize));
            }
            System.arraycopy(encryptHandle.getSaltVector(), 0, propertyVector, offset, encBlockSize);
            System.arraycopy(encryptHandle.getInitVector(), 0, propertyVector, offset += encBlockSize, encBlockSize);
            System.arraycopy(encryptHandle.getHMACSaltVector(), 0, propertyVector, offset += encBlockSize, encBlockSize);
            System.arraycopy(cipherText, 0, propertyVector, offset += encBlockSize, cipherText.length);
            System.arraycopy(hmacVector, 0, propertyVector, offset += cipherText.length, hmacBlockSize);
            logger.debug("Property vector = " + this.toHexString(propertyVector, encBlockSize));
            byte[] encodedBytes = Base64.encodeBase64((byte[])propertyVector);
            encodedText = new String(encodedBytes);
        }
        logger.trace("encodeProperty <<<");
        return encryptHandle.getEncryptionConfigName() + ":" + encodedText;
    }

    public String decodeProperty(String configName, String encodedText) throws Exception {
        return this.decodeProperty(configName, this.storedPassword, encodedText);
    }

    public String decodeProperty(String configName, String encryptionPassword, String encodedText) throws Exception {
        logger.trace("decodeProperty >>>");
        boolean success = true;
        if (configName == null || configName.isEmpty()) {
            success = false;
            throw new IllegalArgumentException("An encoding configuration name is required and cannot be empty");
        }
        if (encryptionPassword == null || encryptionPassword.isEmpty()) {
            success = false;
            throw new IllegalArgumentException("An encryption password is required and cannot be empty");
        }
        if (encodedText == null || encodedText.isEmpty()) {
            success = false;
            throw new IllegalArgumentException("A value to be decoded is required and cannot be empty");
        }
        String decodedPropertyValue = null;
        int offset = encodedText.indexOf(58);
        String encryptionConfigName = encodedText.substring(0, offset);
        if (encryptionConfigName.equals("sasmtr01")) {
            if (success) {
                encodedText = encodedText.substring(offset + 1, encodedText.length());
                decodedPropertyValue = this.getDecodedValue(encryptionConfigName, encryptionPassword, encodedText);
            }
        } else {
            success = false;
            throw new Exception("Unrecognized encryption configuration: " + encryptionConfigName);
        }
        logger.trace("decodeProperty <<<");
        return decodedPropertyValue;
    }

    private String getDecodedValue(String encryptionConfigName, String encryptionPassword, String encodedText) {
        logger.trace("getDecodedValue >>>");
        boolean success = true;
        if (encryptionConfigName == null || encryptionConfigName.isEmpty()) {
            success = false;
            throw new IllegalArgumentException("An encoding configuration name is required and cannot be empty");
        }
        if (encryptionPassword == null || encryptionPassword.isEmpty()) {
            success = false;
            throw new IllegalArgumentException("An encryption password is required and cannot be empty");
        }
        if (encodedText == null || encodedText.isEmpty()) {
            success = false;
            throw new IllegalArgumentException("A value to be decoded is required and cannot be empty");
        }
        String decodedText = null;
        EncryptDecrypt decryptHandle = new EncryptDecrypt("Decrypt_Value");
        try {
            decryptHandle.initConfig(encryptionConfigName);
        }
        catch (Exception exc) {
            success = false;
            logger.error((Object)exc);
            logger.error("Failed to initialize a decryption handle");
        }
        if (success) {
            byte[] propertyVector = Base64.decodeBase64((String)encodedText);
            int encBlockSize = decryptHandle.getAlgorithmBlockSize();
            int hmacBlockSize = decryptHandle.getHMACBlockSize();
            byte[] saltVector = new byte[encBlockSize];
            System.arraycopy(propertyVector, 0, saltVector, 0, encBlockSize);
            byte[] initVector = new byte[encBlockSize];
            System.arraycopy(propertyVector, encBlockSize, initVector, 0, encBlockSize);
            byte[] hmacSaltVector = new byte[encBlockSize];
            System.arraycopy(propertyVector, encBlockSize * 2, hmacSaltVector, 0, encBlockSize);
            int valueVectorSize = propertyVector.length - encBlockSize * 3 - hmacBlockSize;
            byte[] valueVector = new byte[valueVectorSize];
            System.arraycopy(propertyVector, encBlockSize * 3, valueVector, 0, valueVectorSize);
            byte[] hmacVector = new byte[hmacBlockSize];
            System.arraycopy(propertyVector, propertyVector.length - hmacBlockSize, hmacVector, 0, hmacBlockSize);
            if (logger.isDebugEnabled()) {
                logger.debug("Salt vector = " + this.toHexString(saltVector));
                logger.debug("Init vector = " + this.toHexString(initVector));
                logger.debug("HMAC salt   = " + this.toHexString(hmacSaltVector));
                logger.debug("Cipher text = " + this.toHexString(valueVector, encBlockSize));
                logger.debug("HMAC vector = " + this.toHexString(hmacVector, encBlockSize));
            }
            decryptHandle.setSaltVector(saltVector);
            decryptHandle.setInitVector(initVector);
            decryptHandle.setHMACSaltVector(hmacSaltVector);
            byte[] compVector = decryptHandle.createHMAC(encryptionPassword, valueVector);
            logger.debug("HMAC comp   = " + this.toHexString(compVector, encBlockSize));
            if (compVector.equals(hmacVector)) {
                logger.error("The value is corrupted.  The authentication code for thevalue does not match the embedded authentication code");
            } else {
                decodedText = decryptHandle.decryptData(encryptionPassword, valueVector);
                if (decodedText == null || decodedText.isEmpty()) {
                    success = false;
                    logger.error("The value could not be decrypted");
                }
            }
        }
        logger.trace("getDecodedValue <<<");
        return decodedText;
    }

    public String getProperty(String propertyKey) {
        logger.trace("getProperty >>>");
        logger.debug("propertyKey = " + propertyKey);
        boolean success = true;
        String decodedPropertyValue = null;
        if (this.propertiesFile == null) {
            success = this.getPropertiesFile();
        }
        if (success) {
            if (propertyKey == null) {
                logger.error("Invalid property key argument");
                success = false;
            } else {
                String propertyValue = this.fileProperties.getProperty(propertyKey);
                logger.debug("Property value = " + propertyValue);
                if (propertyValue == null) {
                    logger.debug("Property value not found for key: " + propertyKey);
                } else if (propertyValue.startsWith("sasmtr01:")) {
                    int offset = propertyValue.indexOf(58);
                    String encryptConfigName = propertyValue.substring(0, offset);
                    propertyValue = propertyValue.substring(offset + 1, propertyValue.length());
                    decodedPropertyValue = this.getDecodedValue(encryptConfigName, this.storedPassword, propertyValue);
                } else {
                    decodedPropertyValue = propertyValue;
                }
            }
        }
        logger.trace("getProperty <<<");
        return decodedPropertyValue;
    }

    private int base64CharPerBlock(int blockSize) {
        int charCount = (blockSize / 3 + (blockSize % 3 == 0 ? 0 : 1)) * 4;
        return charCount;
    }

    private String toHexString(byte[] bytes) {
        return this.toHexString(bytes, 0);
    }

    private String toHexString(byte[] bytes, int chunkSize) {
        StringBuilder hexBytes = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (chunkSize > 0 && i % chunkSize == 0) {
                hexBytes.append(String.format("%n", new Object[0]));
            }
            hexBytes.append(String.format("%02X ", bytes[i]));
        }
        return hexBytes.toString();
    }

    private static class SystemPropertySource
    implements IntrospectionUtils.PropertySource {
        private SystemPropertySource() {
        }

        public String getProperty(String key) {
            return System.getProperty(key);
        }
    }
}

