/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.authenticator;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class SasFallbackAuthenticatorValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(SasFallbackAuthenticatorValve.class);
    private static final String FALLBACK_REQUEST_PARAM = "fallback";
    private static final String AUTHENTICATORS = "org/apache/catalina/startup/Authenticators.properties";
    protected volatile String uriPattern = "/SASLogon/login.*";
    protected volatile String authMethod;
    protected AuthenticatorBase authenticator;
    protected volatile boolean clientCert = false;

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    protected void startInternal() throws LifecycleException {
        String className;
        super.startInternal();
        if (this.authMethod == null || this.authMethod.length() == 0) {
            throw new LifecycleException("authMethod attribute not set in valve configuration");
        }
        Properties prop = new Properties();
        try {
            ClassLoader loader = SasFallbackAuthenticatorValve.class.getClassLoader();
            InputStream stream = loader.getResourceAsStream(AUTHENTICATORS);
            prop.load(stream);
            className = prop.getProperty(this.authMethod);
        }
        catch (IOException ioe) {
            throw new LifecycleException("Unable to read properties file: org/apache/catalina/startup/Authenticators.properties");
        }
        try {
            Class<?> authenticatorClass = Class.forName(className);
            Constructor<?> constructor = authenticatorClass.getConstructor(new Class[0]);
            this.authenticator = (AuthenticatorBase)constructor.newInstance(new Object[0]);
            this.authenticator.setContainer(this.getContainer());
            this.authenticator.init();
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        String requestURI = request.getRequestURI();
        if (request.getQueryString() != null && request.getQueryString().length() > 0) {
            requestURI = requestURI + "?" + request.getQueryString();
        }
        if (requestURI.matches(this.uriPattern)) {
            if (this.isXhrRequest(request)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Ignoring XHR request");
                }
            } else {
                String fallback = request.getParameter(FALLBACK_REQUEST_PARAM);
                if (fallback == null || fallback.length() == 0) {
                    boolean retval;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Attempting to authenticate with " + this.authMethod));
                    }
                    if (!(retval = this.authenticator.authenticate(request, (HttpServletResponse)response))) {
                        return;
                    }
                }
            }
        }
        this.getNext().invoke(request, response);
    }

    protected boolean isXhrRequest(Request request) {
        if (request.getHeader("X-Requested-With") != null) {
            return true;
        }
        String accessControlRequestHeaders = request.getHeader("Access-Control-Request-Headers");
        return accessControlRequestHeaders != null && this.containsHeader(accessControlRequestHeaders, "X-Requested-With");
    }

    protected boolean containsHeader(String accessControlRequestHeaders, String header) {
        List<String> headers = this.splitCommaDelimitedString(accessControlRequestHeaders);
        return SasFallbackAuthenticatorValve.containsIgnoreCase(headers, header);
    }

    protected List<String> splitCommaDelimitedString(String s) {
        String[] list = s.replace(" ", "").split(",");
        if (list == null || list.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(list);
    }

    public static boolean containsIgnoreCase(List<String> list, String findMe) {
        for (String s : list) {
            if (!findMe.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }
}

