/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.authenticator;

import jakarta.servlet.ServletException;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class PrincipalFromRequestHeadersValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(PrincipalFromRequestHeadersValve.class);
    protected volatile String uriPattern = "/SASLogon/login.*$";
    protected volatile boolean fallThrough = true;
    protected volatile String userHeader = "X-Remote-User";
    protected volatile String secretPassword = null;
    protected volatile String roleName = "ROLE_USER";

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public void setFallThrough(String fallThrough) {
        this.fallThrough = Boolean.parseBoolean(fallThrough);
    }

    public void setUserHeader(String userHeader) {
        this.userHeader = userHeader;
    }

    public void setSecretPassword(String secretPassword) {
        this.secretPassword = secretPassword;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Principal principal;
        String requestURI = request.getRequestURI();
        if (request.getQueryString() != null && request.getQueryString().length() > 0) {
            requestURI = requestURI + "?" + request.getQueryString();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("URI: " + requestURI));
        }
        if ((principal = request.getUserPrincipal()) != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("Already authenticated '" + principal.getName() + "'"));
            }
        } else if (requestURI.matches(this.uriPattern)) {
            String remoteUser = request.getHeader(this.userHeader);
            boolean success = false;
            if (remoteUser != null) {
                String password;
                success = true;
                if (!(this.secretPassword == null || (password = this.getPassword(request)) != null && password.equals(this.secretPassword))) {
                    log.warn((Object)"Incorrect Authorization header in request");
                    success = false;
                }
                if (success) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating principal from remote user: " + remoteUser));
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(new String(this.roleName));
                    principal = new GenericPrincipal(remoteUser, null, list);
                    request.setUserPrincipal(principal);
                    success = true;
                }
            }
            if (!success && !this.fallThrough) {
                response.sendError(401, sm.getString("authenticator.unauthorized"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Authentication with Realm failed");
                }
            }
        }
        this.getNext().invoke(request, response);
    }

    private String getPassword(Request request) throws UnsupportedEncodingException {
        String authorization = request.getHeader("Authorization");
        String authType = "";
        int delim = authorization.indexOf(" ");
        if (delim != -1) {
            authType = authorization.substring(0, delim);
        }
        if (!authType.equals("Basic")) {
            log.warn((Object)("Authorization type not supported: '" + authType + "'"));
            return null;
        }
        byte[] decoded = DatatypeConverter.parseBase64Binary((String)authorization.substring(6));
        String decodedToken = new String(decoded, "UTF-8");
        delim = decodedToken.indexOf(":");
        if (delim == -1) {
            log.warn((Object)"Invalid format of Authorization header");
            return null;
        }
        return decodedToken.substring(delim + 1);
    }
}

