/*
 * Decompiled with CFR 0.152.
 */
package com.sas.vfabrictcsvr.atomikos;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.jdbc.internal.AbstractDataSourceBean;
import com.atomikos.jmx.jdbc.JmxAtomikosDataSourceBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BeanFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(BeanFactory.class);

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        String beanClassName = ref.getClassName();
        try {
            Class<?> beanClass = Class.forName(beanClassName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating instance of " + beanClassName));
            }
            Object bean = beanClass.newInstance();
            Enumeration<RefAddr> properties = ref.getAll();
            while (properties.hasMoreElements()) {
                RefAddr refAddr = properties.nextElement();
                String propertyName = refAddr.getType();
                if (propertyName.equals("factory") || propertyName.equals("singleton") || propertyName.equals("description") || propertyName.equals("scope") || propertyName.equals("auth")) continue;
                String propertyValue = (String)refAddr.getContent();
                if ("com.atomikos.jdbc.AtomikosDataSourceBean".equals(beanClassName) && "uniqueResourceName".equals(propertyName)) {
                    MBeanServer jmx = ManagementFactory.getPlatformMBeanServer();
                    ObjectName mBeanName = new ObjectName("atomikos:dataSource=" + propertyValue);
                    JmxAtomikosDataSourceBean jadsb = new JmxAtomikosDataSourceBean();
                    jadsb.setMonitoredBean((AbstractDataSourceBean)bean);
                    jmx.registerMBean(jadsb, mBeanName);
                    log.debug((Object)("registered " + mBeanName));
                }
                if (log.isDebugEnabled() && !"password".equals(propertyName) && !"xaProperties.password".equals(propertyName)) {
                    log.debug((Object)("Setting " + propertyName + "=" + propertyValue));
                }
                PropertyUtils.setProperty(bean, (String)propertyName, (Object)propertyValue);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing " + bean));
            }
            Method method = beanClass.getMethod("init", null);
            method.invoke(bean, (Object[])null);
            return bean;
        }
        catch (Exception e) {
            log.error((Object)(e.getClass().getName() + ": " + e.getMessage()));
            throw (NamingException)new NamingException("Error creating instance of: " + beanClassName).initCause(e);
        }
    }
}

