/*
 * Decompiled with CFR 0.152.
 */
package com.sas.web.services.common.operations;

import com.sas.metadata.remote.DeployedComponent;
import com.sas.web.services.common.WebServiceInfo;
import com.sas.web.services.common.WebServiceMaker;
import com.sas.web.services.common.operations.AbstractOperation;
import com.sas.web.services.common.operations.OperationState;
import java.net.URL;

public class CreateWebServiceOperation
extends AbstractOperation
implements Runnable {
    public CreateWebServiceOperation(WebServiceInfo info) {
        super(info);
    }

    public CreateWebServiceOperation(DeployedComponent dc, WebServiceInfo info) {
        super(dc, info);
    }

    @Override
    public void run() {
        this.returnedState = this.createWebService(this.wsInfo);
    }

    private OperationState createWebService(WebServiceInfo wsInfo) {
        OperationState cssRet = new OperationState();
        try {
            WebServiceMaker webServiceMaker = this.getWebServiceMaker();
            if (wsInfo.isOverwriteExisting()) {
                webServiceMaker.deleteService(wsInfo.getDeployedWebServiceName(), wsInfo.getUserContext());
            }
            String[] keywords = new String[wsInfo.getKeywordListModel().getSize()];
            for (int i = 0; i < keywords.length; ++i) {
                keywords[i] = (String)wsInfo.getKeywordListModel().get(i);
            }
            URL madeUrl = webServiceMaker.makeWebService(wsInfo.getDeployedWebServiceName(), wsInfo.getStoredProcesses(), wsInfo.getDeployedWebServiceNamespace(), keywords, wsInfo.getUserContext(), wsInfo.isPublishMetadata());
            cssRet.setWasSuccessful(true);
            if (madeUrl != null) {
                cssRet.setUrl(madeUrl.toString());
            } else {
                cssRet.setUrl(null);
            }
            return cssRet;
        }
        catch (Exception e) {
            cssRet.setWasSuccessful(false);
            cssRet.setCapturedThrowable(e);
            return cssRet;
        }
        catch (Error e) {
            cssRet.setWasSuccessful(false);
            cssRet.setCapturedThrowable(e);
            return cssRet;
        }
    }
}

