/*
 * Decompiled with CFR 0.152.
 */
package com.sas.web.services.common;

import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.web.services.common.RB;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import java.awt.Component;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;

public class WebServiceUtilities {
    public static void ShowScrollableError(String title, String shortMessage, String longMessage) {
        MessageUtil.displayDetailsMessage((String)shortMessage, (String)title, (int)0, (JComponent)WebServiceUtilities.getScrollableTextAreaWithMessage(longMessage));
    }

    public static String[] GenerateOtp(UserContextInterface userContext) throws ServiceException, RemoteException {
        ServerInterface authServer = userContext.getAuthServer();
        String[] credentials = new String[2];
        UserIdentityInterface id = authServer.generatePassword(null);
        credentials[0] = id.getPrincipal().toString();
        credentials[1] = id.getCredential().toString();
        return credentials;
    }

    private static String GetNestedMessagesFromDetail(OMElement detail) {
        StringBuilder sb = new StringBuilder();
        OMAttribute messageAttribute = detail.getAttribute(new QName(null, "message"));
        if (messageAttribute != null) {
            sb.append(MessageFormat.format(RB.getStringResource("WSU.MessageTrace.CausedBy.fmt"), messageAttribute.getAttributeValue()));
        }
        if (detail.getFirstElement() != null) {
            sb.append("\n" + WebServiceUtilities.GetNestedMessagesFromDetail(detail.getFirstElement()));
        }
        return sb.toString();
    }

    public static String GetErrorDetailFromAxisFault(AxisFault fault) {
        OMElement detail;
        OMAttribute codeAttr;
        String message = fault.getLocalizedMessage();
        if (fault.getDetail() != null && (codeAttr = (detail = fault.getDetail()).getAttribute(new QName(null, "code"))) != null && codeAttr.getAttributeValue() != null && !codeAttr.getAttributeValue().trim().equals("")) {
            message = message + " " + MessageFormat.format(RB.getStringResource("WSU.MessageTrace.ErrorCode.fmt"), codeAttr.getAttributeValue()) + WebServiceUtilities.GetNestedMessagesFromDetail(detail);
        }
        return message;
    }

    private static JScrollPane getScrollableTextAreaWithMessage(String message) {
        WATextArea textArea = new WATextArea(8, 60);
        textArea.setEditable(false);
        textArea.setLineWrap(false);
        textArea.setText(message);
        JScrollPane scrollPane = new JScrollPane((Component)textArea);
        return scrollPane;
    }
}

