/*
 * Decompiled with CFR 0.152.
 */
package com.sas.web.services.common;

import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.io.IOException;
import java.net.URL;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.wss4j.common.ext.WSPasswordCallback;

public class BIWebServiceClient
extends ServiceClient {
    public static final String WEB_SERVICES_NS_92 = "http://support.sas.com/xml/namespace/biwebservices/webservicemaker-9.2";
    public static final String LIST_WEB_SERVICES_ACTION_92 = "http://support.sas.com/xml/namespace/biwebservices/webservicemaker-9.2/ListWebServices";
    public static final String MAKE_WEB_SERVICE_ACTION_92 = "http://support.sas.com/xml/namespace/biwebservices/webservicemaker-9.2/MakeWebService";
    public static final String REMOVE_WEB_SERVICE_ACTION_92 = "http://support.sas.com/xml/namespace/biwebservices/webservicemaker-9.2/RemoveWebService";
    private static final int DEFAULT_CLIENT_TIMEOUT = 900000;
    private Options _options;

    private void setOptions(String endpoint, String action, String user, String password, int timeoutInMillis) throws AxisFault {
        Integer timeout = new Integer(timeoutInMillis);
        this._options = this.getOptions() == null ? new Options() : this.getOptions();
        this._options.setTo(new EndpointReference(endpoint));
        this._options.setAction(action);
        this._options.setCallTransportCleanup(true);
        this._options.setTransportInProtocol("http");
        this._options.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
        this._options.setProperty("__CHUNKED__", (Object)"false");
        this._options.setProperty("enableMTOM", (Object)"false");
        this._options.setProperty("SO_TIMEOUT", (Object)timeout);
        this._options.setProperty("CONNECTION_TIMEOUT", (Object)timeout);
        this._options.setProperty("mustUnderstand", (Object)"0");
        this.setOptions(this._options);
        if (user != null && password != null) {
            this._options.setProperty("WSAddressingVersion", (Object)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
            this._options.setProperty("passwordCallbackRef", (Object)new PWCBHandler(user, password));
            this._options.setProperty("user", (Object)user);
            Policy policy = new Policy();
            RampartConfig rampartConfig = new RampartConfig();
            rampartConfig.setUser(user);
            rampartConfig.setPwCbClass(PWCBHandler.class.getName());
            policy.addAssertion((Assertion)rampartConfig);
            this._options.setProperty("rampartPolicy", (Object)policy);
            this._options.setUserName(user);
            this._options.setPassword(password);
            this.engageModule("addressing");
        }
    }

    private void setOptions(String endpoint, String action, String user, String password) throws AxisFault {
        int timeout = 900000;
        try {
            WorkspaceFile workspaceFile = Workspace.getWorkspace().getAppDefaultsFile();
            timeout = workspaceFile.getPropertyInt("com.sas.metadata.logical.webservices.ClientTimeout.int", 900000);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.setOptions(endpoint, action, user, password, timeout);
    }

    public BIWebServiceClient(String epr, String action, String user, String password) throws AxisFault {
        this.setOptions(epr, action, user, password);
    }

    public BIWebServiceClient(URL endpoint, String action, String user, String password) throws AxisFault {
        this(endpoint.toExternalForm(), action, user, password);
    }

    public BIWebServiceClient(String epr, String action, String user, String password, ConfigurationContext ctx) throws AxisFault {
        super(ctx, null);
        this.setOptions(epr, action, user, password);
    }

    private class PWCBHandler
    implements CallbackHandler {
        private String _username;
        private String _password;

        public PWCBHandler(String username, String password) {
            this._username = username;
            this._password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                WSPasswordCallback pwcb = (WSPasswordCallback)callbacks[i];
                if (!pwcb.getIdentifier().equals(this._username)) continue;
                pwcb.setPassword(this._password);
                break;
            }
        }
    }
}

