/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.encoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.ImageFormatException;
import com.sas.visuals.image.encoder.KeyInt;
import com.sas.visuals.image.encoder.LEDataOutputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Hashtable;

@SASScope(value="ALL")
public class GifColorTable {
    public static final int ALPHA_THRESHOLD = 128;
    protected boolean isIndexed;
    protected boolean checkAlpha = true;
    protected boolean isTransparentIndexSet = false;
    protected ColorModel cModel;
    protected IndexColorModel iModel;
    protected byte transparentIndex;
    protected int alphaThreshold = 128;
    protected Hashtable hashedColors;
    protected KeyInt currentKey;
    protected short currentIndex;
    protected byte[] reds = new byte[256];
    protected byte[] blues = new byte[256];
    protected byte[] greens = new byte[256];

    public GifColorTable(ColorModel cm) {
        this.cModel = cm;
        if (cm instanceof IndexColorModel) {
            this.isIndexed = true;
            this.iModel = (IndexColorModel)cm;
            int tmpIndex = this.iModel.getTransparentPixel();
            if (tmpIndex != -1) {
                this.setTransparentIndex((byte)(0xFF & tmpIndex));
            }
        } else {
            this.hashedColors = new Hashtable();
            this.currentKey = new KeyInt(0);
            this.currentIndex = 0;
            this.hashedColors.put(this.currentKey, new Short(this.currentIndex));
        }
    }

    public boolean hasIndexColorModel() {
        return this.isIndexed;
    }

    public void setAlphaThreshold(int aThreshold) {
        this.alphaThreshold = aThreshold;
    }

    public int getAlphaThreshold() {
        return this.alphaThreshold;
    }

    public void setCheckAlpha(boolean check) {
        this.checkAlpha = check;
    }

    public void setTransparentIndex(byte tIndex) {
        this.transparentIndex = tIndex;
        this.isTransparentIndexSet = true;
    }

    public byte getTransparentIndex() {
        return this.transparentIndex;
    }

    public boolean isTransparent() {
        return this.isTransparentIndexSet;
    }

    public byte getColorIndex(byte red, byte green, byte blue) throws ImageFormatException {
        short index;
        boolean exists = false;
        int tmpColor = (0xFF & red) << 16 | (0xFF & green) << 8 | 0xFF & blue;
        if (tmpColor == this.currentKey.getValue()) {
            index = this.currentIndex;
        } else {
            this.currentKey.setValue(tmpColor);
            Short tmpShort = (Short)this.hashedColors.get(this.currentKey);
            if (tmpShort != null) {
                index = tmpShort;
            } else {
                KeyInt newKey = (KeyInt)this.currentKey.clone();
                int tmpIndex = this.hashedColors.size();
                if (tmpIndex > 255) {
                    throw new ImageFormatException("Number of colors exceeds 256");
                }
                index = (short)(0xFF & tmpIndex);
                this.hashedColors.put(newKey, new Short(index));
                this.reds[index] = red;
                this.greens[index] = green;
                this.blues[index] = blue;
            }
            this.currentIndex = index;
        }
        return (byte)index;
    }

    public byte[] convertToBytes(Object pixels) throws ImageFormatException {
        if (this.isIndexed) {
            if (!(pixels instanceof byte[])) {
                throw new ImageFormatException("Non-Byte pixel data not supported for IndexColorModel");
            }
            return (byte[])pixels;
        }
        int[] pixelInts = (int[])pixels;
        int numPixels = pixelInts.length;
        byte[] pixelBytes = new byte[numPixels];
        for (int i = 0; i < numPixels; ++i) {
            int alphaVal;
            int curPixel = pixelInts[i];
            byte redVal = (byte)(0xFF & this.cModel.getRed(curPixel));
            byte greenVal = (byte)(0xFF & this.cModel.getGreen(curPixel));
            byte blueVal = (byte)(0xFF & this.cModel.getBlue(curPixel));
            pixelBytes[i] = this.getColorIndex(redVal, greenVal, blueVal);
            if (!this.checkAlpha || this.isTransparentIndexSet || (alphaVal = this.cModel.getAlpha(curPixel)) >= this.alphaThreshold) continue;
            this.setTransparentIndex(pixelBytes[i]);
        }
        return pixelBytes;
    }

    public int getNumColors() {
        int tmpNumColors = this.isIndexed ? this.iModel.getMapSize() : this.hashedColors.size();
        return tmpNumColors;
    }

    public int getPixelBitSize() {
        int numColors = this.getNumColors();
        int numBits = numColors == 0 ? 0 : (numColors < 3 ? 1 : (numColors < 5 ? 2 : (numColors < 9 ? 3 : (numColors < 17 ? 4 : (numColors < 33 ? 5 : (numColors < 65 ? 6 : (numColors < 129 ? 7 : 8)))))));
        return numBits;
    }

    public void writeTo(LEDataOutputStream os) throws IOException {
        int i;
        if (this.isIndexed) {
            this.iModel.getReds(this.reds);
            this.iModel.getGreens(this.greens);
            this.iModel.getBlues(this.blues);
        }
        int colorMapLength = this.getNumColors();
        int closestPowerOfTwo = 1 << this.getPixelBitSize();
        for (i = 0; i < colorMapLength; ++i) {
            os.write(this.reds[i]);
            os.write(this.greens[i]);
            os.write(this.blues[i]);
        }
        for (i = colorMapLength; i < closestPowerOfTwo; ++i) {
            os.write(0);
            os.write(0);
            os.write(0);
        }
    }
}

