/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder.compression;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.decoder.compression.ImageCompressionException;

@SASScope(value="ALL")
public abstract class CompressionScheme {
    protected byte[] inBytes;
    protected int xSize;
    protected int ySize;
    protected int uncompressedSize;
    protected long optionFlags;

    public CompressionScheme(byte[] inputBytes, int iXSize, int iScanLineSize, int iYSize) throws ImageCompressionException {
        this.inBytes = inputBytes;
        this.xSize = iXSize;
        this.ySize = iYSize;
        this.uncompressedSize = this.ySize * iScanLineSize;
    }

    public void finalizer() {
        this.inBytes = null;
    }

    public abstract byte[] uncompress() throws ImageCompressionException;

    public abstract byte[] compress() throws ImageCompressionException;

    public void setOptions(long iOptions) {
        this.optionFlags = iOptions;
        Debug.println("Options=" + Long.toHexString(this.optionFlags));
    }
}

