/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder.compression;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;

@SASScope(value="ALL")
public class BitBuffer {
    public static final boolean MSB_FILL = false;
    public static final boolean LSB_FILL = true;
    static final int[] onesFill = new int[]{1, 3, 7, 15, 31, 63, 127, 255};
    static final int[] onesMask = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    protected byte[] buff;
    protected int sizeInBits;
    protected boolean fillOrder;
    protected int bitOffset;
    protected int byteOffset;
    protected int maxByteOffset;
    protected int maxBitOffset;

    public BitBuffer(int inLength, boolean iFillOrder) {
        int byteRoundedLength = (inLength + 7) / 8;
        this.buff = new byte[byteRoundedLength];
        this.maxByteOffset = byteRoundedLength - 1;
        this.sizeInBits = inLength;
        this.maxBitOffset = (this.sizeInBits - 1) % 8;
        this.fillOrder = iFillOrder;
        this.bitOffset = 0;
        this.byteOffset = 0;
    }

    public BitBuffer(byte[] bitData, boolean iFillOrder) {
        this.buff = bitData;
        this.sizeInBits = bitData.length * 8;
        this.fillOrder = iFillOrder;
        this.bitOffset = 0;
        this.byteOffset = 0;
    }

    public void finalizer() {
        this.buff = null;
    }

    public void fillOnes(int length) {
        if (length + this.byteOffset * 8 + this.bitOffset > this.sizeInBits) {
            Debug.println("Exceeded allocated size");
        }
        if (length == 0) {
            Debug.println("Zero length");
            return;
        }
        if (this.bitOffset != 0) {
            int bitsLeft = 8 - this.bitOffset;
            if (length < bitsLeft) {
                int orValue = onesFill[length - 1];
                int shiftIndex = bitsLeft - length;
                int n = this.byteOffset;
                this.buff[n] = (byte)(this.buff[n] | orValue << shiftIndex);
                this.bitOffset += length;
                return;
            }
            int orValue = onesFill[bitsLeft - 1];
            int shiftIndex = 0;
            int n = this.byteOffset++;
            this.buff[n] = (byte)(this.buff[n] | orValue << shiftIndex);
            length -= bitsLeft;
            this.bitOffset = 0;
        }
        int bytesLeft = length / 8;
        while (bytesLeft > 0) {
            this.buff[this.byteOffset] = (byte)onesFill[7];
            --bytesLeft;
            ++this.byteOffset;
        }
        int trailingBitsLeft = length % 8;
        if (trailingBitsLeft > 0) {
            int orValue = onesFill[trailingBitsLeft - 1];
            int n = this.byteOffset;
            this.buff[n] = (byte)(this.buff[n] | orValue << 8 - trailingBitsLeft);
            this.bitOffset = trailingBitsLeft;
        }
    }

    public void fillZeros(int length) {
        if (length + this.byteOffset * 8 + this.bitOffset > this.sizeInBits) {
            Debug.println("Exceeded allocated size");
        }
        if (length == 0) {
            Debug.println("Zero length");
            return;
        }
        if (this.bitOffset != 0) {
            int bitsLeft = 8 - this.bitOffset;
            if (length < bitsLeft) {
                this.bitOffset += length;
                return;
            }
            length -= bitsLeft;
            ++this.byteOffset;
            this.bitOffset = 0;
        }
        int bytesLeft = length / 8;
        this.byteOffset += bytesLeft;
        int trailingBitsLeft = length % 8;
        if (trailingBitsLeft > 0) {
            this.bitOffset = trailingBitsLeft;
        }
    }

    public void copy(BitBuffer iBuff) {
        int iLength = iBuff.buff.length;
        int selfLength = this.buff.length;
        if (iLength > selfLength) {
            Debug.println("Insufficient length: self=" + selfLength + " iBuff=" + iLength);
        }
        System.arraycopy(iBuff.buff, 0, this.buff, 0, selfLength);
    }

    public void append(BitBuffer tail) {
        int tailLength = tail.getSizeInBits();
        if (tailLength + this.getOffset() > this.sizeInBits) {
            Debug.println("Exceeded allocated size");
        }
        if (tailLength == 0) {
            Debug.println("Zero length");
            return;
        }
        tail.seek(0);
        while (tailLength > 0) {
            this.fill(1, tail.extract() == 1);
            --tailLength;
        }
        tail.seek(0);
    }

    public void fill(int length, boolean isWhitePixel) {
        if (isWhitePixel) {
            this.fillOnes(length);
        } else {
            this.fillZeros(length);
        }
    }

    public int extract() {
        int curBit = this.getBit(this.byteOffset, this.bitOffset);
        if (this.bitOffset == 7) {
            this.bitOffset = 0;
            ++this.byteOffset;
        } else {
            ++this.bitOffset;
        }
        return curBit;
    }

    private int getBit(int iByteOff, int iBitOff) {
        return (this.buff[iByteOff] & onesMask[iBitOff]) == 0 ? 0 : 1;
    }

    public void seek(int length) {
        this.byteOffset = length / 8;
        this.bitOffset = length % 8;
    }

    public void reset() {
        int tmpByteOffset = this.maxByteOffset;
        while (tmpByteOffset >= 0) {
            this.buff[tmpByteOffset--] = 0;
        }
        this.seek(0);
    }

    public int findBit(boolean isWhitePixel) {
        int newBit;
        int refBit;
        int n = refBit = isWhitePixel ? 1 : 0;
        if (this.byteOffset >= this.maxByteOffset && this.bitOffset > this.maxBitOffset) {
            return -1;
        }
        while (refBit != (newBit = this.extract()) && (this.byteOffset < this.maxByteOffset || this.byteOffset == this.maxByteOffset && this.bitOffset <= this.maxBitOffset)) {
        }
        if (refBit == newBit) {
            return this.getOffset() - 1;
        }
        return -1;
    }

    public int findOppositeRun(boolean currentRunIsWhite) {
        boolean initialBitIsWhite;
        boolean bl = initialBitIsWhite = this.getBit(this.byteOffset, this.bitOffset) == 1;
        if (initialBitIsWhite != currentRunIsWhite) {
            this.findBit(currentRunIsWhite);
        }
        return this.findBit(!currentRunIsWhite);
    }

    public void nextByteBoundary() {
        if (this.bitOffset != 0) {
            ++this.byteOffset;
            this.bitOffset = 0;
        }
    }

    public byte[] getByteBuffer() {
        return this.buff;
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public int getOffset() {
        return this.byteOffset * 8 + this.bitOffset;
    }

    public String toString() {
        return this.dumpBytes(0, this.buff.length);
    }

    public String dumpBytes(int fromByte, int toByte) {
        int size = toByte - fromByte;
        StringBuffer tmpStr = new StringBuffer(size);
        int i = 0;
        int j = fromByte;
        while (i < size) {
            if (i % 5 == 0) {
                tmpStr.append("\n");
            }
            String binaryStr = Integer.toBinaryString(0xFF & this.buff[j]);
            int currLength = tmpStr.length();
            for (int padLength = 8 - binaryStr.length(); padLength != 0; --padLength) {
                tmpStr.insert(currLength, '0');
            }
            tmpStr.append(binaryStr + " ");
            ++i;
            ++j;
        }
        tmpStr.append("\nOffsets Byte=" + this.byteOffset + " Bit=" + this.bitOffset);
        return tmpStr.toString();
    }
}

