/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.Debug;
import com.sas.visuals.image.ImageException;
import com.sas.visuals.image.ImageFormatException;
import com.sas.visuals.image.ImageProperties;
import com.sas.visuals.image.RAFileWrapper;
import com.sas.visuals.image.decoder.BufferRandomAccessor;
import com.sas.visuals.image.decoder.FileRandomAccessor;
import com.sas.visuals.image.decoder.ImageDecoder;
import com.sas.visuals.image.decoder.LERAStream;
import com.sas.visuals.image.decoder.RAStream;
import com.sas.visuals.image.decoder.RandomAccessor;
import com.sas.visuals.image.decoder.ReverseFill;
import com.sas.visuals.image.decoder.TiffIFD;
import com.sas.visuals.image.decoder.TiffMissingFieldException;
import com.sas.visuals.image.decoder.compression.Ccitt1DCScheme;
import com.sas.visuals.image.decoder.compression.Ccitt1DG3CScheme;
import com.sas.visuals.image.decoder.compression.CcittG3CScheme;
import com.sas.visuals.image.decoder.compression.CcittG4CScheme;
import com.sas.visuals.image.decoder.compression.CompressionScheme;
import com.sas.visuals.image.decoder.compression.PackBitsCScheme;
import java.io.IOException;
import java.io.InputStream;

@SASScope(value="ALL")
public class TiffDecoder
extends ImageDecoder {
    public static final byte[] imgSignatureLilEnd = new byte[]{73, 73, 42, 0};
    public static final byte[] imgSignatureBigEnd = new byte[]{77, 77, 0, 42};
    protected boolean bigEndian;
    protected TiffIFD tIFD;
    protected RandomAccessor raObj;
    protected RAStream raStrm;
    protected int compresType;
    protected static boolean ccittBWFlip = true;

    TiffDecoder(InputStream iStrm) throws IOException, ImageFormatException {
        super(iStrm);
        if (iStrm instanceof RAFileWrapper) {
            RAFileWrapper rafWrapper = (RAFileWrapper)iStrm;
            Debug.println("TiffDecoder.<init>: RAFileWrapper detected");
            this.raObj = new FileRandomAccessor(rafWrapper.getFileName());
        } else {
            Debug.println("TiffDeocder.<init>: inputStream detected");
            this.raObj = new BufferRandomAccessor(iStrm);
        }
        iStrm.mark(2);
        int byteOrder = iStrm.read();
        iStrm.reset();
        switch (byteOrder) {
            case 73: {
                this.bigEndian = false;
                this.raStrm = new LERAStream(this.raObj);
                break;
            }
            case 77: {
                this.bigEndian = true;
                this.raStrm = new RAStream(this.raObj);
                break;
            }
            default: {
                throw new ImageFormatException("Bad TIFF byte order=" + byteOrder);
            }
        }
        this.initIFD();
    }

    public void finalizer() {
    }

    public static boolean matchFormat(byte[] iSign) {
        return ImageDecoder.compareBytes(imgSignatureBigEnd, iSign) || ImageDecoder.compareBytes(imgSignatureLilEnd, iSign);
    }

    @Override
    public byte[] getColorMap() throws TiffMissingFieldException {
        int numEntries;
        long[] tiffCmap = (long[])this.tIFD.getFieldValue(320);
        int tiffCmapLength = tiffCmap.length;
        int gOffset = numEntries = tiffCmapLength / 3;
        int bOffset = 2 * numEntries;
        byte[] cmap = new byte[tiffCmapLength];
        if (numEntries > 256) {
            Debug.println("WARNING: ColorMapEntries=" + numEntries + "exceeds 256 (8bit)");
        }
        for (int i = 0; i < numEntries; ++i) {
            cmap[3 * i] = (byte)(tiffCmap[i] >> 8);
            cmap[3 * i + 1] = (byte)(tiffCmap[i + gOffset] >> 8);
            cmap[3 * i + 2] = (byte)(tiffCmap[i + bOffset] >> 8);
        }
        return cmap;
    }

    @Override
    public byte[] getRawImageData(ImageProperties iProps) throws IOException, ImageException {
        CompressionScheme cScheme;
        byte[] rawImageData = this.tIFD.getImageData();
        long[] defValue = new long[]{0L};
        Debug.println("TiffDecoder.getRawImageData: CompressionType=" + this.compresType);
        if (iProps.getFillOrder() == 1) {
            ReverseFill.convertToMSB(rawImageData);
        }
        switch (this.compresType) {
            case 1: {
                return rawImageData;
            }
            case 32773: {
                cScheme = new PackBitsCScheme(rawImageData, iProps.getXSize(), iProps.getScanLineSize(), iProps.getYSize());
                break;
            }
            case 2: {
                cScheme = new Ccitt1DCScheme(rawImageData, iProps.getXSize(), iProps.getScanLineSize(), iProps.getYSize());
                break;
            }
            case 3: {
                long t4Options = ((long[])this.tIFD.getFieldValue(292, defValue))[0];
                cScheme = (t4Options & 1L) == 1L ? new CcittG3CScheme(rawImageData, iProps.getXSize(), iProps.getScanLineSize(), iProps.getYSize()) : new Ccitt1DG3CScheme(rawImageData, iProps.getXSize(), iProps.getScanLineSize(), iProps.getYSize());
                cScheme.setOptions(t4Options);
                break;
            }
            case 4: {
                long t6Options = ((long[])this.tIFD.getFieldValue(293, defValue))[0];
                CcittG4CScheme tmpCS = new CcittG4CScheme(rawImageData, iProps.getXSize(), iProps.getScanLineSize(), iProps.getYSize());
                tmpCS.setOptions(t6Options);
                tmpCS.rowsPerStrip = ((long[])this.tIFD.getFieldValue(278, defValue))[0];
                tmpCS.stripCummCounts = (long[])this.tIFD.getFieldValue(279);
                for (int i = 1; i < tmpCS.stripCummCounts.length; ++i) {
                    int n = i;
                    tmpCS.stripCummCounts[n] = tmpCS.stripCummCounts[n] + tmpCS.stripCummCounts[i - 1];
                }
                Debug.println("Rows/Strip=" + tmpCS.rowsPerStrip + " NumStrips=" + tmpCS.stripCummCounts.length);
                cScheme = tmpCS;
                tmpCS = null;
                break;
            }
            default: {
                throw new IOException("Unsupported: Compression type=" + this.compresType);
            }
        }
        return cScheme.uncompress();
    }

    @Override
    public ImageProperties getImageProperties() throws TiffMissingFieldException, ImageFormatException {
        int cmType;
        ImageProperties iProps = new ImageProperties("TIFF");
        iProps.setXSize(this.tIFD.getImageWidth());
        iProps.setYSize(this.tIFD.getImageLength());
        iProps.setPixelSizeInSamples(this.tIFD.getSamplesPerPixel());
        iProps.setSampleSizeInBits(this.tIFD.getBitsPerSample());
        iProps.calcScanLineSizes();
        int fillOrder = this.tIFD.getFillOrder();
        if (fillOrder == 1) {
            iProps.setFillOrder(0);
        } else if (fillOrder == 2) {
            iProps.setFillOrder(1);
        } else {
            throw new ImageFormatException("Unknown TIFF Fill Order=" + fillOrder);
        }
        if (this.tIFD.getPlanarConfiguration() != 1) {
            throw new ImageFormatException("Unsupported PlanarConfiguration=2");
        }
        this.compresType = this.tIFD.getCompression();
        short tiffCMType = (short)this.tIFD.getPhotometricInterpretation();
        switch (tiffCMType) {
            case 1: {
                tiffCMType = this.adjustCMTypeForCcitt(tiffCMType);
            }
            case 0: {
                cmType = tiffCMType == 0 ? 0 : 1;
                break;
            }
            case 2: {
                cmType = 2;
                break;
            }
            case 3: {
                cmType = 3;
                break;
            }
            default: {
                throw new ImageFormatException("Unknown TIFF Photometric Interpretation type =" + tiffCMType);
            }
        }
        iProps.setColorModelType(cmType);
        return iProps;
    }

    public static void ccittBWFlip(boolean flip) {
        ccittBWFlip = flip;
    }

    private short adjustCMTypeForCcitt(short tiffCMType) {
        Debug.println("TiffDecoder.ccittBWFlip = " + ccittBWFlip);
        if (ccittBWFlip && (this.compresType == 2 || this.compresType == 3 || this.compresType == 4)) {
            Debug.println("TiffDecoder: B/W flipped: CCITT compress. & PI=BlackIsZero");
            tiffCMType = tiffCMType == 1 ? (short)0 : 1;
        }
        return tiffCMType;
    }

    private void initIFD() throws IOException {
        this.raStrm.seek(4L);
        long offset = this.raStrm.readUnsignedInt();
        this.tIFD = new TiffIFD(this.raStrm, offset);
        this.tIFD.init();
    }
}

