/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image.decoder;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.image.decoder.RAStream;
import com.sas.visuals.image.decoder.RandomAccessor;
import java.io.IOException;

@SASScope(value="ALL")
public class LERAStream
extends RAStream {
    public LERAStream(RandomAccessor inRAObj) throws IOException {
        super(inRAObj);
    }

    @Override
    public void finalize() throws IOException {
        super.close();
    }

    @Override
    public short readShort() throws IOException {
        return (short)(this.readUnsignedByte() | this.readUnsignedByte() << 8);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return 0xFFFF & this.readShort();
    }

    @Override
    public char readChar() throws IOException {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        return (char)(ch2 << 8 | ch1);
    }

    @Override
    public int readInt() throws IOException {
        return this.readUnsignedShort() | this.readUnsignedShort() << 16;
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return 0xFFFFFFFF & this.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() & 0xFFFFFFFFL) + (long)(this.readInt() << 32);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }
}

