/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.image;

import com.sas.codepolicy.SASScope;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.io.Serializable;
import java.util.Hashtable;

@SASScope(value="ALL")
public class MirrorFilter
extends ImageFilter
implements Serializable {
    static final long serialVersionUID = 7934694141950031540L;
    int width;
    int height;

    public void setProperties(Hashtable props) {
        String key = "mirror";
        String val = "Yes";
        Object o = (props = (Hashtable)props.clone()).get(key);
        if (o != null && o instanceof String) {
            val = (String)o + ", " + val;
        }
        props.put(key, val);
        super.setProperties(props);
    }

    @Override
    public void setDimensions(int iWidth, int iHeight) {
        this.width = iWidth;
        this.height = iHeight;
        super.setDimensions(this.width, this.height);
    }

    @Override
    public void setHints(int hints) {
        hints &= 0xFFFFFFFD;
        super.setHints((hints &= 0xFFFFFFFB) | 1);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        byte[] outputBuffer = new byte[w * h];
        int k = 0;
        for (int j = 0; j < h; ++j) {
            for (int i = w - 1; i >= 0; --i) {
                int srcIndex = off + i + scansize * j;
                outputBuffer[k++] = pixels[srcIndex];
            }
        }
        int dX = this.width - w - x;
        super.setPixels(dX, y, w, h, model, outputBuffer, 0, w);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int[] outputBuffer = new int[w * h];
        int k = 0;
        for (int j = 0; j < h; ++j) {
            for (int i = w - 1; i >= 0; --i) {
                int srcIndex = off + i + scansize * j;
                outputBuffer[k++] = pixels[srcIndex];
            }
        }
        int dX = this.width - w - x;
        super.setPixels(dX, y, w, h, model, outputBuffer, 0, w);
    }
}

