/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.visuals.Direction;
import com.sas.visuals.Group;
import com.sas.visuals.Justification;
import com.sas.visuals.Row;
import com.sas.visuals.Sizing;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;

public class RowLayout
implements LayoutManager2,
Direction,
Sizing,
Justification,
Serializable {
    static final long serialVersionUID = -5775922319625941510L;
    public static final int NONE = 0;
    public static final int TOP = 4;
    public static final int BOTTOM = 8;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    int rightMargin;
    int leftMargin;
    int topMargin;
    int bottomMargin;
    int spacing;
    int rowSpacing;
    int compSizing;
    int justification;
    int orientation;
    int fillFrom;
    int rowStyle;
    int rowHeight;
    int firstGroup;
    int firstRow;
    int rowCount;
    int prevStartIndex;
    int startIndex;
    int endIndex;
    int thresholdCount;
    Vector groups;
    Vector rowStartPositions;
    Group allGroups;
    Dimension componentSize;
    public static final int SINGLEROW = 0;
    public static final int MULTIROW = 1;

    public RowLayout() {
        this(0, 1, 4, 6, 0, 0, 0, 0, 0, 0, 0);
    }

    public RowLayout(int sizing, int just, int orient, int fill, int style, int compSpacing, int rSpacing) {
        this(sizing, just, orient, fill, style, compSpacing, rSpacing, 0, 0, 0, 0);
    }

    public RowLayout(int sizing, int just, int orient, int fill, int style, int compSpacing, int rSpacing, int right, int left, int top, int bottom) {
        this.rightMargin = right;
        this.leftMargin = left;
        this.topMargin = top;
        this.bottomMargin = bottom;
        this.spacing = compSpacing;
        this.rowSpacing = rSpacing;
        this.compSizing = sizing;
        this.justification = just;
        this.orientation = orient;
        this.fillFrom = fill;
        this.rowStyle = style;
        this.startIndex = 0;
        this.endIndex = 0;
        this.firstRow = 0;
        this.rowCount = 1;
        this.rowStartPositions = new Vector();
        this.groups = new Vector();
        this.allGroups = new Group();
        this.componentSize = new Dimension();
        this.thresholdCount = 2;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public Dimension getComponentSize() {
        return this.componentSize;
    }

    protected Dimension getMaximumSize() {
        int ncomponents = this.allGroups.components.size();
        Dimension maxSize = new Dimension(0, 0);
        if (this.compSizing == 1 && this.componentSize != null) {
            return new Dimension(this.componentSize);
        }
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = (Component)this.allGroups.components.elementAt(i);
            Dimension d = comp.getMinimumSize();
            if (maxSize.width < d.width) {
                maxSize.width = d.width;
            }
            if (maxSize.height >= d.height) continue;
            maxSize.height = d.height;
        }
        return maxSize;
    }

    public int getFillFrom() {
        return this.fillFrom;
    }

    public int getJustification() {
        return this.justification;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getGroupIndex(Component comp) {
        for (int i = 0; i < this.groups.size(); ++i) {
            Group grp = (Group)this.groups.elementAt(i);
            if (!grp.components.contains(comp)) continue;
            return i;
        }
        return 0;
    }

    public int getRowIndex(int grpIndex, int tabIndex) {
        Group grp = (Group)this.groups.elementAt(grpIndex);
        for (int i = 0; i < grp.rows.size(); ++i) {
            Row row = (Row)grp.rows.elementAt(i);
            if (row.start > tabIndex || row.end <= tabIndex) continue;
            return i;
        }
        return -1;
    }

    public Vector getGroup(int index) {
        Group group = (Group)this.groups.elementAt(index);
        return group.components;
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Vector getAllGroups() {
        int i;
        Vector grps = new Vector();
        for (int i2 = 0; i2 < this.groups.size(); ++i2) {
            if (i2 == this.firstGroup) continue;
            Group grp = (Group)this.groups.elementAt(i2);
            for (int j = 0; j < grp.components.size(); ++j) {
                grps.addElement(grp.components.elementAt(j));
            }
        }
        Group group1 = (Group)this.groups.elementAt(this.firstGroup);
        Row row1 = (Row)group1.rows.elementAt(this.firstRow);
        Vector rowComponents = new Vector();
        for (i = group1.components.size() - 1; i >= 0; --i) {
            if (row1.start <= i && row1.end > i) {
                rowComponents.addElement(group1.components.elementAt(i));
                continue;
            }
            grps.insertElementAt(group1.components.elementAt(i), 0);
        }
        for (i = 0; i < rowComponents.size(); ++i) {
            grps.insertElementAt(rowComponents.elementAt(i), 0);
        }
        return grps;
    }

    public int getRowCount(int grpIndex) {
        Group grp = (Group)this.groups.elementAt(grpIndex);
        return grp.rows.size();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getRowSpacing() {
        return this.rowSpacing;
    }

    public Vector getRowStartPositions() {
        return this.rowStartPositions;
    }

    public int getRowStyle() {
        return this.rowStyle;
    }

    public int getSizing() {
        return this.compSizing;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public Dimension setComponentSize(Dimension newSize) {
        if (newSize == null) {
            this.componentSize = null;
        } else if (this.componentSize == null) {
            this.componentSize = new Dimension(newSize);
        } else {
            this.componentSize.width = newSize.width;
            this.componentSize.height = newSize.height;
        }
        return this.componentSize;
    }

    public void setFillFrom(int fill) {
        this.fillFrom = fill;
    }

    public void setTopMargin(int margin) {
        this.topMargin = margin;
    }

    public void setBottomMargin(int margin) {
        this.bottomMargin = margin;
    }

    public void setRightMargin(int margin) {
        this.rightMargin = margin;
    }

    public void setLeftMargin(int margin) {
        this.leftMargin = margin;
    }

    public void setJustification(int just) {
        this.justification = just;
    }

    public void setOrientation(int orient) {
        this.orientation = orient;
    }

    public void setRowStyle(int style) {
        this.rowStyle = style;
    }

    public void setRowSpacing(int gap) {
        this.rowSpacing = gap;
    }

    public void setFirstGroup(int index) {
        this.firstGroup = index;
    }

    public void setFirstRow(int index) {
        this.firstRow = index;
    }

    public void setSizing(int sizing) {
        this.compSizing = sizing;
    }

    public void setSpacing(int gap) {
        this.spacing = gap;
    }

    public boolean isDecrementable() {
        int ncomponents = this.allGroups.components.size();
        for (int i = this.startIndex - 1; i >= 0; --i) {
            Component comp;
            if (this.startIndex >= ncomponents || !(comp = (Component)this.allGroups.components.elementAt(i)).isVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean isIncrementable() {
        int ncomponents = this.allGroups.components.size();
        for (int i = this.endIndex + 1; i < ncomponents; ++i) {
            Component comp = (Component)this.allGroups.components.elementAt(i);
            if (!comp.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void incrementStartIndex() {
        int ncomponents = this.allGroups.components.size();
        boolean incrementTwice = true;
        if (((Component)this.allGroups.components.elementAt(this.startIndex)).isVisible()) {
            incrementTwice = false;
        }
        for (int i = this.startIndex + 1; i < ncomponents; ++i) {
            Component comp = (Component)this.allGroups.components.elementAt(i);
            if (comp.isVisible() && !incrementTwice) {
                this.startIndex = i;
                return;
            }
            if (!comp.isVisible() || !incrementTwice) continue;
            incrementTwice = false;
        }
        if (this.startIndex + 1 < ncomponents) {
            ++this.startIndex;
        }
    }

    public void incrementEndIndex() {
        int ncomponents = this.allGroups.components.size();
        if (this.endIndex + 1 >= ncomponents || this.endIndex < 0) {
            return;
        }
        Component currentEndComponent = (Component)this.allGroups.components.elementAt(this.endIndex);
        Component nextComponent = (Component)this.allGroups.components.elementAt(this.endIndex + 1);
        Container parent = currentEndComponent.getParent();
        if (parent == null) {
            return;
        }
        Insets insets = parent.getInsets();
        Dimension availSize = new Dimension();
        Dimension parentSize = parent.getSize();
        availSize.height = parentSize.height - insets.top - insets.bottom - this.topMargin - this.bottomMargin;
        availSize.width = parentSize.width - insets.left - insets.right - this.leftMargin - this.rightMargin;
        Rectangle bounds = currentEndComponent.getBounds();
        int startWidth = availSize.width - (bounds.x + bounds.width);
        int startHeight = availSize.height - (bounds.y + bounds.height);
        Dimension nextCompSize = nextComponent.getPreferredSize();
        if (this.compSizing == 1) {
            nextCompSize = this.componentSize;
        }
        Dimension startSize = new Dimension(startWidth, startHeight);
        for (int i = this.startIndex; i < this.endIndex + 1; ++i) {
            Component comp = (Component)this.allGroups.components.elementAt(i);
            Dimension compDimension = comp.getPreferredSize();
            if (this.compSizing == 1) {
                compDimension = this.componentSize;
            }
            if (comp.isVisible()) {
                startSize.width += compDimension.width + this.spacing;
                startSize.height += compDimension.height + this.spacing;
            }
            if ((this.orientation == 4 || this.orientation == 8) && nextCompSize.width <= startSize.width) {
                this.startIndex = i + 1;
                ++this.endIndex;
                return;
            }
            if (this.orientation != 1 && this.orientation != 2 || nextCompSize.height > startSize.height) continue;
            this.startIndex = i + 1;
            ++this.endIndex;
            return;
        }
        this.startIndex = this.endIndex + 1;
        ++this.endIndex;
    }

    public void decrementStartIndex() {
        boolean decrementTwice = true;
        if (((Component)this.allGroups.components.elementAt(this.startIndex)).isVisible()) {
            decrementTwice = false;
        }
        for (int i = this.startIndex - 1; i >= 0; --i) {
            Component comp = (Component)this.allGroups.components.elementAt(i);
            if (comp.isVisible() && !decrementTwice) {
                this.startIndex = i;
                return;
            }
            if (!comp.isVisible() || !decrementTwice) continue;
            decrementTwice = false;
        }
        if (this.startIndex > 0) {
            --this.startIndex;
        }
    }

    public void setStartIndex(int index) {
        this.startIndex = index;
        if (this.startIndex >= this.allGroups.components.size() || this.startIndex < 0) {
            this.startIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reorderComponents(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int size = this.allGroups.components.size();
            if (size > 0) {
                Component comp = (Component)this.allGroups.components.elementAt(0);
                if (comp.getParent() != parent) {
                    return;
                }
            } else {
                return;
            }
            Vector<Group> newGroups = new Vector<Group>();
            Group newAllGroups = new Group();
            for (int i = 0; i < this.groups.size(); ++i) {
                newGroups.addElement(new Group());
            }
            Component[] comps = parent.getComponents();
            block4: for (int i = 0; i < comps.length; ++i) {
                if (!this.allGroups.components.contains(comps[i])) continue;
                newAllGroups.components.addElement(comps[i]);
                for (int j = 0; j < this.groups.size(); ++j) {
                    if (!((Group)this.groups.elementAt((int)j)).components.contains(comps[i])) continue;
                    ((Group)this.groups.elementAt((int)j)).components.removeElement(comps[i]);
                    ((Group)newGroups.elementAt((int)j)).components.addElement(comps[i]);
                    continue block4;
                }
            }
            this.allGroups.removeAllElements();
            this.allGroups = newAllGroups;
            this.groups.removeAllElements();
            this.groups = newGroups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints == null || constraints instanceof String || constraints instanceof Integer) {
                Integer idx = constraints == null ? new Integer(0) : (constraints instanceof String ? new Integer((String)constraints) : (Integer)constraints);
                int index = idx;
                if (index >= 0) {
                    if (index >= this.groups.size()) {
                        Group newGroup = new Group();
                        newGroup.components.addElement(comp);
                        this.groups.addElement(newGroup);
                    } else {
                        ((Group)this.groups.elementAt((int)index)).components.addElement(comp);
                    }
                    this.allGroups.components.addElement(comp);
                }
            } else {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a String or Integer type (or null)");
            }
        }
    }

    @Override
    public void addLayoutComponent(String group, Component comp) {
        this.addLayoutComponent(comp, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this.groups.size(); ++i) {
                Group grp = (Group)this.groups.elementAt(i);
                if (!grp.components.contains(comp)) continue;
                this.allGroups.components.removeElement(comp);
                grp.components.removeElement(comp);
                if (grp.components.size() != 0) break;
                this.groups.removeElement(grp);
                break;
            }
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    public int getThresholdCount() {
        return this.thresholdCount;
    }

    public void setThresholdCount(int number) {
        this.thresholdCount = number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension maxSize;
            Insets insets = parent.getInsets();
            int ncomponents = this.allGroups.components.size();
            if (ncomponents == 0) {
                return new Dimension(0, 0);
            }
            int marginWidth = insets.left + insets.right + this.leftMargin + this.rightMargin;
            int marginHeight = insets.top + insets.bottom + this.topMargin + this.bottomMargin;
            int preferredWidth = 0;
            int preferredHeight = 0;
            int groupHeight = 0;
            int groupWidth = 0;
            Dimension preferredSize = new Dimension();
            Dimension d = maxSize = this.getMaximumSize();
            for (int i = 0; i < this.groups.size(); ++i) {
                Group grp = (Group)this.groups.elementAt(i);
                int tCount = this.thresholdCount;
                if (this.thresholdCount == -1) {
                    tCount = grp.components.size();
                }
                for (int j = 0; j < grp.components.size() && j < tCount; ++j) {
                    Component comp = (Component)grp.components.elementAt(j);
                    if (this.compSizing == 0) {
                        d = comp.getPreferredSize();
                    }
                    if (!comp.isVisible()) continue;
                    if (this.orientation == 1 || this.orientation == 2) {
                        groupHeight = groupHeight + d.height + this.spacing;
                        if (d.width <= groupWidth) continue;
                        groupWidth = d.width;
                        continue;
                    }
                    groupWidth = groupWidth + d.width + this.spacing;
                    if (d.height <= groupHeight) continue;
                    groupHeight = d.height;
                }
                if (groupHeight < maxSize.height) {
                    groupHeight = maxSize.height;
                }
                if (groupWidth < maxSize.width) {
                    groupWidth = maxSize.width;
                }
                if (this.rowStyle != 1) continue;
                if (this.orientation == 1 || this.orientation == 2) {
                    if (groupHeight > preferredHeight) {
                        preferredHeight = groupHeight - this.spacing;
                    }
                    groupHeight = 0;
                    continue;
                }
                if (groupWidth > preferredWidth) {
                    preferredWidth = groupWidth - this.spacing;
                }
                groupWidth = 0;
            }
            int rows = 1;
            if (this.rowStyle == 1) {
                rows = this.rowCount;
            } else if (this.orientation == 1 || this.orientation == 2) {
                preferredHeight = marginHeight + groupHeight - this.spacing;
            } else {
                preferredWidth = marginWidth + groupWidth - this.spacing;
            }
            if (this.orientation == 1 || this.orientation == 2) {
                preferredSize.width = preferredWidth + groupWidth * rows;
                preferredSize.height = preferredHeight;
            } else {
                preferredSize.width = preferredWidth;
                preferredSize.height = preferredHeight + groupHeight * rows;
            }
            if (preferredSize.width <= 0) {
                preferredSize.width = 1;
            }
            if (preferredSize.height <= 0) {
                preferredSize.height = 1;
            }
            return preferredSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            Dimension max = this.getMaximumSize();
            max.width += insets.left + insets.right;
            max.height += insets.top + insets.bottom;
            return new Dimension(max.width, max.height);
        }
    }

    private int getRowCount(Dimension availSize, Dimension maxSize, int ncomponents) {
        int rowCount = 0;
        int availLength = 0;
        availLength = this.orientation == 1 || this.orientation == 2 ? availSize.height : availSize.width;
        Dimension compSize = maxSize;
        if (this.rowStyle == 1) {
            int sIndex = this.startIndex;
            for (int j = 0; j < this.groups.size(); ++j) {
                int total = 0;
                int prevTotal = 0;
                int componentLength = 0;
                Group grp = (Group)this.groups.elementAt(j);
                grp.rows.removeAllElements();
                for (int i = sIndex; i < grp.components.size(); ++i) {
                    Component comp = (Component)grp.components.elementAt(i);
                    if (!comp.isVisible()) continue;
                    if (this.compSizing == 0) {
                        compSize = comp.getMinimumSize();
                    }
                    if ((total += (componentLength = this.orientation == 1 || this.orientation == 2 ? compSize.height : compSize.width)) > availLength) {
                        int rowLength;
                        int endIndex;
                        if (this.justification == 3) {
                            endIndex = i + 1;
                            rowLength = total;
                            total = 0;
                            prevTotal = 0;
                        } else {
                            endIndex = i;
                            rowLength = prevTotal;
                            total = componentLength + this.spacing;
                            prevTotal = componentLength;
                        }
                        Row row = new Row(sIndex, endIndex, rowLength);
                        grp.rows.addElement(row);
                        sIndex = endIndex;
                        ++rowCount;
                        continue;
                    }
                    prevTotal = total;
                    total += this.spacing;
                }
                if (prevTotal != 0) {
                    Row row = new Row(sIndex, grp.components.size(), prevTotal);
                    grp.rows.addElement(row);
                    ++rowCount;
                }
                sIndex = 0;
                this.groups.setElementAt(grp, j);
            }
        } else {
            int total = 0;
            int maxViewable = 0;
            int sIndex = this.startIndex;
            Dimension totalSize = new Dimension(0, 0);
            for (int i = sIndex; i < ncomponents; ++i) {
                Component comp = (Component)this.allGroups.components.elementAt(i);
                if (!comp.isVisible()) continue;
                if (this.compSizing == 0) {
                    compSize = comp.getMinimumSize();
                }
                totalSize.height += compSize.height + this.spacing;
                totalSize.width += compSize.width + this.spacing;
                total = this.orientation == 4 || this.orientation == 8 ? totalSize.width : totalSize.height;
                if (this.justification == 3) continue;
                if (total - this.spacing <= availLength) {
                    maxViewable = total;
                    continue;
                }
                total = maxViewable;
                break;
            }
            this.allGroups.rows.removeAllElements();
            Row row = new Row(this.startIndex, ncomponents, total -= this.spacing);
            this.allGroups.rows.addElement(row);
            rowCount = 1;
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = this.allGroups.components.size();
            if (ncomponents == 0) {
                return;
            }
            Dimension availSize = new Dimension();
            Dimension parentSize = parent.getSize();
            availSize.height = parentSize.height - insets.top - insets.bottom - this.topMargin - this.bottomMargin;
            availSize.width = parentSize.width - insets.left - insets.right - this.leftMargin - this.rightMargin;
            Dimension compSize = new Dimension();
            if (this.compSizing == 1) {
                compSize = this.getMaximumSize();
            }
            this.rowCount = this.getRowCount(availSize, compSize, ncomponents);
            this.rowHeight = 0;
            Point rowStartPos = new Point();
            if (this.orientation == 1) {
                this.rowHeight = (availSize.width - this.rowSpacing * (this.rowCount - 1)) / this.rowCount;
                rowStartPos.x = availSize.width + insets.left + this.leftMargin - this.rowHeight;
                rowStartPos.y = insets.top + this.topMargin;
            } else if (this.orientation == 2) {
                this.rowHeight = (availSize.width - this.rowSpacing * (this.rowCount - 1)) / this.rowCount;
                rowStartPos.x = insets.left + this.leftMargin;
                rowStartPos.y = insets.top + this.topMargin;
            } else if (this.orientation == 4) {
                this.rowHeight = (availSize.height - this.rowSpacing * (this.rowCount - 1)) / this.rowCount;
                rowStartPos.x = insets.left + this.leftMargin;
                rowStartPos.y = availSize.height + insets.top + this.topMargin - this.rowHeight;
            } else {
                this.rowHeight = (availSize.height - this.rowSpacing * (this.rowCount - 1)) / this.rowCount;
                rowStartPos.x = insets.left + this.leftMargin;
                rowStartPos.y = insets.top + this.topMargin;
            }
            int availLength = availSize.width;
            if (this.orientation == 1 || this.orientation == 2) {
                availLength = availSize.height;
            }
            if (this.rowStyle == 0) {
                Row rowInfo = (Row)this.allGroups.rows.elementAt(0);
                this.layoutRow(this.allGroups, rowInfo.start, rowInfo.end, rowInfo.length, this.rowHeight, rowStartPos, availLength, parentSize, compSize);
                for (int i = 0; i < ncomponents; ++i) {
                    Component comp = (Component)this.allGroups.components.elementAt(i);
                    Dimension minSize = comp.getMinimumSize();
                    if (i >= this.startIndex && i <= this.endIndex) continue;
                    comp.setBounds(-minSize.width, -minSize.height, minSize.width, minSize.height);
                }
                this.rowStartPositions.removeAllElements();
                this.rowStartPositions.addElement(rowStartPos);
            } else {
                Row row;
                Group grp;
                if (this.firstRow > 0) {
                    grp = (Group)this.groups.elementAt(this.firstGroup);
                    if (this.firstRow < grp.rows.size()) {
                        row = (Row)grp.rows.elementAt(this.firstRow);
                        grp.rows.removeElementAt(this.firstRow);
                        grp.rows.insertElementAt(row, 0);
                        this.groups.setElementAt(grp, this.firstGroup);
                    }
                }
                if (this.firstGroup > 0 && this.firstGroup < this.groups.size()) {
                    grp = (Group)this.groups.elementAt(this.firstGroup);
                    this.groups.removeElementAt(this.firstGroup);
                    this.groups.insertElementAt(grp, 0);
                }
                this.rowStartPositions.removeAllElements();
                for (int grpIndex = 0; grpIndex < this.groups.size(); ++grpIndex) {
                    Group grp2 = (Group)this.groups.elementAt(grpIndex);
                    for (int rowIndex = 0; rowIndex < grp2.rows.size(); ++rowIndex) {
                        Row rowInfo = (Row)grp2.rows.elementAt(rowIndex);
                        this.layoutRow(grp2, rowInfo.start, rowInfo.end, rowInfo.length, this.rowHeight, rowStartPos, availLength, parentSize, compSize);
                        Point rowStartPoint = new Point(rowStartPos.x, rowStartPos.y);
                        this.rowStartPositions.addElement(rowStartPoint);
                        if (this.orientation == 1) {
                            rowStartPos.x = rowStartPos.x - this.rowSpacing - this.rowHeight;
                            rowStartPos.y = insets.top + this.topMargin;
                            continue;
                        }
                        if (this.orientation == 2) {
                            rowStartPos.x = rowStartPos.x + this.rowSpacing + this.rowHeight;
                            rowStartPos.y = insets.top + this.topMargin;
                            continue;
                        }
                        if (this.orientation == 4) {
                            rowStartPos.x = insets.left + this.leftMargin;
                            rowStartPos.y = rowStartPos.y - this.rowSpacing - this.rowHeight;
                            continue;
                        }
                        rowStartPos.x = insets.left + this.leftMargin;
                        rowStartPos.y = rowStartPos.y + this.rowSpacing + this.rowHeight;
                    }
                }
                if (this.firstRow > 0) {
                    Group grp3 = (Group)this.groups.elementAt(0);
                    if (this.firstRow < grp3.rows.size()) {
                        row = (Row)grp3.rows.elementAt(0);
                        grp3.rows.removeElementAt(0);
                        grp3.rows.insertElementAt(row, this.firstRow);
                        this.groups.setElementAt(grp3, 0);
                    }
                }
                if (this.firstGroup > 0 && this.firstGroup < this.groups.size()) {
                    Group grp4 = (Group)this.groups.elementAt(0);
                    this.groups.removeElementAt(0);
                    this.groups.insertElementAt(grp4, this.firstGroup);
                }
            }
        }
    }

    private void layoutRow(Group grp, int rowStart, int rowEnd, int rowLength, int rowHeight, Point rowStartPos, int availLength, Dimension parentSize, Dimension maxSize) {
        int buffer = 0;
        int bufferSideX = 0;
        int bufferSideY = 0;
        if (this.justification == 3 && rowStart != rowEnd) {
            int bufferTotal = availLength - rowLength;
            buffer = bufferTotal / (rowEnd - rowStart);
            if (buffer <= 0 && bufferTotal % (rowEnd - rowStart) != 0) {
                --buffer;
            }
            rowLength = availLength;
        } else if (this.justification == 256) {
            int bufferSide = (availLength - rowLength) / 2;
            if (bufferSide >= 0) {
                availLength -= bufferSide;
            } else {
                bufferSide = 0;
            }
            if (this.orientation == 1 || this.orientation == 2) {
                bufferSideY = bufferSide;
            } else {
                bufferSideX = bufferSide;
            }
        }
        Point nextPos = new Point();
        Point compPos = new Point(rowStartPos.x + bufferSideX, rowStartPos.y + bufferSideY);
        if (this.justification == 2) {
            if (this.orientation == 1 || this.orientation == 2) {
                compPos.y = (this.fillFrom & 5) != 0 ? (compPos.y += availLength) : compPos.y + availLength - rowLength;
            } else {
                compPos.x = (this.fillFrom & 5) != 0 ? (compPos.x += availLength) : compPos.x + availLength - rowLength;
            }
        } else if ((this.justification == 1 || this.justification == 256 || this.justification == 3) && (this.fillFrom & 5) != 0) {
            if (this.orientation == 1 || this.orientation == 2) {
                compPos.y += rowLength;
            } else {
                compPos.x += rowLength;
            }
        }
        Point startBuffer = (this.fillFrom & 4) != 0 || (this.fillFrom & 1) != 0 ? new Point(parentSize.width - compPos.x, parentSize.height - compPos.y) : new Point(compPos.x, compPos.y);
        Dimension compSize = maxSize;
        Dimension compNewSize = new Dimension();
        for (int i = rowStart; i < rowEnd; ++i) {
            int usedLength = 0;
            Component comp = (Component)grp.components.elementAt(i);
            if (!comp.isVisible()) {
                if (usedLength > availLength) {
                    this.endIndex = i - 1;
                    break;
                }
                this.endIndex = i;
                continue;
            }
            if (this.compSizing == 0) {
                compSize = comp.getMinimumSize();
            }
            if (this.orientation == 1 || this.orientation == 2) {
                compNewSize.width = rowHeight;
                compNewSize.height = compSize.height + buffer;
                nextPos.x = compPos.x;
                if ((this.fillFrom & 5) != 0) {
                    compPos.y -= compNewSize.height;
                    nextPos.y = compPos.y - this.spacing;
                    usedLength = parentSize.height - compPos.y - startBuffer.y;
                } else {
                    nextPos.y = compPos.y + compNewSize.height + this.spacing;
                    usedLength = compPos.y + compNewSize.height - startBuffer.y;
                }
            } else {
                compNewSize.width = compSize.width + buffer;
                compNewSize.height = rowHeight;
                nextPos.y = compPos.y;
                if ((this.fillFrom & 5) != 0) {
                    compPos.x -= compNewSize.width;
                    nextPos.x = compPos.x - this.spacing;
                    usedLength = parentSize.width - compPos.x - startBuffer.x;
                } else {
                    nextPos.x = compPos.x + compNewSize.width + this.spacing;
                    usedLength = compPos.x + compNewSize.width - startBuffer.x;
                }
            }
            if (usedLength > availLength) {
                if (rowStart == i) {
                    if (this.orientation == 8 || this.orientation == 4) {
                        comp.setBounds(compPos.x, compPos.y, availLength, compNewSize.height);
                    } else {
                        comp.setBounds(compPos.x, compPos.y, compNewSize.width, availLength);
                    }
                    this.endIndex = i;
                    break;
                }
                this.endIndex = i - 1;
                break;
            }
            this.endIndex = i;
            comp.setBounds(compPos.x, compPos.y, compNewSize.width, compNewSize.height);
            compPos.x = nextPos.x;
            compPos.y = nextPos.y;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[rightMargin =" + this.rightMargin + ", leftMargin =" + this.leftMargin + ", topMargin =" + this.topMargin + ", bottomMargin =" + this.bottomMargin + "]";
    }
}

