/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals;

import com.sas.codepolicy.SASScope;
import com.sas.visuals.ColumnWidthInterface;
import com.sas.visuals.RB;
import com.sas.visuals.RowHeightInterface;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

@SASScope(value="ALL")
public class AutoSizingGridLayout
implements LayoutManager,
Serializable,
ColumnWidthInterface,
RowHeightInterface {
    static final long serialVersionUID = 6788620945775160489L;
    public static final String RB_KEY = "AutoSizingGridLayout.";
    protected int hgap;
    protected int vgap;
    protected int rows;
    protected int cols;
    protected boolean fillCell;
    protected boolean useColumnRemainder;
    protected boolean useRowRemainder;
    protected int defaultCellGravity;
    protected int gridGravity;
    protected SpacePartitionerInterface columnPartitioner;
    protected SpacePartitionerInterface rowPartitioner;
    protected boolean ignoreSizeOfNonVisibleComponents;
    protected int remainderColumn = 0;
    protected int remainderRow = 0;
    protected Container[] interlockedColumnContainers;
    protected Container[] interlockedRowContainers;

    public AutoSizingGridLayout() {
        this(1, 0);
    }

    public AutoSizingGridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public AutoSizingGridLayout(int rows, int cols, int hgap, int vgap) {
        this(rows, cols, hgap, vgap, false, false, false);
    }

    public AutoSizingGridLayout(int rows, int cols, int hgap, int vgap, boolean fillCell, boolean useRowRemainder, boolean useColumnRemainder) {
        if (rows == 0 && cols == 0) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"NonzeroRowsAndCols.txt"));
        }
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
        this.fillCell = fillCell;
        this.useRowRemainder = useRowRemainder;
        this.useColumnRemainder = useColumnRemainder;
        this.defaultCellGravity = 5;
        this.gridGravity = 5;
    }

    public int getDefaultCellGravity() {
        return this.defaultCellGravity;
    }

    public void setDefaultCellGravity(int defaultCellGravity) {
        if (defaultCellGravity != 5 && defaultCellGravity != 4 && defaultCellGravity != 6 && defaultCellGravity != 1 && defaultCellGravity != 256 && defaultCellGravity != 2 && defaultCellGravity != 9 && defaultCellGravity != 8 && defaultCellGravity != 10) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"InvalidDefaultCellGravity.txt"));
        }
        this.defaultCellGravity = defaultCellGravity;
    }

    public int getGridGravity() {
        return this.gridGravity;
    }

    public void setGridGravity(int gridGravity) {
        if (gridGravity != 5 && gridGravity != 4 && gridGravity != 6 && gridGravity != 1 && gridGravity != 256 && gridGravity != 2 && gridGravity != 9 && gridGravity != 8 && gridGravity != 10) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"InvalidGridGravity.txt"));
        }
        this.gridGravity = gridGravity;
    }

    public SpacePartitionerInterface getColumnSpacePartitioner() {
        return this.columnPartitioner;
    }

    public void setColumnSpacePartitioner(SpacePartitionerInterface columnPartitioner) {
        this.columnPartitioner = columnPartitioner;
    }

    public SpacePartitionerInterface getRowSpacePartitioner() {
        return this.rowPartitioner;
    }

    public void setRowSpacePartitioner(SpacePartitionerInterface rowPartitioner) {
        this.rowPartitioner = rowPartitioner;
    }

    public boolean getIgnoreSizeOfNonVisibleComponents() {
        return this.ignoreSizeOfNonVisibleComponents;
    }

    public void setIgnoreSizeOfNonVisibleComponents(boolean ignoreSizeOfNonVisibleComponents) {
        this.ignoreSizeOfNonVisibleComponents = ignoreSizeOfNonVisibleComponents;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows == 0 && this.cols == 0) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"NonzeroRowsAndCols.txt"));
        }
        this.rows = rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        if (cols == 0 && this.rows == 0) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"NonzeroRowsAndCols.txt"));
        }
        this.cols = cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void setFillCell(boolean fillCell) {
        this.fillCell = fillCell;
    }

    public boolean getFillCell() {
        return this.fillCell;
    }

    public int getRemainderColumn() {
        return this.remainderColumn;
    }

    public void setRemainderColumn(int remainderColumn) {
        this.remainderColumn = remainderColumn;
    }

    public boolean getUseColumnRemainder() {
        return this.useColumnRemainder;
    }

    public void setUseColumnRemainder(boolean useColumnRemainder) {
        this.useColumnRemainder = useColumnRemainder;
    }

    public int getRemainderRow() {
        return this.remainderRow;
    }

    public void setRemainderRow(int remainderRow) {
        this.remainderRow = remainderRow;
    }

    public boolean getUseRowRemainder() {
        return this.useRowRemainder;
    }

    public void setUseRowRemainder(boolean useRowRemainder) {
        this.useRowRemainder = useRowRemainder;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public final int[] getPreferredRowHeightsPublic(Container parent, int nrows, int ncols) {
        return this.getPreferredRowHeights(parent, nrows, ncols);
    }

    protected int[] getPreferredRowHeights(Container parent, int nrows, int ncols) {
        Component[] comps = parent.getComponents();
        Dimension[] prefSizes = new Dimension[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            prefSizes[i] = comps[i].getPreferredSize();
        }
        return this.getPreferredRowHeights(comps, prefSizes, nrows, ncols);
    }

    protected int[] getPreferredRowHeights(Component[] comps, Dimension[] prefSizes, int nrows, int ncols) {
        int[] rowHeights = new int[nrows];
        for (int row = 0; row < nrows; ++row) {
            for (int i = 0; i < comps.length; ++i) {
                int componentRow = i / ncols;
                if (componentRow != row) continue;
                Dimension size = this.ignoreSizeOfNonVisibleComponents && !comps[i].isVisible() ? new Dimension(0, 0) : prefSizes[i];
                if (size.height <= rowHeights[componentRow]) continue;
                rowHeights[componentRow] = size.height;
            }
        }
        return rowHeights;
    }

    @Override
    public int[] getPreferredColumnWidths(Container parent, int ncols) {
        Component[] comps = parent.getComponents();
        Dimension[] prefSizes = new Dimension[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            prefSizes[i] = comps[i].getPreferredSize();
        }
        return this.getPreferredColumnWidths(comps, prefSizes, ncols);
    }

    @SASScope
    public int[] getPreferredColumnWidths(Component[] comps, Dimension[] prefSizes, int ncols) {
        int[] columnWidths = new int[ncols];
        for (int col = 0; col < ncols; ++col) {
            for (int i = 0; i < comps.length; ++i) {
                int column = i % ncols;
                if (column != col) continue;
                Dimension size = this.ignoreSizeOfNonVisibleComponents && !comps[i].isVisible() ? new Dimension(0, 0) : prefSizes[i];
                if (size.width <= columnWidths[column]) continue;
                columnWidths[column] = size.width;
            }
        }
        return columnWidths;
    }

    public Container[] getInterlockedColumnContainers() {
        return this.interlockedColumnContainers;
    }

    public void setInterlockedColumnContainer(Container interlockedColumnContainer) {
        this.setInterlockedColumnContainers(new Container[]{interlockedColumnContainer});
    }

    public void setInterlockedColumnContainers(Container[] interlockedColumnContainers) {
        this.interlockedColumnContainers = interlockedColumnContainers;
    }

    public Container[] getInterlockedRowContainers() {
        return this.interlockedRowContainers;
    }

    public void setInterlockedRowContainer(Container interlockedRowContainer) {
        this.setInterlockedRowContainers(new Container[]{interlockedRowContainer});
    }

    public void setInterlockedRowContainers(Container[] interlockedRowContainers) {
        this.interlockedRowContainers = interlockedRowContainers;
    }

    protected int[] getInterlockedColumnWidths(Container parent, int ncols) {
        Component[] comps = parent.getComponents();
        Dimension[] prefSizes = new Dimension[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            prefSizes[i] = comps[i].getPreferredSize();
        }
        return this.getInterlockedColumnWidths(parent, comps, prefSizes, ncols);
    }

    protected int[] getInterlockedColumnWidths(Container parent, Component[] comps, Dimension[] prefSize, int ncols) {
        int[] columnWidths = this.getPreferredColumnWidths(comps, prefSize, ncols);
        if (this.columnPartitioner != null) {
            int numZeroWidths = 0;
            for (int i = 0; i < columnWidths.length; ++i) {
                if (columnWidths[i] != 0) continue;
                ++numZeroWidths;
            }
            Insets insets = parent.getInsets();
            this.columnPartitioner.getPartitionedSpace(columnWidths, parent.getSize().width - this.hgap * (ncols - 1 - numZeroWidths) - (insets.left + insets.right), columnWidths);
        }
        if (this.interlockedColumnContainers != null) {
            for (Container interlockedContainer : this.interlockedColumnContainers) {
                LayoutManager interlockedLayout;
                if (interlockedContainer == parent || (interlockedLayout = interlockedContainer.getLayout()) == null || !(interlockedLayout instanceof ColumnWidthInterface)) continue;
                int[] interlockedWidths = ((ColumnWidthInterface)((Object)interlockedLayout)).getPreferredColumnWidths(interlockedContainer, ncols);
                int nj = ncols;
                for (int j = 0; j < nj; ++j) {
                    if (interlockedWidths[j] <= columnWidths[j]) continue;
                    columnWidths[j] = interlockedWidths[j];
                }
            }
        }
        return columnWidths;
    }

    protected int[] getInterlockedRowHeights(Container parent, int nrows, int ncols) {
        Component[] comps = parent.getComponents();
        Dimension[] prefSizes = new Dimension[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            prefSizes[i] = comps[i].getPreferredSize();
        }
        return this.getInterlockedRowHeights(parent, comps, prefSizes, nrows, ncols);
    }

    protected int[] getInterlockedRowHeights(Container parent, Component[] comps, Dimension[] prefSize, int nrows, int ncols) {
        int[] rowHeights = this.getPreferredRowHeights(comps, prefSize, nrows, ncols);
        if (this.rowPartitioner != null) {
            int numZeroHeights = 0;
            for (int i = 0; i < rowHeights.length; ++i) {
                if (rowHeights[i] != 0) continue;
                ++numZeroHeights;
            }
            Insets insets = parent.getInsets();
            this.rowPartitioner.getPartitionedSpace(rowHeights, parent.getSize().height - this.vgap * (nrows - 1 - numZeroHeights) - (insets.bottom + insets.top), rowHeights);
        }
        if (this.interlockedRowContainers != null) {
            for (Container interlockedContainer : this.interlockedRowContainers) {
                LayoutManager interlockedLayout;
                if (interlockedContainer == parent || (interlockedLayout = interlockedContainer.getLayout()) == null || !(interlockedLayout instanceof RowHeightInterface)) continue;
                int[] interlockedHeights = ((RowHeightInterface)((Object)interlockedLayout)).getPreferredRowHeightsPublic(interlockedContainer, nrows, ncols);
                int nj = nrows;
                for (int j = 0; j < nj; ++j) {
                    if (interlockedHeights[j] <= rowHeights[j]) continue;
                    rowHeights[j] = interlockedHeights[j];
                }
            }
        }
        return rowHeights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int vgapfactor;
            int i;
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            Component[] comps = parent.getComponents();
            Dimension[] prefSizes = new Dimension[comps.length];
            for (int i2 = 0; i2 < comps.length; ++i2) {
                prefSizes[i2] = comps[i2].getPreferredSize();
            }
            int[] heights = this.getInterlockedRowHeights(parent, comps, prefSizes, nrows, ncols);
            int[] widths = this.getInterlockedColumnWidths(parent, comps, prefSizes, ncols);
            int width = 0;
            int height = 0;
            for (i = 0; i < heights.length; ++i) {
                height += heights[i];
                if (heights[i] != 0) continue;
                --nrows;
            }
            for (i = 0; i < widths.length; ++i) {
                width += widths[i];
                if (widths[i] != 0) continue;
                --ncols;
            }
            int hgapfactor = (ncols - 1) * this.hgap;
            if (hgapfactor < 0) {
                hgapfactor = 0;
            }
            if ((vgapfactor = (nrows - 1) * this.vgap) < 0) {
                vgapfactor = 0;
            }
            return new Dimension(insets.left + insets.right + width + hgapfactor, insets.top + insets.bottom + height + vgapfactor);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    protected int getXGridGravityOffset(int totalRemainingWidth) {
        int startX = 0;
        switch (this.getGridGravity()) {
            case 5: {
                break;
            }
            case 4: {
                if (this.useColumnRemainder) break;
                startX += totalRemainingWidth / 2;
                break;
            }
            case 6: {
                if (this.useColumnRemainder) break;
                startX += totalRemainingWidth;
                break;
            }
            case 1: {
                break;
            }
            case 256: {
                if (this.useColumnRemainder) break;
                startX += totalRemainingWidth / 2;
                break;
            }
            case 2: {
                if (this.useColumnRemainder) break;
                startX += totalRemainingWidth;
                break;
            }
            case 9: {
                break;
            }
            case 8: {
                if (this.useColumnRemainder) break;
                startX += totalRemainingWidth / 2;
                break;
            }
            case 10: {
                if (this.useColumnRemainder) break;
                startX += totalRemainingWidth;
            }
        }
        return startX;
    }

    protected int getYGridGravityOffset(int totalRemainingHeight) {
        int startY = 0;
        switch (this.gridGravity) {
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                if (this.useRowRemainder) break;
                startY += totalRemainingHeight / 2;
                break;
            }
            case 256: {
                if (this.useRowRemainder) break;
                startY += totalRemainingHeight / 2;
                break;
            }
            case 2: {
                if (this.useRowRemainder) break;
                startY += totalRemainingHeight / 2;
                break;
            }
            case 9: {
                if (this.useRowRemainder) break;
                startY += totalRemainingHeight;
                break;
            }
            case 8: {
                if (this.useRowRemainder) break;
                startY += totalRemainingHeight;
                break;
            }
            case 10: {
                if (this.useRowRemainder) break;
                startY += totalRemainingHeight;
            }
        }
        return startY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (ncomponents == 0) {
                return;
            }
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            Component[] comps = parent.getComponents();
            Dimension[] prefSizes = new Dimension[comps.length];
            for (int i = 0; i < comps.length; ++i) {
                prefSizes[i] = comps[i].getPreferredSize();
            }
            int[] heights = this.getInterlockedRowHeights(parent, comps, prefSizes, nrows, ncols);
            int[] widths = this.getInterlockedColumnWidths(parent, comps, prefSizes, ncols);
            Dimension parentSize = parent.getSize();
            int w = parentSize.width - (insets.left + insets.right);
            int h = parentSize.height - (insets.top + insets.bottom);
            int usedWidth = 0;
            int numZeroWidths = 0;
            for (int i = 0; i < widths.length; ++i) {
                usedWidth += widths[i];
                if (widths[i] != 0) continue;
                ++numZeroWidths;
            }
            usedWidth += this.hgap * (widths.length - 1 - numZeroWidths);
            int columnRemainder = 0;
            if (this.useColumnRemainder) {
                columnRemainder = w - usedWidth;
            }
            int usedHeight = 0;
            int numZeroHeights = 0;
            for (int i = 0; i < heights.length; ++i) {
                usedHeight += heights[i];
                if (heights[i] != 0) continue;
                ++numZeroHeights;
            }
            usedHeight += this.vgap * (heights.length - 1 - numZeroHeights);
            int rowRemainder = 0;
            if (this.useRowRemainder) {
                rowRemainder = h - usedHeight;
            }
            int totalRemainingHeight = h - usedHeight;
            int totalRemainingWidth = w - usedWidth;
            int startX = insets.left;
            int startY = insets.top;
            if (!this.useRowRemainder || !this.useColumnRemainder) {
                startX += this.getXGridGravityOffset(totalRemainingWidth);
                startY += this.getYGridGravityOffset(totalRemainingHeight);
            }
            int width = 0;
            int height = 0;
            int x = startX;
            for (int c = 0; c < ncols; ++c) {
                boolean isRemainderColumn = false;
                if (this.useColumnRemainder && (c + 1 == this.remainderColumn || this.remainderColumn == 0 && c == ncols - 1)) {
                    isRemainderColumn = true;
                    if (columnRemainder < 0 && Math.abs(columnRemainder) > widths[c]) {
                        columnRemainder = -widths[c];
                    }
                }
                int y = startY;
                for (int r = 0; r < nrows; ++r) {
                    int i;
                    boolean isRemainderRow = false;
                    if (this.useRowRemainder && (r + 1 == this.remainderRow || this.remainderRow == 0 && r == nrows - 1)) {
                        isRemainderRow = true;
                        if (rowRemainder < 0 && Math.abs(rowRemainder) > heights[r]) {
                            rowRemainder = -heights[r];
                        }
                    }
                    if ((i = r * ncols + c) < ncomponents) {
                        Component component = parent.getComponent(i);
                        if (this.fillCell) {
                            width = widths[c];
                            height = heights[r];
                        } else {
                            Dimension size = this.ignoreSizeOfNonVisibleComponents && !component.isVisible() ? new Dimension(0, 0) : component.getPreferredSize();
                            width = size.width;
                            height = size.height;
                            if (width > widths[c]) {
                                width = widths[c];
                            }
                            if (height > heights[r]) {
                                height = heights[r];
                            }
                        }
                        if (isRemainderColumn) {
                            width += widths[c] - width + columnRemainder;
                        }
                        if (isRemainderRow) {
                            height += heights[r] - height + rowRemainder;
                        }
                        int xGravityOffset = 0;
                        int yGravityOffset = 0;
                        if (!(this.fillCell || this.useColumnRemainder && this.useRowRemainder)) {
                            int xSpace = 0;
                            if (!this.useColumnRemainder) {
                                xSpace = widths[c] - width;
                            }
                            int ySpace = 0;
                            if (!this.useRowRemainder) {
                                ySpace = heights[r] - height;
                            }
                            switch (this.defaultCellGravity) {
                                case 5: {
                                    break;
                                }
                                case 6: {
                                    xGravityOffset = xSpace;
                                    break;
                                }
                                case 9: {
                                    yGravityOffset = ySpace;
                                    break;
                                }
                                case 10: {
                                    xGravityOffset = xSpace;
                                    yGravityOffset = ySpace;
                                    break;
                                }
                                case 4: {
                                    xGravityOffset = xSpace / 2;
                                    break;
                                }
                                case 8: {
                                    xGravityOffset = xSpace / 2;
                                    yGravityOffset = ySpace;
                                    break;
                                }
                                case 2: {
                                    xGravityOffset = xSpace;
                                    yGravityOffset = ySpace / 2;
                                    break;
                                }
                                case 1: {
                                    yGravityOffset = ySpace / 2;
                                    break;
                                }
                                case 256: {
                                    xGravityOffset = xSpace / 2;
                                    yGravityOffset = ySpace / 2;
                                }
                            }
                        }
                        component.setBounds(x + xGravityOffset, y + yGravityOffset, width, height);
                    }
                    if (isRemainderRow) {
                        y += rowRemainder;
                    }
                    if (heights[r] == 0) continue;
                    y += heights[r] + this.vgap;
                }
                if (isRemainderColumn) {
                    x += columnRemainder;
                }
                if (widths[c] == 0) continue;
                x += widths[c] + this.hgap;
            }
        }
    }

    public int[] getActualColumnPositions(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int nrows = this.rows;
        int ncols = this.cols;
        if (ncomponents == 0) {
            return null;
        }
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        int[] columnPositions = new int[ncols];
        columnPositions[0] = 0;
        int[] widths = this.getInterlockedColumnWidths(parent, ncols);
        int x = widths[0] + insets.left;
        int gap = this.hgap / 2;
        for (int column = 1; column < ncols; ++column) {
            columnPositions[column] = x + gap;
            if (widths[column] == 0) continue;
            x += widths[column] + this.hgap;
        }
        return columnPositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintLines(Graphics g, Container parent) {
        Container container = parent;
        synchronized (container) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (ncomponents == 0) {
                return;
            }
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            Dimension size = parent.getSize();
            int width = size.width;
            int height = size.height;
            Component[] comps = parent.getComponents();
            Dimension[] prefSizes = new Dimension[comps.length];
            for (int i = 0; i < comps.length; ++i) {
                prefSizes[i] = comps[i].getPreferredSize();
            }
            int[] heights = this.getInterlockedRowHeights(parent, comps, prefSizes, nrows, ncols);
            int[] widths = this.getInterlockedColumnWidths(parent, comps, prefSizes, ncols);
            int x = widths[0] + insets.left;
            int gap = this.hgap / 2;
            for (int column = 1; column < ncols; ++column) {
                g.drawLine(x + gap, 0, x + gap, height);
                if (widths[column] == 0) continue;
                x += widths[column] + this.hgap;
            }
            int y = heights[0] + insets.top;
            gap = this.vgap / 2;
            for (int row = 1; row < nrows; ++row) {
                g.drawLine(0, y + gap, width, y + gap);
                if (heights[row] == 0) continue;
                y += heights[row] + this.vgap;
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }
}

