/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.validators;

import com.sas.text.Message;
import com.sas.util.validators.IntegerStringValidator;

public class MinMaxIntegerStringValidator
extends IntegerStringValidator {
    static final long serialVersionUID = -6732669468419889330L;
    public static final String valueBelowMin = "MinMaxIntegerStringValidator.ValueBelowMin";
    public static final String valueAboveMax = "MinMaxIntegerStringValidator.ValueAboveMax";
    protected static final int VALUE_BELOW_MIN = 2;
    protected static final int VALUE_ABOVE_MAX = 3;
    protected int min;
    protected int max;

    public MinMaxIntegerStringValidator() {
        this.min = 0;
        this.max = 100;
    }

    public MinMaxIntegerStringValidator(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean validateValue(Object component, Object value) {
        if (super.validateValue(component, value)) {
            try {
                Integer intValue = Integer.valueOf((String)value);
                if (intValue < this.min) {
                    Message message = (Message)this.messages.get(2);
                    message.toString((Object[])new Integer[]{new Integer(this.min)});
                    this.setValidationMessage(message);
                    this.setValidationMessageCode(valueBelowMin);
                    return false;
                }
                if (intValue > this.max) {
                    Message message = (Message)this.messages.get(3);
                    message.toString((Object[])new Integer[]{new Integer(this.max)});
                    this.setValidationMessage(message);
                    this.setValidationMessageCode(valueAboveMax);
                    return false;
                }
                return true;
            }
            catch (NumberFormatException e) {
                this.setValidationMessage((Message)this.messages.get(0));
                this.setValidationMessageCode("IntegerStringValidator.InvalidFormat");
            }
        }
        return false;
    }

    @Override
    public void createValidationMessages() {
        super.createValidationMessages();
        this.messages.add(this.newValidationMessage("Value must be greater than or equal to {0}"));
        this.messages.add(this.newValidationMessage("Value must be less than or equal to {0}"));
    }
}

