/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.validators;

import com.sas.text.Message;
import com.sas.util.validators.RB;
import com.sas.util.validators.Validator;

public class IntegerStringValidator
extends Validator {
    static final long serialVersionUID = -2315546223903595427L;
    public static final String RB_KEY = "IntegerStringValidator.";
    public static final String invalidFormat = "IntegerStringValidator.InvalidFormat";
    public static final String notString = "IntegerStringValidator.NotString";
    protected static final int INVALID_FORMAT = 0;
    protected static final int NOT_STRING = 1;

    @Override
    public boolean validateValue(Object component, Object value) {
        if (value instanceof String) {
            try {
                Integer.valueOf((String)value);
                return true;
            }
            catch (NumberFormatException e) {
                this.setValidationMessage((Message)this.messages.get(0));
                this.setValidationMessageCode(invalidFormat);
            }
        } else {
            this.setValidationMessage((Message)this.messages.get(1));
            this.setValidationMessageCode(notString);
        }
        return false;
    }

    @Override
    public Object normalizeValue(Object component, Object value) {
        String string = (String)value;
        string.trim();
        return string;
    }

    @Override
    public void createValidationMessages() {
        super.createValidationMessages();
        this.messages.add(this.newValidationMessage(RB.getStringResource(RB_KEY, "InvalidFormat.txt")));
        this.messages.add(this.newValidationMessage(RB.getStringResource(RB_KEY, "NotString.txt")));
    }
}

