/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.validators;

import com.sas.util.validators.ValidationInterface;
import com.sas.util.validators.Validator;
import java.util.ArrayList;
import java.util.List;

public class CompositeValidator
extends Validator {
    protected ValidationInterface validator1;
    protected ValidationInterface validator2;
    protected List validators;

    public CompositeValidator() {
        this.validators = new ArrayList();
    }

    public CompositeValidator(ValidationInterface validator1) {
        this.validators = new ArrayList();
        this.validators.add(validator1);
    }

    public CompositeValidator(ValidationInterface validator1, ValidationInterface validator2) {
        this.validators = new ArrayList();
        this.validators.add(validator1);
        this.validators.add(validator2);
    }

    public CompositeValidator(List validators) {
        this.validators = validators;
    }

    public void addValidator(ValidationInterface validator) {
        this.validators.add(validator);
    }

    public boolean removeValidator(ValidationInterface validator) {
        return this.validators.remove(validator);
    }

    public void removeValidatorAtIndex(int index) {
        this.validators.remove(index);
    }

    @Override
    public boolean validateValue(Object component, Object value) {
        this.setValidationMessage(null);
        this.setValidationMessageCode("");
        int size = this.validators.size();
        for (int i = 0; i < size; ++i) {
            ValidationInterface validator = (ValidationInterface)this.validators.get(i);
            if (validator.validateValue(component, value)) continue;
            this.setValidationMessage(validator.getValidationMessage());
            this.setValidationMessageCode(validator.getValidationMessageCode());
            return false;
        }
        return true;
    }

    @Override
    public Object normalizeValue(Object component, Object value) {
        int size = this.validators.size();
        for (int i = 0; i < size; ++i) {
            ValidationInterface validator = (ValidationInterface)this.validators.get(i);
            value = validator.normalizeValue(component, value);
        }
        return value;
    }

    public ValidationInterface getValidatorAtIndex(int index) {
        if (index >= 0 && index < this.validators.size()) {
            return (ValidationInterface)this.validators.get(index);
        }
        return null;
    }

    public void insertValidatorAtIndex(int index, ValidationInterface validator) {
        this.validators.add(index, validator);
    }

    public List getValidators() {
        return this.validators;
    }

    public void setValidators(List validators) {
        this.validators = validators;
    }

    public ValidationInterface getFirstValidator() {
        return this.getValidatorAtIndex(0);
    }

    public void setFirstValidator(ValidationInterface firstValidator) {
        this.validators.set(0, firstValidator);
    }

    public ValidationInterface getSecondValidator() {
        return (ValidationInterface)this.validators.get(1);
    }

    public void setSecondValidator(ValidationInterface secondValidator) {
        this.validators.set(1, secondValidator);
    }
}

