/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.login;

import com.sas.util.login.LoginBean;
import com.sas.util.login.LoginBeanActionInterface;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class LoginBeanSwingUtil
implements ActionListener,
LoginBeanActionInterface {
    protected LoginBean loginBean;
    protected JTextField usernameTextField;
    protected JPasswordField passwordTextField;
    protected JDialog dialog;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton closeButton;
    protected JLabel retryLabel;
    protected int buttonSelected;

    public LoginBeanSwingUtil() {
    }

    public LoginBeanSwingUtil(LoginBean bean) {
        this();
        this.setLoginBean(bean);
    }

    public void setLoginBean(LoginBean bean) {
        this.loginBean = bean;
    }

    public LoginBean getLoginBean() {
        return this.loginBean;
    }

    public int getSelectedButton() {
        return this.buttonSelected;
    }

    public JPanel createSwingPanel() {
        JPanel panel = new JPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 5, 10, true, true, true);
        panel.setLayout(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel titleLabel = new JLabel(this.loginBean.getTitle());
        panel.add(titleLabel);
        panel.add(new JPanel());
        JPanel upPanel = new JPanel();
        upPanel.setLayout(new AutoSizingGridLayout(0, 2, 5, 5, true, true, true));
        JLabel usernameLabel = new JLabel(this.loginBean.getUsernameLabel());
        upPanel.add(usernameLabel);
        this.usernameTextField = new JTextField(this.loginBean.getUsername());
        this.usernameTextField.setColumns(20);
        upPanel.add(this.usernameTextField);
        JLabel passwordLabel = new JLabel(this.loginBean.getPasswordLabel());
        upPanel.add(passwordLabel);
        this.passwordTextField = new JPasswordField(this.loginBean.getPassword());
        upPanel.add(this.passwordTextField);
        panel.add(upPanel);
        this.retryLabel = new JLabel(" ");
        panel.add(this.retryLabel);
        String okButtonLabel = this.loginBean.getOKButtonLabel();
        String cancelButtonLabel = this.loginBean.getCancelButtonLabel();
        String closeButtonLabel = this.loginBean.getCloseButtonLabel();
        if (okButtonLabel != null || cancelButtonLabel != null) {
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setLayout(new FlowLayout(1));
            if (okButtonLabel != null) {
                this.okButton = new JButton(okButtonLabel);
                buttonsPanel.add(this.okButton);
                this.okButton.addActionListener(this);
            }
            if (cancelButtonLabel != null) {
                this.cancelButton = new JButton(cancelButtonLabel);
                buttonsPanel.add(this.cancelButton);
                this.cancelButton.addActionListener(this);
            }
            if (closeButtonLabel != null) {
                this.closeButton = new JButton(closeButtonLabel);
                this.closeButton.setVisible(false);
                buttonsPanel.add(this.closeButton);
                this.closeButton.addActionListener(this);
            }
            panel.add(buttonsPanel);
        }
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object eSource = evt.getSource();
        if (eSource == this.okButton) {
            LoginBeanActionInterface actionHandler;
            this.buttonSelected = 0;
            String username = this.usernameTextField.getText();
            String password = new String(this.passwordTextField.getPassword());
            if (username.length() > 0) {
                this.loginBean.setUsername(username);
            }
            if (password.length() > 0) {
                this.loginBean.setPassword(password);
            }
            if ((actionHandler = this.loginBean.getActionHandler()) != null) {
                actionHandler.OKAction();
            }
            this.loginBean.validate();
        } else if (eSource == this.cancelButton) {
            this.buttonSelected = 1;
            LoginBeanActionInterface actionHandler = this.loginBean.getActionHandler();
            if (actionHandler != null) {
                actionHandler.cancelAction();
            }
        } else if (eSource == this.closeButton) {
            this.buttonSelected = 2;
            LoginBeanActionInterface actionHandler = this.loginBean.getActionHandler();
            if (actionHandler != null) {
                actionHandler.closeAction();
            }
        }
    }

    public void OKAction() {
        if (this.loginBean.getValidateHandler() == null) {
            this.disposeDialog();
        }
    }

    public void cancelAction() {
        this.disposeDialog();
    }

    public void closeAction() {
        this.disposeDialog();
    }

    public void successAction() {
        this.disposeDialog();
    }

    public void failureAction() {
        this.retryLabel.setText(this.loginBean.getCurrentFailureMessage());
        if (this.okButton != null) {
            this.okButton.setVisible(false);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setVisible(false);
        }
        if (this.closeButton != null) {
            this.closeButton.setVisible(true);
        } else {
            this.disposeDialog();
        }
    }

    public void retryAction() {
        this.passwordTextField.setText("");
        this.retryLabel.setText(this.loginBean.getCurrentFailureMessage() + " " + this.loginBean.getRetryMessage());
    }

    private void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    private void disposeDialog() {
        this.dialog.dispose();
        if (this.okButton != null) {
            this.okButton.removeActionListener(this);
        }
        if (this.cancelButton != null) {
            this.cancelButton.removeActionListener(this);
        }
        if (this.closeButton != null) {
            this.closeButton.removeActionListener(this);
        }
    }

    public void showDialog(String dialogTitle, Frame owner) {
        JDialog dialog = new JDialog(owner);
        this.setDialog(dialog);
        dialog.setTitle(dialogTitle);
        dialog.getContentPane().add(this.createSwingPanel());
        dialog.pack();
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.show();
    }

    public static void showDialog(String dialogTitle, Frame owner, LoginBean bean) {
        LoginBeanSwingUtil beanUtil = new LoginBeanSwingUtil(bean);
        beanUtil.showDialog(dialogTitle, owner);
    }

    public static void main(String[] argv) {
        LoginBean bean = new LoginBean();
        bean.setTitle("Enter your username and password:");
        LoginBeanSwingUtil beanUtil = new LoginBeanSwingUtil(bean);
        bean.setActionHandler((LoginBeanActionInterface)beanUtil);
        beanUtil.showDialog("LoginBean", null);
        System.exit(0);
    }
}

