/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.lang.BooleanDataInterface;
import com.sas.util.Command;
import com.sas.util.CommandsInterface;
import com.sas.util.ContextCommandsConsumerInterface;
import com.sas.util.ContextCommandsInterface;
import com.sas.util.MenuCommand;
import com.sas.util.MenuSeparatorCommand;
import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CommandManager
implements ContextCommandsConsumerInterface,
ContextCommandsInterface {
    private static Command[] m_emptyCommandArray;
    private static CommandsInterface[] m_emptyCommandsInterfaceArray;
    private static ContextCommandsInterface[] m_emptyContextCommandsInterfaceArray;
    private transient Vector m_contextCommandsProducers;
    private transient Vector m_workVector;
    private transient boolean m_separatorsAdded = true;

    @Override
    public synchronized ContextCommandsInterface[] getContextCommandsProducers() {
        Object[] cci;
        if (this.m_contextCommandsProducers == null || this.m_contextCommandsProducers.size() == 0) {
            cci = CommandManager.getEmptyContextCommandsInterfaceArray();
        } else {
            cci = new ContextCommandsInterface[this.m_contextCommandsProducers.size()];
            this.m_contextCommandsProducers.copyInto(cci);
        }
        return cci;
    }

    @Override
    public synchronized void addContextCommandsProducer(ContextCommandsInterface producer) {
        if (producer == null) {
            throw new IllegalArgumentException();
        }
        if (this.m_contextCommandsProducers == null) {
            this.m_contextCommandsProducers = new Vector(1, 1);
        }
        if (!this.m_contextCommandsProducers.contains(producer)) {
            this.m_contextCommandsProducers.addElement(producer);
        }
    }

    @Override
    public synchronized void removeContextCommandsProducer(ContextCommandsInterface producer) {
        if (this.m_contextCommandsProducers != null && producer != null) {
            this.m_contextCommandsProducers.removeElement(producer);
        }
    }

    @Override
    public synchronized Command[] getContextCommands(Object context, int x, int y) {
        Object[] cmds;
        ContextCommandsInterface[] ccp = this.getContextCommandsProducers();
        if (this.m_workVector == null) {
            this.m_workVector = new Vector();
        }
        for (int i = 0; i < ccp.length; ++i) {
            cmds = ccp[i].getContextCommands(context, x, y);
            if (cmds == null || cmds.length == 0) continue;
            if (this.m_workVector.size() != 0 && this.isSeparatorsAdded()) {
                this.m_workVector.addElement(MenuSeparatorCommand.instance());
            }
            for (int j = 0; j < cmds.length; ++j) {
                this.m_workVector.addElement(cmds[j]);
            }
        }
        if (this.m_workVector.size() == 0) {
            cmds = CommandManager.getEmptyCommandArray();
        } else {
            cmds = new Command[this.m_workVector.size()];
            this.m_workVector.copyInto(cmds);
            this.m_workVector.removeAllElements();
        }
        return cmds;
    }

    public boolean isSeparatorsAdded() {
        return this.m_separatorsAdded;
    }

    public void setSeparatorsAdded(boolean newValue) {
        this.m_separatorsAdded = newValue;
    }

    public static void addCommand(Menu menu, final Command command, final Object executeParm) {
        MenuItem menuItem;
        Menu subMenu = null;
        CheckboxMenuItem checkBox = null;
        if (command instanceof MenuCommand) {
            if (((MenuCommand)command).isSeparator()) {
                menu.addSeparator();
                return;
            }
            subMenu = new Menu(command.getText());
            menuItem = subMenu;
        } else if (command instanceof BooleanDataInterface) {
            checkBox = new CheckboxMenuItem(command.getText(), ((BooleanDataInterface)command).getBooleanData());
            menuItem = checkBox;
        } else {
            menuItem = new MenuItem(command.getText());
        }
        if (command.isExecutable()) {
            if (subMenu != null) {
                CommandManager.addCommands(subMenu, ((MenuCommand)command).getCommands(), executeParm);
            } else if (checkBox != null) {
                checkBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent event) {
                        command.execute(executeParm);
                    }
                });
            } else {
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        command.execute(executeParm);
                    }
                });
            }
        } else {
            menuItem.setEnabled(false);
        }
        menu.add(menuItem);
    }

    public static void addCommands(Menu menu, Command[] commands, Object executeParm) {
        if (commands == null) {
            return;
        }
        for (int i = 0; i < commands.length; ++i) {
            CommandManager.addCommand(menu, commands[i], executeParm);
        }
    }

    public static void addCommand(JPopupMenu menu, final Command command, final Object executeParm) {
        JMenuItem menuItem;
        JMenu subMenu = null;
        JCheckBoxMenuItem checkBox = null;
        if (command instanceof MenuCommand) {
            if (((MenuCommand)command).isSeparator()) {
                menu.addSeparator();
                return;
            }
            subMenu = new JMenu(command.getText());
            menuItem = subMenu;
        } else if (command instanceof BooleanDataInterface) {
            checkBox = new JCheckBoxMenuItem(command.getText(), ((BooleanDataInterface)command).getBooleanData());
            menuItem = checkBox;
        } else {
            menuItem = new JMenuItem(command.getText());
        }
        if (command.isExecutable()) {
            if (subMenu != null) {
                CommandManager.addCommands(subMenu, ((MenuCommand)command).getCommands(), executeParm);
            } else if (checkBox != null) {
                checkBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        command.execute(executeParm);
                    }
                });
            } else {
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        command.execute(executeParm);
                    }
                });
            }
        } else {
            menuItem.setEnabled(false);
        }
        menu.add(menuItem);
    }

    public static void addCommands(JPopupMenu menu, Command[] commands, Object executeParm) {
        if (commands == null) {
            return;
        }
        for (int i = 0; i < commands.length; ++i) {
            CommandManager.addCommand(menu, commands[i], executeParm);
        }
    }

    public static void addCommand(JMenu menu, final Command command, final Object executeParm) {
        JMenuItem menuItem;
        JMenu subMenu = null;
        JCheckBoxMenuItem checkBox = null;
        if (command instanceof MenuCommand) {
            if (((MenuCommand)command).isSeparator()) {
                menu.addSeparator();
                return;
            }
            subMenu = new JMenu(command.getText());
            menuItem = subMenu;
        } else if (command instanceof BooleanDataInterface) {
            checkBox = new JCheckBoxMenuItem(command.getText(), ((BooleanDataInterface)command).getBooleanData());
            menuItem = checkBox;
        } else {
            menuItem = new JMenuItem(command.getText());
        }
        if (command.isExecutable()) {
            if (subMenu != null) {
                CommandManager.addCommands(subMenu, ((MenuCommand)command).getCommands(), executeParm);
            } else if (checkBox != null) {
                checkBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        command.execute(executeParm);
                    }
                });
            } else {
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        command.execute(executeParm);
                    }
                });
            }
        } else {
            menuItem.setEnabled(false);
        }
        menu.add(menuItem);
    }

    public static void addCommands(JMenu menu, Command[] commands, Object executeParm) {
        if (commands == null) {
            return;
        }
        for (int i = 0; i < commands.length; ++i) {
            CommandManager.addCommand(menu, commands[i], executeParm);
        }
    }

    public static Command[] getEmptyCommandArray() {
        if (m_emptyCommandArray == null) {
            m_emptyCommandArray = new Command[0];
        }
        return m_emptyCommandArray;
    }

    public static CommandsInterface[] getEmptyCommandsInterfaceArray() {
        if (m_emptyCommandsInterfaceArray == null) {
            m_emptyCommandsInterfaceArray = new CommandsInterface[0];
        }
        return m_emptyCommandsInterfaceArray;
    }

    public static ContextCommandsInterface[] getEmptyContextCommandsInterfaceArray() {
        if (m_emptyContextCommandsInterfaceArray == null) {
            m_emptyContextCommandsInterfaceArray = new ContextCommandsInterface[0];
        }
        return m_emptyContextCommandsInterfaceArray;
    }
}

