/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import java.awt.Color;

@SASScope
public class ColorUtil {
    public static float[] colorToHSL(Color color, float[] hsl) {
        return ColorUtil.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), hsl);
    }

    public static float[] RGBtoHSL(int r, int g, int b, float[] hsl) {
        float fR = (float)r / 255.0f;
        float fG = (float)g / 255.0f;
        float fB = (float)b / 255.0f;
        float minrgb = fR;
        float maxrgb = fR;
        if (fG > maxrgb) {
            maxrgb = fG;
        }
        if (fB > maxrgb) {
            maxrgb = fB;
        }
        if (fG < minrgb) {
            minrgb = fG;
        }
        if (fB < minrgb) {
            minrgb = fB;
        }
        float lum = (maxrgb + minrgb) / 2.0f;
        float sat = 0.0f;
        float hue = 0.0f;
        if (Float.MIN_VALUE > Math.abs(maxrgb - minrgb)) {
            sat = 0.0f;
            hue = 0.0f;
        } else {
            sat = lum <= 0.5f ? (maxrgb - minrgb) / (maxrgb + minrgb) : (maxrgb - minrgb) / (2.0f - maxrgb - minrgb);
            if (fR == maxrgb) {
                hue = (fG - fB) / (maxrgb - minrgb);
            }
            if (fG == maxrgb) {
                hue = 2.0f + (fB - fR) / (maxrgb - minrgb);
            }
            if (fB == maxrgb) {
                hue = 4.0f + (fR - fG) / (maxrgb - minrgb);
            }
            if ((hue *= 60.0f) < 0.0f) {
                hue += 360.0f;
            }
        }
        hsl[0] = hue;
        hsl[1] = sat;
        hsl[2] = lum;
        return hsl;
    }

    public static Color getHSLColor(float h, float s, float l) {
        Color color;
        float v = l <= 0.5f ? l * (1.0f + s) : l + s - l * s;
        if (v <= 0.0f) {
            color = Color.BLACK;
        } else {
            float m = l + l - v;
            float sv = (v - m) / v;
            float hs = h / 60.0f;
            int sextant = (int)Math.floor(hs);
            float fract = hs - (float)sextant;
            float vsf = v * sv * fract;
            float mid1 = m + vsf;
            float mid2 = v - vsf;
            int iv = Math.round(255.0f * v);
            int im = Math.round(255.0f * m);
            int imid1 = Math.round(255.0f * mid1);
            int imid2 = Math.round(255.0f * mid2);
            switch (sextant) {
                case 0: {
                    color = new Color(iv, imid1, im);
                    break;
                }
                case 1: {
                    color = new Color(imid2, iv, im);
                    break;
                }
                case 2: {
                    color = new Color(im, iv, imid1);
                    break;
                }
                case 3: {
                    color = new Color(im, imid2, iv);
                    break;
                }
                case 4: {
                    color = new Color(imid1, im, iv);
                    break;
                }
                case 5: {
                    color = new Color(iv, im, imid2);
                    break;
                }
                default: {
                    color = Color.BLACK;
                }
            }
        }
        return color;
    }

    public static boolean isDark(Color color) {
        return ColorUtil.getYIQLuminance(color) <= 145.0f;
    }

    public static float getYIQLuminance(Color color) {
        return 0.299f * (float)color.getRed() + 0.587f * (float)color.getGreen() + 0.114f * (float)color.getBlue();
    }

    public static Color applyGradient(Color baseColor, int depth) {
        float[] hsl = new float[3];
        ColorUtil.colorToHSL(baseColor, hsl);
        float brightness = hsl[2];
        float delta = 0.05f * (float)depth;
        brightness -= delta;
        brightness = Math.max(0.0f, brightness);
        Color thisColor = ColorUtil.getHSLColor(hsl[0], hsl[1], brightness);
        return thisColor;
    }
}

