/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.wizard2;

import com.sas.swing.visuals.wizard.WizardPageInterface;
import com.sas.swing.visuals.wizard2.RB;
import com.sas.swing.visuals.wizard2.Wizard;
import com.sas.text.Message;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JPanel;

public class WizardPageDeck
extends JPanel {
    public static final String RB_KEY = "WizardPageDeck.";
    protected Vector path;
    protected Map pageTable;
    protected Vector pageShownList;
    protected String currentPageName;
    protected CardLayout cardLayout;
    protected Wizard wizard;

    public WizardPageDeck(Wizard wizard) {
        this.wizard = wizard;
        this.path = new Vector();
        this.pageTable = new HashMap();
        this.pageShownList = new Vector();
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
    }

    public String getFirstPageName() {
        if (this.path.isEmpty()) {
            return null;
        }
        return (String)this.path.firstElement();
    }

    public String getLastPageName() {
        if (this.path.isEmpty()) {
            return null;
        }
        return (String)this.path.lastElement();
    }

    public String getPreviousPageName() {
        int currentPageIndex = this.path.indexOf(this.currentPageName);
        if (currentPageIndex == this.path.indexOf(this.path.firstElement())) {
            return null;
        }
        return (String)this.path.elementAt(--currentPageIndex);
    }

    public String getNextPageName() {
        int currentPageIndex = this.path.indexOf(this.currentPageName);
        if (currentPageIndex == this.path.indexOf(this.path.lastElement())) {
            return null;
        }
        return (String)this.path.elementAt(++currentPageIndex);
    }

    public String getCurrentPageName() {
        return this.currentPageName;
    }

    public void showPage(String pageName, int directionFlag) {
        WizardPageInterface page;
        if (this.path.contains(pageName)) {
            if ((directionFlag & 8) != 0 && this.currentPageName != null) {
                WizardPageInterface currentPage = (WizardPageInterface)this.pageTable.get(this.currentPageName);
                currentPage.hidePage(directionFlag);
            }
            this.currentPageName = pageName;
            if (this.wizard.whenToCreatePage == 1) {
                page = (WizardPageInterface)this.pageTable.get(pageName);
                if (page == null) {
                    page = this.wizard.createNamedPage(pageName);
                    this.pageTable.put(pageName, page);
                }
                if (page != null) {
                    boolean found = false;
                    Component[] components = this.getComponents();
                    for (int i = 0; i < components.length; ++i) {
                        if (components[i] != page) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.addPagesToDeck(new String[]{pageName});
                    }
                }
            }
            this.firePropertyChange("currentPageNumber", null, new Integer(this.getCurrentPageNumber()));
            page = (WizardPageInterface)this.pageTable.get(pageName);
            if (!this.pageShownList.contains(pageName)) {
                page.showPage(directionFlag | 4);
                this.pageShownList.addElement(pageName);
            } else {
                page.showPage(directionFlag);
            }
        } else {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "showPage.ex.txt"), (Object)pageName));
        }
        this.wizard.setImage(page.getStatusImage());
        this.wizard.enableButtons();
        this.cardLayout.show(this, pageName);
    }

    public void clearPath() {
        this.path.removeAllElements();
    }

    public void addToPath(String[] pageNames) {
        if (pageNames == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "addToPath.ex.txt"));
        }
        for (int i = 0; i < pageNames.length; ++i) {
            this.path.addElement(pageNames[i]);
        }
        this.firePropertyChange("pageCount", null, new Integer(this.getPageCount()));
        if (this.wizard.whenToCreatePage == 2) {
            this.addPagesToDeck(pageNames);
        }
    }

    protected void addPagesToDeck(String[] pageNames) {
        for (int i = 0; i < pageNames.length; ++i) {
            WizardPageInterface page = this.getPage(pageNames[i]);
            this.add((Component)((Object)page), pageNames[i]);
        }
    }

    public void appendPath(String[] pageNames) {
        int i;
        if (pageNames == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "appendPath.ex.txt"));
        }
        int tailSize = this.path.indexOf(this.path.lastElement()) - this.path.indexOf(this.currentPageName);
        for (i = 0; i < tailSize; ++i) {
            String name = (String)this.path.lastElement();
            WizardPageInterface page = this.getPage(name);
            if (page != null) {
                this.remove((Component)((Object)page));
            }
            this.path.removeElement(name);
        }
        for (i = 0; i < pageNames.length; ++i) {
            if (this.path.contains(pageNames[i])) {
                throw new IllegalStateException(Message.format((String)RB.getStringResource(RB_KEY, "appendPath2.ex.txt"), (Object)pageNames[i]));
            }
            this.path.addElement(pageNames[i]);
        }
        this.firePropertyChange("pageCount", null, new Integer(this.getPageCount()));
        if (this.wizard.whenToCreatePage == 2) {
            this.addPagesToDeck(pageNames);
        }
        this.wizard.buttonPanel.enableButtons();
    }

    public void addPage(String pageName, WizardPageInterface page) {
        if (!(this.pageTable.containsKey(pageName) || page != null && this.pageTable.containsValue(page))) {
            this.pageTable.put(pageName, page);
        } else {
            if (this.pageTable.containsKey(pageName)) {
                throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "addPage.ex.txt"), (Object)pageName));
            }
            if (page != null && this.pageTable.containsValue(page)) {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "addPage2.ex.txt"));
            }
        }
    }

    public void removePage(String pageName) {
        if (this.path.contains(pageName)) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "removePage.ex.txt"), (Object)pageName));
        }
        WizardPageInterface page = this.getPage(pageName);
        if (page != null) {
            this.remove((Component)((Object)page));
        }
        if (this.pageTable.containsKey(pageName)) {
            this.pageTable.remove(pageName);
        }
        this.pageShownList.removeElement(pageName);
    }

    public String getPageName(WizardPageInterface page) {
        if (this.pageTable.containsValue(page)) {
            Set entries = this.pageTable.entrySet();
            for (Map.Entry entry : entries) {
                if (entry.getValue() != page) continue;
                return (String)entry.getKey();
            }
        }
        throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "getPageName.ex.txt"), (Object)page));
    }

    public WizardPageInterface getPage(String pageName) {
        if (this.pageTable.containsKey(pageName)) {
            Object page = this.pageTable.get(pageName);
            if (page != null) {
                return (WizardPageInterface)page;
            }
            return null;
        }
        throw new IllegalArgumentException(Message.format((String)RB.getStringResource(RB_KEY, "getPage.ex.txt"), (Object)pageName));
    }

    public WizardPageInterface[] getPages() {
        WizardPageInterface[] pages = new WizardPageInterface[this.pageTable.size()];
        int pagesIndex = 0;
        Collection pageObjects = this.pageTable.values();
        for (Object page : pageObjects) {
            if (!(page instanceof WizardPageInterface)) continue;
            pages[pagesIndex++] = (WizardPageInterface)page;
        }
        return pages;
    }

    public int getCurrentPageNumber() {
        int currentPageNumber;
        if (this.currentPageName != null) {
            int currentPageIndex = this.path.indexOf(this.currentPageName);
            currentPageNumber = ++currentPageIndex;
        } else {
            currentPageNumber = -1;
        }
        return currentPageNumber;
    }

    public int getPageCount() {
        return this.path.size();
    }

    public String[] getPath() {
        int size = this.path.size();
        Object[] pageNames = new String[size];
        this.path.copyInto(pageNames);
        return pageNames;
    }
}

