/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import com.sas.swing.visuals.treetable.SasCellRenderer;
import com.sas.swing.visuals.treetable.TreeTable;
import com.sas.swing.visuals.treetable.TreeTableModel;
import com.sas.swing.visuals.treetable.TreeTableRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TreeUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class TreeTableRowRE
extends JTree
implements TableCellRenderer,
TableCellEditor {
    TreeTable tt;
    TreeTableModel ttm;
    Color background;
    Color selectionBackground;
    Color foreground;
    Color selectionForeground;
    DefaultTreeCellRenderer cr;
    JTable render_table;
    Object render_value;
    boolean render_selected;
    boolean render_focused;
    int render_row = -1;
    int render_col = -1;
    Hashtable rowIconWidths;
    static final int DEFAULT_ICON_WIDTH = 16;
    private int tempHeight = -1;
    TreeExpansionListener[] treeExpansionListeners;

    public TreeTableRowRE() {
        this.init();
    }

    public TreeTableRowRE(TreeTableModel m) {
        super(m);
        this.init();
    }

    private void init() {
        this.rowIconWidths = new Hashtable();
        this.tt = null;
        this.ttm = null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable t, Object val, boolean isSelected, boolean isFocused, int rx, int cx) {
        this.render_row = rx;
        this.render_col = cx;
        this.render_selected = isSelected;
        this.render_focused = isFocused;
        if (this.render_table == null) {
            this.setTable(t);
        }
        this.render_value = val;
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable t, Object val, boolean isSelected, int rx, int cx) {
        return this;
    }

    @Override
    public void setCellRenderer(TreeCellRenderer x) {
        if (x instanceof DefaultTreeCellRenderer) {
            this.cr = (DefaultTreeCellRenderer)x;
        }
        super.setCellRenderer(x);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (event == null || this.render_row == -1) {
            return null;
        }
        Point event_point = event.getPoint();
        Rectangle rb = this.getRowBounds(this.render_row);
        Point offset = new Point(rb.x, rb.y);
        int excess = event_point.x - (rb.width - 1);
        if (excess > 0) {
            offset.x -= excess;
        }
        if ((excess = event_point.y - (rb.height - 1)) > 0) {
            offset.y -= excess;
        }
        MouseEvent adjustedEvent = new MouseEvent(event.getComponent(), event.getID(), event.getWhen(), event.getModifiers(), event_point.x + offset.x, event_point.y + offset.y, event.getClickCount(), event.isPopupTrigger());
        return super.getToolTipText(adjustedEvent);
    }

    public void setTable(JTable t) {
        TreeCellRenderer x;
        this.render_table = t;
        this.tt = null;
        this.ttm = null;
        if (this.render_table instanceof TreeTable) {
            this.tt = (TreeTable)this.render_table;
            if (this.tt.getModel() instanceof TreeTableModel) {
                this.ttm = (TreeTableModel)this.tt.getModel();
            }
        }
        if ((x = this.getCellRenderer()) instanceof DefaultTreeCellRenderer) {
            this.cr = (DefaultTreeCellRenderer)x;
        }
        this.setBackground(t.getBackground());
        this.setForeground(t.getForeground());
        this.setSelectionBackground(t.getSelectionBackground());
        this.setSelectionForeground(t.getSelectionForeground());
    }

    @Override
    public void setUI(TreeUI ui) {
        this.setCellRenderer(null);
        super.setUI(ui);
    }

    @Override
    public void paint(Graphics g) {
        Color c;
        int rx = this.render_row;
        int cx = this.render_col;
        boolean sel = this.render_selected;
        boolean foc = this.render_focused;
        this.render_row = -1;
        TreeTableRow ttr = null;
        if (this.ttm != null && this.ttm.getRowAt(rx) instanceof TreeTableRow) {
            ttr = this.ttm.getRowAt(rx);
        }
        boolean renderingLink = this.tt != null && this.tt.isCellLink(rx, cx);
        Color bgcolor = this.background;
        Color fgcolor = this.foreground;
        if (this.tt != null) {
            Color c2;
            Color[] cc = this.tt.getBackgroundArray();
            if (cc != null && (c2 = cc[rx % cc.length]) != null) {
                bgcolor = c2;
            }
            if ((cc = this.tt.getForegroundArray()) != null && (c2 = cc[rx % cc.length]) != null) {
                fgcolor = c2;
            }
        }
        if (ttr != null) {
            c = ttr.getBackground();
            if (c != null) {
                bgcolor = c;
            }
            if ((c = ttr.getForeground()) != null) {
                fgcolor = c;
            }
        }
        if (renderingLink && (c = this.tt.getLinkForeground()) != null) {
            fgcolor = c;
        }
        if (sel) {
            if (this.selectionBackground != null) {
                bgcolor = this.selectionBackground;
            }
            if (this.selectionForeground != null) {
                fgcolor = this.selectionForeground;
            }
        }
        this.clearSelection();
        if (bgcolor instanceof ColorUIResource) {
            bgcolor = new Color(bgcolor.getRed(), bgcolor.getGreen(), bgcolor.getBlue(), bgcolor.getAlpha());
        }
        super.setBackground(bgcolor);
        super.setForeground(fgcolor);
        Icon openIcon = null;
        Icon closedIcon = null;
        Icon leafIcon = null;
        if (this.cr != null) {
            this.cr.setBackgroundNonSelectionColor(bgcolor);
            this.cr.setTextNonSelectionColor(fgcolor);
            if (ttr != null) {
                openIcon = this.cr.getOpenIcon();
                closedIcon = this.cr.getClosedIcon();
                leafIcon = this.cr.getLeafIcon();
                Icon i = ttr.getOpenIcon();
                if (i != null) {
                    this.cr.setOpenIcon(i);
                }
                if ((i = ttr.getClosedIcon()) != null) {
                    this.cr.setClosedIcon(i);
                }
                if ((i = ttr.getLeafIcon()) != null) {
                    this.cr.setLeafIcon(i);
                }
            }
        }
        Object oldCellValue = ttr.getUserObject();
        boolean oldCellValueSet = false;
        if (ttr != null && this.render_value != null && renderingLink && this.tt.isMouseOver(rx, cx)) {
            oldCellValueSet = true;
            String newCellValue = this.render_value.toString();
            Color c3 = this.tt.getLinkForeground();
            if (c3 != null) {
                newCellValue = "<font color=" + SasCellRenderer.getHtmlColor(c3) + ">" + newCellValue + "</font>";
            }
            newCellValue = "<html><u>" + newCellValue + "</u></html>";
            ttr.setUserObject(newCellValue);
        } else if (this.render_value != null && this.render_value != oldCellValue) {
            oldCellValueSet = true;
            ttr.setUserObject(this.render_value.toString());
        }
        int rh = this.render_table.getRowHeight(rx);
        int oldRh = this.getRowHeight();
        this.setRowHeight(rh);
        Rectangle rr = this.getRowBounds(rx);
        if (this.tt != null) {
            Rectangle r = this.tt.getCellRect(rx, cx, false);
            g.clipRect(0, 0, r.width, r.height);
        }
        g.translate(0, -rr.y);
        if (this.ttm != null && ttr != null && this.cr != null) {
            int currentWidth;
            boolean winbug = this.cr.getClass().getName().equals("com.sun.java.swing.plaf.windows.WindowsTreeUI$WindowsTreeCellRenderer");
            Icon rowIcon = ttr.isLeaf() ? this.cr.getLeafIcon() : (winbug && sel ? this.cr.getOpenIcon() : (!winbug && ttr.isExpanded() ? this.cr.getOpenIcon() : this.cr.getClosedIcon()));
            Integer cachedWidthInteger = (Integer)this.rowIconWidths.get(ttr);
            int cachedWidth = cachedWidthInteger != null ? cachedWidthInteger : 16;
            int n = currentWidth = rowIcon != null ? rowIcon.getIconWidth() : 16;
            if (currentWidth != cachedWidth) {
                this.ttm.fireTreeNodeChanged(ttr);
                if (currentWidth != 16) {
                    this.rowIconWidths.put(ttr, new Integer(currentWidth));
                } else {
                    this.rowIconWidths.remove(ttr);
                }
            }
        }
        this.setTempHeight(rh * this.getRowCount());
        super.paint(g);
        this.setTempHeight(-1);
        if (this.cr != null) {
            if (foc) {
                Border b = UIManager.getBorder("Table.focusCellHighlightBorder");
                b.paintBorder(this, g, 1, rr.y, this.getWidth() - 2, rr.height - 1);
            }
            if (ttr != null) {
                this.cr.setOpenIcon(openIcon);
                this.cr.setClosedIcon(closedIcon);
                this.cr.setLeafIcon(leafIcon);
            }
        }
        if (oldCellValueSet) {
            ttr.setUserObject(oldCellValue);
        }
        this.setRowHeight(oldRh);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, 0, w, this.render_table.getHeight());
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getRowCount() == 0) {
            return new Dimension(0, 0);
        }
        if (this.render_row < 0) {
            if (this.ttm == null) {
                return new Dimension(0, 0);
            }
            int maxWidth = 0;
            Dimension maxPs = null;
            for (int rx = 0; rx < this.ttm.getRowCount(); ++rx) {
                Component r = super.getCellRenderer().getTreeCellRendererComponent(this, this.ttm.getRowAt(rx).getUserObject(), false, false, false, rx, false);
                Dimension ps = r.getPreferredSize();
                int rw = ps.width;
                if (rw <= maxWidth) continue;
                maxWidth = rw;
                maxPs = ps;
            }
            return maxPs;
        }
        boolean nodeIsExpanded = false;
        boolean nodeIsALeaf = false;
        if (this.ttm != null) {
            TreeTableRow ttr = this.ttm.getRowAt(this.render_row);
            nodeIsExpanded = ttr.isExpanded();
            nodeIsALeaf = ttr.isLeaf();
        }
        Component r = super.getCellRenderer().getTreeCellRendererComponent(this, this.render_value, this.render_selected, nodeIsExpanded, nodeIsALeaf, this.render_row, this.render_focused);
        return r.getPreferredSize();
    }

    private void setTempHeight(int h) {
        this.tempHeight = h;
    }

    @Override
    public int getHeight() {
        return this.tempHeight > 0 ? this.tempHeight : super.getHeight();
    }

    @Override
    public void setBackground(Color c) {
        if (this.cr != null) {
            this.cr.setBackgroundNonSelectionColor(new Color(0, 0, 0, 0));
        }
        this.background = c;
    }

    @Override
    public void setForeground(Color c) {
        if (this.cr != null) {
            this.cr.setTextNonSelectionColor(c);
        }
        this.foreground = c;
    }

    public void setSelectionBackground(Color c) {
        if (this.cr != null) {
            this.cr.setBackgroundSelectionColor(c);
        }
        this.selectionBackground = c;
    }

    public void setSelectionForeground(Color c) {
        if (this.cr != null) {
            this.cr.setTextSelectionColor(c);
        }
        this.selectionForeground = c;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
    }

    synchronized void disconnectTreeExpansionListeners() {
        if (this.treeExpansionListeners != null) {
            return;
        }
        TreeExpansionListener[] listeners = this.getTreeExpansionListeners();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                String n = listeners[i].getClass().getName();
                if (!n.startsWith("java")) {
                    this.removeTreeExpansionListener(listeners[i]);
                    continue;
                }
                listeners[i] = null;
            }
        } else {
            listeners = new TreeExpansionListener[]{};
        }
        this.treeExpansionListeners = listeners;
    }

    synchronized void reconnectTreeExpansionListeners() {
        if (this.treeExpansionListeners == null) {
            return;
        }
        TreeExpansionListener[] listeners = this.treeExpansionListeners;
        this.treeExpansionListeners = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] == null) continue;
            this.addTreeExpansionListener(listeners[i]);
            listeners[i] = null;
        }
    }

    @Override
    public synchronized void addTreeExpansionListener(TreeExpansionListener el) {
        if (this.treeExpansionListeners != null) {
            if (this.findTreeExpansionListeners(el) >= 0) {
                return;
            }
            TreeExpansionListener[] oldListeners = this.treeExpansionListeners;
            int oldlen = oldListeners.length;
            int len = oldlen + 1;
            this.treeExpansionListeners = new TreeExpansionListener[len];
            for (int i = 0; i < oldlen; ++i) {
                this.treeExpansionListeners[i] = oldListeners[i];
            }
            this.treeExpansionListeners[len - 1] = el;
        } else {
            super.addTreeExpansionListener(el);
        }
    }

    @Override
    public synchronized void removeTreeExpansionListener(TreeExpansionListener el) {
        if (this.treeExpansionListeners != null) {
            if (this.findTreeExpansionListeners(el) < 0) {
                return;
            }
            TreeExpansionListener[] oldListeners = this.treeExpansionListeners;
            int oldlen = oldListeners.length;
            int len = oldlen - 1;
            this.treeExpansionListeners = new TreeExpansionListener[len];
            int found = 0;
            for (int i = 0; i < len; ++i) {
                if (oldListeners[i] == el) {
                    found = 1;
                }
                this.treeExpansionListeners[i] = oldListeners[i + found];
            }
        } else {
            super.removeTreeExpansionListener(el);
        }
    }

    @Override
    public synchronized TreeExpansionListener[] getTreeExpansionListeners() {
        return this.treeExpansionListeners != null ? this.treeExpansionListeners : super.getTreeExpansionListeners();
    }

    private int findTreeExpansionListeners(TreeExpansionListener el) {
        if (this.treeExpansionListeners == null) {
            return -1;
        }
        for (int i = 0; i < this.treeExpansionListeners.length; ++i) {
            if (this.treeExpansionListeners[i] != el) continue;
            return i;
        }
        return -1;
    }
}

