/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.treetable;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class TreeTableHeader
extends JTableHeader {
    int preferredHeight;
    int preferredWidth;
    boolean preferredHeightIsValid = false;
    boolean preferredWidthIsValid = false;

    public TreeTableHeader() {
    }

    public TreeTableHeader(TableColumnModel cm) {
        super(cm);
    }

    public void setPreferredHeight(int h) {
        this.preferredHeight = h;
        this.preferredHeightIsValid = true;
    }

    public void unsetPreferredHeight() {
        this.preferredHeightIsValid = false;
    }

    public boolean isPreferredHeightSet() {
        return this.preferredHeightIsValid;
    }

    public int getPreferredHeight() {
        if (this.preferredHeightIsValid) {
            return this.preferredHeight;
        }
        return (int)super.getPreferredSize().getHeight();
    }

    public void setPreferredWidth(int w) {
        this.preferredWidth = w;
        this.preferredWidthIsValid = true;
    }

    public void unsetPreferredWidth() {
        this.preferredWidthIsValid = false;
    }

    public boolean isPreferredWidthSet() {
        return this.preferredWidthIsValid;
    }

    public int getPreferredWidth() {
        if (this.preferredWidthIsValid) {
            return this.preferredWidth;
        }
        return (int)super.getPreferredSize().getWidth();
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.preferredWidth;
        int h = this.preferredHeight;
        boolean wv = this.preferredWidthIsValid;
        boolean hv = this.preferredHeightIsValid;
        if (wv && hv) {
            return new Dimension(w, h);
        }
        Dimension sd = super.getPreferredSize();
        if (!wv && !hv) {
            return sd;
        }
        return new Dimension(wv ? w : sd.width, hv ? h : sd.height);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.setOpaque(bg.getAlpha() == 255);
    }
}

