/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview.editors;

import com.sas.swing.events.TextSelectionEvent;
import com.sas.swing.events.TextSelectionListener;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TextSelectionEditor
extends DefaultTableCellEditor {
    protected int textSelectStart;
    protected int textSelectEnd;
    protected boolean fireSelectionChangedOnAllDrags;

    public TextSelectionEditor() {
        this(2);
    }

    public TextSelectionEditor(int horizontalAlignment) {
        this.setClickCountToStart(1);
        this.fireSelectionChangedOnAllDrags = false;
        JTextField textField = (JTextField)this.getComponent();
        textField.setEditable(false);
        textField.setHorizontalAlignment(horizontalAlignment);
        textField.setOpaque(true);
        textField.setBackground(UIManager.getColor("Table.background"));
        textField.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextSelectionEditor.this.evaluateSelection(TextSelectionEditor.this.fireSelectionChangedOnAllDrags);
                    }
                });
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        textField.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextSelectionEditor.this.evaluateSelection(false);
                    }
                });
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
    }

    public void setFireSelectionChangedOnAllDrags(boolean mode) {
        this.fireSelectionChangedOnAllDrags = mode;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ((JTextField)this.editorComponent).setText(value.toString());
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public void addTextSelectionListener(TextSelectionListener l) {
        this.listenerList.add(TextSelectionListener.class, l);
    }

    public void removeTextSelectionListener(TextSelectionListener l) {
        this.listenerList.remove(TextSelectionListener.class, l);
    }

    protected void evaluateSelection(boolean forceEvent) {
        JTextField textField = (JTextField)this.getComponent();
        if (forceEvent || textField.getSelectionStart() != this.textSelectStart || textField.getSelectionEnd() != this.textSelectEnd) {
            if (textField.getSelectionStart() == textField.getSelectionEnd()) {
                if (this.textSelectStart != this.textSelectEnd) {
                    this.textSelectStart = textField.getSelectionStart();
                    this.textSelectEnd = textField.getSelectionEnd();
                    this.fireSelectionCleared(textField);
                }
            } else {
                this.textSelectStart = textField.getSelectionStart();
                this.textSelectEnd = textField.getSelectionEnd();
                this.fireSelectionChanged(textField, this.textSelectStart, this.textSelectEnd);
            }
        }
    }

    protected void fireSelectionChanged(Object source, int textSelectStart, int textSelectEnd) {
        Object[] listeners = this.listenerList.getListenerList();
        TextSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TextSelectionListener.class) continue;
            if (e == null) {
                e = new TextSelectionEvent(source, textSelectStart, textSelectEnd);
            }
            ((TextSelectionListener)listeners[i + 1]).textSelectionChanged(e);
        }
    }

    protected void fireSelectionCleared(Object source) {
        Object[] listeners = this.listenerList.getListenerList();
        TextSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TextSelectionListener.class) continue;
            if (e == null) {
                e = new TextSelectionEvent(source);
            }
            ((TextSelectionListener)listeners[i + 1]).textSelectionCleared(e);
        }
    }
}

