/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview.editors;

import com.sas.models.tableview.editors.EditorValueInterface;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.swing.visuals.tableview.editors.RB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;

public class ComponentAndButtonEditor
extends DefaultTableCellEditor {
    public static final String RB_KEY = "ComponentAndButtonEditor.";
    protected JComponent component;
    protected JButton button;
    protected EditorValueInterface editorValueInterface;

    public ComponentAndButtonEditor(JComponent component) {
        this.component = component;
        this.init();
    }

    public ComponentAndButtonEditor(JComponent component, JButton button) {
        this.component = component;
        this.button = button;
        this.init();
    }

    public void setEditorValueInterface(EditorValueInterface editorValueInterface) {
        this.editorValueInterface = editorValueInterface;
    }

    protected void init() {
        JPanel panel = new JPanel();
        BorderLayout layout = new BorderLayout();
        layout.setHgap(2);
        panel.setLayout(layout);
        this.component.setName("TextFieldAndButtonEditor_Component");
        panel.add((Component)this.component, "Center");
        if (this.button == null) {
            this.button = new JButton(RB.getStringResource(RB_KEY, "defaultButtonLaunch.txt"));
        }
        this.button.setName("ComponentAndButtonEditor_Button");
        this.button.setMargin(new Insets(0, 2, 0, 2));
        panel.add((Component)this.button, "East");
        this.editorComponent = panel;
    }

    public JComponent getEditorComponent() {
        return this.component;
    }

    public JButton getButton() {
        return this.button;
    }

    public void setButtonText(String text) {
        this.button.setText(text);
    }

    public void setButtonIcon(Icon icon) {
        this.button.setIcon(icon);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setCellEditorValue(value);
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.editorValueInterface != null) {
            return this.editorValueInterface.getCellEditorValue();
        }
        return this.component.toString();
    }

    public void setCellEditorValue(Object value) {
        if (this.editorValueInterface != null && value != null) {
            this.editorValueInterface.setCellEditorValue(value.toString());
        }
    }
}

