/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.actionprovider.SwingActionProviderViewInterface;
import com.sas.actionprovider.support.SwingViewerSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.entities.AttributeSetException;
import com.sas.swing.adapters.TableViewClipboardAdapter;
import com.sas.swing.event.SwingTableModelEvent;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.visuals.DatePicker;
import com.sas.swing.visuals.TextEditor;
import com.sas.swing.visuals.tableview.CellSelectionModel;
import com.sas.swing.visuals.tableview.ColumnHeader;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.tableview.DefaultTableRowModel;
import com.sas.swing.visuals.tableview.EditController;
import com.sas.swing.visuals.tableview.HoldInterface;
import com.sas.swing.visuals.tableview.OriginComponent;
import com.sas.swing.visuals.tableview.RB;
import com.sas.swing.visuals.tableview.RowHeader;
import com.sas.swing.visuals.tableview.TableRowModel;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.swing.visuals.tableview.TableRowModelListener;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.swing.visuals.tableview.TableViewViewportLayout;
import com.sas.swing.visuals.util.ActionUIFactory;
import com.sas.swing.visuals.util.ChangeCursorCommand;
import com.sas.swing.visuals.util.Util;
import com.sas.table.EditControllerInterface;
import com.sas.table.FormattedInterface;
import com.sas.table.InsertRowInterface;
import com.sas.table.MoveColumnInterface;
import com.sas.table.SortableInterface;
import com.sas.text.Message;
import com.sas.util.errorhandlers.GenericErrorHandlerInterface;
import com.sas.util.errorhandlers.JOptionPaneErrorHandler;
import com.sas.util.errorhandlers.SupportsGenericErrorHandlerInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SizeSequence;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class TableView
extends JTable
implements TableRowModelListener,
SwingActionProviderViewInterface,
ContentsChangedListener,
AdjustmentListener,
Printable,
SupportsGenericErrorHandlerInterface,
MoveColumnInterface {
    public static final String RB_KEY = "TableView.";
    public static final int LASTROW = -369;
    protected static final String uiClassID = "TableViewUI";
    private RowHeader rowHeader;
    private List hiddenColumns;
    private boolean rowsReorderable;
    private JPopupMenu popupMenu;
    private boolean popupMenuEnabled;
    private TableViewClipboardAdapter clipboardAdapter;
    private JComponent originComponent;
    private Map cellRenderers;
    private Map cellEditors;
    protected SizeSequence rowHeightModel;
    private int currentRow;
    private int currentColumn;
    protected boolean changingCurrentCell;
    private EditControllerInterface editController;
    private TableRowModel rowModel;
    private int gridWidth;
    protected SwingViewerSupport viewerSupport;
    protected ActionSupportFilter dataCellFilter;
    protected ActionSupportFilter rowHeaderFilter;
    protected ActionSupportFilter columnHeaderFilter;
    protected ActionSupportFilter titleFilter;
    protected ActionSupportFilter toolbarFilter;
    private boolean sizingRows;
    private boolean waitForSizing;
    protected boolean columnsSized;
    protected int rowAutoResizeMode;
    protected int columnAutoResizeMode;
    protected GenericErrorHandlerInterface genericErrorHandler;
    private int visibleRowCount;
    private int visibleColumnCount;
    protected ActionUIFactory factory;
    protected boolean tableInitialized;
    private boolean ignoreResizeEvents;
    public static final int AUTO_RESIZE_FIRST_ROW = 5;
    public static final int AUTO_RESIZE_ALL_ROWS = 6;
    private boolean rowAutoResizeModeInitialized;
    private boolean columnAutoResizeModeInitialized;
    private ChangeCursorCommand changeCursorCommand;
    public boolean printing;
    protected String[] lastSortedColumns;
    protected int[] lastSortDirections;
    protected boolean clearRowSelectionAfterSorting;
    private PrintInfo printInfo;

    public TableView() {
        this(null, null, null);
    }

    public TableView(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public TableView(TableModel tableModel, TableColumnModel columnModel) {
        this(tableModel, columnModel, null);
    }

    public TableView(TableModel tableModel, TableColumnModel columnModel, ListSelectionModel selectionModel) {
        super(tableModel, columnModel, selectionModel);
        this.updateUI();
    }

    public TableView(int numRows, int numColumns) {
        this(new DefaultTableModel(numRows, numColumns));
    }

    public TableView(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.updateUI();
    }

    public TableView(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    @Override
    public int rowAtPoint(Point point) {
        return this.rowAtPoint(point, true);
    }

    public int rowAtPoint(Point point, boolean accountForHolds) {
        int y = point.y;
        if (y < 0) {
            return -1;
        }
        int result = this.rowHeightModel == null ? y / this.getRowHeight() : this.rowHeightModel.getIndex(y);
        int rowCount = this.getRowCount();
        int heldTopSize = this.getRowHeader().getHeldIndices(1).size();
        int heldBottomSize = this.getRowHeader().getHeldIndices(3).size();
        if (accountForHolds && (heldTopSize > 0 || heldBottomSize > 0)) {
            Point viewPoint = this.getViewPosition();
            Rectangle view = this.getVisibleRect().intersection(this.getCellAreaRect());
            int loc = point.y - viewPoint.y;
            if (loc < this.getTopHeldHeight()) {
                int i = 0;
                for (int heldRowHeight = 0; heldRowHeight < loc; heldRowHeight += this.getRowHeight(i)) {
                    result = i++;
                }
            } else {
                loc = view.y + view.height - point.y;
                if (loc > 0) {
                    int h = 0;
                    for (int i = rowCount - 1; i >= rowCount - heldBottomSize; --i) {
                        if ((h += this.getRowHeight(i)) <= loc) continue;
                        result = i;
                        break;
                    }
                }
            }
        }
        if (result < 0) {
            return -1;
        }
        if (result >= rowCount) {
            return -1;
        }
        return result;
    }

    @Override
    public int columnAtPoint(Point point) {
        return this.columnAtPoint(point, true);
    }

    public int columnAtPoint(Point point, boolean accountForHolds) {
        int x = point.x;
        if (!this.getComponentOrientation().isLeftToRight()) {
            x = this.getCellAreaWidth() - x;
        }
        int result = -1;
        int width = 0;
        int columnCount = this.getColumnCount();
        int heldLeftSize = 0;
        int heldRightSize = 0;
        if (this.getTableHeader() instanceof HoldInterface) {
            heldLeftSize = ((HoldInterface)((Object)this.getTableHeader())).getHeldIndices(2).size();
            heldRightSize = ((HoldInterface)((Object)this.getTableHeader())).getHeldIndices(4).size();
        }
        int heldLeftWidth = 0;
        int i = 0;
        while (width <= x) {
            if (i == columnCount) {
                result = i;
                break;
            }
            int columnWidth = this.getColumnModel().getColumn(i).getWidth();
            width += columnWidth;
            if (i < heldLeftSize) {
                heldLeftWidth += columnWidth;
            }
            if (x < width) {
                result = i;
            }
            ++i;
        }
        if (accountForHolds && (heldLeftSize > 0 || heldRightSize > 0)) {
            Point viewPoint = this.getViewPosition();
            Rectangle view = this.getVisibleRect().intersection(this.getCellAreaRect());
            int loc = point.x - viewPoint.x;
            if (loc < heldLeftWidth) {
                int i2 = 0;
                for (int heldColumnWidth = 0; heldColumnWidth < loc; heldColumnWidth += this.getColumnModel().getColumn(i2).getWidth()) {
                    result = i2++;
                }
            } else {
                loc = view.x + view.width - point.x;
                if (loc > 0) {
                    int w = 0;
                    for (int i3 = columnCount - 1; i3 >= columnCount - heldRightSize; --i3) {
                        if ((w += this.getColumnModel().getColumn(i3).getWidth()) <= loc) continue;
                        result = i3;
                        break;
                    }
                }
            }
        }
        if (result < 0) {
            return -1;
        }
        if (result >= this.getColumnCount()) {
            return -1;
        }
        return result;
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing, boolean accountForHolds) {
        int tableHeight;
        Rectangle r = new Rectangle();
        boolean valid = true;
        boolean leftToRight = this.getComponentOrientation().isLeftToRight();
        int rowCount = this.getRowCount();
        if (row < 0) {
            r.y = 0;
            r.height = this.getRowHeight(rowCount - 1);
            r.height = tableHeight = this.rowHeightModel == null ? (rowCount - 1) * r.height : this.rowHeightModel.getPosition(rowCount - 1);
            valid = false;
        } else if (row >= rowCount) {
            r.y = 0;
            r.height = this.getRowHeight(rowCount - 1);
            r.height = tableHeight = this.rowHeightModel == null ? (rowCount - 1) * r.height : this.rowHeightModel.getPosition(rowCount - 1);
            valid = false;
        } else {
            int modelRow = this.convertRowIndexToModel(row);
            r.height = this.getRowHeight(row);
            int n = r.y = this.rowHeightModel == null ? row * r.height : this.rowHeightModel.getPosition(row);
            if (accountForHolds && this.getRowHeader() != null) {
                if (this.getRowHeader().isHeld(modelRow, 1)) {
                    r.y += this.getViewPosition().y;
                } else if (this.getRowHeader().isHeld(modelRow, 3)) {
                    int tableHeight2 = this.rowHeightModel == null ? (rowCount - 1) * r.height : this.rowHeightModel.getPosition(rowCount - 1);
                    int insetFromBottom = (tableHeight2 += this.getRowHeight(rowCount - 1)) - r.y;
                    Rectangle vr = this.getVisibleRect();
                    r.y = vr.y + (Math.min(tableHeight2, vr.height) - insetFromBottom);
                }
            }
        }
        if (column < 0) {
            if (!leftToRight) {
                r.x = this.getColumnModel().getTotalColumnWidth();
            }
            r.x = 0;
            r.width = this.getColumnModel().getTotalColumnWidth();
            valid = false;
        } else if (column >= this.getColumnCount()) {
            if (leftToRight) {
                r.x = this.getColumnModel().getTotalColumnWidth();
            }
            r.x = 0;
            r.width = this.getColumnModel().getTotalColumnWidth();
            valid = false;
        } else {
            int i;
            int modelColumn = this.convertColumnIndexToModel(column);
            TableColumnModel cm = this.getColumnModel();
            if (leftToRight) {
                for (i = 0; i < column; ++i) {
                    r.x += cm.getColumn(i).getWidth();
                }
            } else {
                for (i = cm.getColumnCount() - 1; i > column; --i) {
                    r.x += cm.getColumn(i).getWidth();
                }
            }
            r.width = cm.getColumn(column).getWidth();
            if (accountForHolds && this.getTableHeader() instanceof HoldInterface) {
                if (((HoldInterface)((Object)this.getTableHeader())).isHeld(modelColumn, 2)) {
                    r.x = leftToRight ? (r.x += this.getViewPosition().x) : (r.x -= this.getViewPosition().x);
                } else if (((HoldInterface)((Object)this.getTableHeader())).isHeld(modelColumn, 4)) {
                    int tableWidth = this.getColumnModel().getTotalColumnWidth();
                    int insetFromRight = tableWidth - r.x;
                    Rectangle vr = this.getVisibleRect();
                    r.x = vr.x + (Math.min(tableWidth, vr.width) - insetFromRight);
                }
            }
        }
        if (valid && !includeSpacing) {
            int rm = this.getRowMargin();
            int cm = this.getColumnModel().getColumnMargin();
            if (leftToRight) {
                r.setBounds(r.x + cm / 2, r.y + rm / 2, r.width - cm, r.height - rm);
            } else {
                r.setBounds(r.x + cm / 2 + cm % 2, r.y + rm / 2, r.width - cm, r.height - rm);
            }
        }
        return r;
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        return this.getCellRect(row, column, includeSpacing, true);
    }

    public int getFirstVisibleRow() {
        return this.rowAtPoint(this.getViewPosition());
    }

    public int getLastVisibleRow() {
        Rectangle rect = this.getVisibleRect().intersection(this.getCellAreaRect());
        if (rect.height > 0) {
            int rowCount;
            Point point = new Point(0, rect.y + rect.height - 1);
            int row = this.rowAtPoint(point);
            if (row == -1 && (rowCount = this.getRowCount()) > 0) {
                row = rowCount - 1;
            }
            return row;
        }
        return -1;
    }

    public int getFirstVisibleColumn() {
        return this.columnAtPoint(this.getViewPosition());
    }

    public int getLastVisibleColumn() {
        Point point = this.getViewPosition();
        Container p = this.getParent();
        if (p instanceof JViewport) {
            point.x += p.getWidth();
        }
        int column = this.columnAtPoint(point);
        int columnCount = this.getColumnCount();
        if (column == -1 && columnCount > 0) {
            column = columnCount - 1;
        }
        return column;
    }

    @Override
    public void setRowMargin(int rowMargin) {
        if (this.getRowMargin() != rowMargin) {
            int old = this.getRowMargin();
            this.rowMargin = rowMargin;
            if (this.getRowModel() != null) {
                this.getRowModel().setRowMargin(rowMargin);
            }
            this.resizeAndRepaint();
            this.firePropertyChange("rowMargin", old, rowMargin);
        }
    }

    @Override
    public int getRowMargin() {
        if (this.getRowModel() != null) {
            return this.getRowModel().getRowMargin();
        }
        return 1;
    }

    @Override
    public Dimension getIntercellSpacing() {
        return new Dimension(this.getColumnModel().getColumnMargin(), this.getRowMargin());
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int newWidth) {
        if (newWidth < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidGridWidth.ex.txt"));
        }
        if (newWidth != this.gridWidth) {
            int old = this.gridWidth;
            this.gridWidth = newWidth;
            this.firePropertyChange("gridWidth", old, this.gridWidth);
            this.repaint();
        }
    }

    public Point getViewPosition() {
        Container p = this.getParent();
        Point point = new Point(0, 0);
        if (p instanceof JViewport) {
            point = ((JViewport)p).getViewPosition();
            if (!this.getComponentOrientation().isLeftToRight()) {
                point.x += p.getWidth() - this.getCellAreaWidth();
            }
        }
        return point;
    }

    @Override
    public Object getValueAt(int row, int column) {
        int columnIndex = this.convertColumnIndexToModel(column);
        if (columnIndex >= 0) {
            Class colClass;
            Object obj = this.getModel().getValueAt(this.convertRowIndexToModel(row), columnIndex);
            if (obj instanceof String && Number.class.isAssignableFrom(colClass = this.getUnformattedColumnClass(column))) {
                obj = ((String)obj).trim();
            }
            return obj;
        }
        return null;
    }

    public Object getUnformattedValueAt(int row, int column) {
        if (this.getModel() instanceof FormattedInterface) {
            int columnIndex = this.convertColumnIndexToModel(column);
            if (columnIndex >= 0) {
                return ((FormattedInterface)this.getModel()).getUnformattedValueAt(this.convertRowIndexToModel(row), columnIndex);
            }
        } else {
            return this.getValueAt(row, column);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        JScrollPane pane;
        int columnIndex = this.convertColumnIndexToModel(column);
        if (columnIndex >= 0) {
            this.getModel().setValueAt(aValue, this.convertRowIndexToModel(row), columnIndex);
        }
        if ((pane = this.getScrollPane()) != null) {
            pane.getViewport().repaint();
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.getEditController().isEditableColumn(TableViewUtil.getColumnName(this.getModel(), column))) {
            return this.getModel().isCellEditable(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column));
        }
        return false;
    }

    @Override
    public int convertRowIndexToModel(int viewRowIndex) {
        if (this.getRowModel() != null) {
            return this.getRowModel().convertRowIndexToModel(viewRowIndex);
        }
        return viewRowIndex;
    }

    @Override
    public int convertRowIndexToView(int modelRowIndex) {
        if (modelRowIndex < 0) {
            return modelRowIndex;
        }
        return this.getRowModel().convertRowIndexToView(modelRowIndex);
    }

    @Override
    protected ListSelectionModel createDefaultSelectionModel() {
        return new CellSelectionModel(this);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new ColumnHeader(this.getColumnModel());
    }

    public JScrollPane getScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            return (JScrollPane)gp;
        }
        return null;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane != null) {
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            viewport.setLayout(new TableViewViewportLayout());
            Border border = scrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
            if (this.getTableHeader() != null && this.getTableHeader().isVisible()) {
                scrollPane.setColumnHeaderView(this.getTableHeader());
                scrollPane.getColumnHeader().setScrollMode(2);
            }
            if (this.getRowHeader() != null && this.getRowHeader().isVisible()) {
                scrollPane.setRowHeaderView(this.getRowHeader());
                scrollPane.getRowHeader().setScrollMode(2);
            }
            if (this.getOriginComponent() != null && this.getOriginComponent().isVisible()) {
                scrollPane.setCorner("UPPER_LEFT_CORNER", this.getOriginComponent());
            }
            viewport.setScrollMode(2);
            scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
            scrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        }
    }

    @Override
    protected void unconfigureEnclosingScrollPane() {
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane != null) {
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.setColumnHeaderView(null);
            scrollPane.setRowHeaderView(null);
        }
    }

    public void setRowHeaderVisible(boolean b) {
        this.getRowHeader().setVisible(b);
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane != null) {
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            if (b) {
                scrollPane.setRowHeaderView(this.getRowHeader());
            } else {
                scrollPane.setRowHeaderView(null);
            }
        }
    }

    public boolean isRowHeaderVisible() {
        return this.getRowHeader().isVisible();
    }

    public void setRowsReorderable(boolean newValue) {
        if (newValue != this.rowsReorderable) {
            this.rowsReorderable = newValue;
            this.firePropertyChange("rowsReorderable", newValue ? Boolean.FALSE : Boolean.TRUE, newValue ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isRowsReorderable() {
        return this.rowsReorderable;
    }

    public void setColumnHeaderVisible(boolean b) {
        if (this.getTableHeader() != null) {
            this.getTableHeader().setVisible(b);
            JScrollPane scrollPane = this.getScrollPane();
            if (scrollPane != null) {
                JViewport viewport = scrollPane.getViewport();
                if (viewport == null || viewport.getView() != this) {
                    return;
                }
                if (b) {
                    scrollPane.setColumnHeaderView(this.getTableHeader());
                } else {
                    scrollPane.setColumnHeaderView(null);
                }
            }
        }
    }

    public boolean isColumnHeaderVisible() {
        return this.getTableHeader() != null ? this.getTableHeader().isVisible() : false;
    }

    public void setEditController(EditControllerInterface newEditController) {
        if (com.sas.util.Util.unequal((Object)newEditController, (Object)this.editController)) {
            EditControllerInterface old = this.editController;
            this.editController = newEditController;
            this.firePropertyChange("editController", old, this.editController);
        }
    }

    public EditControllerInterface getEditController() {
        return this.editController;
    }

    @Override
    protected void initializeLocalVars() {
        this.factory = new ActionUIFactory();
        this.sizingRows = false;
        this.columnsSized = false;
        if (!this.rowAutoResizeModeInitialized) {
            this.rowAutoResizeMode = 5;
        }
        if (!this.columnAutoResizeModeInitialized) {
            this.columnAutoResizeMode = 4;
        }
        this.visibleRowCount = -1;
        this.visibleColumnCount = -1;
        this.gridWidth = 1;
        this.rowsReorderable = true;
        this.popupMenuEnabled = true;
        this.currentRow = 0;
        this.currentColumn = 0;
        this.editController = new EditController();
        this.editController.setEditEnabled(true);
        this.genericErrorHandler = new JOptionPaneErrorHandler();
        this.changingCurrentCell = false;
        this.clearRowSelectionAfterSorting = true;
        this.setRowHeight(18);
        try {
            if (this.getClipboardAdapter() == null) {
                this.clipboardAdapter = new TableViewClipboardAdapter(this);
            }
        }
        catch (AccessControlException ex) {
            this.clipboardAdapter = null;
        }
        this.changeCursorCommand = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
        this.cellRenderers = null;
        this.cellEditors = null;
        this.createDefaultRenderers();
        this.setRowModel(this.createDefaultRowModel());
        this.setRowHeader(this.createDefaultRowHeader());
        this.setOriginComponent(this.createDefaultOriginComponent());
        this.popupMenu = this.createPopupMenu();
        this.add(this.popupMenu);
        this.createDefaultViewerSupport();
        this.createDefaultActionProviderFilters();
        super.initializeLocalVars();
        this.setRowHeight(18);
        this.setSurrendersFocusOnKeystroke(true);
        this.autoResizeMode = 0;
        this.tableInitialized = true;
        this.sizeColumnsIfNeeded();
    }

    public void createDefaultViewerSupport() {
        this.viewerSupport = new SwingViewerSupport(this);
        this.viewerSupport.setActionSupportType("TABLEVIEW_SUPPORT");
    }

    public void createDefaultActionProviderFilters() {
        this.dataCellFilter = new ActionSupportFilter(this.getActionSupportType(), "DATA_CELL_AREA", this);
        this.rowHeaderFilter = new ActionSupportFilter(this.getActionSupportType(), "ROW_HEADER_AREA", this);
        this.columnHeaderFilter = new ActionSupportFilter(this.getActionSupportType(), "COLUMN_HEADER_AREA", this);
        this.titleFilter = new ActionSupportFilter(this.getActionSupportType(), "TITLE_AREA", this);
        this.toolbarFilter = new ActionSupportFilter(this.getActionSupportType(), "TOOLBAR_AREA", this);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean retValue = false;
        InputMap map = this.getInputMap(condition);
        ActionMap am = this.getActionMap();
        if (map != null && am != null && this.isEnabled()) {
            Action action;
            Object binding = map.get(ks);
            Action action2 = action = binding == null ? null : am.get(binding);
            if (action != null) {
                retValue = SwingUtilities.notifyAction(action, ks, e, this, e.getModifiers());
            }
        }
        if (!retValue && condition == 1 && this.hasFocus() && !Boolean.FALSE.equals((Boolean)this.getClientProperty("JTable.autoStartsEdit"))) {
            Component editorComponent = this.getEditorComponent();
            if (editorComponent == null) {
                if (e == null || e.getID() != 400) {
                    return false;
                }
                if (Character.isISOControl(e.getKeyChar())) {
                    return false;
                }
                int anchorRow = this.currentRow;
                int anchorColumn = this.currentColumn;
                if (anchorRow != -1 && anchorColumn != -1 && !this.isEditing() && !this.editCellAt(anchorRow, anchorColumn)) {
                    return false;
                }
                editorComponent = this.getEditorComponent();
                if (editorComponent == null) {
                    return false;
                }
            }
            if (editorComponent instanceof JComponent) {
                if (editorComponent instanceof DatePicker) {
                    DatePicker dp = (DatePicker)editorComponent;
                    editorComponent = dp.getEditor();
                } else if (editorComponent instanceof TextEditor) {
                    editorComponent = ((TextEditor)editorComponent).getTextComponent();
                }
                if (editorComponent instanceof JComboBox && ((JComboBox)editorComponent).isEditable() && ((JComboBox)editorComponent).getEditor().getEditorComponent() instanceof JComponent) {
                    editorComponent = ((JComboBox)editorComponent).getEditor().getEditorComponent();
                }
                map = ((JComponent)editorComponent).getInputMap(0);
                am = ((JComponent)editorComponent).getActionMap();
                if (map != null && am != null && ((JComponent)editorComponent).isEnabled()) {
                    Action action;
                    Object binding = map.get(ks);
                    Action action3 = action = binding == null ? null : am.get(binding);
                    if (action != null) {
                        retValue = SwingUtilities.notifyAction(action, ks, e, editorComponent, e.getModifiers());
                    }
                }
                if (this.getSurrendersFocusOnKeystroke()) {
                    editorComponent.requestFocus();
                }
            }
        }
        return retValue;
    }

    public Class getUnformattedColumnClass(int column) {
        if (this.getModel() instanceof FormattedInterface) {
            return ((FormattedInterface)this.getModel()).getUnformattedColumnClass(this.convertColumnIndexToModel(column));
        }
        return this.getColumnClass(column);
    }

    private void setLazyValue(Hashtable h, Class c, String s) {
        h.put(c, new UIDefaults.ProxyLazyValue(s));
    }

    private void setLazyRenderer(Class c, String s) {
        this.setLazyValue(this.defaultRenderersByColumnClass, c, s);
    }

    @Override
    protected void createDefaultRenderers() {
        if (this.defaultRenderersByColumnClass == null) {
            this.defaultRenderersByColumnClass = new UIDefaults();
            this.defaultRenderersByColumnClass.put("ClassLoader", this.getClass().getClassLoader());
            this.setLazyRenderer(Object.class, "com.sas.swing.visuals.tableview.DefaultTableCellRenderer");
            this.setLazyRenderer(Number.class, "com.sas.swing.visuals.tableview.NumberRenderer");
            this.setLazyRenderer(Float.class, "com.sas.swing.visuals.tableview.DoubleRenderer");
            this.setLazyRenderer(Double.class, "com.sas.swing.visuals.tableview.DoubleRenderer");
            this.setLazyRenderer(Date.class, "com.sas.swing.visuals.tableview.DateRenderer");
            this.setLazyRenderer(Icon.class, "com.sas.swing.visuals.tableview.IconRenderer");
            this.setLazyRenderer(ImageIcon.class, "com.sas.swing.visuals.tableview.IconRenderer");
            this.setLazyRenderer(Boolean.class, "com.sas.swing.visuals.tableview.BooleanRenderer");
        }
    }

    private void setLazyEditor(Class c, String s) {
        this.setLazyValue(this.defaultEditorsByColumnClass, c, s);
    }

    @Override
    protected void createDefaultEditors() {
        this.defaultEditorsByColumnClass = new UIDefaults();
        this.defaultEditorsByColumnClass.put("ClassLoader", this.getClass().getClassLoader());
        this.setLazyEditor(Object.class, "com.sas.swing.visuals.tableview.DefaultTableCellEditor");
        this.setLazyEditor(Number.class, "com.sas.swing.visuals.tableview.NumberEditor");
        this.setLazyEditor(Boolean.class, "com.sas.swing.visuals.tableview.BooleanEditor");
    }

    public void setCellRenderer(int row, int column, TableCellRenderer renderer) {
        if (row == -1 && column == -1) {
            this.setCellRenderer(1, -1, 1, 1, -1, 1, renderer);
        } else if (row == -1) {
            this.setCellRenderer(1, -1, 1, column, column, 1, renderer);
        } else if (column == -1) {
            this.setCellRenderer(row, row, 1, 1, -1, 1, renderer);
        } else {
            this.setCellRenderer(row, row, 1, column, column, 1, renderer);
        }
    }

    public void setCellRenderer(int startRow, int endRow, int repeatRowFactor, int startColumn, int endColumn, int repeatColumnFactor, TableCellRenderer renderer) {
        if (this.cellRenderers == null) {
            this.cellRenderers = new LinkedHashMap();
        }
        TableViewUtil.setValuesOnMap(this.cellRenderers, startRow, endRow, repeatRowFactor, startColumn, endColumn, repeatColumnFactor, renderer);
        this.repaint();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Object rend = (TableCellRenderer)TableViewUtil.checkForLastRowFromMap(this.cellRenderers, row == -369 ? row : this.convertRowIndexToModel(row) + 1, this.convertColumnIndexToModel(column) + 1, this.getModel());
        if (rend == null) {
            rend = TableViewUtil.getValueFromMap(this.cellRenderers, row == -369 ? row : this.convertRowIndexToModel(row) + 1, this.convertColumnIndexToModel(column) + 1);
        }
        if (rend != null) {
            return rend;
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null) {
            renderer = this.getDefaultRenderer(this.getUnformattedColumnClass(column));
        }
        return renderer;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Object value = this.getValueAt(row, column);
        boolean isCellSelected = this.isCellSelected(row, column);
        boolean rowIsAnchor = this.currentRow == row;
        boolean colIsAnchor = this.currentColumn == column;
        boolean hasFocus = rowIsAnchor && colIsAnchor && this.isFocusOwner();
        Component cmp = renderer.getTableCellRendererComponent(this, value, isCellSelected, hasFocus, row, column);
        if (hasFocus) {
            if (renderer instanceof DefaultTableCellRenderer) {
                this.getAccessibleContext().setAccessibleDescription(((DefaultTableCellRenderer)renderer).getText());
            } else if (value != null) {
                this.getAccessibleContext().setAccessibleDescription(String.valueOf(value));
            }
        }
        return cmp;
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        JComponent jComp;
        boolean isSelected;
        Object value = this.getUnformattedValueAt(row, column);
        Component comp = editor.getTableCellEditorComponent(this, value, isSelected = this.isCellSelected(row, column), row, column);
        if (comp instanceof JComponent && (jComp = (JComponent)comp).getNextFocusableComponent() == null) {
            jComp.setNextFocusableComponent(this);
        }
        return comp;
    }

    public void setCellEditor(int row, int column, TableCellEditor editor) {
        if (row == -1 && column == -1) {
            this.setCellEditor(1, -1, 1, 1, -1, 1, editor);
        } else if (row == -1) {
            this.setCellEditor(1, -1, 1, column, column, 1, editor);
        } else if (column == -1) {
            this.setCellEditor(row, row, 1, 1, -1, 1, editor);
        } else {
            this.setCellEditor(row, row, 1, column, column, 1, editor);
        }
    }

    public void setCellEditor(int startRow, int endRow, int repeatRowFactor, int startColumn, int endColumn, int repeatColumnFactor, TableCellEditor editor) {
        if (this.cellEditors == null) {
            this.cellEditors = new LinkedHashMap();
        }
        TableViewUtil.setValuesOnMap(this.cellEditors, startRow, endRow, repeatRowFactor, startColumn, endColumn, repeatColumnFactor, editor);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        Object ed = (TableCellRenderer)TableViewUtil.checkForLastRowFromMap(this.cellEditors, row == -369 ? row : this.convertRowIndexToModel(row) + 1, this.convertColumnIndexToModel(column) + 1, this.getModel());
        if (ed == null) {
            ed = TableViewUtil.getValueFromMap(this.cellEditors, row == -369 ? row : this.convertRowIndexToModel(row) + 1, this.convertColumnIndexToModel(column) + 1);
        }
        if (ed != null) {
            return (TableCellEditor)ed;
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellEditor editor = tableColumn.getCellEditor();
        if (editor == null) {
            editor = this.getDefaultEditor(this.getUnformattedColumnClass(column));
        }
        return editor;
    }

    @Override
    public GenericErrorHandlerInterface getGenericErrorHandler() {
        return this.genericErrorHandler;
    }

    @Override
    public void setGenericErrorHandler(GenericErrorHandlerInterface errorHandler) {
        if (this.genericErrorHandler != errorHandler) {
            GenericErrorHandlerInterface old = this.genericErrorHandler;
            this.genericErrorHandler = errorHandler;
            this.firePropertyChange("genericErrorHandler", old, this.genericErrorHandler);
        }
    }

    @Override
    public void updateUI() {
        if (!UIManager.getDefaults().containsKey(uiClassID)) {
            UIManager.put(uiClassID, "com.sas.swing.visuals.tableview.BasicTableViewUI");
        }
        super.updateUI();
        this.setUI((TableUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected TableRowModel createDefaultRowModel() {
        return new DefaultTableRowModel(this);
    }

    protected RowHeader createDefaultRowHeader() {
        return new RowHeader(this.getRowModel());
    }

    protected JComponent createDefaultOriginComponent() {
        return new OriginComponent(this);
    }

    public void setRowHeader(RowHeader newHeader) {
        if (this.rowHeader != newHeader) {
            RowHeader old = this.rowHeader;
            if (old != null) {
                old.setTable(null);
            }
            this.rowHeader = newHeader;
            if (this.rowHeader != null) {
                this.rowHeader.setTable(this);
            }
            this.firePropertyChange("rowHeader", old, this.rowHeader);
        }
    }

    public RowHeader getRowHeader() {
        return this.rowHeader;
    }

    public void setColumnHeader(ColumnHeader columnHeader) {
        ColumnHeader oldValue = this.getColumnHeader();
        if (oldValue != columnHeader) {
            this.setTableHeader(columnHeader);
            this.firePropertyChange("columnHeader", oldValue, columnHeader);
        }
    }

    public ColumnHeader getColumnHeader() {
        if (this.getTableHeader() instanceof ColumnHeader) {
            return (ColumnHeader)this.getTableHeader();
        }
        return null;
    }

    public void setOriginComponent(JComponent newOriginComponent) {
        if (this.originComponent != newOriginComponent) {
            JScrollPane scrollPane;
            JComponent oldOrigin = this.originComponent;
            if (oldOrigin != null) {
                oldOrigin.putClientProperty("table", null);
            }
            this.originComponent = newOriginComponent;
            if (this.originComponent != null) {
                this.originComponent.putClientProperty("table", this);
            }
            if ((scrollPane = this.getScrollPane()) != null) {
                scrollPane.setCorner("UPPER_LEFT_CORNER", this.getOriginComponent());
            }
            this.firePropertyChange("originComponent", oldOrigin, newOriginComponent);
        }
    }

    public JComponent getOriginComponent() {
        return this.originComponent;
    }

    private SizeSequence getRowHeightModel() {
        if (this.rowHeightModel == null) {
            this.rowHeightModel = new SizeSequence(this.getRowCount(), this.getRowHeight());
        }
        return this.rowHeightModel;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        if (rowHeight <= 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidRowHeight.ex.txt"));
        }
        int old = this.rowHeight;
        if (old != rowHeight) {
            this.rowHeight = rowHeight;
            this.rowHeightModel = null;
            if (!this.sizingRows) {
                if (this.getRowHeader() != null) {
                    this.getRowHeader().resizeAndRepaint();
                }
                this.resizeAndRepaint();
            }
            this.firePropertyChange("rowHeight", old, rowHeight);
        }
    }

    @Override
    public void setRowHeight(int row, int rowHeight) {
        if (rowHeight <= 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidRowHeight.ex.txt"));
        }
        this.getRowHeightModel().setSize(row, rowHeight);
        if (!this.sizingRows) {
            this.resizeAndRepaint();
            if (this.getRowHeader() != null) {
                this.getRowHeader().resizeAndRepaint();
            }
        }
    }

    @Override
    public int getRowHeight(int row) {
        return this.rowHeightModel == null ? this.getRowHeight() : this.rowHeightModel.getSize(row);
    }

    public void setRowModel(TableRowModel rowModel) {
        if (rowModel == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidRowModel.ex.txt"));
        }
        TableRowModel old = this.rowModel;
        if (rowModel != old) {
            if (old != null) {
                old.removeRowModelListener(this);
            }
            this.rowModel = rowModel;
            rowModel.addRowModelListener(this);
            if (this.rowHeader != null) {
                this.rowHeader.setRowModel(rowModel);
            }
            this.firePropertyChange("rowModel", old, rowModel);
            this.resizeAndRepaint();
        }
    }

    public TableRowModel getRowModel() {
        return this.rowModel;
    }

    public void hideColumn(int columnModelIndex) {
        this.clearSelection();
        TableColumnModel tableColumnModel = this.getColumnModel();
        int size = tableColumnModel.getColumnCount();
        for (int i = 0; i < size; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (tableColumn.getModelIndex() != columnModelIndex) continue;
            tableColumnModel.removeColumn(tableColumn);
            this.getHiddenColumns().add(tableColumn);
            break;
        }
    }

    public void showColumn(int columnModelIndex) {
        this.clearSelection();
        TableColumnModel tableColumnModel = this.getColumnModel();
        int size = this.getHiddenColumns().size();
        for (int i = 0; i < size; ++i) {
            TableColumn tableColumn = (TableColumn)this.hiddenColumns.get(i);
            if (tableColumn.getModelIndex() != columnModelIndex) continue;
            this.hiddenColumns.remove(tableColumn);
            tableColumnModel.addColumn(tableColumn);
            int colCount = tableColumnModel.getColumnCount();
            int dest = -1;
            int heldLeadingSize = 0;
            if (this.getTableHeader() != null) {
                heldLeadingSize = ((HoldInterface)((Object)this.getTableHeader())).getHeldIndices(10).size();
            }
            int heldTrailingSize = 0;
            if (this.getTableHeader() != null) {
                heldTrailingSize = ((HoldInterface)((Object)this.getTableHeader())).getHeldIndices(11).size();
            }
            for (int j = heldLeadingSize; j < colCount - heldTrailingSize; ++j) {
                int index = tableColumnModel.getColumn(j).getModelIndex();
                if (index <= columnModelIndex) continue;
                dest = j;
                break;
            }
            if (dest == -1) {
                dest = colCount - 1 - heldTrailingSize;
            }
            tableColumnModel.moveColumn(colCount - 1, dest);
            break;
        }
    }

    public void showAllColumns() {
        this.clearSelection();
        TableColumnModel tableColumnModel = this.getColumnModel();
        int heldLeadingSize = 0;
        if (this.getTableHeader() != null) {
            heldLeadingSize = ((HoldInterface)((Object)this.getTableHeader())).getHeldIndices(10).size();
        }
        int heldTrailingSize = 0;
        if (this.getTableHeader() != null) {
            heldTrailingSize = ((HoldInterface)((Object)this.getTableHeader())).getHeldIndices(11).size();
        }
        int size = this.getHiddenColumns().size();
        for (int i = 0; i < size; ++i) {
            TableColumn tableColumn = (TableColumn)this.hiddenColumns.get(i);
            tableColumnModel.addColumn(tableColumn);
            int colCount = tableColumnModel.getColumnCount();
            int dest = -1;
            int columnModelIndex = tableColumn.getModelIndex();
            for (int j = heldLeadingSize; j < colCount - heldTrailingSize; ++j) {
                int index = tableColumnModel.getColumn(j).getModelIndex();
                if (index <= columnModelIndex) continue;
                dest = j;
                break;
            }
            if (dest == -1) {
                dest = colCount - 1 - heldTrailingSize;
            }
            tableColumnModel.moveColumn(colCount - 1, dest);
        }
        this.hiddenColumns.clear();
    }

    public List getHiddenColumns() {
        if (this.hiddenColumns == null) {
            this.hiddenColumns = new ArrayList();
        }
        return this.hiddenColumns;
    }

    public void moveRow(int fromIndex, int toIndex) {
        this.getRowModel().moveRow(fromIndex, toIndex);
    }

    public boolean isColumnMoveAllowed(int columnIndex, int newIndex) {
        if (this.getTableHeader() != null && this.getTableHeader().getReorderingAllowed()) {
            int cc = this.getColumnCount();
            int leadingHeld = 0;
            int trailingHeld = 0;
            ColumnHeader ch = this.getColumnHeader();
            if (ch != null) {
                leadingHeld = this.getColumnHeader().getHeldIndices(10).size();
                trailingHeld = this.getColumnHeader().getHeldIndices(11).size();
                if (ch.isHeld(this.convertColumnIndexToModel(columnIndex))) {
                    return false;
                }
            }
            return columnIndex >= leadingHeld && columnIndex <= cc - 1 - trailingHeld && newIndex >= leadingHeld && newIndex <= cc - 1 - trailingHeld;
        }
        return false;
    }

    public void copy() {
        if (this.getClipboardAdapter() != null) {
            this.clipboardAdapter.copySelectedCells();
        }
    }

    public void paste() {
        if (this.getClipboardAdapter() != null) {
            this.clipboardAdapter.pasteSelectedCells();
        }
    }

    public void cut() {
        if (this.getClipboardAdapter() != null) {
            this.clipboardAdapter.cutSelectedCells();
        }
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.rowModel.getSelectionModel().setSelectionMode(selectionMode);
        super.setSelectionMode(selectionMode);
        this.repaint();
    }

    @Override
    public boolean getRowSelectionAllowed() {
        return this.rowModel.getRowSelectionAllowed();
    }

    @Override
    public void setRowSelectionAllowed(boolean rowSelectionAllowed) {
        if (rowSelectionAllowed != this.rowModel.getRowSelectionAllowed()) {
            boolean old = this.rowModel.getRowSelectionAllowed();
            this.rowSelectionAllowed = rowSelectionAllowed;
            this.rowModel.setRowSelectionAllowed(rowSelectionAllowed);
            if (!rowSelectionAllowed) {
                this.rowModel.getSelectionModel().clearSelection();
            }
            this.repaint();
            this.firePropertyChange("rowSelectionAllowed", old, rowSelectionAllowed);
        }
    }

    @Override
    public void setColumnSelectionAllowed(boolean columnSelectionAllowed) {
        if (columnSelectionAllowed != this.columnModel.getColumnSelectionAllowed()) {
            boolean old = this.columnModel.getColumnSelectionAllowed();
            this.columnModel.setColumnSelectionAllowed(columnSelectionAllowed);
            if (!columnSelectionAllowed) {
                this.columnModel.getSelectionModel().clearSelection();
            }
            this.repaint();
            this.firePropertyChange("columnSelectionAllowed", old, columnSelectionAllowed);
        }
    }

    @Override
    public void setCellSelectionEnabled(boolean cellSelectionEnabled) {
        if (cellSelectionEnabled != this.cellSelectionEnabled) {
            boolean old = this.cellSelectionEnabled;
            this.cellSelectionEnabled = cellSelectionEnabled;
            if (!this.cellSelectionEnabled) {
                this.getSelectionModel().clearSelection();
                this.repaint();
            }
            this.firePropertyChange("cellSelectionEnabled", old, cellSelectionEnabled);
        }
    }

    @Override
    public boolean getCellSelectionEnabled() {
        return this.cellSelectionEnabled;
    }

    @Override
    public void selectAll() {
        if (this.isEditing()) {
            this.removeEditor();
        }
        int colCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        if (rowCount > 0 && colCount > 0) {
            this.setRowSelectionInterval(0, rowCount - 1);
            this.setColumnSelectionInterval(0, colCount - 1);
            this.setCellSelectionInterval(0, 0, rowCount - 1, colCount - 1);
        }
    }

    @Override
    public void clearSelection() {
        super.clearSelection();
        if (this.rowModel != null) {
            this.rowModel.getSelectionModel().clearSelection();
        }
    }

    protected int boundRow(int row) throws IllegalArgumentException {
        if (row < 0 || row >= this.getRowCount()) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidRowIndex.ex.txt"));
        }
        return row;
    }

    protected int boundColumn(int col) {
        if (col < 0 || col >= this.getColumnCount()) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidColumnIndex.ex.txt"));
        }
        return col;
    }

    public void setCellSelectionInterval(int row0, int column0, int row1, int column1) {
        if (this.getCellSelectionEnabled()) {
            this.getSelectionModel().setSelectionInterval(this.createOrdinal(this.boundRow(row0), this.boundColumn(column0)), this.createOrdinal(this.boundRow(row1), this.boundColumn(column1)));
        }
    }

    @Override
    public void setRowSelectionInterval(int index0, int index1) {
        if (this.getRowSelectionAllowed()) {
            this.rowModel.getSelectionModel().setSelectionInterval(this.boundRow(index0), this.boundRow(index1));
        }
    }

    @Override
    public void setColumnSelectionInterval(int index0, int index1) {
        if (this.getColumnSelectionAllowed()) {
            super.setColumnSelectionInterval(index0, index1);
        }
    }

    public void addCellSelectionInterval(int row0, int column0, int row1, int column1) {
        if (this.getCellSelectionEnabled()) {
            this.getSelectionModel().addSelectionInterval(this.createOrdinal(this.boundRow(row0), this.boundColumn(column0)), this.createOrdinal(this.boundRow(row1), this.boundColumn(column1)));
        }
    }

    @Override
    public void addRowSelectionInterval(int index0, int index1) {
        if (this.getRowSelectionAllowed()) {
            this.rowModel.getSelectionModel().addSelectionInterval(this.boundRow(index0), this.boundRow(index1));
        }
    }

    @Override
    public void addColumnSelectionInterval(int index0, int index1) {
        if (this.getColumnSelectionAllowed()) {
            super.addColumnSelectionInterval(index0, index1);
        }
    }

    public void removeCellSelectionInterval(int row0, int column0, int row1, int column1) {
        if (this.getCellSelectionEnabled()) {
            this.getSelectionModel().removeSelectionInterval(this.createOrdinal(this.boundRow(row0), this.boundColumn(column0)), this.createOrdinal(this.boundRow(row1), this.boundColumn(column1)));
        }
    }

    @Override
    public void removeRowSelectionInterval(int index0, int index1) {
        if (this.getRowSelectionAllowed()) {
            this.rowModel.getSelectionModel().removeSelectionInterval(this.boundRow(index0), this.boundRow(index1));
        }
    }

    @Override
    public void removeColumnSelectionInterval(int index0, int index1) {
        if (this.getColumnSelectionAllowed()) {
            super.removeColumnSelectionInterval(index0, index1);
        }
    }

    @Override
    public int getSelectedRow() {
        if (this.getRowSelectionAllowed()) {
            return this.rowModel.getSelectionModel().getMinSelectionIndex();
        }
        return -1;
    }

    @Override
    public int getSelectedColumn() {
        if (this.getColumnSelectionAllowed()) {
            return super.getSelectedColumn();
        }
        return -1;
    }

    public int[][] getSelectedCells() {
        if (this.getCellSelectionEnabled()) {
            int iMin = this.getSelectionModel().getMinSelectionIndex();
            int iMax = this.getSelectionModel().getMaxSelectionIndex();
            if (iMin == -1 || iMax == -1) {
                return new int[0][2];
            }
            int[][] rvTmp = new int[1 + (iMax - iMin)][2];
            int n = 0;
            int columnCount = this.getColumnCount();
            for (int i = iMin; i <= iMax; ++i) {
                if (!this.getSelectionModel().isSelectedIndex(i)) continue;
                rvTmp[n][0] = i / columnCount;
                rvTmp[n++][1] = i % columnCount;
            }
            int[][] rv = new int[n][2];
            System.arraycopy(rvTmp, 0, rv, 0, n);
            return rv;
        }
        return new int[0][2];
    }

    public int[][] getSelectedCellsForRow(int row) {
        if (this.getCellSelectionEnabled()) {
            int iMin = this.getSelectionModel().getMinSelectionIndex();
            int iMax = this.getSelectionModel().getMaxSelectionIndex();
            if (iMin == -1 || iMax == -1) {
                return new int[0][2];
            }
            int n = 0;
            int columnCount = this.getColumnCount();
            int oMin = row * columnCount;
            int oMax = oMin + columnCount - 1;
            int[][] rvTmp = new int[1 + (oMax - oMin)][2];
            for (int i = oMin; i <= oMax; ++i) {
                if (!this.getSelectionModel().isSelectedIndex(i)) continue;
                rvTmp[n][0] = i / columnCount;
                rvTmp[n++][1] = i % columnCount;
            }
            int[][] rv = new int[n][2];
            System.arraycopy(rvTmp, 0, rv, 0, n);
            return rv;
        }
        return new int[0][2];
    }

    public int[][] getSelectedCellsForColumn(int column) {
        if (this.getCellSelectionEnabled()) {
            int iMin = this.getSelectionModel().getMinSelectionIndex();
            int iMax = this.getSelectionModel().getMaxSelectionIndex();
            if (iMin == -1 || iMax == -1) {
                return new int[0][2];
            }
            int n = 0;
            int columnCount = this.getColumnCount();
            int rowCount = this.getRowCount();
            int oMin = column;
            int oMax = column + (rowCount - 1) * columnCount;
            int[][] rvTmp = new int[1 + (oMax - oMin)][2];
            for (int i = oMin; i <= oMax; i += columnCount) {
                if (!this.getSelectionModel().isSelectedIndex(i)) continue;
                rvTmp[n][0] = i / columnCount;
                rvTmp[n++][1] = i % columnCount;
            }
            int[][] rv = new int[n][2];
            System.arraycopy(rvTmp, 0, rv, 0, n);
            return rv;
        }
        return new int[0][2];
    }

    @Override
    public int[] getSelectedRows() {
        if (this.getRowSelectionAllowed()) {
            return this.rowModel.getSelectedRows();
        }
        return new int[0];
    }

    @Override
    public int[] getSelectedColumns() {
        if (this.getColumnSelectionAllowed()) {
            return super.getSelectedColumns();
        }
        return new int[0];
    }

    public int getSelectedCellCount() {
        if (this.getCellSelectionEnabled() && !this.getSelectionModel().isSelectionEmpty()) {
            int iMin = this.getSelectionModel().getMinSelectionIndex();
            int iMax = this.getSelectionModel().getMaxSelectionIndex();
            int count = 0;
            for (int i = iMin; i <= iMax; ++i) {
                if (!this.getSelectionModel().isSelectedIndex(i)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    @Override
    public int getSelectedRowCount() {
        if (this.getRowSelectionAllowed()) {
            return this.rowModel.getSelectedRowCount();
        }
        return 0;
    }

    @Override
    public int getSelectedColumnCount() {
        if (this.getColumnSelectionAllowed()) {
            return super.getSelectedColumnCount();
        }
        return 0;
    }

    @Override
    public boolean isRowSelected(int row) {
        if (this.getRowSelectionAllowed()) {
            return this.rowModel.getSelectionModel().isSelectedIndex(row);
        }
        return false;
    }

    @Override
    public boolean isColumnSelected(int column) {
        if (this.getColumnSelectionAllowed()) {
            return super.isColumnSelected(column);
        }
        return false;
    }

    @Override
    public boolean isCellSelected(int row, int column) {
        if (!(this.getRowSelectionAllowed() || this.getColumnSelectionAllowed() || this.getCellSelectionEnabled())) {
            return false;
        }
        return this.getSelectionModel().isSelectedIndex(this.createOrdinal(row, column)) || this.isRowSelected(row) || this.isColumnSelected(column);
    }

    private void changeSelectionModel(ListSelectionModel sm, int index, boolean toggle, boolean extend, boolean selected) {
        if (extend) {
            sm.setLeadSelectionIndex(index);
        } else if (toggle) {
            if (selected) {
                sm.removeSelectionInterval(index, index);
            } else {
                sm.addSelectionInterval(index, index);
            }
        } else {
            sm.setSelectionInterval(index, index);
        }
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        Rectangle cellRect;
        JScrollPane pane = this.getScrollPane();
        if (pane != null) {
            pane.getViewport().repaint();
        }
        ListSelectionModel cellsm = this.getSelectionModel();
        ListSelectionModel rsm = this.getRowModel().getSelectionModel();
        ListSelectionModel csm = this.getColumnModel().getSelectionModel();
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        boolean selected = false;
        if (columnIndex >= 0 && rowIndex >= 0) {
            if (this.getCellSelectionEnabled()) {
                if (rowCount > 0 && colCount > 0) {
                    selected = this.isCellSelected(rowIndex, columnIndex);
                    if (!toggle) {
                        rsm.clearSelection();
                        csm.clearSelection();
                    }
                    this.changeSelectionModel(cellsm, columnIndex + rowIndex * colCount, toggle, extend, selected);
                }
            } else if (this.getRowSelectionAllowed() && rowCount > 0) {
                selected = this.isRowSelected(rowIndex);
                if (!toggle) {
                    csm.clearSelection();
                    cellsm.clearSelection();
                }
                this.changeSelectionModel(rsm, rowIndex, toggle, extend, selected);
            } else if (this.getColumnSelectionAllowed() && colCount > 0) {
                selected = this.isColumnSelected(columnIndex);
                if (!toggle) {
                    cellsm.clearSelection();
                    rsm.clearSelection();
                }
                this.changeSelectionModel(csm, columnIndex, toggle, extend, selected);
            }
        } else if (columnIndex >= 0 && rowIndex < 0 && this.getColumnSelectionAllowed() && colCount > 0) {
            int c = columnIndex;
            if (rowIndex < -1) {
                c = columnIndex + colCount * (Math.abs(rowIndex) - 1);
            }
            selected = this.isColumnSelected(c);
            if (!toggle) {
                cellsm.clearSelection();
                rsm.clearSelection();
            }
            this.changeSelectionModel(csm, c, toggle, extend, selected);
        } else if (rowIndex >= 0 && columnIndex < 0 && this.getRowSelectionAllowed() && rowCount > 0) {
            int r = rowIndex;
            if (columnIndex < -1) {
                r = rowIndex + rowCount * (Math.abs(columnIndex) - 1);
            }
            selected = this.isRowSelected(r);
            if (!toggle) {
                cellsm.clearSelection();
                csm.clearSelection();
            }
            this.changeSelectionModel(rsm, r, toggle, extend, selected);
        }
        if (!extend) {
            this.changeCurrentCell(rowIndex, columnIndex);
        }
        if (this.getAutoscrolls() && rowIndex < rowCount && columnIndex < colCount && (cellRect = this.getCellRect(rowIndex, columnIndex, true)) != null) {
            Rectangle vr = this.getVisibleRect().intersection(this.getCellAreaRect());
            int heldRowTopHeight = this.getTopHeldHeight();
            int heldRowBottomHeight = this.getBottomHeldHeight();
            int heldColumnLeftWidth = this.getLeadingHeldWidth();
            int heldColumnRightWidth = this.getTrailingHeldWidth();
            boolean rowHeld = false;
            if (this.getRowHeader() != null) {
                rowHeld = this.getRowHeader().isHeld(this.convertRowIndexToModel(rowIndex));
            }
            boolean columnHeld = false;
            if (this.getColumnHeader() != null) {
                columnHeld = this.getColumnHeader().isHeld(this.convertColumnIndexToModel(columnIndex));
            }
            if (!rowHeld && heldRowTopHeight > 0 && cellRect.y <= vr.y + heldRowTopHeight) {
                cellRect.y -= heldRowTopHeight;
            }
            if (!rowHeld && heldRowBottomHeight > 0 && cellRect.y + cellRect.height > vr.y + vr.height - heldRowBottomHeight) {
                cellRect.height += heldRowBottomHeight;
            }
            if (!columnHeld && heldColumnLeftWidth > 0 && cellRect.x <= vr.x + heldColumnLeftWidth) {
                cellRect.x -= heldColumnLeftWidth;
            }
            if (!columnHeld && heldColumnRightWidth > 0 && cellRect.x + cellRect.width > vr.x + vr.width - heldColumnRightWidth) {
                cellRect.width += heldColumnRightWidth;
            }
            if (!vr.contains(cellRect)) {
                Rectangle cellRect2;
                this.scrollRectToVisible(cellRect);
                if (this.rowAutoResizeMode == 6 && !cellRect.equals(cellRect2 = this.getCellRect(rowIndex, columnIndex, true))) {
                    this.scrollRectToVisible(cellRect2);
                }
            }
        }
    }

    private int getTopHeldHeight() {
        if (this.getRowHeader() != null) {
            return this.getRowHeader().getTopHeldHeight();
        }
        return 0;
    }

    private int getLeadingHeldWidth() {
        if (this.getColumnHeader() != null) {
            return this.getColumnHeader().getLeadingHeldWidth();
        }
        return 0;
    }

    private int getBottomHeldHeight() {
        if (this.getRowHeader() != null) {
            return this.getRowHeader().getBottomHeldHeight();
        }
        return 0;
    }

    private int getTrailingHeldWidth() {
        if (this.getColumnHeader() != null) {
            return this.getColumnHeader().getTrailingHeldWidth();
        }
        return 0;
    }

    public void setRowAutoResizeMode(int mode) {
        if (mode == 0 || mode == 6 || mode == 5) {
            this.rowAutoResizeModeInitialized = true;
            int old = this.rowAutoResizeMode;
            if (old != mode) {
                this.rowAutoResizeMode = mode;
                this.resizeAndRepaint();
                if (this.rowHeader != null) {
                    this.rowHeader.resizeAndRepaint();
                }
                this.firePropertyChange("rowAutoResizeMode", old, this.rowAutoResizeMode);
            }
        }
    }

    public int getRowAutoResizeMode() {
        return this.rowAutoResizeMode;
    }

    public void setColumnAutoResizeMode(int mode) {
        if (mode == 0 || mode == 4) {
            this.columnAutoResizeModeInitialized = true;
            int old = this.columnAutoResizeMode;
            if (old != mode) {
                this.columnAutoResizeMode = mode;
                this.columnsSized = false;
                this.sizeColumnsIfNeeded();
                this.doLayout();
                this.firePropertyChange("columnAutoResizeMode", old, this.columnAutoResizeMode);
            }
        }
    }

    public int getColumnAutoResizeMode() {
        return this.columnAutoResizeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        try {
            int i;
            this.ignoreResizeEvents = true;
            int colCount = this.getColumnCount();
            int[] colSizes = new int[colCount];
            if (this.getAutoResizeMode() == 0) {
                for (i = 0; i < colCount; ++i) {
                    colSizes[i] = this.getColumnModel().getColumn(i).getPreferredWidth();
                }
            }
            super.doLayout();
            if (this.getAutoResizeMode() == 0) {
                for (i = 0; i < colCount; ++i) {
                    this.getColumnModel().getColumn(i).setPreferredWidth(colSizes[i]);
                    this.getColumnModel().getColumn(i).setWidth(colSizes[i]);
                }
            }
        }
        finally {
            this.ignoreResizeEvents = false;
        }
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        int colCount = this.getColumnCount();
        if (this.getRowCount() <= 0 || colCount <= 0) {
            return;
        }
        int oldCurrentColumn = this.currentColumn;
        if (e.getSource().equals(this.getColumnModel().getSelectionModel()) && this.getColumnModel().getSelectionModel().isSelectedIndex(this.getColumnModel().getSelectionModel().getAnchorSelectionIndex())) {
            this.setCurrentColumn(this.getColumnModel().getSelectionModel().getAnchorSelectionIndex());
        }
        int firstIndex = this.limit(e.getFirstIndex(), 0, colCount - 1);
        int lastIndex = this.limit(e.getLastIndex(), 0, colCount - 1);
        Rectangle firstColumnRect = this.getCellRect(0, firstIndex, false);
        Rectangle lastColumnRect = this.getCellRect(this.getRowCount() - 1, lastIndex, false);
        Rectangle dirtyRegion = firstColumnRect.union(lastColumnRect);
        if (oldCurrentColumn < firstIndex || oldCurrentColumn > lastIndex) {
            Rectangle oldCurrentRect = this.getCellRect(0, oldCurrentColumn, false);
            dirtyRegion = oldCurrentRect.union(dirtyRegion);
        }
        this.repaint(dirtyRegion);
        dirtyRegion.y = 0;
        if (this.getTableHeader() != null) {
            dirtyRegion.height = this.getTableHeader().getSize().height;
            this.getTableHeader().repaint(dirtyRegion);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int columnCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        if (rowCount <= 0 || columnCount <= 0) {
            return;
        }
        int firstIndex = e.getFirstIndex();
        int lastIndex = e.getLastIndex();
        if (e.getSource().equals(this.getSelectionModel())) {
            firstIndex = this.limit(firstIndex / columnCount, 0, rowCount - 1);
            lastIndex = this.limit(lastIndex / columnCount, 0, rowCount - 1);
        } else {
            firstIndex = this.limit(firstIndex, 0, rowCount - 1);
            lastIndex = this.limit(lastIndex, 0, rowCount - 1);
        }
        int oldCurrentRow = this.currentRow;
        Object source = e.getSource();
        if (source.equals(this.getSelectionModel())) {
            int colCount = this.getColumnCount();
            int row = this.getSelectionModel().getAnchorSelectionIndex() / colCount;
            int col = this.getSelectionModel().getAnchorSelectionIndex() % colCount;
            if (this.getSelectionModel().isSelectedIndex(this.createOrdinal(row, col))) {
                this.setCurrentRow(row);
                this.setCurrentColumn(col);
            }
        } else if (source.equals(this.getRowModel().getSelectionModel())) {
            if (this.getRowModel().getSelectionModel().isSelectedIndex(this.getRowModel().getSelectionModel().getAnchorSelectionIndex())) {
                this.setCurrentRow(this.getRowModel().getSelectionModel().getAnchorSelectionIndex());
            }
        } else if (source.equals(this.getColumnModel().getSelectionModel()) && this.getColumnModel().getSelectionModel().isSelectedIndex(this.getColumnModel().getSelectionModel().getAnchorSelectionIndex())) {
            this.setCurrentColumn(this.getColumnModel().getSelectionModel().getAnchorSelectionIndex());
        }
        Rectangle firstRowRect = this.getCellRect(firstIndex, 0, false);
        Rectangle lastRowRect = this.getCellRect(lastIndex, columnCount - 1, false);
        Rectangle dirtyRegion = firstRowRect.union(lastRowRect);
        if (oldCurrentRow < firstIndex || oldCurrentRow > lastIndex) {
            Rectangle oldCurrentRect = this.getCellRect(oldCurrentRow, 0, false);
            dirtyRegion = oldCurrentRect.union(dirtyRegion);
        }
        this.repaint(dirtyRegion);
        dirtyRegion.x = 0;
        dirtyRegion.width = this.getRowHeader().getSize().width;
        this.getRowHeader().repaint(dirtyRegion);
    }

    protected void repaintCurrentCell() {
        if (this.currentRow >= 0 && this.currentColumn >= 0) {
            this.repaint(this.getCellRect(this.currentRow, this.currentColumn, false));
        } else if (this.currentRow < 0 && this.currentColumn >= 0) {
            if (this.getColumnHeader() != null) {
                this.getColumnHeader().repaint(this.getColumnHeader().getHeaderRect(this.currentColumn));
            }
        } else if (this.currentRow >= 0 && this.currentColumn < 0) {
            if (this.getRowHeader() != null) {
                this.getRowHeader().repaint(this.getRowHeader().getHeaderRect(this.currentRow));
            }
        } else if (this.getOriginComponent() != null) {
            this.getOriginComponent().repaint();
        }
    }

    protected void repaintCells(int oldRow, int newRow, int oldColumn, int newColumn) {
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        oldRow = Math.min(oldRow, rowCount - 1);
        oldColumn = Math.min(oldColumn, colCount - 1);
        if (oldRow >= 0 && oldColumn >= 0) {
            Rectangle oldRect = this.getCellRect(oldRow, oldColumn, false);
            if (newRow >= 0 && newColumn >= 0) {
                Rectangle newRect = this.getCellRect(newRow, newColumn, false);
                Rectangle dirtyRegion = oldRect.union(newRect);
                this.repaint(dirtyRegion);
            } else {
                this.repaint(oldRect);
                this.repaintCurrentCell();
            }
        } else if (oldRow < 0 && oldColumn >= 0) {
            if (this.getColumnHeader() != null) {
                Rectangle oldRect = this.getColumnHeader().getHeaderRect(oldColumn);
                if (newRow < 0 && newColumn >= 0) {
                    Rectangle newRect = this.getColumnHeader().getHeaderRect(newColumn);
                    Rectangle dirtyRegion = oldRect.union(newRect);
                    this.getColumnHeader().repaint(dirtyRegion);
                } else {
                    this.getColumnHeader().repaint(oldRect);
                    this.repaintCurrentCell();
                }
            }
        } else if (oldRow >= 0 && oldColumn < 0) {
            if (this.getRowHeader() != null) {
                Rectangle oldRect = this.getRowHeader().getHeaderRect(oldRow);
                if (newRow >= 0 && newColumn < 0) {
                    Rectangle newRect = this.getRowHeader().getHeaderRect(newRow);
                    Rectangle dirtyRegion = oldRect.union(newRect);
                    this.getRowHeader().repaint(dirtyRegion);
                } else {
                    this.getRowHeader().repaint(oldRect);
                    this.repaintCurrentCell();
                }
            }
        } else {
            if (this.getOriginComponent() != null) {
                this.getOriginComponent().repaint();
            }
            if (newRow >= 0 || newColumn >= 0) {
                this.repaintCurrentCell();
            }
        }
    }

    protected void validateCurrentCell() {
        int rowCount = this.getRowCount();
        if (this.getCurrentRow() >= rowCount) {
            this.setCurrentRow(rowCount - 1);
        }
        int colCount = this.getColumnCount();
        if (this.getCurrentColumn() >= colCount) {
            this.setCurrentColumn(colCount - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeCurrentCell(int row, int column) {
        if (row != this.currentRow || column != this.currentColumn) {
            try {
                this.changingCurrentCell = true;
                int oldRow = this.currentRow;
                int oldColumn = this.currentColumn;
                this.currentColumn = column;
                this.setCurrentRow(row);
                this.currentColumn = oldColumn;
                this.setCurrentColumn(column);
                this.validateCurrentCell();
                this.repaintCells(oldRow, this.currentRow, oldColumn, this.currentColumn);
            }
            finally {
                this.changingCurrentCell = false;
            }
        }
    }

    public int[] getCurrentCell() {
        int[] cell = new int[]{this.currentRow, this.currentColumn};
        return cell;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(int newRow) {
        if (this.currentRow != newRow) {
            InsertRowInterface insertModel;
            int old = this.currentRow;
            this.currentRow = newRow;
            this.firePropertyChange("currentRow", old, this.currentRow);
            if (!this.changingCurrentCell) {
                this.validateCurrentCell();
                this.repaintCells(old, this.currentRow, this.currentColumn, this.currentColumn);
            }
            if (this.getModel() instanceof InsertRowInterface && (insertModel = (InsertRowInterface)this.getModel()).isUncommittedRowPresent() && this.convertRowIndexToView(insertModel.getUncommittedRowNumber()) != this.currentRow) {
                this.commitUncommittedRow(insertModel);
            }
        }
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public void setCurrentColumn(int newColumn) {
        if (this.currentColumn != newColumn) {
            int old = this.currentColumn;
            this.currentColumn = newColumn;
            this.firePropertyChange("currentColumn", old, newColumn);
            if (!this.changingCurrentCell) {
                this.validateCurrentCell();
                this.repaintCells(this.currentRow, this.currentRow, old, this.currentColumn);
            }
        }
    }

    private int limit(int i, int a, int b) {
        return Math.min(b, Math.max(i, a));
    }

    private void commitUncommittedRow(InsertRowInterface insertModel) {
        try {
            insertModel.commitUncommittedRow();
        }
        catch (Exception ex) {
            if (this.getGenericErrorHandler() != null) {
                if (this.getGenericErrorHandler() instanceof Frame) {
                    ((Frame)((Object)this.getGenericErrorHandler())).setTitle(RB.getStringResource(RB_KEY, "errorCommittingRow.txt"));
                } else if (this.getGenericErrorHandler() instanceof JOptionPaneErrorHandler) {
                    ((JOptionPaneErrorHandler)this.getGenericErrorHandler()).setTitle(RB.getStringResource(RB_KEY, "errorCommittingRow.txt"));
                }
                Message message = ex.getMessage() == null ? new Message("") : new Message(ex.getMessage());
                this.getGenericErrorHandler().handleError(this.getScrollPane(), message, "COMMIT_ROW_ERROR");
            }
            ex.printStackTrace();
        }
    }

    public int getCellAreaHeight() {
        int rowCount = this.getRowCount();
        if (rowCount > 0 && this.getColumnCount() > 0) {
            Rectangle r = this.getCellRect(rowCount - 1, 0, true);
            return r.y + r.height;
        }
        return -1;
    }

    public int getCellAreaWidth() {
        return this.getColumnModel().getTotalColumnWidth();
    }

    public Rectangle getCellAreaRect() {
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        if (rowCount > 0 && colCount > 0) {
            Rectangle r = this.getCellRect(rowCount - 1, colCount - 1, true, false);
            r.height = r.y + r.height;
            r.width = r.x + r.width;
            r.x = 0;
            r.y = 0;
            return r;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public void setPopupMenuEnabled(boolean enablePopupMenu) {
        if (this.popupMenuEnabled != enablePopupMenu) {
            this.popupMenuEnabled = enablePopupMenu;
            this.firePropertyChange("popupMenuEnabled", this.popupMenuEnabled ? Boolean.FALSE : Boolean.TRUE, this.popupMenuEnabled ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isPopupMenuEnabled() {
        return this.popupMenuEnabled;
    }

    public JPopupMenu createPopupMenu() {
        return new JPopupMenu();
    }

    public void showPopup(int row, int column) {
        Point point = null;
        if (row < 0 && column < 0) {
            Dimension dim = this.getOriginComponent().getSize();
            point = new Point(-dim.height, -dim.width);
        } else if (row < 0) {
            Rectangle rect = this.getColumnHeader().getHeaderRect(column);
            Rectangle visRect = this.getVisibleRect();
            int x = rect.x + rect.width;
            if (x < visRect.x) {
                x = visRect.x;
            }
            if (x > visRect.x + visRect.width) {
                x = visRect.x + visRect.width;
            }
            point = new Point(x, -(this.getColumnHeader().getHeight() - (rect.y + rect.height)));
        } else if (column < 0) {
            Rectangle rect = this.getRowHeader().getHeaderRect(row);
            Rectangle visRect = this.getVisibleRect();
            int y = rect.y + rect.height;
            if (y < visRect.y) {
                y = visRect.y;
            }
            if (y > visRect.y + visRect.height) {
                y = visRect.y + visRect.height;
            }
            point = new Point(-(this.getRowHeader().getWidth() - (rect.x + rect.width)), y);
        } else {
            Rectangle rect = this.getCellRect(row, column, true);
            point = new Point(rect.x + rect.width, rect.y + rect.height);
        }
        this.showPopup(row, column, point);
    }

    public void showPopup(Point point) {
        int row = -1;
        int column = -1;
        if (point.y > this.getCellAreaHeight() || point.x > this.getCellAreaWidth()) {
            row = point.y > 0 ? Integer.MAX_VALUE : -1;
            column = point.x > 0 ? Integer.MAX_VALUE : -1;
        } else {
            row = this.rowAtPoint(point);
            column = this.columnAtPoint(point);
        }
        this.showPopup(row, column, point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showPopup(int row, int column, Point point) {
        if (!this.isPopupMenuEnabled()) {
            return;
        }
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.popupMenu.removeAll();
        try {
            Util.apply(this.getScrollPane(), this.changeCursorCommand);
            this.populatePopupMenu(this.popupMenu, row, column);
            int subElementCount = this.popupMenu.getSubElements().length;
            if (subElementCount != 0) {
                JComponent comp = null;
                if (row >= 0 && column >= 0) {
                    comp = this;
                } else if (row < 0 && column >= 0) {
                    comp = this.getTableHeader();
                    point.y += this.getTableHeader().getHeight();
                } else if (row >= 0 && column < 0) {
                    comp = this.getRowHeader();
                    point.x += this.getRowHeader().getWidth();
                } else {
                    comp = this.getOriginComponent();
                    Dimension dim = this.getOriginComponent().getSize();
                    point.y += dim.height;
                    point.x += dim.width;
                }
                Dimension menuSize = Util.computePopupMenuSize(this.popupMenu, comp);
                final Point popupLoc = Util.computePopupMenuLocation(point.x, point.y, menuSize.width, menuSize.height, comp);
                final JComponent invoker = comp;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TableView.this.popupMenu.show(invoker, popupLoc.x, popupLoc.y);
                    }
                });
            }
        }
        finally {
            this.changeCursorCommand.undoAll();
        }
    }

    public void populatePopupMenu(JPopupMenu popup, int row, int column) {
        ActionSupportFilter filter = null;
        if (row < 0 && column < 0) {
            filter = this.configureTitleActionFilter(row, column);
        } else if (row < 0 && column >= 0) {
            filter = this.configureColumnHeaderActionFilter(row, column);
        } else if (row >= 0 && column < 0) {
            filter = this.configureRowHeaderActionFilter(row, column);
        } else if (row >= 0 && column >= 0) {
            filter = this.configureDataCellActionFilter(row, column);
        }
        ActionList actions = this.getActionProvider().getActions(filter);
        this.factory.populatePopupMenu(popup, actions);
    }

    protected ActionSupportFilter configureRowHeaderActionFilter(int row, int column) {
        int modelRowIndex = Integer.MAX_VALUE;
        int modelColumnIndex = Integer.MAX_VALUE;
        if (row != Integer.MAX_VALUE) {
            modelRowIndex = this.convertRowIndexToModel(row);
        }
        if (column != Integer.MAX_VALUE) {
            modelColumnIndex = this.convertColumnIndexToModel(column);
        }
        try {
            this.rowHeaderFilter.setAttribute("table", this);
            this.rowHeaderFilter.setAttribute("modelColumn", new Integer(modelColumnIndex));
            this.rowHeaderFilter.setAttribute("modelRow", new Integer(modelRowIndex));
            this.rowHeaderFilter.setAttribute("column", new Integer(column));
            this.rowHeaderFilter.setAttribute("row", new Integer(row));
            this.rowHeaderFilter.setAttribute("model", this.getModel());
            this.rowHeaderFilter.setAttribute("heldRows", this.getRowHeader());
            this.rowHeaderFilter.setHiddenActionsMap(this.viewerSupport.getHiddenActionsMap());
        }
        catch (AttributeSetException ase) {
            ase.printStackTrace();
        }
        return this.rowHeaderFilter;
    }

    protected ActionSupportFilter configureColumnHeaderActionFilter(int row, int column) {
        int modelRowIndex = Integer.MAX_VALUE;
        int modelColumnIndex = Integer.MAX_VALUE;
        if (row != Integer.MAX_VALUE) {
            modelRowIndex = this.convertRowIndexToModel(row);
        }
        if (column != Integer.MAX_VALUE) {
            modelColumnIndex = this.convertColumnIndexToModel(column);
        }
        try {
            Integer modelInt = new Integer(modelColumnIndex);
            Integer viewerInt = new Integer(column);
            this.columnHeaderFilter.setAttribute("table", this);
            this.columnHeaderFilter.setAttribute("modelColumn", modelInt);
            this.columnHeaderFilter.setAttribute("modelRow", new Integer(modelRowIndex));
            this.columnHeaderFilter.setAttribute("column", viewerInt);
            this.columnHeaderFilter.setAttribute("row", new Integer(row));
            this.columnHeaderFilter.setAttribute("model", this.getModel());
            this.columnHeaderFilter.setAttribute("heldColumns", (HoldInterface)((Object)this.getTableHeader()));
            this.columnHeaderFilter.setHiddenActionsMap(this.viewerSupport.getHiddenActionsMap());
            if (this.getModel() instanceof MoveColumnInterface) {
                this.columnHeaderFilter.setAttribute("moveColumnInterface", this.getModel());
                this.columnHeaderFilter.setAttribute("moveColumn", modelInt);
                int leftMoveAmount = Integer.MAX_VALUE;
                int rightMoveAmount = Integer.MAX_VALUE;
                if (column != Integer.MAX_VALUE) {
                    if (column > 0) {
                        int leftIndex = this.getColumnModel().getColumn(column - 1).getModelIndex();
                        if (this.getColumnHeader() != null && !this.getColumnHeader().isHeld(leftIndex)) {
                            leftMoveAmount = modelColumnIndex - leftIndex;
                        }
                    }
                    if (column < this.getColumnCount() - 1) {
                        int rightIndex = this.getColumnModel().getColumn(column + 1).getModelIndex();
                        if (this.getColumnHeader() != null && !this.getColumnHeader().isHeld(rightIndex)) {
                            rightMoveAmount = rightIndex - modelColumnIndex;
                        }
                    }
                }
                this.columnHeaderFilter.setAttribute("moveColumnLeftAmount", new Integer(leftMoveAmount));
                this.columnHeaderFilter.setAttribute("moveColumnRightAmount", new Integer(rightMoveAmount));
            } else {
                this.columnHeaderFilter.setAttribute("moveColumnInterface", this);
                this.columnHeaderFilter.setAttribute("moveColumn", viewerInt);
                this.columnHeaderFilter.setAttribute("moveColumnLeftAmount", new Integer(1));
                this.columnHeaderFilter.setAttribute("moveColumnRightAmount", new Integer(1));
            }
        }
        catch (AttributeSetException ase) {
            ase.printStackTrace();
        }
        return this.columnHeaderFilter;
    }

    protected ActionSupportFilter configureTitleActionFilter(int row, int column) {
        int modelRowIndex = Integer.MAX_VALUE;
        int modelColumnIndex = Integer.MAX_VALUE;
        if (row != Integer.MAX_VALUE) {
            modelRowIndex = this.convertRowIndexToModel(row);
        }
        if (column != Integer.MAX_VALUE) {
            modelColumnIndex = this.convertColumnIndexToModel(column);
        }
        try {
            this.titleFilter.setAttribute("table", this);
            this.titleFilter.setAttribute("modelColumn", new Integer(modelColumnIndex));
            this.titleFilter.setAttribute("modelRow", new Integer(modelRowIndex));
            this.titleFilter.setAttribute("column", new Integer(column));
            this.titleFilter.setAttribute("row", new Integer(row));
            this.titleFilter.setAttribute("model", this.getModel());
            this.titleFilter.setHiddenActionsMap(this.viewerSupport.getHiddenActionsMap());
        }
        catch (AttributeSetException ase) {
            ase.printStackTrace();
        }
        return this.titleFilter;
    }

    protected ActionSupportFilter configureDataCellActionFilter(int row, int column) {
        int modelRowIndex = Integer.MAX_VALUE;
        int modelColumnIndex = Integer.MAX_VALUE;
        if (row != Integer.MAX_VALUE) {
            modelRowIndex = this.convertRowIndexToModel(row);
        }
        if (column != Integer.MAX_VALUE) {
            modelColumnIndex = this.convertColumnIndexToModel(column);
        }
        try {
            Integer modelInt = new Integer(modelColumnIndex);
            Integer viewerInt = new Integer(column);
            this.dataCellFilter.setAttribute("table", this);
            this.dataCellFilter.setAttribute("modelColumn", modelInt);
            this.dataCellFilter.setAttribute("modelRow", new Integer(modelRowIndex));
            this.dataCellFilter.setAttribute("column", viewerInt);
            this.dataCellFilter.setAttribute("row", new Integer(row));
            this.dataCellFilter.setAttribute("model", this.getModel());
            this.dataCellFilter.setAttribute("heldColumns", (HoldInterface)((Object)this.getTableHeader()));
            this.dataCellFilter.setAttribute("heldRows", this.getRowHeader());
            this.dataCellFilter.setHiddenActionsMap(this.viewerSupport.getHiddenActionsMap());
            if (this.getModel() instanceof MoveColumnInterface) {
                this.dataCellFilter.setAttribute("moveColumnInterface", this.getModel());
                this.dataCellFilter.setAttribute("moveColumn", modelInt);
                int leftMoveAmount = Integer.MAX_VALUE;
                int rightMoveAmount = Integer.MAX_VALUE;
                if (column != Integer.MAX_VALUE) {
                    if (column > 0) {
                        int leftIndex = this.getColumnModel().getColumn(column - 1).getModelIndex();
                        if (this.getColumnHeader() != null && !this.getColumnHeader().isHeld(leftIndex)) {
                            leftMoveAmount = modelColumnIndex - leftIndex;
                        }
                    }
                    if (column < this.getColumnCount() - 1) {
                        int rightIndex = this.getColumnModel().getColumn(column + 1).getModelIndex();
                        if (this.getColumnHeader() != null && !this.getColumnHeader().isHeld(rightIndex)) {
                            rightMoveAmount = rightIndex - modelColumnIndex;
                        }
                    }
                }
                this.dataCellFilter.setAttribute("moveColumnLeftAmount", new Integer(leftMoveAmount));
                this.dataCellFilter.setAttribute("moveColumnRightAmount", new Integer(rightMoveAmount));
            } else {
                this.dataCellFilter.setAttribute("moveColumnInterface", this);
                this.dataCellFilter.setAttribute("moveColumn", viewerInt);
                this.dataCellFilter.setAttribute("moveColumnLeftAmount", new Integer(1));
                this.dataCellFilter.setAttribute("moveColumnRightAmount", new Integer(1));
            }
        }
        catch (AttributeSetException ase) {
            ase.printStackTrace();
        }
        return this.dataCellFilter;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void populateToolBar(JToolBar toolbar) {
        this.configureToolBarActionFilter();
        ActionList actions = this.getActionProvider().getActions(this.toolbarFilter);
        this.factory.populateToolBar(toolbar, actions);
    }

    protected ActionSupportFilter configureToolBarActionFilter() {
        ActionSupportFilter filter = this.toolbarFilter;
        try {
            filter.setAttribute("table", this);
            filter.setAttribute("model", this.getModel());
            filter.setAttribute("heldColumns", (HoldInterface)((Object)this.getTableHeader()));
            filter.setAttribute("heldRows", this.getRowHeader());
            filter.setHiddenActionsMap(this.viewerSupport.getHiddenActionsMap());
        }
        catch (AttributeSetException ase) {
            ase.printStackTrace();
        }
        return filter;
    }

    protected int createOrdinal(int row, int column) {
        if (row == -1 || column == -1) {
            return -1;
        }
        int colCount = this.getColumnCount();
        return column + row * colCount;
    }

    private void sizeRowsIfNeeded() {
        try {
            int last;
            this.sizingRows = true;
            Dimension dim = this.getSize();
            if (dim.width == 0 && dim.height == 0) {
                this.waitForSizing = true;
                return;
            }
            if (this.getRowAutoResizeMode() != 0 && (last = this.getRowHeader().sizeRowsToFit(true, false)) != -1) {
                this.getRowHeader().revalidate();
                this.revalidate();
            }
        }
        finally {
            this.sizingRows = false;
        }
    }

    private void sizeColumnsIfNeeded() {
        Dimension dim = this.getSize();
        if (dim.width == 0 && dim.height == 0) {
            return;
        }
        if (this.getColumnHeader() != null && this.getColumnAutoResizeMode() != 0 && this.tableInitialized && !this.columnsSized) {
            this.getColumnHeader().sizeColumnsToFit();
            this.columnsSized = true;
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (!this.columnsSized && width != 0 && height != 0) {
            this.sizeColumnsIfNeeded();
        }
        if (this.waitForSizing && width != 0 && height != 0) {
            this.sizeRowsIfNeeded();
            this.waitForSizing = false;
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        TableColumn resizingColumn;
        if (this.getTableHeader() != null && (resizingColumn = this.getTableHeader().getResizingColumn()) != null && this.autoResizeMode == 0) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    @Override
    protected void resizeAndRepaint() {
        JScrollPane pane = this.getScrollPane();
        if (pane != null) {
            pane.getViewport().repaint();
        }
        super.resizeAndRepaint();
    }

    private void updateList(List list, int oldValue, int newValue) {
        if (oldValue > newValue) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                int index = (Integer)list.get(i);
                if (index >= oldValue || index < newValue) continue;
                list.set(i, new Integer(index + 1));
            }
        } else {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                int index = (Integer)list.get(i);
                if (index <= oldValue || index > newValue) continue;
                list.set(i, new Integer(index - 1));
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        Rectangle dirtyRegion;
        if (e == null || e.getFirstRow() == -1) {
            this.lastSortDirections = null;
            this.lastSortedColumns = null;
            if (this.hiddenColumns != null) {
                this.hiddenColumns.clear();
            }
            this.rowHeightModel = null;
            if (this.getRowHeader() != null) {
                this.getRowHeader().releaseAll();
            }
            if (this.getColumnHeader() != null) {
                this.getColumnHeader().releaseAll();
            }
            if (this.getAutoCreateColumnsFromModel()) {
                this.createDefaultColumnsFromModel();
            }
            this.validateCurrentCell();
            this.resizeAndRepaint();
            if (this.tableHeader != null) {
                this.tableHeader.resizeAndRepaint();
            }
            this.columnsSized = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TableView.this.getColumnHeader() != null) {
                        TableView.this.sizeColumnsIfNeeded();
                    }
                    if (TableView.this.getRowHeader() != null) {
                        TableView.this.sizeRowsIfNeeded();
                    }
                    TableView.this.clearSelection();
                    TableView.this.resizeAndRepaint();
                }
            });
            if (this.getRowHeader() != null) {
                this.rowHeader.resizeAndRepaint();
            }
            return;
        }
        if (this.rowHeightModel != null) {
            this.repaint();
        }
        if (e instanceof SwingTableModelEvent) {
            SwingTableModelEvent stme = (SwingTableModelEvent)e;
            if (e.getType() == 44) {
                if (this.getAutoCreateColumnsFromModel()) {
                    ColumnHeader ch;
                    int index;
                    TableColumn column;
                    int i;
                    int newColumn;
                    int oldColumn = stme.getColumn();
                    if (oldColumn == (newColumn = stme.getNewColumn())) {
                        return;
                    }
                    TableColumnModel cm = this.getColumnModel();
                    int colCount = this.getColumnCount();
                    if (oldColumn > newColumn) {
                        for (i = 0; i < colCount; ++i) {
                            column = cm.getColumn(i);
                            index = column.getModelIndex();
                            if (index == oldColumn) {
                                column.setModelIndex(newColumn);
                                continue;
                            }
                            if (index >= oldColumn || index < newColumn) continue;
                            column.setModelIndex(index + 1);
                        }
                    } else {
                        for (i = 0; i < colCount; ++i) {
                            column = cm.getColumn(i);
                            index = column.getModelIndex();
                            if (index == oldColumn) {
                                column.setModelIndex(newColumn);
                                continue;
                            }
                            if (index <= oldColumn || index > newColumn) continue;
                            column.setModelIndex(index - 1);
                        }
                    }
                    if (this.hiddenColumns != null) {
                        if (oldColumn > newColumn) {
                            int size = this.hiddenColumns.size();
                            for (i = 0; i < size; ++i) {
                                TableColumn column2 = (TableColumn)this.hiddenColumns.get(i);
                                int index2 = column2.getModelIndex();
                                if (index2 >= oldColumn || index2 < newColumn) continue;
                                column2.setModelIndex(index2 + 1);
                            }
                        } else {
                            int size = this.hiddenColumns.size();
                            for (i = 0; i < size; ++i) {
                                TableColumn column3 = (TableColumn)this.hiddenColumns.get(i);
                                int index3 = column3.getModelIndex();
                                if (index3 <= oldColumn || index3 > newColumn) continue;
                                column3.setModelIndex(index3 - 1);
                            }
                        }
                    }
                    if ((ch = this.getColumnHeader()) != null) {
                        List heldColumns = ch.getHeldIndices(2);
                        this.updateList(heldColumns, oldColumn, newColumn);
                        heldColumns = ch.getHeldIndices(4);
                        this.updateList(heldColumns, oldColumn, newColumn);
                    }
                }
                return;
            }
            if (e.getType() == 17) {
                int columnIndex = stme.getColumn();
                String oldName = stme.getOldColumnName();
                String newName = stme.getNewColumnName();
                TableColumnModel cm = this.getColumnModel();
                int count = this.getColumnCount();
                if (oldName == null && newName == null) {
                    for (int i = 0; i < count; ++i) {
                        TableColumn column = cm.getColumn(i);
                        if (column.getModelIndex() != columnIndex) continue;
                        column.setHeaderValue(this.getModel().getColumnName(columnIndex));
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        TableColumn column = cm.getColumn(i);
                        if (column.getModelIndex() != columnIndex || column.getHeaderValue() != oldName) continue;
                        column.setHeaderValue(newName);
                    }
                }
                return;
            }
        }
        if (e.getType() == 1) {
            this.tableRowsInserted(e);
            return;
        }
        if (e.getType() == -1) {
            this.tableRowsDeleted(e);
            return;
        }
        if (e.getType() == 0) {
            this.tableRowsUpdated(e);
        }
        int modelColumn = e.getColumn();
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start == -1) {
            start = 0;
            end = Integer.MAX_VALUE;
        }
        if (modelColumn == -1) {
            dirtyRegion = new Rectangle(0, this.getCellRect((int)start, (int)0, (boolean)false).y, this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int column = this.convertColumnIndexToView(modelColumn);
            dirtyRegion = this.getCellRect(start, column, false);
        }
        if (end != Integer.MAX_VALUE) {
            Rectangle dirtyEndRegion = this.getCellRect(end, 0, false);
            dirtyRegion.height = dirtyEndRegion.y + dirtyEndRegion.height - dirtyRegion.y;
            JScrollPane pane = this.getScrollPane();
            if (pane != null) {
                pane.getViewport().repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
            }
            this.repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
            if (this.getRowHeader() != null) {
                this.getRowHeader().repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
            }
            if (this.getTableHeader() != null) {
                this.getTableHeader().repaint(dirtyRegion.x, dirtyRegion.y, dirtyRegion.width, dirtyRegion.height);
            }
        } else {
            this.clearSelection();
            this.resizeAndRepaint();
            if (this.getRowHeader() != null) {
                this.getRowHeader().resizeAndRepaint();
            }
        }
    }

    protected void tableRowsInserted(TableModelEvent e) {
        JScrollPane pane;
        int start = e.getFirstRow();
        int end = e.getLastRow();
        if (start < 0) {
            start = 0;
        }
        int rowCount = this.getRowCount();
        int rowsInserted = end - start + 1;
        if (this.rowHeightModel != null) {
            this.rowHeightModel.insertEntries(start, rowsInserted, this.getRowHeight());
        }
        if (this.getRowHeader() != null) {
            this.getRowHeader().tableRowsInserted(e);
        }
        this.sizeRowsIfNeeded();
        Rectangle rect2 = this.getCellRect(rowCount - 1, 0, true);
        Rectangle drawRect = new Rectangle(0, this.getCellRect((int)start, (int)0, (boolean)true).y, this.getColumnModel().getTotalColumnWidth(), 0);
        drawRect.height = rect2.y - drawRect.y + rect2.height;
        if (this.rowModel != null && this.rowModel.getSelectionModel() != null) {
            if (end < 0) {
                end = rowCount - 1;
            }
            int length = end - start + 1;
            this.rowModel.getSelectionModel().insertIndexInterval(start, length, true);
        }
        if (this.selectionModel != null) {
            if (end < 0) {
                end = rowCount - 1;
            }
            int columnCount = this.getColumnCount();
            int length = end - start + 1;
            this.selectionModel.insertIndexInterval(start * columnCount, length * columnCount, true);
        }
        if ((pane = this.getScrollPane()) != null) {
            pane.getViewport().repaint();
        }
        this.revalidate();
        this.repaint(drawRect);
        if (this.getRowHeader() != null) {
            this.rowHeader.revalidate();
            this.rowHeader.repaint();
        }
    }

    protected void tableRowsDeleted(TableModelEvent e) {
        JScrollPane pane;
        this.validateCurrentCell();
        if (this.getRowHeader() != null) {
            this.getRowHeader().tableRowsDeleted(e);
        }
        if ((pane = this.getScrollPane()) != null) {
            pane.getViewport().repaint();
        }
        this.revalidate();
        this.repaint();
        if (this.getRowHeader() != null) {
            this.rowHeader.repaint();
        }
    }

    protected void tableRowsUpdated(TableModelEvent e) {
        if (this.isClearRowSelectionPostSortingAllowed()) {
            this.handlePostSortingSelections(e);
        }
    }

    protected void handlePostSortingSelections(TableModelEvent e) {
        if (e.getSource() instanceof SortableInterface) {
            SortableInterface se = (SortableInterface)e.getSource();
            boolean sortColsChanged = false;
            if (!Arrays.equals(se.getSortedColumns(), this.lastSortedColumns)) {
                this.lastSortedColumns = se.getSortedColumns();
                sortColsChanged = true;
            }
            boolean sortDirectionChanged = false;
            if (!Arrays.equals(se.getSortedDirections(), this.lastSortDirections)) {
                this.lastSortDirections = se.getSortedDirections();
                sortDirectionChanged = true;
            }
            ListSelectionModel rowSelectionModel = this.getRowModel().getSelectionModel();
            if (se instanceof SortableTableModelAdapter) {
                if (sortColsChanged || sortDirectionChanged) {
                    int rowIndx;
                    int[] selRowIndx = this.getSelectedRows();
                    rowSelectionModel.clearSelection();
                    for (int i = 0; i < selRowIndx.length; ++i) {
                        rowIndx = ((SortableTableModelAdapter)se).convertRowIndexToView(selRowIndx[i]);
                        this.addRowSelectionInterval(rowIndx, rowIndx);
                    }
                    int[][] selectedCellsIndices = this.getSelectedCells();
                    this.getSelectionModel().clearSelection();
                    for (int i = 0; i < selectedCellsIndices.length; ++i) {
                        rowIndx = ((SortableTableModelAdapter)se).convertRowIndexToView(selectedCellsIndices[i][0]);
                        for (int j = 1; j < selectedCellsIndices[i].length; ++j) {
                            this.addCellSelectionInterval(rowIndx, selectedCellsIndices[i][j], rowIndx, selectedCellsIndices[i][j]);
                        }
                    }
                }
            } else if (sortColsChanged || sortDirectionChanged) {
                rowSelectionModel.clearSelection();
                this.getSelectionModel().clearSelection();
            }
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        int toIndex = e.getToIndex();
        int fromIndex = e.getFromIndex();
        if (this.isEditing()) {
            this.removeEditor();
        }
        if (toIndex != fromIndex) {
            int rowCount = this.getRowCount();
            int min = Math.min(fromIndex, toIndex);
            int max = Math.max(fromIndex, toIndex);
            int[][] selectedCells = this.getSelectedCells();
            int direction = -1;
            int match = min;
            if (fromIndex > toIndex) {
                direction = 1;
                match = max;
            }
            this.selectionModel.removeSelectionInterval(this.createOrdinal(0, min), this.createOrdinal(rowCount - 1, max));
            for (int i = 0; i < selectedCells.length; ++i) {
                if (selectedCells[i][1] < min || selectedCells[i][1] > max) continue;
                if (selectedCells[i][1] == match) {
                    if (match == max) {
                        this.selectionModel.addSelectionInterval(this.createOrdinal(selectedCells[i][0], min), this.createOrdinal(selectedCells[i][0], min));
                        continue;
                    }
                    this.selectionModel.addSelectionInterval(this.createOrdinal(selectedCells[i][0], max), this.createOrdinal(selectedCells[i][0], max));
                    continue;
                }
                this.selectionModel.addSelectionInterval(this.createOrdinal(selectedCells[i][0], selectedCells[i][1] + direction), this.createOrdinal(selectedCells[i][0], selectedCells[i][1] + direction));
            }
            this.setCurrentColumn(toIndex);
            JScrollPane pane = this.getScrollPane();
            if (pane != null) {
                pane.getViewport().repaint();
            }
        }
        this.repaint();
    }

    @Override
    public void rowMoved(TableRowModelEvent e) {
        int toIndex = e.getToIndex();
        int fromIndex = e.getFromIndex();
        if (this.isEditing()) {
            this.removeEditor();
        }
        if (toIndex != fromIndex) {
            int oldCurrentRow = this.currentRow;
            if (toIndex != -1 && fromIndex != -1) {
                int columnCount = this.getColumnCount();
                int min = Math.min(fromIndex, toIndex);
                int max = Math.max(fromIndex, toIndex);
                int[][] selectedCells = this.getSelectedCells();
                int direction = -1;
                int match = min;
                if (fromIndex > toIndex) {
                    direction = 1;
                    match = max;
                }
                this.selectionModel.removeSelectionInterval(this.createOrdinal(min, 0), this.createOrdinal(max, columnCount - 1));
                for (int i = 0; i < selectedCells.length; ++i) {
                    if (selectedCells[i][0] < min || selectedCells[i][0] > max) continue;
                    if (selectedCells[i][0] == match) {
                        if (match == max) {
                            this.selectionModel.addSelectionInterval(this.createOrdinal(min, selectedCells[i][1]), this.createOrdinal(min, selectedCells[i][1]));
                            continue;
                        }
                        this.selectionModel.addSelectionInterval(this.createOrdinal(max, selectedCells[i][1]), this.createOrdinal(max, selectedCells[i][1]));
                        continue;
                    }
                    this.selectionModel.addSelectionInterval(this.createOrdinal(selectedCells[i][0] + direction, selectedCells[i][1]), this.createOrdinal(selectedCells[i][0] + direction, selectedCells[i][1]));
                }
                if (this.rowHeightModel != null && fromIndex != -1 && toIndex != -1) {
                    int size = this.rowHeightModel.getSize(fromIndex);
                    this.rowHeightModel.removeEntries(fromIndex, 1);
                    this.rowHeightModel.insertEntries(toIndex, 1, size);
                }
                this.setCurrentRow(toIndex);
            } else {
                this.clearSelection();
                this.setCurrentRow(oldCurrentRow);
            }
            JScrollPane pane = this.getScrollPane();
            if (pane != null) {
                pane.getViewport().repaint();
            }
        }
        this.repaint();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        this.validateCurrentCell();
        super.columnRemoved(e);
    }

    @Override
    public void rowMarginChanged(ChangeEvent e) {
        this.resizeAndRepaint();
    }

    @Override
    public void rowSelectionChanged(ListSelectionEvent e) {
        int rowCount = this.getRowCount();
        if (this.getColumnCount() <= 0 || rowCount <= 0) {
            return;
        }
        int oldCurrentRow = this.currentRow;
        if (e.getSource().equals(this.getRowModel().getSelectionModel()) && this.getRowModel().getSelectionModel().isSelectedIndex(this.getRowModel().getSelectionModel().getAnchorSelectionIndex())) {
            this.setCurrentRow(this.getRowModel().getSelectionModel().getAnchorSelectionIndex());
        }
        int firstIndex = this.limit(e.getFirstIndex(), 0, rowCount - 1);
        int lastIndex = this.limit(e.getLastIndex(), 0, rowCount - 1);
        Rectangle firstRowRect = this.getCellRect(firstIndex, 0, false);
        Rectangle lastRowRect = this.getCellRect(lastIndex, this.getColumnCount() - 1, false);
        Rectangle dirtyRegion = firstRowRect.union(lastRowRect);
        if (oldCurrentRow < firstIndex || oldCurrentRow > lastIndex) {
            Rectangle oldCurrentRect = this.getCellRect(oldCurrentRow, 0, false);
            dirtyRegion = oldCurrentRect.union(dirtyRegion);
        }
        this.repaint(dirtyRegion);
        if (this.getRowHeader() != null) {
            dirtyRegion.x = 0;
            dirtyRegion.width = this.getRowHeader().getWidth();
            this.getRowHeader().repaint(dirtyRegion);
        }
    }

    public void contentsChanged(ContentsChangedEvent event) {
    }

    @Override
    public void setActionProvider(SwingActionProvider actionProvider) {
        if (this.viewerSupport.getActionProvider() != actionProvider) {
            SwingActionProvider old = this.viewerSupport.getActionProvider();
            if (old != null) {
                old.removeContentsChangedListener(this);
            }
            this.viewerSupport.setActionProvider(actionProvider);
            if (actionProvider != null) {
                actionProvider.addContentsChangedListener(this);
            }
            this.firePropertyChange("actionProvider", old, actionProvider);
        }
    }

    @Override
    public SwingActionProvider getActionProvider() {
        if (this.viewerSupport.getActionProvider() == null) {
            this.setActionProvider(new SwingActionProvider());
        }
        return this.viewerSupport.getActionProvider();
    }

    @Override
    public void setActionVisible(String actionType, String areaType, boolean visible) {
        this.viewerSupport.setActionVisible(actionType, areaType, visible);
    }

    @Override
    public boolean isActionVisible(String actionType, String areaType) {
        return this.viewerSupport.isActionVisible(actionType, areaType);
    }

    @Override
    public Object getUniqueId() {
        return this.viewerSupport.getUniqueId();
    }

    @Override
    public void setUniqueId(Object uniqueId) {
        this.viewerSupport.setUniqueId(uniqueId);
    }

    @Override
    public Collection listAreaTypes() {
        return this.viewerSupport.listAreaTypes();
    }

    @Override
    public Collection listActionTypes(String areaType) {
        return this.viewerSupport.listActionTypes(areaType);
    }

    @Override
    public void setActionSupportType(String actionSupportType) {
        if (!this.viewerSupport.getActionSupportType().equals(actionSupportType)) {
            String old = this.viewerSupport.getActionSupportType();
            this.viewerSupport.setActionSupportType(actionSupportType);
            if (this.dataCellFilter != null) {
                this.dataCellFilter.setActionSupportType(actionSupportType);
            }
            if (this.rowHeaderFilter != null) {
                this.rowHeaderFilter.setActionSupportType(actionSupportType);
            }
            if (this.columnHeaderFilter != null) {
                this.columnHeaderFilter.setActionSupportType(actionSupportType);
            }
            if (this.titleFilter != null) {
                this.titleFilter.setActionSupportType(actionSupportType);
            }
            if (this.toolbarFilter != null) {
                this.toolbarFilter.setActionSupportType(actionSupportType);
            }
            this.firePropertyChange("actionSupportType", old, actionSupportType);
        }
    }

    @Override
    public String getActionSupportType() {
        return this.viewerSupport.getActionSupportType();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        JScrollPane pane = this.getScrollPane();
        if (pane != null) {
            pane.getViewport().repaint();
        }
        if (e.getAdjustable().getOrientation() == 1) {
            this.sizeRowsIfNeeded();
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.printInfo == null || !this.printInfo.pageDone) {
            this.getPageInfo(g, pageFormat);
        }
        this.printInfo.printFont = g.getFont();
        g.setColor(Color.black);
        g.setFont(this.printInfo.printFont);
        if (pageIndex >= this.printInfo.m_pages) {
            this.printInfo.pageDone = false;
            return 1;
        }
        if (this.printInfo.prevPageIndex != pageIndex) {
            ++this.printInfo.subPageIndex;
            if (this.printInfo.subPageIndex == this.printInfo.colSplits) {
                this.printInfo.subPageIndex = 0;
            }
        }
        int X = (int)pageFormat.getImageableX();
        int Y = (int)pageFormat.getImageableY();
        g.translate(X, Y);
        int rowIndex = pageIndex / this.printInfo.colSplits;
        this.printSubTable(g, pageFormat, rowIndex, this.printInfo.subPageIndex);
        this.printInfo.prevPageIndex = pageIndex;
        return 0;
    }

    private void getPageInfo(Graphics g, PageFormat pageFormat) {
        if (this.printInfo == null) {
            this.printInfo = new PrintInfo();
        }
        this.printInfo.subPageIndex = 0;
        this.printInfo.colLayout = null;
        this.printInfo.colSplits = 0;
        this.printInfo.subPageIndex = 0;
        this.printInfo.prevPageIndex = 0;
        this.printInfo.printFont = g.getFont();
        g.setFont(this.printInfo.printFont);
        g.setColor(Color.black);
        TableColumnModel tableColumnModel = this.tableHeader.getColumnModel();
        int colCount = tableColumnModel.getColumnCount();
        this.printInfo.heldRowTopHeight = this.getTopHeldHeight();
        this.printInfo.heldRowBottomHeight = this.getBottomHeldHeight();
        this.printInfo.heldColumnLeftWidth = this.getLeadingHeldWidth();
        this.printInfo.heldColumnRightWidth = this.getTrailingHeldWidth();
        this.printInfo.heldColumnLeftCount = 0;
        this.printInfo.heldColumnRightCount = 0;
        if (this.getColumnHeader() != null) {
            this.printInfo.heldColumnLeftCount = this.getColumnHeader().getHeldIndices(10).size();
            this.printInfo.heldColumnRightCount = this.getColumnHeader().getHeldIndices(11).size();
        }
        this.printInfo.heldRowTopCount = this.getRowHeader().getHeldIndices(1).size();
        this.printInfo.heldRowBottomCount = this.getRowHeader().getHeldIndices(3).size();
        this.printInfo.heldRowHeight = this.printInfo.heldRowTopHeight + this.printInfo.heldRowBottomHeight;
        this.printInfo.heldColumnWidth = this.printInfo.heldColumnLeftWidth + this.printInfo.heldColumnRightWidth;
        if (this.getTableHeader() != null) {
            this.printInfo.columnHeaderHeight = this.getTableHeader().getHeight();
        }
        if (this.getRowHeader() != null) {
            this.printInfo.rowHeaderWidth = this.getRowHeader().getWidth();
        }
        this.printInfo.pageHeight = (int)pageFormat.getImageableHeight();
        this.printInfo.pageWidth = (int)pageFormat.getImageableWidth();
        int hgt = this.printInfo.columnHeaderHeight + this.printInfo.heldRowHeight;
        int yPos = 0;
        this.printInfo.rowLayout = new ArrayList();
        this.printInfo.rowLayout.add(new Integer(0));
        this.printInfo.rowSplits = 0;
        int rowCount = this.getRowCount();
        for (int row = this.printInfo.heldRowTopCount; row < rowCount - this.printInfo.heldRowBottomCount; ++row) {
            int rowHgt = this.getRowHeight(row);
            if (hgt + rowHgt > this.printInfo.pageHeight && yPos != 0) {
                ++this.printInfo.rowSplits;
                this.printInfo.rowLayout.add(new Integer(yPos + this.printInfo.rowSplits * this.printInfo.heldRowHeight));
                hgt = this.printInfo.columnHeaderHeight + this.printInfo.heldRowHeight;
            }
            hgt += rowHgt;
            yPos += rowHgt;
        }
        if (hgt > 0) {
            this.printInfo.rowLayout.add(new Integer(yPos + (this.printInfo.rowSplits + 1) * this.printInfo.heldRowHeight));
            ++this.printInfo.rowSplits;
        }
        int wid = this.printInfo.rowHeaderWidth + this.printInfo.heldColumnWidth;
        int xPos = 0;
        this.printInfo.colLayout = new ArrayList();
        this.printInfo.colLayout.add(new Integer(0));
        this.printInfo.colSplits = 0;
        for (int col = this.printInfo.heldColumnLeftCount; col < colCount - this.printInfo.heldColumnRightCount; ++col) {
            int colWid = tableColumnModel.getColumn(col).getWidth();
            if (wid + colWid > this.printInfo.pageWidth && xPos != 0) {
                ++this.printInfo.colSplits;
                this.printInfo.colLayout.add(new Integer(xPos + this.printInfo.colSplits * this.printInfo.heldColumnWidth));
                wid = this.printInfo.rowHeaderWidth + this.printInfo.heldColumnWidth;
            }
            wid += colWid;
            xPos += colWid;
        }
        if (wid > 0) {
            this.printInfo.colLayout.add(new Integer(xPos + (this.printInfo.colSplits + 1) * this.printInfo.heldColumnWidth));
            ++this.printInfo.colSplits;
        }
        this.printInfo.m_pages = this.printInfo.rowSplits * this.printInfo.colSplits;
        this.printInfo.pageDone = true;
    }

    private void printSubTable(Graphics g, PageFormat pageFormat, int rowIndex, int columnIndex) {
        int pageLeft = (Integer)this.printInfo.colLayout.get(columnIndex);
        int pageRight = (Integer)this.printInfo.colLayout.get(columnIndex + 1);
        int pageWidth = pageRight - pageLeft;
        int pageTop = (Integer)this.printInfo.rowLayout.get(rowIndex);
        int pageBottom = (Integer)this.printInfo.rowLayout.get(rowIndex + 1);
        int pageHeight = pageBottom - pageTop;
        JComponent origin = this.getOriginComponent();
        g.setClip(0, 0, this.printInfo.rowHeaderWidth, this.printInfo.columnHeaderHeight);
        ((Component)origin).print(g);
        g.translate(-pageLeft, 0);
        g.translate(this.printInfo.rowHeaderWidth, 0);
        ColumnHeader header = this.getColumnHeader();
        g.translate(columnIndex * this.printInfo.heldColumnWidth, 0);
        g.setClip(pageLeft - columnIndex * this.printInfo.heldColumnWidth, 0, pageWidth, this.printInfo.columnHeaderHeight);
        if (header != null) {
            header.print(g);
        }
        g.translate(-columnIndex * this.printInfo.heldColumnWidth, 0);
        g.translate(0, this.printInfo.columnHeaderHeight);
        g.translate(pageLeft, -pageTop);
        RowHeader rowHeader = this.getRowHeader();
        g.translate(-this.printInfo.rowHeaderWidth, 0);
        g.translate(0, rowIndex * this.printInfo.heldRowHeight);
        g.setClip(0, pageTop - rowIndex * this.printInfo.heldRowHeight, this.printInfo.rowHeaderWidth, pageHeight);
        if (rowHeader != null) {
            rowHeader.print(g);
        }
        g.translate(0, -rowIndex * this.printInfo.heldRowHeight);
        g.translate(-pageLeft, 0);
        g.translate(this.printInfo.rowHeaderWidth, 0);
        g.translate(columnIndex * this.printInfo.heldColumnWidth, rowIndex * this.printInfo.heldRowHeight);
        g.setClip(pageLeft - columnIndex * this.printInfo.heldColumnWidth, pageTop - rowIndex * this.printInfo.heldRowHeight, pageWidth, pageHeight);
        this.print(g);
        g.translate(-columnIndex * this.printInfo.heldColumnWidth, -(rowIndex * this.printInfo.heldRowHeight));
    }

    @Override
    public void paintComponent(Graphics g) {
        this.printing = false;
        int heldRowTopHeight = this.getTopHeldHeight();
        int heldRowBottomHeight = this.getBottomHeldHeight();
        int heldColumnLeftWidth = this.getLeadingHeldWidth();
        int heldColumnRightWidth = this.getTrailingHeldWidth();
        Rectangle cellArea = this.getCellAreaRect();
        this.verifyClipRect(g, heldRowTopHeight, heldRowBottomHeight, heldColumnLeftWidth, heldColumnRightWidth, cellArea.width, cellArea.height);
        super.paintComponent(g);
    }

    @Override
    public void printComponent(Graphics g) {
        this.printing = true;
        super.paintComponent(g);
    }

    private void verifyClipRect(Graphics g, int heldRowTopHeight, int heldRowBottomHeight, int heldColumnLeftWidth, int heldColumnRightWidth, int tableWidth, int tableHeight) {
        Rectangle clipBounds = g.getClipBounds();
        if (heldRowTopHeight > 0 || heldRowBottomHeight > 0 || heldColumnLeftWidth > 0 || heldColumnRightWidth > 0) {
            Rectangle viewRect = this.getVisibleRect();
            if (heldColumnRightWidth > 0 || heldRowBottomHeight > 0 || heldColumnLeftWidth > 0 && heldRowTopHeight > 0) {
                clipBounds = viewRect;
            } else if (heldColumnLeftWidth > 0) {
                int xMin = viewRect.x;
                int xMax = Math.max(viewRect.x + heldColumnLeftWidth + clipBounds.width, clipBounds.x + clipBounds.width);
                int yMin = viewRect.y;
                int yMax = Math.max(viewRect.y + clipBounds.height, clipBounds.y + clipBounds.height);
                clipBounds.x = viewRect.x;
                clipBounds.y = viewRect.y;
                clipBounds.width = Math.min(xMax - xMin, viewRect.width);
                clipBounds.height = Math.min(viewRect.height, yMax - yMin);
            } else if (heldRowTopHeight > 0) {
                int xMin = viewRect.x;
                int xMax = Math.max(viewRect.x + clipBounds.width, clipBounds.x + clipBounds.width);
                int yMin = viewRect.y;
                int yMax = Math.max(viewRect.y + heldRowTopHeight + clipBounds.height, clipBounds.y + clipBounds.height);
                clipBounds.x = viewRect.x;
                clipBounds.y = viewRect.y;
                clipBounds.width = Math.min(xMax - xMin, viewRect.width);
                clipBounds.height = Math.min(viewRect.height, yMax - yMin);
            }
        }
        g.setClip(clipBounds);
    }

    public TableViewClipboardAdapter getClipboardAdapter() {
        return this.clipboardAdapter;
    }

    public void setClipboardAdapter(TableViewClipboardAdapter clipboardAdapter) {
        this.clipboardAdapter = clipboardAdapter;
    }

    @SASScope
    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    @SASScope
    public void setVisibleRowCount(int newCount) {
        if (newCount != this.visibleRowCount) {
            int oldCount = this.visibleRowCount;
            this.visibleRowCount = newCount;
            this.firePropertyChange("visibleRowCount", oldCount, this.visibleRowCount);
            this.invalidate();
        }
    }

    @SASScope
    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    @SASScope
    public void setVisibleColumnCount(int newCount) {
        if (newCount != this.visibleColumnCount) {
            int oldCount = this.visibleColumnCount;
            this.visibleColumnCount = newCount;
            this.firePropertyChange("visibleColumnCount", oldCount, this.visibleColumnCount);
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SASScope
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getVisibleRowCount() >= 0 || this.getVisibleColumnCount() >= 0) {
            int width = this.preferredViewportSize.width;
            int height = this.preferredViewportSize.height;
            int visRows = this.getVisibleRowCount();
            int visCols = this.getVisibleColumnCount();
            int cc = this.getColumnCount();
            int rc = this.getRowCount();
            if (visRows >= 0) {
                try {
                    int last;
                    this.sizingRows = true;
                    if (this.getRowAutoResizeMode() != 0 && (last = this.getRowHeader().sizeRowsToFit(0, Math.min(visRows - 1, rc - 1), false)) != -1) {
                        this.getRowHeader().revalidate();
                        this.revalidate();
                    }
                }
                finally {
                    this.sizingRows = false;
                }
                if (cc == 0 || rc == 0 || this.getRowAutoResizeMode() == 0) {
                    height = visRows * this.getRowHeight();
                } else if (this.getRowAutoResizeMode() == 5) {
                    Rectangle bounds = this.getCellRect(0, 0, true);
                    if (bounds != null) {
                        height = bounds.height * visRows;
                    }
                } else if (rc >= visRows) {
                    Rectangle bounds = this.getCellRect(visRows - 1, 0, true);
                    if (bounds != null) {
                        height = bounds.y + bounds.height;
                    }
                } else if (rc > 0) {
                    Rectangle bounds = this.getCellRect(rc - 1, 0, true);
                    if (bounds != null) {
                        height = bounds.y + bounds.height;
                        double rh = (double)height / (double)rc;
                        height += (int)(rh * (double)(visRows - rc));
                    }
                } else {
                    height = visRows * this.getRowHeight();
                }
            }
            if (visCols >= 0) {
                Rectangle bounds;
                if (this.getColumnAutoResizeMode() != 0 && this.getColumnHeader() != null && !this.columnsSized) {
                    this.getColumnHeader().sizeColumnsToFit();
                    this.columnsSized = true;
                }
                if ((bounds = this.getCellRect(0, (visCols = Math.min(visCols, cc)) - 1, true)) != null) {
                    width = bounds.x + bounds.width;
                }
            }
            return new Dimension(width, height);
        }
        return super.getPreferredScrollableViewportSize();
    }

    @SASScope
    public boolean isClearRowSelectionPostSortingAllowed() {
        return this.clearRowSelectionAfterSorting;
    }

    @SASScope
    public void setClearRowSelectionPostSortingAllowed(boolean newVal) {
        if (newVal != this.clearRowSelectionAfterSorting) {
            this.clearRowSelectionAfterSorting = newVal;
            this.firePropertyChange("clearRowSelectionAfterSorting", newVal ? Boolean.FALSE : Boolean.TRUE, newVal ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @SASScope
    class PrintInfo {
        public boolean pageDone;
        public Font printFont;
        public List colLayout;
        public List rowLayout;
        public int colSplits;
        public int rowSplits;
        public int subPageIndex;
        public int prevPageIndex;
        public int m_pages;
        public int pageHeight;
        public int pageWidth;
        public int columnHeaderHeight;
        public int rowHeaderWidth;
        public int heldRowTopHeight;
        public int heldRowBottomHeight;
        public int heldColumnLeftWidth;
        public int heldColumnRightWidth;
        public int heldColumnLeftCount;
        public int heldColumnRightCount;
        public int heldRowTopCount;
        public int heldRowBottomCount;
        public int heldRowHeight;
        public int heldColumnWidth;

        PrintInfo() {
        }
    }
}

