/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.TableView;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class SwapCurrentCellAction
extends AbstractAction {
    public static final int COLUMN_HEADER = 1;
    public static final int ROW_HEADER = 2;
    public static final int ORIGIN_COMPONENT = 3;
    protected int swappingComponent;
    protected int oldRow;
    protected int oldColumn;

    public SwapCurrentCellAction() {
        this(1);
    }

    public SwapCurrentCellAction(int swappingComponent) {
        this.swappingComponent = swappingComponent;
        this.oldRow = -1;
        this.oldColumn = -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TableView table = null;
        if (e.getSource() instanceof TableView) {
            table = (TableView)e.getSource();
        }
        if (table != null) {
            int newRow = table.getCurrentRow();
            int newColumn = table.getCurrentColumn();
            if (this.swappingComponent == 1) {
                if (newRow < 0 && newColumn >= 0) {
                    if (this.oldRow >= 0 && this.oldColumn >= 0) {
                        table.changeCurrentCell(this.oldRow, this.oldColumn);
                        this.oldRow = newRow;
                        this.oldColumn = newColumn;
                    } else {
                        this.oldRow = newRow;
                        this.oldColumn = newColumn;
                        int colCount = table.getColumnCount();
                        int rowCount = table.getRowCount();
                        if (colCount > 0 && rowCount > 0) {
                            newColumn = Math.max(0, newColumn);
                            newColumn = Math.min(newColumn, colCount - 1);
                            newRow = 0;
                            table.changeCurrentCell(newRow, newColumn);
                        }
                    }
                } else if (this.oldRow < 0 && this.oldColumn >= 0) {
                    table.changeCurrentCell(this.oldRow, this.oldColumn);
                    this.oldRow = newRow;
                    this.oldColumn = newColumn;
                } else {
                    this.oldRow = newRow;
                    this.oldColumn = newColumn;
                    int colCount = table.getColumnCount();
                    if (colCount > 0) {
                        newColumn = Math.max(0, newColumn);
                        newColumn = Math.min(newColumn, colCount - 1);
                        newRow = -1;
                        table.changeCurrentCell(newRow, newColumn);
                    }
                }
            } else if (this.swappingComponent == 2) {
                if (newColumn < 0 && newRow >= 0) {
                    if (this.oldRow >= 0 && this.oldColumn >= 0) {
                        table.changeCurrentCell(this.oldRow, this.oldColumn);
                        this.oldRow = newRow;
                        this.oldColumn = newColumn;
                    } else {
                        this.oldRow = newRow;
                        this.oldColumn = newColumn;
                        int colCount = table.getColumnCount();
                        int rowCount = table.getRowCount();
                        if (colCount > 0 && rowCount > 0) {
                            newRow = Math.max(0, newRow);
                            newRow = Math.min(newRow, rowCount - 1);
                            newColumn = 0;
                            table.changeCurrentCell(newRow, newColumn);
                        }
                    }
                } else if (this.oldColumn < 0 && this.oldRow >= 0) {
                    table.changeCurrentCell(this.oldRow, this.oldColumn);
                    this.oldRow = newRow;
                    this.oldColumn = newColumn;
                } else {
                    this.oldRow = newRow;
                    this.oldColumn = newColumn;
                    int rowCount = table.getRowCount();
                    if (rowCount > 0) {
                        newRow = Math.max(0, newRow);
                        newRow = Math.min(newRow, rowCount - 1);
                        newColumn = -1;
                        table.changeCurrentCell(newRow, newColumn);
                    }
                }
            } else if (this.swappingComponent == 3) {
                if (newRow < 0 && newColumn < 0) {
                    if (this.oldRow >= 0 && this.oldColumn >= 0) {
                        table.changeCurrentCell(this.oldRow, this.oldColumn);
                        this.oldRow = newRow;
                        this.oldColumn = newColumn;
                    } else {
                        this.oldRow = newRow;
                        this.oldColumn = newColumn;
                        int colCount = table.getColumnCount();
                        int rowCount = table.getRowCount();
                        if (colCount > 0 && rowCount > 0) {
                            newColumn = Math.max(0, newColumn);
                            newColumn = Math.min(newColumn, colCount - 1);
                            newRow = Math.max(0, newRow);
                            newRow = Math.min(newRow, rowCount - 1);
                            table.changeCurrentCell(newRow, newColumn);
                        }
                    }
                } else if (this.oldRow < 0 && this.oldColumn < 0) {
                    table.changeCurrentCell(this.oldRow, this.oldColumn);
                    this.oldRow = newRow;
                    this.oldColumn = newColumn;
                } else {
                    this.oldRow = newRow;
                    this.oldColumn = newColumn;
                    int colCount = table.getColumnCount();
                    int rowCount = table.getRowCount();
                    if (colCount > 0 && rowCount > 0) {
                        newRow = -1;
                        newColumn = -1;
                        table.changeCurrentCell(newRow, newColumn);
                    }
                }
            }
        }
    }
}

