/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class IndicatorCellRenderer
extends JProgressBar
implements TableCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected Hashtable limitColors;
    protected int[] limitValues;
    protected Color unselectedForeground;
    protected Color unselectedBackground;

    public IndicatorCellRenderer() {
        super(0);
        this.setBorderPainted(false);
        this.setStringPainted(true);
        Hashtable<Integer, Color> hash = new Hashtable<Integer, Color>();
        hash.put(new Integer(0), Color.red);
        hash.put(new Integer(15), Color.pink);
        hash.put(new Integer(30), Color.magenta);
        hash.put(new Integer(45), Color.orange);
        hash.put(new Integer(60), Color.yellow);
        hash.put(new Integer(75), Color.cyan);
        hash.put(new Integer(90), Color.blue);
        hash.put(new Integer(100), Color.green);
        this.setLimits(hash);
    }

    public IndicatorCellRenderer(int min, int max) {
        super(0, min, max);
        this.setBorderPainted(false);
        this.setStringPainted(true);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = c;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        super.setForeground(null);
        super.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        int n = 0;
        if (value != null) {
            Color color;
            if (!(value instanceof Number)) {
                String str = value instanceof String ? (String)value : value.toString();
                try {
                    n = Integer.valueOf(str);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                n = ((Number)value).intValue();
            }
            if ((color = this.getColor(n)) != null) {
                this.setForeground(color);
            }
            this.setValue(n);
        } else {
            this.setValue(this.getMinimum());
        }
        return this;
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    public void setLimits(Hashtable limitColors) {
        this.limitColors = limitColors;
        int i = 0;
        int n = limitColors.size();
        this.limitValues = new int[n];
        Enumeration keys = limitColors.keys();
        while (keys.hasMoreElements()) {
            this.limitValues[i++] = (Integer)keys.nextElement();
        }
        this.sort(this.limitValues);
    }

    private Color getColor(int value) {
        Color color = null;
        if (this.limitValues != null) {
            for (int i = 0; i < this.limitValues.length; ++i) {
                if (this.limitValues[i] >= value) continue;
                color = (Color)this.limitColors.get(new Integer(this.limitValues[i]));
            }
        }
        return color;
    }

    private void sort(int[] a) {
        int n = a.length;
        for (int i = 0; i < n - 1; ++i) {
            int k = i;
            for (int j = i + 1; j < n; ++j) {
                if (a[j] >= a[k]) continue;
                k = j;
            }
            int tmp = a[i];
            a[i] = a[k];
            a[k] = tmp;
        }
    }
}

