/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.HoldInterface;
import com.sas.swing.visuals.tableview.RB;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingConstants;

public abstract class HoldColumnSupport
implements HoldInterface,
SwingConstants {
    public static final String RB_KEY = "ColumnHeader.";
    private List heldColumns;
    private List heldColumnsLeft;
    private List heldColumnsRight;
    private boolean holdingEnabled;
    public int base = 0;

    @Override
    public void hold(int columnModelIndex) {
        this.hold(columnModelIndex, 10);
    }

    @Override
    public void hold(int columnModelIndex, int orientation) {
        if (!this.checkOrientation(orientation)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegalHoldOrientation.txt"));
        }
        if (this.isHoldingAllowed(orientation)) {
            Integer heldColumn = new Integer(columnModelIndex);
            if (!this.getHeldIndices().contains(heldColumn)) {
                int viewIndex = this.convertColumnIndexToView(columnModelIndex);
                boolean left = true;
                boolean ltr = this.isLeftToRight();
                if (ltr && (orientation == 4 || orientation == 11) || !ltr && (orientation == 2 || orientation == 11)) {
                    left = false;
                }
                int insertIndex = 0;
                if (left) {
                    insertIndex = this.heldColumnsLeft.size();
                    this.heldColumnsLeft.add(heldColumn);
                } else {
                    insertIndex = this.heldColumnsRight.size();
                    this.heldColumnsRight.add(heldColumn);
                }
                this.doHoldColumn(viewIndex, insertIndex, left);
            }
        }
    }

    public void doHoldColumn(int viewIndex, int insertIndex, boolean left) {
        int newpos = 0;
        if (left) {
            newpos = this.base + insertIndex;
        } else {
            int colCount = this.getColumnCount();
            newpos = this.base + colCount - 1 - insertIndex;
        }
        this.moveColumn(viewIndex, newpos);
    }

    public abstract int convertColumnIndexToView(int var1);

    public abstract int getColumnCount();

    public abstract void moveColumn(int var1, int var2);

    @Override
    public void release(int columnModelIndex) {
        if (this.isHoldingEnabled()) {
            Integer heldColumn = new Integer(columnModelIndex);
            int viewIndex = this.convertColumnIndexToView(columnModelIndex);
            if (this.getHeldIndices(2).contains(heldColumn)) {
                this.heldColumnsLeft.remove(heldColumn);
            } else if (this.getHeldIndices(4).contains(heldColumn)) {
                this.heldColumnsRight.remove(heldColumn);
            } else {
                return;
            }
            this.doReleaseColumn(columnModelIndex, viewIndex);
        }
    }

    public void doReleaseColumn(int columnModelIndex, int viewIndex) {
        int startIndex;
        int count = this.calculateViewOffset(columnModelIndex);
        int tableColCount = this.getColumnCount();
        int modelColCount = this.getModelColumnCount();
        int toIndex = Math.min(columnModelIndex + count, tableColCount - 1);
        if (tableColCount != modelColCount) {
            int diff = modelColCount - tableColCount;
            int adjustTo = 0;
            for (int i = 1; i <= diff; ++i) {
                int c = toIndex - i + 1;
                if (c < 0 || this.getModelIndex(c) <= columnModelIndex) continue;
                ++adjustTo;
            }
            toIndex -= adjustTo;
            toIndex = Math.max(toIndex, 0);
        }
        if ((startIndex = viewIndex) != -1) {
            this.moveColumn(startIndex, toIndex);
        }
    }

    public int calculateViewOffset(int columnModelIndex) {
        int heldColumn2;
        int j;
        List leftList = this.getHeldIndices(2);
        List rightList = this.getHeldIndices(4);
        int count = 0;
        int size = leftList.size();
        for (j = 0; j < size; ++j) {
            heldColumn2 = (Integer)leftList.get(j);
            if (heldColumn2 <= columnModelIndex) continue;
            ++count;
        }
        size = rightList.size();
        for (j = 0; j < size; ++j) {
            heldColumn2 = (Integer)rightList.get(j);
            if (heldColumn2 >= columnModelIndex) continue;
            --count;
        }
        return count;
    }

    public abstract int getModelIndex(int var1);

    public abstract int getModelColumnCount();

    @Override
    public void releaseAll() {
        if (this.isHoldingEnabled()) {
            List list = this.getHeldIndices();
            for (int i = list.size() - 1; i >= 0; --i) {
                this.release((Integer)list.get(i));
            }
        }
    }

    @Override
    public List getHeldIndices() {
        if (this.heldColumnsLeft == null) {
            this.heldColumnsLeft = new ArrayList();
        }
        if (this.heldColumnsRight == null) {
            this.heldColumnsRight = new ArrayList();
        }
        if (this.heldColumns == null) {
            this.heldColumns = new ArrayList();
        } else {
            this.heldColumns.clear();
        }
        this.heldColumns.addAll(this.heldColumnsLeft);
        this.heldColumns.addAll(this.heldColumnsRight);
        return this.heldColumns;
    }

    @Override
    public List getHeldIndices(int orientation) {
        if (!this.checkOrientation(orientation)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegalHoldOrientation.txt"));
        }
        int convertedOrient = this.convertOrientation(orientation);
        if (convertedOrient == 2) {
            if (this.heldColumnsLeft == null) {
                this.heldColumnsLeft = new ArrayList();
            }
            return this.heldColumnsLeft;
        }
        if (this.heldColumnsRight == null) {
            this.heldColumnsRight = new ArrayList();
        }
        return this.heldColumnsRight;
    }

    @Override
    public boolean isHeld(int columnModelIndex) {
        return this.getHeldIndices().contains(new Integer(columnModelIndex));
    }

    @Override
    public boolean isHeld(int columnModelIndex, int orientation) {
        return this.getHeldIndices(orientation).contains(new Integer(columnModelIndex));
    }

    @Override
    public boolean isHoldingEnabled() {
        return this.holdingEnabled;
    }

    @Override
    public void setHoldingEnabled(boolean enableHolding) {
        if (this.holdingEnabled != enableHolding) {
            this.holdingEnabled = enableHolding;
            this.firePropertyChange("holdingEnabled", this.holdingEnabled ? Boolean.FALSE : Boolean.TRUE, this.holdingEnabled ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public boolean isHoldingAllowed(int orientation) {
        return this.isHoldingEnabled() && (orientation == 4 || orientation == 10 || orientation == 11 || orientation == 2);
    }

    private boolean checkOrientation(int orientation) {
        return orientation == 2 || orientation == 10 || orientation == 11 || orientation == 4;
    }

    private int convertOrientation(int orientation) {
        boolean ltr = this.isLeftToRight();
        if (ltr) {
            if (orientation == 10) {
                return 2;
            }
            if (orientation == 11) {
                return 4;
            }
            return orientation;
        }
        if (orientation == 10) {
            return 4;
        }
        if (orientation == 11) {
            return 2;
        }
        return orientation;
    }

    public abstract boolean isLeftToRight();

    public void firePropertyChange(String string, Boolean boolean1, Boolean boolean2) {
    }
}

