/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.swing.visuals.tableview.TableView;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.metal.MetalBorders;

public class DefaultTableHeaderRenderer
extends DefaultTableCellRenderer {
    protected Border focusBorder;
    protected Border nonFocusBorder;
    protected Border headerOutsideBorder;

    public DefaultTableHeaderRenderer() {
        this.setHorizontalAlignment(7);
        this.setVerticalAlignment(0);
        this.headerOutsideBorder = this.createOutsideBorder();
        this.nonFocusBorder = new BorderUIResource.CompoundBorderUIResource(this.headerOutsideBorder, noFocusBorder);
        this.focusBorder = new BorderUIResource.CompoundBorderUIResource(this.headerOutsideBorder, UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.setLineWrap(false);
    }

    protected Border createOutsideBorder() {
        Border outsideBorder = UIManager.getBorder("TableHeader.cellBorder");
        if (outsideBorder instanceof MetalBorders.TableHeaderBorder) {
            outsideBorder = new MetalBorders.TableHeaderBorder(){

                @Override
                public Insets getBorderInsets(Component comp) {
                    Insets insets = super.getBorderInsets(comp);
                    if (insets.right == 0) {
                        insets.right = 2;
                    }
                    return insets;
                }
            };
        }
        return outsideBorder;
    }

    public DefaultTableHeaderRenderer(Character splitCharacter) {
        this();
        this.splitCharacter = splitCharacter;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.gettingRenderer = true;
            if (table != null) {
                JComponent header = null;
                if (column != -1 && table.getTableHeader() != null) {
                    header = table.getTableHeader();
                } else if (table instanceof TableView) {
                    header = ((TableView)table).getRowHeader();
                }
                if (header != null) {
                    if (isSelected) {
                        super.setForeground(table.getSelectionForeground());
                        super.setBackground(table.getSelectionBackground());
                    } else {
                        super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : header.getForeground());
                        super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : header.getBackground());
                    }
                    super.setFont(this.font != null ? this.font : header.getFont());
                }
            }
            if (value != null && this.splitCharacter != null) {
                value = value.toString().replace(this.splitCharacter.charValue(), '\n');
            }
            this.setValue(value == null ? "" : value.toString());
            if (hasFocus) {
                super.setBorder(this.focusBorder);
            } else {
                super.setBorder(this.nonFocusBorder);
            }
        }
        finally {
            this.gettingRenderer = false;
        }
        return this;
    }

    @Override
    public Insets getInsets() {
        Insets ins = super.getInsets();
        if (ins.right == 0 && this.getBorder() instanceof MetalBorders.TableHeaderBorder) {
            ins.right = 2;
        }
        return ins;
    }

    @Override
    public Insets getInsets(Insets insets) {
        super.getInsets(insets);
        if (insets.right == 0 && this.getBorder() instanceof MetalBorders.TableHeaderBorder) {
            insets.right = 2;
        }
        return insets;
    }
}

