/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.LabelView;
import com.sas.table.ColumnAlignmentInterface;
import com.sas.util.Util;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class DefaultTableCellRenderer
extends LabelView
implements TableCellRenderer,
Serializable {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected Color unselectedForeground;
    protected Color unselectedBackground;
    protected Border border;
    protected Font font;
    protected boolean isSelected;
    protected TransformInterface transform;
    protected Character splitCharacter;
    protected boolean gettingRenderer = false;
    protected Locale locale;
    private boolean defaultTransform;
    private boolean paintSelectionIfEditable;

    public DefaultTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.setLineWrap(false);
        this.transform = new ObjectToStringTransform();
        this.locale = null;
        this.defaultTransform = true;
        this.paintSelectionIfEditable = false;
        ((ObjectToStringTransform)this.transform).setNullString("");
        this.setReplaceTab(false);
    }

    public DefaultTableCellRenderer(Character splitCharacter) {
        this();
        this.splitCharacter = splitCharacter;
    }

    @Override
    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
        if (this.defaultTransform && this.locale != null) {
            this.transform = new ObjectToStringTransform(this.locale);
            ((ObjectToStringTransform)this.transform).setNullString("");
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale == null ? Locale.getDefault() : this.locale;
    }

    @SASScope
    public void setShowSelectionWhenFocusAndEditable(boolean showSelection) {
        this.paintSelectionIfEditable = showSelection;
    }

    @SASScope
    public boolean isShowSelectionWhenFocusAndEditable() {
        return this.paintSelectionIfEditable;
    }

    public void setSplitCharacter(Character newValue) {
        if (this.splitCharacter != newValue) {
            Character oldChar = this.splitCharacter;
            this.splitCharacter = newValue;
            this.firePropertyChange("splitCharacter", oldChar, newValue);
        }
    }

    public Character getSplitCharacter() {
        return this.splitCharacter;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (!this.gettingRenderer && !(c instanceof javax.swing.plaf.UIResource)) {
            this.unselectedForeground = c;
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (!this.gettingRenderer && !(c instanceof javax.swing.plaf.UIResource)) {
            this.unselectedBackground = c;
        }
    }

    @Override
    public void setBorder(Border newBorder) {
        super.setBorder(newBorder);
        if (!this.gettingRenderer && !(newBorder instanceof javax.swing.plaf.UIResource) && newBorder != noFocusBorder) {
            this.border = newBorder;
        }
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (!this.gettingRenderer && !(newFont instanceof javax.swing.plaf.UIResource)) {
            this.font = newFont;
        }
    }

    public void setTransform(TransformInterface newTransform) {
        if (this.transform != newTransform) {
            TransformInterface old = this.transform;
            this.transform = newTransform;
            this.defaultTransform = false;
            this.firePropertyChange("transform", old, newTransform);
        }
    }

    public TransformInterface getTransform() {
        return this.transform;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        super.setForeground(null);
        super.setBackground(null);
    }

    protected void setSelected(boolean b) {
        this.isSelected = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.gettingRenderer = true;
            TableModel model = table.getModel();
            if (model instanceof ColumnAlignmentInterface) {
                this.setHorizontalAlignment(((ColumnAlignmentInterface)model).getColumnAlignment(table.convertColumnIndexToModel(column)));
            }
            this.setSelected(isSelected);
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            super.setFont(this.font != null ? this.font : table.getFont());
            if (hasFocus) {
                super.setBorder(this.border != null ? this.border : UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (!this.paintSelectionIfEditable && table.isCellEditable(row, column)) {
                    super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    super.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                super.setBorder(this.border != null ? this.border : noFocusBorder);
            }
            if (value != null && this.splitCharacter != null) {
                value = value.toString().replace(this.splitCharacter.charValue(), '\n');
            }
            this.setValue(value);
        }
        finally {
            this.gettingRenderer = false;
        }
        return this;
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName != null && propertyName.equals("text")) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void setValue(Object value) {
        if (this.transform != null) {
            try {
                value = this.transform.transform(value);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        this.setText(value == null ? "" : value.toString());
    }

    public boolean equals(Object o) {
        if (o instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer rend = (DefaultTableCellRenderer)o;
            if (this == rend) {
                return true;
            }
            if ((Util.equal((Object)this.getFont(), (Object)rend.getFont()) || this.getFont() instanceof javax.swing.plaf.UIResource && rend.getFont() instanceof javax.swing.plaf.UIResource) && this.getSplitCharacter() == rend.getSplitCharacter() && (Util.equal((Object)this.getForeground(), (Object)rend.getForeground()) || this.getForeground() instanceof javax.swing.plaf.UIResource && rend.getForeground() instanceof javax.swing.plaf.UIResource) && (Util.equal((Object)this.getBackground(), (Object)rend.getBackground()) || this.getBackground() instanceof javax.swing.plaf.UIResource && rend.getBackground() instanceof javax.swing.plaf.UIResource) && (Util.equal((Object)this.getBorder(), (Object)rend.getBorder()) || this.getBorder() instanceof javax.swing.plaf.UIResource && rend.getBorder() instanceof javax.swing.plaf.UIResource)) {
                return true;
            }
        }
        return false;
    }

    @SASScope
    public static class UIResource
    extends DefaultTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

