/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.codepolicy.SASScope;
import com.sas.table.ColumnAlignmentInterface;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class BooleanRenderer
extends JCheckBox
implements TableCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private boolean paintSelectionIfEditable;

    public BooleanRenderer() {
        this.setHorizontalAlignment(0);
        this.setBorderPainted(true);
        this.paintSelectionIfEditable = false;
    }

    @SASScope
    public void setShowSelectionWhenFocusAndEditable(boolean showSelection) {
        this.paintSelectionIfEditable = showSelection;
    }

    @SASScope
    public boolean isShowSelectionWhenFocusAndEditable() {
        return this.paintSelectionIfEditable;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableModel model = table.getModel();
        if (model instanceof ColumnAlignmentInterface) {
            this.setHorizontalAlignment(((ColumnAlignmentInterface)model).getColumnAlignment(table.convertColumnIndexToModel(column)));
        }
        this.setSelected(isSelected);
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        if (hasFocus) {
            super.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (!this.paintSelectionIfEditable && table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            super.setBorder(noFocusBorder);
        }
        if (value != null && value instanceof Boolean) {
            this.setSelected((Boolean)value);
        } else {
            this.setSelected(false);
        }
        return this;
    }
}

