/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.tableview;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingAction;
import com.sas.entities.AttributeSetException;
import com.sas.swing.visuals.tableview.ColumnHeader;
import com.sas.swing.visuals.tableview.HoldInterface;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.table.MoveColumnInterface;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicColumnHeaderUI
extends BasicTableHeaderUI {
    protected boolean resizingHeader;
    protected boolean resizingColumn;

    protected int viewIndexForColumn(int column) {
        return this.getHeader().getTable().convertColumnIndexToView(column);
    }

    protected int modelIndexForColumn(int column) {
        return this.getHeader().getTable().convertColumnIndexToModel(column);
    }

    public void setResizingHeader(boolean newValue) {
        this.resizingHeader = newValue;
    }

    public boolean isResizingHeader() {
        return this.resizingHeader;
    }

    public void setResizingColumn(boolean newValue) {
        this.resizingColumn = newValue;
    }

    public boolean isResizingColumn() {
        return this.resizingColumn;
    }

    protected ColumnHeader getHeader() {
        return (ColumnHeader)this.header;
    }

    public static ComponentUI createUI(JComponent h) {
        return new BasicColumnHeaderUI();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected int getHeaderHeight() {
        if (this.getHeader().isHeightSet()) {
            return this.header.getHeight();
        }
        int height = 0;
        boolean accomodatedDefault = false;
        TableColumnModel columnModel = this.header.getColumnModel();
        for (int column = 0; column < columnModel.getColumnCount(); ++column) {
            TableColumn aColumn = columnModel.getColumn(column);
            if (aColumn.getHeaderRenderer() == null && accomodatedDefault) continue;
            Component comp = this.getHeaderRenderer(column);
            int rendererHeight = comp.getPreferredSize().height;
            height = Math.max(height, rendererHeight);
            if (rendererHeight <= 0) continue;
            accomodatedDefault = true;
        }
        return height;
    }

    protected Dimension createHeaderSize(long width) {
        TableColumnModel columnModel = this.header.getColumnModel();
        if (width > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createHeaderSize(width);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        return this.createHeaderSize(width);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        TableColumn draggedColumn;
        Rectangle vr;
        if (this.header.getColumnModel() == null) {
            return;
        }
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        Rectangle oldClipBounds = g.getClipBounds();
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        int heldColumnLeftWidth = this.getHeader().getLeadingHeldWidth();
        int heldColumnRightWidth = this.getHeader().getTrailingHeldWidth();
        int heldColumnLeftCount = ((HoldInterface)((Object)this.header)).getHeldIndices(2).size();
        int heldColumnRightCount = ((HoldInterface)((Object)this.header)).getHeldIndices(4).size();
        int colCount = this.header.getColumnModel().getColumnCount();
        Point left = new Point(oldClipBounds.x, 0);
        Point right = new Point(oldClipBounds.x + oldClipBounds.width - 1, oldClipBounds.y);
        boolean accountForHolds = !this.getHeader().printing;
        int cMin = Math.max(this.getHeader().columnAtPoint(ltr ? left : right, accountForHolds), heldColumnLeftCount);
        int cMax = Math.min(this.getHeader().columnAtPoint(ltr ? right : left, accountForHolds), colCount - 1 - heldColumnRightCount);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = colCount - 1;
        }
        if (cMin <= (cMax = Math.min(cMax, this.header.getTable().getColumnCount() - 1))) {
            this.paintCells(g, cMin, cMax);
        }
        if (heldColumnRightCount > 0) {
            vr = this.header.getVisibleRect();
            int visTableWidth = Math.min(vr.width, ((TableView)this.getHeader().getTable()).getCellAreaWidth());
            if (this.getHeader().printing) {
                g.translate(oldClipBounds.x + oldClipBounds.width - vr.x - visTableWidth, 0);
            }
            this.paintCells(g, colCount - heldColumnRightCount, colCount - 1);
            if (this.getHeader().printing) {
                g.translate(-(oldClipBounds.x + oldClipBounds.width - vr.x - visTableWidth), 0);
            }
        }
        if (heldColumnLeftCount > 0) {
            vr = this.header.getVisibleRect();
            if (this.getHeader().printing) {
                g.translate(oldClipBounds.x - vr.x, 0);
            }
            this.paintCells(g, 0, heldColumnLeftCount - 1);
            if (this.getHeader().printing) {
                g.translate(-(oldClipBounds.x - vr.x), 0);
            }
        }
        if ((draggedColumn = this.header.getDraggedColumn()) != null) {
            int draggedColumnIndex = this.header.getTable().convertColumnIndexToView(draggedColumn.getModelIndex());
            Rectangle draggedCellRect = this.header.getHeaderRect(draggedColumnIndex);
            draggedCellRect.x += this.header.getDraggedDistance();
            if (this.header.isOpaque()) {
                g.setColor(this.header.getBackground());
            } else {
                g.setColor(this.header.getParent().getBackground());
            }
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            this.paintCell(g, draggedCellRect, draggedColumnIndex);
        }
        this.rendererPane.removeAll();
    }

    protected void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        Component component = this.getHeaderRenderer(columnIndex);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    protected Component getHeaderRenderer(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return ((ColumnHeader)this.header).prepareRenderer(renderer, columnIndex);
    }

    protected void paintCells(Graphics g, int cMin, int cMax) {
        TableColumn draggedColumn = this.header.getDraggedColumn();
        TableColumnModel cm = this.header.getColumnModel();
        int draggedColumnIndex = -1;
        Rectangle cellRect = this.header.getHeaderRect(cMin);
        boolean ltr = this.header.getComponentOrientation().isLeftToRight();
        if (draggedColumn != null) {
            draggedColumnIndex = this.header.getTable().convertColumnIndexToView(draggedColumn.getModelIndex());
        }
        if (ltr) {
            for (int column = cMin; column <= cMax; ++column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (column != draggedColumnIndex) {
                    this.paintCell(g, cellRect, column);
                }
                cellRect.x += columnWidth;
            }
        } else {
            for (int column = cMin; column <= cMax; ++column) {
                int columnWidth;
                TableColumn aColumn = cm.getColumn(column);
                cellRect.width = columnWidth = aColumn.getWidth();
                if (column != cMin) {
                    cellRect.x -= columnWidth;
                }
                if (column == draggedColumnIndex) continue;
                this.paintCell(g, cellRect, column);
            }
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected int lastEffectiveMouseY;
        protected int lastEffectiveMouseX;
        private int startMoveColumn;
        private int endMoveColumn;
        private ActionSupportFilter dragColumnFilter;

        protected boolean shouldIgnore(MouseEvent e) {
            return !BasicColumnHeaderUI.this.header.getTable().isEnabled() || !BasicColumnHeaderUI.this.header.isEnabled();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && !this.shouldIgnore(e) && SwingUtilities.isLeftMouseButton(e) && BasicColumnHeaderUI.this.getHeader().getDraggedColumn() == null && BasicColumnHeaderUI.this.isResizingColumn() && !BasicColumnHeaderUI.this.isResizingHeader() && !e.isConsumed()) {
                BasicColumnHeaderUI.this.getHeader().sizeColumnToFit(this.getResizingColumn(e.getPoint()));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                this.startMoveColumn = -1;
                this.endMoveColumn = -1;
                BasicColumnHeaderUI.this.getHeader().setDraggedColumn(null);
                BasicColumnHeaderUI.this.getHeader().setResizingColumn(null);
                BasicColumnHeaderUI.this.getHeader().setDraggedDistance(0);
                if (!BasicColumnHeaderUI.this.getHeader().getTable().hasFocus() && BasicColumnHeaderUI.this.getHeader().getTable().isRequestFocusEnabled()) {
                    BasicColumnHeaderUI.this.getHeader().getTable().requestFocus();
                }
                Point p = e.getPoint();
                this.lastEffectiveMouseY = p.y;
                this.lastEffectiveMouseX = p.x;
                if (BasicColumnHeaderUI.this.isResizingHeader()) {
                    return;
                }
                int resizeIndex = this.getResizingColumn(p);
                if (this.canResize(resizeIndex) && BasicColumnHeaderUI.this.getHeader().getResizingAllowed() && resizeIndex != -1) {
                    BasicColumnHeaderUI.this.getHeader().setResizingColumn(BasicColumnHeaderUI.this.getHeader().getColumnModel().getColumn(resizeIndex));
                    return;
                }
                JTable table = BasicColumnHeaderUI.this.getHeader().getTable();
                int column = BasicColumnHeaderUI.this.getHeader().columnAtPoint(p);
                if (column != -1 && table.getColumnSelectionAllowed() && (SwingUtilities.isLeftMouseButton(e) || !table.isColumnSelected(column))) {
                    this.setValueIsAdjusting(true);
                    table.changeSelection(-1, column, e.isControlDown(), e.isShiftDown());
                }
                if (!(SwingUtilities.isLeftMouseButton(e) || BasicColumnHeaderUI.this.getHeader().getDraggedColumn() != null || BasicColumnHeaderUI.this.isResizingHeader() || BasicColumnHeaderUI.this.isResizingColumn() || e.isConsumed() || !((TableView)BasicColumnHeaderUI.this.getHeader().getTable()).isPopupMenuEnabled())) {
                    Point point = new Point(p.x, p.y - BasicColumnHeaderUI.this.getHeader().getHeight());
                    if (!BasicColumnHeaderUI.this.getHeader().getComponentOrientation().isLeftToRight()) {
                        point.x = this.getWidthInRightToLeft() - point.x;
                        if (BasicColumnHeaderUI.this.getHeader().getTable() != null) {
                            point.x = ((TableView)BasicColumnHeaderUI.this.getHeader().getTable()).getCellAreaWidth() - point.x;
                        }
                    }
                    ((TableView)BasicColumnHeaderUI.this.getHeader().getTable()).showPopup(point);
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int reorderIndex = this.getReorderColumn(p);
                    if (BasicColumnHeaderUI.this.getHeader().getReorderingAllowed() && reorderIndex != -1) {
                        BasicColumnHeaderUI.this.getHeader().setDraggedColumn(BasicColumnHeaderUI.this.getHeader().getColumnModel().getColumn(reorderIndex));
                    }
                }
            }
        }

        protected boolean canResize(int column) {
            return column != -1 && BasicColumnHeaderUI.this.header.getResizingAllowed() && BasicColumnHeaderUI.this.header.getColumnModel().getColumn(column).getResizable();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                if (this.canResize(this.getResizingColumn(e.getPoint()))) {
                    BasicColumnHeaderUI.this.setResizingHeader(false);
                    BasicColumnHeaderUI.this.setResizingColumn(true);
                    Cursor resizeCursor = Cursor.getPredefinedCursor(10);
                    if (BasicColumnHeaderUI.this.getHeader().getCursor() != resizeCursor) {
                        BasicColumnHeaderUI.this.getHeader().setCursor(resizeCursor);
                    }
                } else if (this.resizingHeader(e.getPoint())) {
                    BasicColumnHeaderUI.this.setResizingHeader(true);
                    BasicColumnHeaderUI.this.setResizingColumn(false);
                    Cursor resizeCursor = Cursor.getPredefinedCursor(8);
                    if (BasicColumnHeaderUI.this.getHeader().getCursor() != resizeCursor) {
                        BasicColumnHeaderUI.this.getHeader().setCursor(resizeCursor);
                    }
                } else {
                    BasicColumnHeaderUI.this.setResizingHeader(false);
                    BasicColumnHeaderUI.this.setResizingColumn(false);
                    Cursor defaultCursor = Cursor.getPredefinedCursor(0);
                    if (BasicColumnHeaderUI.this.getHeader().getCursor() != defaultCursor) {
                        BasicColumnHeaderUI.this.getHeader().setCursor(defaultCursor);
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                int mouseY = e.getY();
                int mouseX = e.getX();
                boolean headerLeftToRight = BasicColumnHeaderUI.this.header.getComponentOrientation().isLeftToRight();
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int deltaY = mouseY - this.lastEffectiveMouseY;
                    int deltaX = mouseX - this.lastEffectiveMouseX;
                    TableColumn resizingColumn = BasicColumnHeaderUI.this.getHeader().getResizingColumn();
                    TableColumn draggedColumn = BasicColumnHeaderUI.this.getHeader().getDraggedColumn();
                    int resizingColumnIndex = -1;
                    int draggedColumnIndex = -1;
                    if (resizingColumn != null) {
                        resizingColumnIndex = BasicColumnHeaderUI.this.viewIndexForColumn(resizingColumn.getModelIndex());
                    }
                    if (draggedColumn != null) {
                        draggedColumnIndex = BasicColumnHeaderUI.this.viewIndexForColumn(draggedColumn.getModelIndex());
                    }
                    if (BasicColumnHeaderUI.this.isResizingHeader()) {
                        if (deltaY == 0) {
                            return;
                        }
                        int oldHeight = BasicColumnHeaderUI.this.header.getHeight();
                        int newHeight = oldHeight + deltaY;
                        JScrollPane pane = ((TableView)BasicColumnHeaderUI.this.getHeader().getTable()).getScrollPane();
                        int maxHeight = pane.getSize().height - pane.getInsets().top - pane.getInsets().bottom;
                        if (newHeight < 1) {
                            newHeight = 1;
                        }
                        if (newHeight > maxHeight) {
                            newHeight = maxHeight;
                        }
                        BasicColumnHeaderUI.this.getHeader().setHeight(newHeight);
                        int acheivedDeltaY = BasicColumnHeaderUI.this.header.getHeight() - oldHeight;
                        this.lastEffectiveMouseY += acheivedDeltaY;
                        this.lastEffectiveMouseX = mouseX;
                        BasicColumnHeaderUI.this.getHeader().resizeAndRepaint();
                    } else {
                        if (deltaX == 0) {
                            return;
                        }
                        if (resizingColumnIndex != -1) {
                            int oldWidth = resizingColumn.getWidth();
                            int newWidth = headerLeftToRight ? oldWidth + deltaX : oldWidth - deltaX;
                            resizingColumn.setWidth(newWidth);
                            int acheivedDeltaX = resizingColumn.getWidth() - oldWidth;
                            this.lastEffectiveMouseX = headerLeftToRight ? (this.lastEffectiveMouseX += acheivedDeltaX) : (this.lastEffectiveMouseX -= acheivedDeltaX);
                            this.lastEffectiveMouseY = mouseY;
                        } else if (draggedColumnIndex != -1) {
                            this.move(e, deltaX);
                            this.lastEffectiveMouseY = mouseY;
                            this.lastEffectiveMouseX = mouseX;
                        } else {
                            this.lastEffectiveMouseY = mouseY;
                            this.lastEffectiveMouseX = mouseX;
                        }
                    }
                } else {
                    this.lastEffectiveMouseY = mouseY;
                    this.lastEffectiveMouseX = mouseX;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.shouldIgnore(e)) {
                TableView table = (TableView)BasicColumnHeaderUI.this.getHeader().getTable();
                BasicColumnHeaderUI.this.getHeader().setResizingColumn(null);
                BasicColumnHeaderUI.this.getHeader().setDraggedColumn(null);
                BasicColumnHeaderUI.this.getHeader().setDraggedDistance(0);
                BasicColumnHeaderUI.this.getHeader().repaint();
                this.setValueIsAdjusting(false);
                if (table != null) {
                    table.repaint();
                }
                if (this.startMoveColumn != -1 && this.endMoveColumn != -1 && this.startMoveColumn != this.endMoveColumn) {
                    int startModelIndex = table.getColumnModel().getColumn(this.endMoveColumn).getModelIndex();
                    int endModelIndex = -1;
                    endModelIndex = this.startMoveColumn > this.endMoveColumn ? table.getColumnModel().getColumn(this.endMoveColumn + 1).getModelIndex() : table.getColumnModel().getColumn(this.endMoveColumn - 1).getModelIndex();
                    final ActionSupportFilter filter = this.configureDragColumnActionFilter(this.endMoveColumn, endModelIndex - startModelIndex);
                    final TableView tableView = table;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingAction action;
                            List list = tableView.getActionProvider().getActions(filter).getActions();
                            if (list != null && list.size() > 0 && (action = (SwingAction)list.get(0)).isEnabled()) {
                                action.performAction();
                            }
                            BasicColumnHeaderUI.this.getHeader().repaint();
                            if (tableView != null) {
                                tableView.repaint();
                            }
                        }
                    });
                }
                this.startMoveColumn = -1;
                this.endMoveColumn = -1;
            }
        }

        private ActionSupportFilter configureDragColumnActionFilter(int column, int amountDragged) {
            TableView table = (TableView)BasicColumnHeaderUI.this.getHeader().getTable();
            int modelColumnIndex = Integer.MAX_VALUE;
            if (column != Integer.MAX_VALUE) {
                modelColumnIndex = table.convertColumnIndexToModel(column);
            }
            try {
                if (this.dragColumnFilter == null) {
                    this.dragColumnFilter = new ActionSupportFilter(table.getActionSupportType(), "DRAG_COLUMN_AREA", table);
                } else {
                    this.dragColumnFilter.setActionSupportType(table.getActionSupportType());
                }
                Integer modelInt = new Integer(modelColumnIndex);
                Integer viewerInt = new Integer(column);
                this.dragColumnFilter.setAttribute("table", table);
                this.dragColumnFilter.setAttribute("modelColumn", modelInt);
                this.dragColumnFilter.setAttribute("column", viewerInt);
                this.dragColumnFilter.setAttribute("model", table.getModel());
                this.dragColumnFilter.setAttribute("heldColumns", (HoldInterface)((Object)table.getTableHeader()));
                Integer orientation = null;
                orientation = amountDragged < 0 ? new Integer(10) : new Integer(11);
                if (table.getModel() instanceof MoveColumnInterface) {
                    this.dragColumnFilter.setAttribute("moveColumnInterface", table.getModel());
                    this.dragColumnFilter.setAttribute("moveColumn", modelInt);
                    this.dragColumnFilter.setAttribute("distanceToMoveColumn", new Integer(Math.abs(amountDragged)));
                    this.dragColumnFilter.setAttribute("orientation", orientation);
                }
            }
            catch (AttributeSetException attributeSetException) {
                // empty catch block
            }
            return this.dragColumnFilter;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void move(MouseEvent e, int delta) {
            TableColumnModel columnModel = BasicColumnHeaderUI.this.header.getColumnModel();
            TableView table = (TableView)BasicColumnHeaderUI.this.getHeader().getTable();
            boolean headerLeftToRight = BasicColumnHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            TableColumn draggedColumn = BasicColumnHeaderUI.this.header.getDraggedColumn();
            int draggedDistance = BasicColumnHeaderUI.this.header.getDraggedDistance() + delta;
            int direction = draggedDistance < 0 ? -1 : 1;
            int columnIndex = BasicColumnHeaderUI.this.viewIndexForColumn(draggedColumn.getModelIndex());
            int newColumnIndex = columnIndex + (headerLeftToRight ? direction : -direction);
            int lastColumn = table.getColumnCount() - 1;
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != -1) {
                Rectangle rect = BasicColumnHeaderUI.this.header.getHeaderRect(col);
                rect.height = BasicColumnHeaderUI.this.header.getTable().getHeight();
                BasicColumnHeaderUI.this.header.getTable().scrollRectToVisible(rect);
            }
            boolean swapping = true;
            while (swapping) {
                int width;
                if (draggedDistance < 0 && columnIndex != 0) {
                    if (!BasicColumnHeaderUI.this.getHeader().isHeld(BasicColumnHeaderUI.this.modelIndexForColumn(columnIndex - 1))) {
                        width = columnModel.getColumn(columnIndex - 1).getWidth();
                        if (-draggedDistance > width / 2) {
                            if (this.startMoveColumn == -1) {
                                this.startMoveColumn = columnIndex;
                            }
                            this.endMoveColumn = columnIndex - 1;
                            columnModel.moveColumn(columnIndex, columnIndex - 1);
                            draggedDistance = width + draggedDistance;
                            --columnIndex;
                            continue;
                        }
                        swapping = false;
                        continue;
                    }
                    swapping = false;
                    continue;
                }
                if (draggedDistance > 0 && columnIndex != lastColumn) {
                    if (!BasicColumnHeaderUI.this.getHeader().isHeld(BasicColumnHeaderUI.this.modelIndexForColumn(columnIndex + 1))) {
                        width = columnModel.getColumn(columnIndex + 1).getWidth();
                        if (draggedDistance > width / 2) {
                            if (this.startMoveColumn == -1) {
                                this.startMoveColumn = columnIndex;
                            }
                            this.endMoveColumn = columnIndex + 1;
                            columnModel.moveColumn(columnIndex, columnIndex + 1);
                            draggedDistance = -(width - draggedDistance);
                            ++columnIndex;
                            continue;
                        }
                        swapping = false;
                        continue;
                    }
                    swapping = false;
                    continue;
                }
                swapping = false;
            }
            BasicColumnHeaderUI.this.header.setDraggedColumn(columnModel.getColumn(columnIndex));
            this.setDraggedDistance(draggedDistance, columnIndex);
        }

        protected void setDraggedDistance(int draggedDistance, int column) {
            BasicColumnHeaderUI.this.header.setDraggedDistance(draggedDistance);
            if (column != -1) {
                BasicColumnHeaderUI.this.header.getColumnModel().moveColumn(column, column);
            }
        }

        protected int getResizingColumn(Point p) {
            return this.getResizingColumn(p, BasicColumnHeaderUI.this.header.columnAtPoint(p));
        }

        protected int getResizingColumn(Point p, int column) {
            if (column == -1) {
                return -1;
            }
            Rectangle r = BasicColumnHeaderUI.this.header.getHeaderRect(column);
            r.grow(-3, 0);
            if (r.contains(p)) {
                return -1;
            }
            int midPoint = r.x + r.width / 2;
            int columnIndex = BasicColumnHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? (p.x < midPoint ? column - 1 : column) : (p.x < midPoint ? column : column - 1);
            return columnIndex;
        }

        protected int getReorderColumn(Point p) {
            if (BasicColumnHeaderUI.this.getHeader().getReorderingAllowed()) {
                int column = BasicColumnHeaderUI.this.header.columnAtPoint(p);
                if (column == -1) {
                    return -1;
                }
                TableView table = (TableView)BasicColumnHeaderUI.this.header.getTable();
                if (((HoldInterface)((Object)BasicColumnHeaderUI.this.header)).isHeld(table.convertColumnIndexToModel(column))) {
                    return -1;
                }
                return column;
            }
            return -1;
        }

        protected boolean resizingHeader(Point p) {
            Rectangle r = new Rectangle(0, 0, BasicColumnHeaderUI.this.header.getWidth(), BasicColumnHeaderUI.this.header.getHeight());
            r.grow(0, -3);
            r.y = 0;
            r.height += 3;
            return !r.contains(p);
        }

        protected void setValueIsAdjusting(boolean flag) {
            TableView table = (TableView)BasicColumnHeaderUI.this.getHeader().getTable();
            table.getSelectionModel().setValueIsAdjusting(flag);
            table.getRowModel().getSelectionModel().setValueIsAdjusting(flag);
            table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        protected int getWidthInRightToLeft() {
            if (BasicColumnHeaderUI.this.getHeader().getTable() != null && BasicColumnHeaderUI.this.getHeader().getTable().getAutoResizeMode() != 0) {
                if (BasicColumnHeaderUI.this.getHeader().getTable() instanceof TableView) {
                    return ((TableView)BasicColumnHeaderUI.this.getHeader().getTable()).getCellAreaWidth();
                }
                return BasicColumnHeaderUI.this.getHeader().getTable().getWidth();
            }
            return BasicColumnHeaderUI.this.getHeader().getWidth();
        }
    }
}

