/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dualselector;

import com.sas.codepolicy.SASScope;
import com.sas.swing.models.ValueItemsToTableModelAdapter;
import com.sas.swing.visuals.EditorInterface;
import com.sas.swing.visuals.ValueListEditor;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.DualSelectorUpDownInterface;
import com.sas.swing.visuals.util.DNDObject;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

@SASScope
public class ValueListEditorDualSelectorAdapter
implements DualSelectorInterface,
DualSelectorUpDownInterface,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    protected ValueListEditor component;
    protected JComponent parentSelector;
    public DropTarget dropTarget = null;
    public DragSource dragSource = null;
    protected ListSelectionModel lsm;

    public ValueListEditorDualSelectorAdapter(JComponent parent, EditorInterface editor) {
        this.parentSelector = parent;
        this.component = new ValueListEditor(editor){

            @Override
            protected boolean deleteSelectedRows() {
                boolean focusCycleRoot = false;
                if (ValueListEditorDualSelectorAdapter.this.parentSelector != null) {
                    focusCycleRoot = ValueListEditorDualSelectorAdapter.this.parentSelector.isFocusCycleRoot();
                }
                try {
                    if (ValueListEditorDualSelectorAdapter.this.parentSelector != null) {
                        ValueListEditorDualSelectorAdapter.this.parentSelector.setFocusCycleRoot(true);
                    }
                    boolean bl = super.deleteSelectedRows();
                    return bl;
                }
                finally {
                    if (ValueListEditorDualSelectorAdapter.this.parentSelector != null) {
                        ValueListEditorDualSelectorAdapter.this.parentSelector.setFocusCycleRoot(focusCycleRoot);
                    }
                }
            }
        };
        this.lsm = this.component.getTable().getRowModel().getSelectionModel();
        if (this.parentSelector != null) {
            if (!((BaseDualSelector)this.parentSelector).isDesignTime()) {
                DropTarget dropTarget = new DropTarget(this.component.getTable(), this);
                this.dragSource = new DragSource();
                this.dragSource.createDefaultDragGestureRecognizer(this.component.getTable(), 3, this);
            } else {
                ((BaseDualSelector)this.parentSelector).setDragAndDropEnabled(false);
            }
        }
    }

    public ValueListEditor getValueListEditor() {
        return this.component;
    }

    public void setParentSelector(JComponent parent) {
        this.parentSelector = parent;
    }

    @Override
    public void clearSelections() {
        this.lsm.clearSelection();
    }

    @Override
    public int getCount() {
        return this.component.getModel().getRowCount();
    }

    @Override
    public int getSelectedCount() {
        return this.component.getSelectedRowCount();
    }

    @Override
    public int getLastSelectedIndex() {
        return this.lsm.getMaxSelectionIndex();
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.getCount() > 0) {
            this.component.getTable().setRowSelectionInterval(index, index);
        } else if (((BaseDualSelector)this.parentSelector).sourceAdapter == this) {
            ((BaseDualSelector)this.parentSelector).targetAdapter.clearSelections();
        } else {
            ((BaseDualSelector)this.parentSelector).sourceAdapter.clearSelections();
        }
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public JComponent getContainerComponent() {
        return this.component;
    }

    private int getLabelColumn() {
        List cols;
        TableModel tableModel = this.component.getModel();
        if (tableModel instanceof ValueItemsToTableModelAdapter && (cols = ((ValueItemsToTableModelAdapter)tableModel).getColumns()) != null && !cols.isEmpty()) {
            int count = 0;
            for (Object element : cols) {
                if (element == "LABEL") {
                    return count;
                }
                ++count;
            }
        }
        return 0;
    }

    @Override
    public List getSelectedItems() {
        int columnCount;
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        int count = this.component.getSelectedRows().length;
        TableModel tableModel = this.component.getModel();
        if (count > 0 && tableModel != null && tableModel.getRowCount() > 0 && (columnCount = tableModel.getColumnCount()) >= 1) {
            int minSelectionIndex = this.lsm.getMinSelectionIndex();
            int maxSelectionIndex = this.lsm.getMaxSelectionIndex();
            int col = this.getLabelColumn();
            for (int i = minSelectionIndex; i <= maxSelectionIndex; ++i) {
                if (!this.component.getTable().isRowSelected(i)) continue;
                selectedItems.add(tableModel.getValueAt(i, col));
            }
        }
        return selectedItems;
    }

    @Override
    public List getAllItems() {
        int columnCount;
        int rowCount;
        ArrayList<Object> items = new ArrayList<Object>();
        TableModel tableModel = this.component.getModel();
        if (tableModel != null && (rowCount = tableModel.getRowCount()) > 0 && (columnCount = tableModel.getColumnCount()) >= 1) {
            int col = this.getLabelColumn();
            for (int i = 0; i < rowCount; ++i) {
                items.add(tableModel.getValueAt(i, col));
            }
        }
        return items;
    }

    @Override
    public List getAllMoveableItems() {
        return this.getAllItems();
    }

    @Override
    public void addItems(List newItems) {
        this.component.addItems(newItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItems(List removeItems) {
        int listSize = removeItems.size();
        if (listSize == 0) {
            return;
        }
        boolean focusCycleRoot = false;
        if (this.parentSelector != null) {
            focusCycleRoot = this.parentSelector.isFocusCycleRoot();
        }
        try {
            if (this.parentSelector != null) {
                this.parentSelector.setFocusCycleRoot(true);
            }
            if (listSize == this.component.getModel().getRowCount()) {
                this.component.deleteAllRows();
                if (this.parentSelector != null) {
                    this.parentSelector.transferFocus();
                }
            } else {
                List totalItems = this.getAllItems();
                int[] rows = new int[listSize];
                for (int i = 0; i < listSize; ++i) {
                    rows[i] = totalItems.indexOf(removeItems.get(i));
                    if (rows[i] >= 0) continue;
                }
                this.component.deleteRows(rows);
            }
        }
        finally {
            if (this.parentSelector != null) {
                this.parentSelector.setFocusCycleRoot(focusCycleRoot);
            }
        }
    }

    @Override
    public boolean isInAdapter(Object item) {
        List allItems = this.getAllItems();
        return allItems.contains(item);
    }

    @Override
    public int[] getSelectedIndices() {
        return this.component.getSelectedRows();
    }

    @Override
    public void moveItems(int[] selectedIndices, int offset) {
        block4: {
            TableModel tableModel = this.component.getModel();
            if (tableModel == null || !(tableModel instanceof DefaultTableModel) || !this.canMove(selectedIndices, offset)) break block4;
            int selectedIndicesLength = selectedIndices.length;
            this.lsm.clearSelection();
            if (offset == -1) {
                for (int i = 0; i < selectedIndicesLength; ++i) {
                    int index = selectedIndices[i];
                    ((DefaultTableModel)tableModel).moveRow(index, index, index + offset);
                    this.lsm.addSelectionInterval(index + offset, index + offset);
                }
            } else {
                for (int j = selectedIndicesLength - 1; j >= 0; --j) {
                    int index = selectedIndices[j];
                    ((DefaultTableModel)tableModel).moveRow(index, index, index + offset);
                    this.lsm.addSelectionInterval(index + offset, index + offset);
                }
            }
        }
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.lsm.isSelectedIndex(index);
    }

    @Override
    public boolean canMove(int[] indices, int offset) {
        boolean returnValue = false;
        if (offset == -1 && !this.isSelectedIndex(0)) {
            returnValue = true;
        }
        if (offset == 1 && !this.isSelectedIndex(this.getCount() - 1)) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            event.acceptDrag(2);
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            if (((BaseDualSelector)this.parentSelector).dragGestureInitiator == event.getDropTargetContext().getComponent()) {
                event.rejectDrop();
            } else {
                Transferable transferable = event.getTransferable();
                if (transferable.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                    event.acceptDrop(2);
                    if (((BaseDualSelector)this.parentSelector).sourceAdapter == this) {
                        ((BaseDualSelector)this.parentSelector).transferTargetItems();
                    } else {
                        ((BaseDualSelector)this.parentSelector).transferSourceItems();
                    }
                    event.getDropTargetContext().dropComplete(true);
                } else {
                    event.rejectDrop();
                }
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        List selected;
        ((BaseDualSelector)this.parentSelector).dragGestureInitiator = event.getComponent();
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled() && (selected = this.getSelectedItems()) != null) {
            DNDObject items = new DNDObject();
            for (int i = 0; i < selected.size(); ++i) {
                items.add(selected.get(i));
            }
            this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, items, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }
}

