/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dualselector;

import com.sas.beans.Util;
import com.sas.codepolicy.SASScope;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualSelectorTreeInterface;
import com.sas.swing.visuals.dualselector.JTreeDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.RB;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

@SASScope(value="ALL")
public class DualTreeSelector
extends BaseDualSelector
implements TreeSelectionListener,
ViewDefaultModel {
    private static final String RB_KEY = "DualTreeSelector.";
    private String rootTreeNodeName = RB.getStringResource("DualTreeSelector.", "rootNodeName.txt");
    private transient TreeModel sourceTreeModel;
    private transient TreeModel targetTreeModel;
    private boolean moveParentNodesOnly;
    private boolean parentNodesMoveable;
    protected TreeCellRenderer cellRenderer;
    protected JTree sourceJTree;
    protected JTree targetJTree;
    protected DefaultMutableTreeNode rootNode;

    public DualTreeSelector() {
        this.setDesignTime(Util.isDesignTime());
        this.targetControlsVisible = false;
        this.transferAllControlsVisible = true;
        this.targetMaximumCount = -1;
        this.dragAndDropEnabled = true;
        this.sourceAdapter = new JTreeDualSelectorAdapter(this);
        this.targetAdapter = new JTreeDualSelectorAdapter(this);
        this.sourceJTree = (JTree)this.sourceAdapter.getComponent();
        this.targetJTree = (JTree)this.targetAdapter.getComponent();
        this.sourceTreeModel = this.sourceJTree.getModel();
        this.targetTreeModel = this.targetJTree.getModel();
        this.initializeBaseDualSelector();
        this.sourceJTree.addMouseListener(this.sourceMouseListener);
        this.targetJTree.addMouseListener(this.targetMouseListener);
        this.rootNode = new DefaultMutableTreeNode(this.rootTreeNodeName);
        if (this.getModel() == null) {
            this.setModel(new DefaultTreeModel(this.rootNode));
        }
        if (this.getTargetModel() == null) {
            this.setTargetModel(new DefaultTreeModel(this.rootNode));
        }
        this.sourceAdapter.setSelectedIndex(0);
        this.initialized = true;
        this.ensureButtonsEnabled();
        this.addListeners();
        this.updateUI();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.sourceJTree.removeTreeSelectionListener(this);
        this.sourceJTree.addTreeSelectionListener(this);
        this.targetJTree.removeTreeSelectionListener(this);
        this.targetJTree.addTreeSelectionListener(this);
    }

    public TreeCellRenderer getSourceCellRenderer() {
        return this.sourceJTree.getCellRenderer();
    }

    public void setSourceCellRenderer(TreeCellRenderer newValue) {
        TreeCellRenderer oldValue = this.sourceJTree.getCellRenderer();
        if (newValue == oldValue) {
            return;
        }
        this.sourceJTree.setCellRenderer(newValue);
        this.firePropertyChange("SourceTreeCellRenderer", oldValue, newValue);
    }

    public TreeCellRenderer getTargetCellRenderer() {
        return this.targetJTree.getCellRenderer();
    }

    public void setTargetCellRenderer(TreeCellRenderer newValue) {
        TreeCellRenderer oldValue = this.targetJTree.getCellRenderer();
        if (newValue == oldValue) {
            return;
        }
        this.targetJTree.setCellRenderer(newValue);
        this.firePropertyChange("targetTreeCellRenderer", oldValue, newValue);
    }

    public void setSourceRootVisible(boolean visible) {
        this.sourceJTree.setRootVisible(visible);
        if (!visible) {
            this.sourceJTree.setShowsRootHandles(true);
        }
    }

    public boolean isSourceRootVisible() {
        return this.sourceJTree.isRootVisible();
    }

    public void setTargetRootVisible(boolean visible) {
        this.targetJTree.setRootVisible(visible);
        if (!visible) {
            this.targetJTree.setShowsRootHandles(true);
        }
    }

    public boolean isTargetRootVisible() {
        return this.targetJTree.isRootVisible();
    }

    public void setParentNodesOnlyMoveable(boolean parentNodes) {
        this.moveParentNodesOnly = parentNodes;
        ((JTreeDualSelectorAdapter)this.sourceAdapter).setParentNodesOnlyMoveable(parentNodes);
        ((JTreeDualSelectorAdapter)this.targetAdapter).setParentNodesOnlyMoveable(parentNodes);
    }

    public boolean isParentNodesOnlyMoveable() {
        return this.moveParentNodesOnly;
    }

    public void setParentNodesMoveable(boolean moveable) {
        this.parentNodesMoveable = moveable;
        ((JTreeDualSelectorAdapter)this.sourceAdapter).setParentNodesMoveable(moveable);
        ((JTreeDualSelectorAdapter)this.targetAdapter).setParentNodesMoveable(moveable);
    }

    public boolean isParentNodesMoveable() {
        return this.parentNodesMoveable;
    }

    public void setSourceTargetNode(Object sourceTargetNode) {
        ((DualSelectorTreeInterface)this.targetAdapter).setSourceTargetNode(sourceTargetNode);
        this.setCopyModeEnabled(true);
        this.setParentNodesMoveable(false);
    }

    @SASScope
    public boolean isRemoveEmptySourceParentNodes() {
        return ((JTreeDualSelectorAdapter)this.sourceAdapter).isRemoveEmptyParentNodes();
    }

    @SASScope
    public boolean isRemoveEmptyTargetParentNodes() {
        return ((JTreeDualSelectorAdapter)this.targetAdapter).isRemoveEmptyParentNodes();
    }

    @SASScope
    public void setRemoveEmptyParentNodes(boolean remove) {
        ((JTreeDualSelectorAdapter)this.sourceAdapter).setRemoveEmptyParentNodes(remove);
        ((JTreeDualSelectorAdapter)this.targetAdapter).setRemoveEmptyParentNodes(remove);
    }

    @SASScope
    public void setRemoveEmptySourceParentNodes(boolean remove) {
        ((JTreeDualSelectorAdapter)this.sourceAdapter).setRemoveEmptyParentNodes(remove);
    }

    @SASScope
    public void setRemoveEmptyTargetParentNodes(boolean remove) {
        ((JTreeDualSelectorAdapter)this.targetAdapter).setRemoveEmptyParentNodes(remove);
    }

    public TreeModel getModel() {
        return this.sourceTreeModel;
    }

    public void setModel(TreeModel treeModel) {
        TreeModel oldModel = this.sourceTreeModel;
        if (treeModel != null) {
            this.sourceTreeModel = treeModel;
            if (this.sourceJTree != null) {
                this.sourceJTree.setModel(this.sourceTreeModel);
            }
        } else {
            this.rootNode = new DefaultMutableTreeNode(this.rootTreeNodeName);
            this.sourceTreeModel = new DefaultTreeModel(this.rootNode);
            if (this.sourceJTree != null) {
                this.sourceJTree.setModel(this.sourceTreeModel);
            }
        }
        if (this.sourceJTree.getRowCount() > 0) {
            this.sourceJTree.removeTreeSelectionListener(this);
            this.sourceJTree.setSelectionRow(0);
            this.sourceJTree.addTreeSelectionListener(this);
        }
        if (!(this.sourceTreeModel instanceof DefaultTreeModel)) {
            this.setCopyModeEnabled(true);
        }
        this.firePropertyChange("model", oldModel, this.sourceTreeModel);
    }

    public TreeModel getTargetModel() {
        return this.targetTreeModel;
    }

    public void setTargetModel(TreeModel treeModel) throws IllegalArgumentException {
        TreeModel oldModel;
        if (treeModel instanceof DefaultTreeModel) {
            oldModel = this.targetTreeModel;
            if (treeModel != null) {
                this.targetTreeModel = treeModel;
                if (this.targetJTree != null) {
                    this.targetJTree.setModel(this.targetTreeModel);
                }
            } else {
                this.rootNode = new DefaultMutableTreeNode(this.rootTreeNodeName);
                this.targetTreeModel = new DefaultTreeModel(this.rootNode);
                if (this.targetJTree != null) {
                    this.targetJTree.setModel(this.targetTreeModel);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange("targetModel", oldModel, this.targetTreeModel);
    }

    @Override
    public boolean isDefaultModelAttached() {
        return this.getModel() instanceof DefaultTreeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent ie) {
        Object source = ie.getSource();
        this.direction = ie.getNewLeadSelectionPath() == null || source != this.sourceJTree;
        if (!this.clearSelection) {
            if (source == this.sourceJTree) {
                if (this.alternatingMultipleButtonStyle) {
                    this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", false));
                }
                if (this.alternatingSingleButtonStyle) {
                    this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", false));
                }
                this.ensureButtonsEnabled();
                this.clearSelection = true;
                try {
                    this.targetJTree.getSelectionModel().clearSelection();
                    this.direction = false;
                }
                finally {
                    this.clearSelection = false;
                }
            }
            if (source == this.targetJTree) {
                if (this.alternatingMultipleButtonStyle) {
                    this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", true));
                }
                if (this.alternatingSingleButtonStyle) {
                    this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", true));
                }
                this.ensureButtonsEnabled();
                this.clearSelection = true;
                try {
                    this.sourceJTree.getSelectionModel().clearSelection();
                    this.direction = true;
                }
                finally {
                    this.clearSelection = false;
                }
            }
        }
    }
}

