/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.sort;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.dataselectors.sort.RB;
import com.sas.swing.visuals.dataselectors.sort.SortedItem;
import com.sas.text.Message;
import com.sas.util.SortDirectionInterface;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

@SASScope(value="ALL")
public class SortSelectorRenderer
extends LabelView
implements ListCellRenderer,
SortDirectionInterface {
    protected static Border noFocusBorder;
    private String formatString;

    public SortSelectorRenderer() {
        this.setHorizontalTextPosition(11);
        if (noFocusBorder == null) {
            noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
        this.formatString = RB.getStringResource("sortRendererLabel.txt");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value instanceof SortedItem) {
            String v;
            String string = v = value == null ? "" : value.toString();
            if (((SortedItem)value).getDirection() == 0) {
                this.setText(Message.format((String)this.formatString, (Object)v, (Object)RB.getStringResource("ascending.txt")));
            } else {
                this.setText(Message.format((String)this.formatString, (Object)v, (Object)RB.getStringResource("descending.txt")));
            }
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
        return this;
    }
}

