/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.sort;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.sort.SortSelectorInterface;
import com.sas.swing.visuals.dataselectors.BaseSwingSelectorPanel;
import com.sas.swing.visuals.dataselectors.sort.RB;
import com.sas.swing.visuals.dataselectors.sort.SortSelectorRenderer;
import com.sas.swing.visuals.dataselectors.sort.SortedItem;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.util.SortDirectionInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.EqualSpacePartitioner;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@SASScope(value="ALL")
public class SortSelector
extends BaseSwingSelectorPanel
implements LayoutConstants,
ListSelectionListener,
ListDataListener,
ActionListener,
SortDirectionInterface {
    public static final String RB_KEY = "SortSelector.";
    private DualListSelector dualSelector;
    private JPanel sortDirectionPanel;
    private JRadioButton ascendingButton;
    private JRadioButton descendingButton;
    private JRadioButton noneButton;
    private ButtonGroup directionGroup;
    private DefaultListModel sortedListModel;
    private EqualSpacePartitioner partitioner;

    public SortSelector() {
        this.createComponents();
        this.addListeners();
    }

    protected void createComponents() {
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        mainLayout.setRemainderRow(1);
        this.setLayout(mainLayout);
        this.dualSelector = new DualListSelector();
        this.dualSelector.setSourceLabel(RB.getStringResource(RB_KEY, "availableColumnsLabel.txt"));
        this.dualSelector.setTargetLabel(RB.getStringResource("sortBy.txt"));
        this.dualSelector.setTransferAllControlsVisible(false);
        this.dualSelector.setTargetControlsVisible(true);
        this.dualSelector.setAlternatingSingleButtonStyle(false);
        this.dualSelector.setTargetCellRenderer(new SortSelectorRenderer());
        this.sortDirectionPanel = new JPanel();
        JPanel outerDirectionPanel = new JPanel();
        outerDirectionPanel.setBorder(INDENTED_BORDER);
        AutoSizingGridLayout outerLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        outerDirectionPanel.setLayout(outerLayout);
        AutoSizingGridLayout directionLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, false);
        this.sortDirectionPanel.setLayout(directionLayout);
        this.ascendingButton = new JRadioButton(RB.getStringResource("ascending.txt"));
        this.descendingButton = new JRadioButton(RB.getStringResource("descending.txt"));
        this.noneButton = new JRadioButton();
        this.directionGroup = new ButtonGroup();
        this.directionGroup.add(this.ascendingButton);
        this.directionGroup.add(this.descendingButton);
        this.directionGroup.add(this.noneButton);
        this.sortDirectionPanel.add(this.ascendingButton);
        this.sortDirectionPanel.add(this.descendingButton);
        Util.setEnabledOnContainer(this.sortDirectionPanel, false);
        outerDirectionPanel.add(new JPanel());
        outerDirectionPanel.add(this.sortDirectionPanel);
        this.partitioner = new EqualSpacePartitioner(false);
        outerLayout.setColumnSpacePartitioner(this.partitioner);
        this.add(this.dualSelector);
        this.add(outerDirectionPanel);
    }

    @Override
    public void doLayout() {
        this.partitioner.setMaximumSize((this.getSize().width - 5) / 2);
        super.doLayout();
    }

    protected void addListeners() {
        ((JList)this.dualSelector.getTargetComponent()).addListSelectionListener(this);
        this.ascendingButton.addActionListener(this);
        this.descendingButton.addActionListener(this);
    }

    @Override
    public void setSelectorModel(Object model) {
        if (this.selectorModel != model && model instanceof SortSelectorInterface) {
            Object old = this.selectorModel;
            this.selectorModel = (SortSelectorInterface)model;
            this.sortedListModel = new DefaultListModel();
            Object[] sortedCols = ((SortSelectorInterface)model).getSortedItems();
            int[] directions = ((SortSelectorInterface)model).getSortedDirections();
            for (int i = 0; i < sortedCols.length; ++i) {
                this.sortedListModel.addElement(sortedCols[i]);
            }
            this.dualSelector.setTargetModel(this.sortedListModel);
            this.sortedListModel.addListDataListener(this);
            DefaultListModel<Object> availListModel = new DefaultListModel<Object>();
            Object[] availCols = ((SortSelectorInterface)model).getAvailableItems();
            for (int i = 0; i < availCols.length; ++i) {
                if (this.sortedListModel.contains(availCols[i])) continue;
                availListModel.addElement(availCols[i]);
            }
            this.dualSelector.setModel(availListModel);
            this.firePropertyChange("selectorModel", old, this.selectorModel);
        }
    }

    @Override
    public String getDialogTitle() {
        return RB.getStringResource("sort.txt");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        JList list = (JList)this.dualSelector.getTargetComponent();
        int size = list.getModel().getSize();
        if (list.getSelectedIndices().length == 1 && size > 0) {
            Object item;
            Util.setEnabledOnContainer(this.sortDirectionPanel, true);
            int index = list.getSelectedIndex();
            if (index >= size) {
                list.setSelectedIndex(size - 1);
            }
            if ((item = list.getSelectedValue()) instanceof SortedItem) {
                if (((SortedItem)item).getDirection() == 0) {
                    this.ascendingButton.setSelected(true);
                } else {
                    this.descendingButton.setSelected(true);
                }
            }
        } else {
            Util.setEnabledOnContainer(this.sortDirectionPanel, false);
            this.noneButton.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JList list;
        Object item;
        Object source = e.getSource();
        if ((source == this.ascendingButton || source == this.descendingButton) && (item = (list = (JList)this.dualSelector.getTargetComponent()).getSelectedValue()) instanceof SortedItem) {
            if (this.ascendingButton.isSelected()) {
                ((SortedItem)item).setDirection(0);
            } else {
                ((SortedItem)item).setDirection(1);
            }
            this.updateModel();
            list.repaint();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateModel();
        this.valueChanged(null);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updateModel();
        this.valueChanged(null);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updateModel();
        this.valueChanged(null);
    }

    private void updateModel() {
        Object[] items = this.sortedListModel.toArray();
        int[] dirs = null;
        if (items != null) {
            dirs = new int[items.length];
            for (int i = 0; i < items.length; ++i) {
                dirs[i] = ((SortedItem)items[i]).getDirection();
            }
        }
        ((SortSelectorInterface)this.selectorModel).setSortedItems(items);
        ((SortSelectorInterface)this.selectorModel).setSortedDirections(dirs);
    }
}

