/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.propertyeditor;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.dataselectors.propertyeditor.EditorPanelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.EntityAttributeValueModelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.PropertyValueInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.RB;
import com.sas.swing.visuals.util.Util;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.StringToMissingValuesTransform;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

@SASScope(value="ALL")
public class TextFieldEditorPanel
extends JPanel
implements EditorPanelInterface {
    protected JTextField valueField;
    protected LabelView helpLabel;
    private EntityAttributeValueModelInterface selectorAdapter;
    private String propertyName;

    public TextFieldEditorPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 5, 5, true, false, true);
        this.setLayout(layout);
        this.add(this.makePanel());
    }

    protected JPanel makePanel() {
        JPanel textFieldPanel = new JPanel();
        AutoSizingGridLayout textFieldLayout = new AutoSizingGridLayout(2, 1, 5, 10, true, false, true);
        textFieldPanel.setLayout(textFieldLayout);
        JPanel textFieldInnerPanel = new JPanel();
        AutoSizingGridLayout textFieldInnerLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        textFieldInnerPanel.setLayout(textFieldInnerLayout);
        this.valueField = new JTextField();
        this.valueField.getAccessibleContext().setAccessibleName("valueField");
        this.valueField.setColumns(20);
        JLabel valueLabel = Util.createLabelForComponent(this.valueField, RB.getStringResource("value.txt"));
        textFieldInnerPanel.add(valueLabel);
        textFieldInnerPanel.add(this.valueField);
        textFieldPanel.add(textFieldInnerPanel);
        this.helpLabel = new LabelView();
        this.helpLabel.setPreferredSpanSize(new Dimension(20, 100));
        textFieldPanel.add(this.helpLabel);
        return textFieldPanel;
    }

    @Override
    public void setModel(EntityAttributeValueModelInterface selectorAdapter, String propertyName) {
        this.selectorAdapter = selectorAdapter;
        this.propertyName = propertyName;
        List list = selectorAdapter.getSelectedValues(propertyName);
        if (list.size() == 0) {
            this.valueField.setText(null);
        } else {
            Object o = ((PropertyValueInterface)list.get(0)).getUnformattedValue();
            if (o != null) {
                this.valueField.setText((String)ObjectToStringTransform.defaultInstance.transform(o));
            } else {
                this.valueField.setText(list.get(0).toString());
            }
        }
        String editorInstructionText = selectorAdapter.getEditorInstructionText(propertyName);
        if (editorInstructionText != null) {
            this.helpLabel.setVisible(true);
            this.helpLabel.setText(editorInstructionText);
        } else {
            this.helpLabel.setVisible(false);
        }
    }

    @Override
    public Object getValue() {
        if (this.selectorAdapter.getType(this.propertyName) == 2 || this.selectorAdapter.getType(this.propertyName) == 3) {
            return StringToMissingValuesTransform.defaultInstance.transform((Object)this.valueField.getText());
        }
        return this.valueField.getText();
    }
}

