/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.propertyeditor;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.dataselectors.propertyeditor.EditorPanelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.EntityAttributeValueModelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.PropertyValueInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.RB;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

@SASScope(value="ALL")
public class SingleSelectionListEditorPanel
extends JPanel
implements EditorPanelInterface,
PropertyChangeListener {
    protected JList singleList;
    protected Map propertyModelMap;
    protected boolean newModel;

    public SingleSelectionListEditorPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 5, 0, true, false, true);
        this.setLayout(layout);
        this.add(this.makePanel());
        this.newModel = false;
    }

    protected JPanel makePanel() {
        JPanel singleListContainer = new JPanel();
        AutoSizingGridLayout singleListLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        singleListContainer.setLayout(singleListLayout);
        this.singleList = new JList();
        this.singleList.setSelectionMode(0);
        this.singleList.getAccessibleContext().setAccessibleName("valueList");
        JLabel singleLabel = Util.createLabelForComponent(this.singleList, RB.getStringResource("value.txt"));
        JScrollPane listPane = new JScrollPane(this.singleList);
        listPane.setVerticalScrollBarPolicy(20);
        listPane.setHorizontalScrollBarPolicy(30);
        listPane.setPreferredSize(new Dimension(200, 150));
        singleLabel.setLabelFor(listPane);
        singleListContainer.add(singleLabel);
        singleListContainer.add(listPane);
        this.singleList.addPropertyChangeListener(this);
        return singleListContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModel(EntityAttributeValueModelInterface selectorAdapter, String propertyName) {
        this.newModel = true;
        if (this.propertyModelMap == null) {
            this.propertyModelMap = new HashMap();
        }
        if (this.propertyModelMap.containsKey(propertyName)) {
            this.singleList.setModel((DefaultListModel)this.propertyModelMap.get(propertyName));
        } else {
            List listValues = new ArrayList();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                listValues = selectorAdapter.getAvailableValues(propertyName);
            }
            catch (Exception exception) {
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            DefaultListModel<PropertyValueInterface> listModel = new DefaultListModel<PropertyValueInterface>();
            int listSize = listValues.size();
            for (int i = 0; i < listSize; ++i) {
                PropertyValueInterface dvi = (PropertyValueInterface)listValues.get(i);
                listModel.addElement(dvi);
            }
            this.propertyModelMap.put(propertyName, listModel);
            this.singleList.setModel(listModel);
        }
        List selectedValuesList = selectorAdapter.getSelectedValues(propertyName);
        DefaultListModel model = (DefaultListModel)this.singleList.getModel();
        int modelSize = model.size();
        if (selectedValuesList.size() > 0) {
            PropertyValueInterface selectedValue = (PropertyValueInterface)selectedValuesList.get(0);
            for (int i = 0; i < modelSize; ++i) {
                PropertyValueInterface dvii = (PropertyValueInterface)model.getElementAt(i);
                Object selectedUnformattedValue = selectedValue.getUnformattedValue();
                Object unformattedValue = dvii.getUnformattedValue();
                if (selectedUnformattedValue != null && unformattedValue != null) {
                    if (!selectedUnformattedValue.equals(unformattedValue) || !selectedValue.getFormattedValue().equals(dvii.getFormattedValue())) continue;
                    this.singleList.setSelectedIndex(i);
                    continue;
                }
                if (selectedUnformattedValue != null || unformattedValue != null || !selectedValue.getFormattedValue().equals(dvii.getFormattedValue())) continue;
                this.singleList.setSelectedIndex(i);
            }
            if (this.singleList.getSelectedIndex() == -1) {
                this.singleList.setSelectedIndex(0);
            }
        } else if (modelSize > 0) {
            this.singleList.setSelectedIndex(0);
        }
    }

    @Override
    public Object getValue() {
        return this.singleList.getSelectedValue();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("model")) {
            this.newModel = true;
        }
    }
}

