/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.propertyeditor;

import com.sas.codepolicy.SASScope;
import com.sas.swing.visuals.CheckBoxList;
import com.sas.swing.visuals.dataselectors.propertyeditor.EditorPanelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.EntityAttributeValueModelInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.PropertyValueInterface;
import com.sas.swing.visuals.dataselectors.propertyeditor.RB;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@SASScope(value="ALL")
public class MultiSelectionListEditorPanel
extends JPanel
implements EditorPanelInterface,
PropertyChangeListener {
    protected CheckBoxList multiList;
    protected Map labelValueMap;
    protected Map propertyModelMap;
    protected ListSelectionListener selectionListener;
    protected boolean newModel;
    protected DefaultListModel listModel;
    protected Object value;

    public MultiSelectionListEditorPanel() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 5, 0, true, false, true);
        this.setLayout(layout);
        this.add(this.makePanel());
        this.createListeners();
        this.newModel = false;
    }

    protected JPanel makePanel() {
        JPanel multiListContainer = new JPanel();
        AutoSizingGridLayout multiListLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, false, true);
        multiListContainer.setLayout(multiListLayout);
        this.multiList = new CheckBoxList();
        this.multiList.getAccessibleContext().setAccessibleName("valueList");
        JScrollPane multilistPane = new JScrollPane(this.multiList);
        JLabel multiLabel = Util.createLabelForComponent(this.multiList, RB.getStringResource("values.txt"));
        multilistPane.setPreferredSize(new Dimension(200, 150));
        multilistPane.setVerticalScrollBarPolicy(20);
        multilistPane.setHorizontalScrollBarPolicy(30);
        multiListContainer.add(multiLabel);
        multiListContainer.add(multilistPane);
        multiLabel.setLabelFor(this.multiList);
        return multiListContainer;
    }

    protected void createListeners() {
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!MultiSelectionListEditorPanel.this.newModel) {
                    Object[] selectedValues = MultiSelectionListEditorPanel.this.multiList.getSelectedValues();
                    MultiSelectionListEditorPanel.this.value = Arrays.asList(selectedValues);
                }
                MultiSelectionListEditorPanel.this.newModel = false;
            }
        };
        this.multiList.addPropertyChangeListener(this);
        this.multiList.addListSelectionListener(selectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModel(EntityAttributeValueModelInterface selectorAdapter, String propertyName) {
        this.newModel = true;
        if (this.propertyModelMap == null) {
            this.propertyModelMap = new HashMap();
        }
        if (this.propertyModelMap.containsKey(propertyName)) {
            this.multiList.setModel((DefaultListModel)this.propertyModelMap.get(propertyName));
        } else {
            List listValues = new ArrayList();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                listValues = selectorAdapter.getAvailableValues(propertyName);
            }
            catch (Exception exception) {
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.listModel = new DefaultListModel();
            int listSize = listValues.size();
            if (this.labelValueMap == null) {
                this.labelValueMap = new HashMap();
            }
            for (int i = 0; i < listSize; ++i) {
                PropertyValueInterface dvi = (PropertyValueInterface)listValues.get(i);
                this.labelValueMap.put(dvi.getFormattedValue(), dvi.getUnformattedValue());
                this.listModel.addElement(dvi);
            }
            this.propertyModelMap.put(propertyName, this.listModel);
            this.multiList.setModel(this.listModel);
        }
        List selectedValuesList = selectorAdapter.getSelectedValues(propertyName);
        int selectedValuesListSize = selectedValuesList.size();
        int[] selectedIndices = new int[selectedValuesListSize];
        DefaultListModel model = (DefaultListModel)this.multiList.getModel();
        int modelSize = model.size();
        for (int i = 0; i < selectedValuesListSize; ++i) {
            for (int j = 0; j < modelSize; ++j) {
                PropertyValueInterface selectedValue;
                PropertyValueInterface dvii = (PropertyValueInterface)model.getElementAt(j);
                if (!dvii.equals(selectedValue = (PropertyValueInterface)selectedValuesList.get(i), Locale.getDefault())) continue;
                selectedIndices[i] = j;
            }
        }
        if (selectedIndices.length > 0) {
            this.multiList.setSelectedIndices(selectedIndices);
        } else if (modelSize > 0) {
            this.multiList.setSelectedIndices(new int[]{0});
        }
    }

    @Override
    public Object getValue() {
        return Arrays.asList(this.multiList.getSelectedValues());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("model")) {
            this.newModel = true;
        }
    }
}

