/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.FilterException;
import com.sas.dataselectors.filters.OLAPMemberTreePathFactoryInterface;
import com.sas.swing.visuals.dataselectors.filters.RB;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

@SASScope
public class StartEndDatePanel
extends JPanel
implements ActionListener,
TreeSelectionListener {
    public static final String RB_KEY = "StartEndDatePanel.";
    public static final String OLAP_PANEL_RB_KEY = "OLAPRelativeTimeFilterPanel.";
    public static final int TYPE_STARTING = 0;
    public static final int TYPE_ENDING = 1;
    public static final int ITEM_FIRST_LAST_UNIT = 0;
    public static final int ITEM_SELECTED_UNIT = 1;
    protected final int dateTextFieldCols = 7;
    protected final int timeTextFieldCols = 6;
    protected final int unitTextFieldCols = 4;
    protected JLabel startEndLabel;
    protected JRadioButton firstLastRadioButton;
    protected JLabel firstLastLabel;
    protected JRadioButton selectedRadioButton;
    protected JScrollPane selectedTreeScrollPane;
    protected JTree selectedTree;
    protected static final int hGap = 10;
    protected static final int vGap = 5;
    protected static final String SELECTION_CHANGED = "selectionChanged";
    protected int type;
    protected int selectedItem;
    protected String startingUnitLabel;
    protected String firstUnitLabel;
    protected String endingUnitLabel;
    protected String lastUnitLabel;
    protected String selectedUnitLabel;
    protected String firstLastValue;
    protected GregorianCalendar calendar;
    protected TreePath previousSelectedPath;

    public StartEndDatePanel() {
        this.calendar = new GregorianCalendar();
        this.init();
    }

    public StartEndDatePanel(GregorianCalendar date) {
        this.calendar = date;
        this.init();
    }

    protected void init() {
        this.previousSelectedPath = null;
        this.createComponents();
        this.layoutComponents();
        this.adjustComponents();
        this.addListeners();
        this.setType(0);
        this.setSensitivities();
    }

    protected void createComponents() {
        this.startEndLabel = new JLabel();
        this.firstLastRadioButton = new JRadioButton("", true);
        this.firstLastLabel = new JLabel();
        this.selectedRadioButton = new JRadioButton();
        this.selectedTree = new JTree();
        this.selectedTree.setVisibleRowCount(9);
        this.selectedTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TreePath newPath = event.getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)newPath.getLastPathComponent();
                if (node.getChildCount() != 0) {
                    if (StartEndDatePanel.this.previousSelectedPath != null) {
                        if (!StartEndDatePanel.this.previousSelectedPath.equals(newPath)) {
                            StartEndDatePanel.this.selectedTree.setExpandsSelectedPaths(false);
                            StartEndDatePanel.this.selectedTree.setSelectionPath(StartEndDatePanel.this.previousSelectedPath);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    StartEndDatePanel.this.selectedTree.setExpandsSelectedPaths(true);
                                }
                            });
                        }
                    } else {
                        StartEndDatePanel.this.selectedTree.clearSelection();
                    }
                } else {
                    StartEndDatePanel.this.previousSelectedPath = newPath;
                }
            }
        });
        this.selectedTreeScrollPane = new JScrollPane(this.selectedTree);
    }

    protected void setAccessibleNames() {
        String prefix = "";
        if (this.type == 0) {
            prefix = "starting_";
        } else if (this.type == 1) {
            prefix = "ending_";
        }
        this.firstLastRadioButton.getAccessibleContext().setAccessibleName(prefix + "firstLastRadioButton");
        this.selectedRadioButton.getAccessibleContext().setAccessibleName(prefix + "selectedRadioButton");
        this.selectedTree.getAccessibleContext().setAccessibleName(prefix + "selectedTree");
        this.selectedTreeScrollPane.getAccessibleContext().setAccessibleName(prefix + "selectedTreeScrollPane");
    }

    protected void layoutComponents() {
        int rows = 0;
        int cols = 1;
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(rows, cols, 10, 0, true, false, false);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout(mainLayout);
        this.setBorder(new EmptyBorder(new Insets(0, 10, 5, 10)));
        this.add(this.startEndLabel);
        this.add(this.firstLastRadioButton);
        this.add(this.firstLastLabel);
        this.add(this.selectedRadioButton);
        JPanel treePanel = new JPanel();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(rows, 2, 10, 5, true, false, true);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        treePanel.setLayout(layout);
        this.add(treePanel);
        JPanel leftPadding = new JPanel();
        leftPadding.setPreferredSize(new Dimension(10, 0));
        treePanel.add(leftPadding);
        treePanel.add(this.selectedTreeScrollPane);
        ButtonGroup group = new ButtonGroup();
        group.add(this.firstLastRadioButton);
        group.add(this.selectedRadioButton);
    }

    protected void adjustComponents() {
        Insets insets = this.firstLastRadioButton.getBorder().getBorderInsets(this.firstLastRadioButton);
        this.firstLastRadioButton.setBorder(new EmptyBorder(insets.top, insets.left, 0, insets.right));
        this.firstLastLabel.setBorder(new EmptyBorder(0, 20, 0, 0));
    }

    protected void addListeners() {
        this.firstLastRadioButton.addActionListener(this);
        this.selectedRadioButton.addActionListener(this);
        this.selectedTree.addTreeSelectionListener(this);
    }

    protected void removeListeners() {
        this.firstLastRadioButton.removeActionListener(this);
        this.selectedRadioButton.removeActionListener(this);
        this.selectedTree.removeTreeSelectionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.firstLastRadioButton) {
            this.updateTree();
            this.setSelectedItem(0);
        } else if (source == this.selectedRadioButton) {
            this.updateTree();
            this.setSelectedItem(1);
        }
        this.firePropertyChange(SELECTION_CHANGED, null, null);
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        this.firePropertyChange(SELECTION_CHANGED, null, null);
    }

    public void setUnitLabels(String startingLabel, String firstLabel, String endingLabel, String lastLabel, String selectedLabel) {
        this.startingUnitLabel = startingLabel;
        this.endingUnitLabel = endingLabel;
        this.firstUnitLabel = firstLabel;
        this.lastUnitLabel = lastLabel;
        this.selectedUnitLabel = selectedLabel;
        this.updateComponents();
    }

    public void setFirstLastValue(String value) {
        this.firstLastValue = value;
        this.updateComponents();
    }

    public void setType(int type) {
        this.type = type;
        this.updateComponents();
        this.setAccessibleNames();
    }

    public void setSelectedItem(int item) {
        this.selectedItem = item;
        this.firstLastRadioButton.setSelected(this.selectedItem == 0);
        this.selectedRadioButton.setSelected(this.selectedItem == 1);
        this.setSensitivities();
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedDateTreePath(TreePath path) {
        try {
            this.removeListeners();
            this.selectedTree.setSelectionPath(path);
            this.previousSelectedPath = null;
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StartEndDatePanel.this.addListeners();
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public TreePath getSelectedDateTreePath() {
        return this.selectedTree.getSelectionPath();
    }

    public void setSelectedDate(String memberName) {
        TreeModel treeModel = this.selectedTree.getModel();
        if (treeModel instanceof OLAPMemberTreePathFactoryInterface) {
            OLAPMemberTreePathFactoryInterface pathFactory = (OLAPMemberTreePathFactoryInterface)((Object)treeModel);
            try {
                List pathList = pathFactory.getTreePathNodeList(memberName);
                if (pathList != null) {
                    DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)pathList.get(pathList.size() - 1);
                    TreePath path = new TreePath(lastNode.getPath());
                    this.setSelectedDateTreePath(path);
                }
            }
            catch (FilterException filterException) {
                // empty catch block
            }
        }
    }

    protected void updateComponents() {
        if (this.type == 0) {
            this.startEndLabel.setText(this.startingUnitLabel);
            this.firstLastRadioButton.setText(this.firstUnitLabel);
            String s = MessageFormat.format(RB.getStringResource(RB_KEY, "unitValue.txt"), this.firstLastValue);
            this.firstLastLabel.setText(s);
        } else {
            this.startEndLabel.setText(this.endingUnitLabel);
            this.firstLastRadioButton.setText(this.lastUnitLabel);
            String s = MessageFormat.format(RB.getStringResource(RB_KEY, "unitValue.txt"), this.firstLastValue);
            this.firstLastLabel.setText(s);
        }
        this.selectedRadioButton.setText(this.selectedUnitLabel);
        this.updateTree();
    }

    protected void updateTree() {
        if (this.selectedRadioButton.isSelected()) {
            this.selectedTree.setVisible(true);
        } else {
            this.selectedTree.setVisible(false);
        }
    }

    public void setTree(TreeModel treeModel) {
        this.selectedTree.setModel(treeModel);
        this.selectedTree.setRootVisible(false);
        this.selectedTree.setShowsRootHandles(true);
        this.selectedTree.getSelectionModel().setSelectionMode(1);
        this.selectedTree.setExpandsSelectedPaths(true);
        this.previousSelectedPath = null;
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        renderer.setIconTextGap(0);
        this.selectedTree.setCellRenderer(renderer);
    }

    protected void setSensitivities() {
        this.selectedTree.setEnabled(this.selectedRadioButton.isSelected());
    }

    public boolean isSelectionComplete() {
        return this.selectedItem != 1 || this.getSelectedDateTreePath() != null;
    }
}

