/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.codepolicy.SASScope;
import com.sas.dataselectors.filters.timebased.TimePeriod;
import com.sas.dataselectors.filters.timebased.TimePeriodType;
import com.sas.swing.visuals.dataselectors.filters.RB;
import com.sas.swing.visuals.dataselectors.filters.RelationalRelativeDatePanel;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

@SASScope(value="ALL")
public class RelationalRelativeTimeFilterPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
KeyListener {
    public static final String RB_KEY = "RelationalRelativeTimeFilterPanel.";
    public static final int TYPE_SINGLE_VALUE = 0;
    public static final int TYPE_STARTING_ENDING = 1;
    public static final int SHOW_LAST = 0;
    public static final int SHOW_NEXT = 1;
    protected int type;
    protected boolean timeBased;
    protected boolean singleDayResult;
    protected int daySelectedInStartTimePeriod;
    protected int daySelectedInEndTimePeriod;
    protected final int dateTextFieldCols = 7;
    protected final int timeTextFieldCols = 6;
    protected final int unitTextFieldCols = 4;
    protected JPanel showLastPanel;
    protected JLabel showLastLabel;
    protected JLabel notIncludingCurrentLabel;
    protected JTextField showLastTextField;
    protected JComboBox showLastComboBox;
    protected boolean ignoreDatePanelEvents = false;
    protected static String SHOW_THE_PREVIOUS = RB.getStringResource("RelationalRelativeTimeFilterPanel.", "showThePrevious.txt");
    protected static String SHOW_THE_NEXT = RB.getStringResource("RelationalRelativeTimeFilterPanel.", "showTheNext.txt");
    protected static String NOT_INCLUDING_CURRENT = RB.getStringResource("RelationalRelativeTimeFilterPanel.", "notIncludingCurrent.txt");
    protected static String DAY = RB.getStringResource("RelationalRelativeTimeFilterPanel.", "day.txt");
    protected static String MINUTE = RB.getStringResource("RelationalRelativeTimeFilterPanel.", "minute.txt");
    protected JPanel datePanel;
    protected RelationalRelativeDatePanel date1Panel;
    protected RelationalRelativeDatePanel date2Panel;
    protected TimeZone timeZone;
    protected static final int hGap = 10;
    protected static final int vGap = 10;
    public static final String SELECTION_CHANGED = "selectionChanged";

    public RelationalRelativeTimeFilterPanel() {
        this((TimeZone)null);
    }

    public RelationalRelativeTimeFilterPanel(TimeZone timeZone) {
        this.setTimeZone(timeZone);
        this.createComponents();
        this.layoutComponents();
        this.addListeners();
        this.setTimeBased(false);
        this.setSingleDayResult(false);
    }

    public void setType(int type) {
        if (type < 0 || type > 1) {
            throw new IllegalArgumentException("The type must be either TYPE_SINGLE_VALUE or TYPE_STARTING_ENDING");
        }
        this.type = type;
        switch (type) {
            case 0: {
                this.date1Panel.setType(0);
                this.date2Panel.setVisible(false);
                break;
            }
            case 1: {
                this.date1Panel.setType(1);
                this.date2Panel.setType(2);
                this.date2Panel.setVisible(true);
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public void setTimeBased(boolean mode) {
        String notIncludingCurrent = Message.format((String)NOT_INCLUDING_CURRENT, (Object)(mode ? MINUTE : DAY));
        this.notIncludingCurrentLabel.setText(notIncludingCurrent);
        if (this.timeBased == mode) {
            return;
        }
        this.timeBased = mode;
        this.buildNPeriods();
        this.date1Panel.setTimeBased(this.timeBased);
        this.date2Panel.setTimeBased(this.timeBased);
    }

    public boolean getTimeBased() {
        return this.timeBased;
    }

    public void setSingleDayResult(boolean mode) {
        if (this.singleDayResult == mode) {
            return;
        }
        this.singleDayResult = mode;
        this.date1Panel.setSingleDayResult(mode);
        this.date2Panel.setSingleDayResult(mode);
    }

    public boolean getSingleDayResult() {
        return this.singleDayResult;
    }

    @SASScope
    public void setWeekStartingDay(int weekStartingDay) {
        this.date1Panel.setWeekStartingDay(weekStartingDay);
        this.date2Panel.setWeekStartingDay(weekStartingDay);
    }

    @SASScope
    public int getWeekStartingDay() {
        return this.date1Panel.getWeekStartingDay();
    }

    public void setDaySelectedInStartTimePeriod(int value) throws IllegalArgumentException {
        if (value != 1 && value != 2 && value != 0) {
            throw new IllegalArgumentException("Invalid parameter to setDaySelectedInStartTimePeriod. Must be DAY_FIRST or DAY_LAST or DAY_UNDEFINED");
        }
        this.daySelectedInStartTimePeriod = value;
        this.date1Panel.setDaySelectedInTimePeriod(value);
    }

    public void setDaySelectedInTimePeriod(int value) throws IllegalArgumentException {
        this.setDaySelectedInStartTimePeriod(value);
    }

    public int getDaySelectedInStartTimePeriod() {
        return this.daySelectedInStartTimePeriod;
    }

    public int getDaySelectedInTimePeriod() {
        return this.getDaySelectedInStartTimePeriod();
    }

    public void setDaySelectedInEndTimePeriod(int value) throws IllegalArgumentException {
        if (value != 1 && value != 2 && value != 0) {
            throw new IllegalArgumentException("Invalid parameter to setDaySelectedInEndTimePeriod. Must be DAY_FIRST or DAY_LAST or DAY_UNDEFINED");
        }
        this.daySelectedInEndTimePeriod = value;
        this.date2Panel.setDaySelectedInTimePeriod(value);
    }

    public int getDaySelectedInEndTimePeriod() {
        return this.daySelectedInEndTimePeriod;
    }

    public void showNPeriodsPanel(boolean show) {
        this.showLastPanel.setVisible(show);
    }

    public void setShowNPeriodsType(int type) {
        if (type == 0) {
            this.showLastLabel.setText(SHOW_THE_PREVIOUS);
        } else if (type == 1) {
            this.showLastLabel.setText(SHOW_THE_NEXT);
        } else {
            throw new IllegalArgumentException("The \"Show N Periods\" type must be either SHOW_LAST or SHOW_NEXT");
        }
    }

    public RelationalRelativeDatePanel getDate1Panel() {
        return this.date1Panel;
    }

    public RelationalRelativeDatePanel getDate2Panel() {
        return this.date2Panel;
    }

    public void setShowLastNPeriodsValue(int value) {
        this.showLastTextField.setText("" + value);
    }

    public int getShowLastNPeriodsValue() {
        try {
            return Integer.parseInt(this.showLastTextField.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setShowLastNPeriodsType(TimePeriodType type) {
        if (type == null) {
            return;
        }
        this.showLastComboBox.setSelectedItem(type.getLabel());
    }

    public TimePeriodType getShowLastNPeriodsType() {
        String label = (String)this.showLastComboBox.getSelectedItem();
        return TimePeriodType.findByLabel(label);
    }

    public List getSelectedValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(this.date1Panel.getSelection());
        if (this.type == 1) {
            values.add(this.date2Panel.getSelection());
        }
        return values;
    }

    public void setSelectedValues(List values) {
        if (values == null || values.size() == 0) {
            return;
        }
        this.setType(values.size() > 1 ? 1 : 0);
        this.date1Panel.setSelection(values.get(0));
        if (values.size() > 1) {
            this.date2Panel.setSelection(values.get(1));
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    protected void createComponents() {
        this.createShowLastPanel();
        this.createDatePanels();
    }

    protected void createShowLastPanel() {
        this.showLastPanel = new JPanel();
        this.showLastLabel = new JLabel(SHOW_THE_PREVIOUS);
        this.showLastTextField = new JTextField("", 3);
        this.showLastTextField.getAccessibleContext().setAccessibleName("showLastTextField");
        this.showLastComboBox = new JComboBox();
        this.showLastComboBox.getAccessibleContext().setAccessibleName("showLastComboBox");
        this.notIncludingCurrentLabel = new JLabel();
        this.buildNPeriods();
    }

    protected void buildNPeriods() {
        this.showLastComboBox.removeAllItems();
        this.showLastComboBox.addItem(TimePeriodType.YEARS.getLabel());
        this.showLastComboBox.addItem(TimePeriodType.MONTHS.getLabel());
        this.showLastComboBox.addItem(TimePeriodType.WEEKS.getLabel());
        this.showLastComboBox.addItem(TimePeriodType.DAYS.getLabel());
        if (this.timeBased) {
            this.showLastComboBox.addItem(TimePeriodType.HOURS.getLabel());
            this.showLastComboBox.addItem(TimePeriodType.MINUTES.getLabel());
        }
    }

    protected void createDatePanels() {
        this.datePanel = new JPanel();
        this.date1Panel = new RelationalRelativeDatePanel(this.timeZone);
        this.date2Panel = new RelationalRelativeDatePanel(this.timeZone);
    }

    protected void layoutComponents() {
        int rows = 0;
        int cols = 1;
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(rows, cols, 10, 0, true, false, false);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout(mainLayout);
        this.layoutShowLastPanel();
        this.layoutDatePanels();
    }

    protected void layoutShowLastPanel() {
        this.add(this.showLastPanel);
        int rows = 0;
        int cols = 4;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(rows, cols, 10, 10, true, false, false);
        layout.setDefaultCellGravity(256);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.showLastPanel.setLayout(layout);
        this.showLastPanel.add(this.showLastLabel);
        this.showLastPanel.add(this.showLastTextField);
        this.showLastPanel.add(this.showLastComboBox);
        this.showLastPanel.add(this.notIncludingCurrentLabel);
    }

    protected void layoutDatePanels() {
        this.add(this.datePanel);
        int rows = 0;
        int cols = 2;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(rows, cols, 20, 0, true, false, false);
        layout.setIgnoreSizeOfNonVisibleComponents(true);
        this.datePanel.setLayout(layout);
        this.datePanel.add(this.date1Panel);
        this.datePanel.add(this.date2Panel);
    }

    protected void addListeners() {
        this.showLastTextField.addKeyListener(this);
        this.showLastComboBox.addActionListener(this);
        this.date1Panel.addPropertyChangeListener(this);
        this.date2Panel.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.showLastComboBox) {
            String label = (String)this.showLastComboBox.getSelectedItem();
            if (this.date1Panel.getSelectedPeriod() == TimePeriod.PERIOD_N_PERIODS_AGO) {
                this.date1Panel.setNPeriodsType(TimePeriodType.findByLabel(label));
                this.date2Panel.updateCalendarCurrentDate();
            }
            if (this.date2Panel.getSelectedPeriod() == TimePeriod.PERIOD_N_PERIODS_FROM_NOW) {
                this.date2Panel.setNPeriodsType(TimePeriodType.findByLabel(label));
                this.date1Panel.updateCalendarCurrentDate();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (evt.getSource() == this.showLastTextField) {
            int nPeriods = this.getShowLastNPeriodsValue();
            if (this.date1Panel.getSelectedPeriod() == TimePeriod.PERIOD_N_PERIODS_AGO) {
                this.date1Panel.setNPeriodsValue(nPeriods);
                this.date2Panel.updateCalendarCurrentDate();
            }
            if (this.date2Panel.getSelectedPeriod() == TimePeriod.PERIOD_N_PERIODS_FROM_NOW) {
                this.date2Panel.setNPeriodsValue(nPeriods);
                this.date1Panel.updateCalendarCurrentDate();
            }
            this.firePropertyChange(SELECTION_CHANGED, null, null);
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.date1Panel) {
            if (evt.getPropertyName().equals(SELECTION_CHANGED) && !this.ignoreDatePanelEvents) {
                this.firePropertyChange(SELECTION_CHANGED, null, null);
                if (this.date2Panel.getRadioSelection() == 1) {
                    this.ignoreDatePanelEvents = true;
                    this.date2Panel.updateCalendarCurrentDate();
                    this.ignoreDatePanelEvents = false;
                }
            }
        } else if (evt.getSource() == this.date2Panel && evt.getPropertyName().equals(SELECTION_CHANGED) && !this.ignoreDatePanelEvents) {
            this.firePropertyChange(SELECTION_CHANGED, null, null);
            if (this.date1Panel.getRadioSelection() == 1) {
                this.ignoreDatePanelEvents = true;
                this.date1Panel.updateCalendarCurrentDate();
                this.ignoreDatePanelEvents = false;
            }
        }
    }

    @SASScope
    public void redraw() {
        this.date1Panel.redraw();
        if (this.date2Panel.isVisible()) {
            this.date2Panel.redraw();
        }
    }

    public static void main(String[] argv) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JDialog dialog = new JDialog();
        dialog.setModal(true);
        RelationalRelativeTimeFilterPanel filterPanel = new RelationalRelativeTimeFilterPanel();
        filterPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        dialog.getContentPane().add(filterPanel);
        dialog.pack();
        dialog.show();
        System.exit(0);
    }
}

