/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals.dataselectors.filters;

import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.swing.visuals.dataselectors.filters.AdvancedFilterSelectorPanel;
import com.sas.swing.visuals.dataselectors.filters.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.visuals.AutoSizingGridLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DateTimeValuePanel
extends JComponent
implements LayoutConstants,
ActionListener {
    private static final int START_DATE = 3;
    private static final int END_DATE = 5;
    public static final String RB_KEY = "DateTimeValuePanel.";
    protected JComboBox day1;
    protected JComboBox month1;
    protected JTextField year1;
    protected JComboBox hour1;
    protected JComboBox minute1;
    protected JComboBox second1;
    protected JComboBox day2;
    protected JComboBox month2;
    protected JTextField year2;
    protected JComboBox hour2;
    protected JComboBox minute2;
    protected JComboBox second2;
    protected JLabel startLabel;
    protected JLabel endLabel;
    protected JLabel dayLabel;
    protected JLabel monthLabel;
    protected JLabel yearLabel;
    protected JLabel hourLabel;
    protected JLabel minuteLabel;
    protected JLabel secondLabel;
    protected Calendar calendar1;
    protected Calendar calendar2;
    protected Integer[] minutesSeconds;
    protected Integer[] hours;
    protected Integer[] days;
    protected String[] months;
    private long dateType;
    private Calendar currentCalendar;
    protected final String startDateText = RB.getStringResource("DateTimeValuePanel.", "startDateLabel.txt");
    protected final String endDateText = RB.getStringResource("DateTimeValuePanel.", "endDateLabel.txt");
    protected final String startTimeText = RB.getStringResource("DateTimeValuePanel.", "startTimeLabel.txt");
    protected final String endTimeText = RB.getStringResource("DateTimeValuePanel.", "endTimeLabel.txt");
    protected final String startDateTimeText = RB.getStringResource("DateTimeValuePanel.", "startDateTimeLabel.txt");
    protected final String endDateTimeText = RB.getStringResource("DateTimeValuePanel.", "endDateTimeLabel.txt");
    protected final String dateText = RB.getStringResource("DateTimeValuePanel.", "dateLabel.txt");
    protected final String timeText = RB.getStringResource("DateTimeValuePanel.", "timeLabel.txt");
    protected final String dateTimeText = RB.getStringResource("DateTimeValuePanel.", "dateTimeLabel.txt");
    protected AdvancedFilterSelectorPanel filterDefinitionPanel;
    protected boolean isEndDateVisible;
    private boolean ignoreDateFieldEvents;

    public DateTimeValuePanel(AdvancedFilterSelectorPanel filterDefinitionPanel) {
        this.filterDefinitionPanel = filterDefinitionPanel;
        this.calendar1 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        this.calendar2 = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        this.currentCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        this.createComponents();
        this.dateType = 4L;
        this.isEndDateVisible = true;
        this.setUpDateTimeFields(this.isEndDateVisible, this.dateType);
        this.addListeners();
    }

    protected void createComponents() {
        SingleDigitValueRenderer renderer = new SingleDigitValueRenderer();
        this.month1 = new JComboBox<String>(this.getMonths());
        this.day1 = new JComboBox<Integer>(this.getDays());
        this.day1.setRenderer(renderer);
        this.day1.setPreferredSize(this.month1.getPreferredSize());
        this.year1 = new JTextField();
        this.year1.setDocument(new NumberDocument());
        this.hour1 = new JComboBox<Integer>(this.getHours());
        this.hour1.setRenderer(renderer);
        this.hour1.setPreferredSize(this.month1.getPreferredSize());
        this.hour1.setSelectedIndex(12);
        this.minute1 = new JComboBox<Integer>(this.getMinutes_Seconds());
        this.minute1.setPreferredSize(this.month1.getPreferredSize());
        this.minute1.setRenderer(renderer);
        this.second1 = new JComboBox<Integer>(this.getMinutes_Seconds());
        this.second1.setPreferredSize(this.month1.getPreferredSize());
        this.second1.setRenderer(renderer);
        this.month2 = new JComboBox<String>(this.getMonths());
        this.day2 = new JComboBox<Integer>(this.days);
        this.day2.setPreferredSize(this.month1.getPreferredSize());
        this.day2.setRenderer(renderer);
        this.year2 = new JTextField();
        this.year2.setDocument(new NumberDocument());
        this.hour2 = new JComboBox<Integer>(this.getHours());
        this.hour2.setRenderer(renderer);
        this.hour2.setPreferredSize(this.month2.getPreferredSize());
        this.hour2.setSelectedIndex(12);
        this.minute2 = new JComboBox<Integer>(this.getMinutes_Seconds());
        this.minute2.setPreferredSize(this.month1.getPreferredSize());
        this.minute2.setRenderer(renderer);
        this.second2 = new JComboBox<Integer>(this.getMinutes_Seconds());
        this.second2.setPreferredSize(this.month1.getPreferredSize());
        this.second2.setRenderer(renderer);
        this.dayLabel = new JLabel(RB.getStringResource(RB_KEY, "dayLabel.txt"));
        this.dayLabel.setLabelFor(this.day1);
        this.monthLabel = new JLabel(RB.getStringResource(RB_KEY, "monthLabel.txt"));
        this.monthLabel.setLabelFor(this.month1);
        this.yearLabel = new JLabel(RB.getStringResource(RB_KEY, "yearLabel.txt"));
        this.yearLabel.setLabelFor(this.year1);
        this.hourLabel = new JLabel(RB.getStringResource(RB_KEY, "hourLabel.txt"));
        this.hourLabel.setLabelFor(this.hour1);
        this.minuteLabel = new JLabel(RB.getStringResource(RB_KEY, "minuteLabel.txt"));
        this.minuteLabel.setLabelFor(this.minute1);
        this.secondLabel = new JLabel(RB.getStringResource(RB_KEY, "secondLabel.txt"));
        this.secondLabel.setLabelFor(this.secondLabel);
        this.startLabel = new JLabel(this.startDateText);
        this.endLabel = new JLabel(this.endDateText);
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(7, 3, 5, 5, true, false, false);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this.setLayout(mainLayout);
        this.add(new JLabel());
        this.add(this.startLabel);
        this.add(this.endLabel);
        this.add(this.dayLabel);
        this.add(this.day1);
        this.add(this.day2);
        this.add(this.monthLabel);
        this.add(this.month1);
        this.add(this.month2);
        this.add(this.yearLabel);
        this.add(this.year1);
        this.add(this.year2);
        this.add(this.hourLabel);
        this.add(this.hour1);
        this.add(this.hour2);
        this.add(this.minuteLabel);
        this.add(this.minute1);
        this.add(this.minute2);
        this.add(this.secondLabel);
        this.add(this.second1);
        this.add(this.second2);
    }

    private void addListeners() {
        this.day1.addActionListener(this);
        this.day2.addActionListener(this);
        this.month1.addActionListener(this);
        this.month2.addActionListener(this);
        this.hour1.addActionListener(this);
        this.hour2.addActionListener(this);
        this.minute1.addActionListener(this);
        this.minute2.addActionListener(this);
        this.second1.addActionListener(this);
        this.second2.addActionListener(this);
        InnerDocumentListener myDocumentListener = new InnerDocumentListener();
        this.year1.getDocument().addDocumentListener(myDocumentListener);
        this.year2.getDocument().addDocumentListener(myDocumentListener);
    }

    protected boolean isSelectionComplete() {
        String endYear;
        String startYear = this.year1.getText();
        if (this.year1.isVisible() && (startYear == null || startYear.length() == 0)) {
            return false;
        }
        return !this.isEndDateVisible || !this.year2.isVisible() || (endYear = this.year2.getText()) != null && endYear.length() != 0;
    }

    private String[] getMonths() {
        if (this.months == null) {
            this.months = new String[12];
            this.months[0] = RB.getStringResource(RB_KEY, "jan.txt");
            this.months[1] = RB.getStringResource(RB_KEY, "feb.txt");
            this.months[2] = RB.getStringResource(RB_KEY, "mar.txt");
            this.months[3] = RB.getStringResource(RB_KEY, "april.txt");
            this.months[4] = RB.getStringResource(RB_KEY, "may.txt");
            this.months[5] = RB.getStringResource(RB_KEY, "june.txt");
            this.months[6] = RB.getStringResource(RB_KEY, "july.txt");
            this.months[7] = RB.getStringResource(RB_KEY, "aug.txt");
            this.months[8] = RB.getStringResource(RB_KEY, "sept.txt");
            this.months[9] = RB.getStringResource(RB_KEY, "oct.txt");
            this.months[10] = RB.getStringResource(RB_KEY, "nov.txt");
            this.months[11] = RB.getStringResource(RB_KEY, "dec.txt");
        }
        return this.months;
    }

    private Integer[] getDays() {
        if (this.days == null) {
            this.days = new Integer[31];
            for (int i = 0; i < 31; ++i) {
                this.days[i] = new Integer(i + 1);
            }
        }
        return this.days;
    }

    private Integer[] getMinutes_Seconds() {
        if (this.minutesSeconds == null) {
            this.minutesSeconds = new Integer[60];
            for (int i = 0; i < 60; ++i) {
                this.minutesSeconds[i] = new Integer(i);
            }
        }
        return this.minutesSeconds;
    }

    private Integer[] getHours() {
        if (this.hours == null) {
            this.hours = new Integer[24];
            for (int i = 0; i < 24; ++i) {
                this.hours[i] = new Integer(i);
            }
        }
        return this.hours;
    }

    public void setUpDateTimeFields(boolean endDateVisible, long dateType) {
        this.isEndDateVisible = endDateVisible;
        this.dateType = dateType;
        this.setDefaults();
        if (dateType == 5L) {
            this.day1.setVisible(false);
            this.month1.setVisible(false);
            this.year1.setVisible(false);
            this.day2.setVisible(false);
            this.month2.setVisible(false);
            this.year2.setVisible(false);
            this.dayLabel.setVisible(false);
            this.monthLabel.setVisible(false);
            this.yearLabel.setVisible(false);
            this.hour1.setVisible(true);
            this.minute1.setVisible(true);
            this.second1.setVisible(true);
            this.hourLabel.setVisible(true);
            this.minuteLabel.setVisible(true);
            this.secondLabel.setVisible(true);
            this.hour2.setVisible(this.isEndDateVisible);
            this.minute2.setVisible(this.isEndDateVisible);
            this.second2.setVisible(this.isEndDateVisible);
            if (this.isEndDateVisible) {
                this.startLabel.setText(this.startTimeText);
                this.endLabel.setText(this.endTimeText);
            } else {
                this.startLabel.setText(this.timeText);
            }
        } else if (dateType == 4L) {
            this.hour1.setVisible(false);
            this.minute1.setVisible(false);
            this.second1.setVisible(false);
            this.hour2.setVisible(false);
            this.minute2.setVisible(false);
            this.second2.setVisible(false);
            this.hourLabel.setVisible(false);
            this.minuteLabel.setVisible(false);
            this.secondLabel.setVisible(false);
            this.day1.setVisible(true);
            this.month1.setVisible(true);
            this.year1.setVisible(true);
            this.dayLabel.setVisible(true);
            this.monthLabel.setVisible(true);
            this.yearLabel.setVisible(true);
            this.day2.setVisible(this.isEndDateVisible);
            this.month2.setVisible(this.isEndDateVisible);
            this.year2.setVisible(this.isEndDateVisible);
            if (this.isEndDateVisible) {
                this.startLabel.setText(this.startDateText);
                this.endLabel.setText(this.endDateText);
            } else {
                this.startLabel.setText(this.dateText);
            }
        } else if (dateType == 6L) {
            this.day1.setVisible(true);
            this.month1.setVisible(true);
            this.year1.setVisible(true);
            this.dayLabel.setVisible(true);
            this.monthLabel.setVisible(true);
            this.yearLabel.setVisible(true);
            this.hour1.setVisible(true);
            this.minute1.setVisible(true);
            this.second1.setVisible(true);
            this.hourLabel.setVisible(true);
            this.minuteLabel.setVisible(true);
            this.secondLabel.setVisible(true);
            this.day2.setVisible(this.isEndDateVisible);
            this.month2.setVisible(this.isEndDateVisible);
            this.year2.setVisible(this.isEndDateVisible);
            this.hour2.setVisible(this.isEndDateVisible);
            this.minute2.setVisible(this.isEndDateVisible);
            this.second2.setVisible(this.isEndDateVisible);
            if (this.isEndDateVisible) {
                this.startLabel.setText(this.startDateTimeText);
                this.endLabel.setText(this.endDateTimeText);
            } else {
                this.startLabel.setText(this.dateTimeText);
            }
        } else {
            this.day1.setVisible(false);
            this.month1.setVisible(false);
            this.year1.setVisible(false);
            this.day2.setVisible(false);
            this.month2.setVisible(false);
            this.year2.setVisible(false);
            this.hour1.setVisible(false);
            this.minute1.setVisible(false);
            this.second1.setVisible(false);
            this.hour2.setVisible(false);
            this.minute2.setVisible(false);
            this.second2.setVisible(false);
        }
        this.endLabel.setVisible(this.isEndDateVisible);
        this.firePropertyChange("selectionComplete", false, this.isSelectionComplete());
    }

    private void initializeFieldsWithDate(Object date, int interval) {
        Calendar calendar;
        this.ignoreDateFieldEvents = true;
        Calendar calendar2 = calendar = interval == 3 ? this.calendar1 : this.calendar2;
        if (date instanceof FilterValueInterface) {
            date = ((FilterValueInterface)date).getUnformattedValue();
        }
        if (date instanceof Date) {
            calendar.setTime((Date)date);
            if (this.dateType == 5L || this.dateType == 6L) {
                if (interval == 3) {
                    this.hour1.setSelectedIndex(calendar.get(11));
                    this.minute1.setSelectedIndex(calendar.get(12));
                    this.second1.setSelectedIndex(calendar.get(13));
                } else if (interval == 5) {
                    this.hour2.setSelectedIndex(calendar.get(11));
                    this.minute2.setSelectedIndex(calendar.get(12));
                    this.second2.setSelectedIndex(calendar.get(13));
                }
            }
            if (this.dateType == 4L || this.dateType == 6L) {
                if (interval == 3) {
                    this.day1.setSelectedIndex(calendar.get(5) - 1);
                    this.month1.setSelectedIndex(calendar.get(2));
                    this.year1.setText(Integer.toString(calendar.get(1)));
                } else if (interval == 5) {
                    this.day2.setSelectedIndex(calendar.get(5) - 1);
                    this.month2.setSelectedIndex(calendar.get(2));
                    this.year2.setText(Integer.toString(calendar.get(1)));
                }
            }
        } else {
            this.setDefaults();
        }
        this.ignoreDateFieldEvents = false;
        List values = this.getSelectedValues();
        this.firePropertyChange("selectionChanged", null, values);
        if (this.filterDefinitionPanel != null) {
            this.filterDefinitionPanel.doValuesSelected(values);
        }
    }

    private void setDefaults() {
        this.calendar1.clear();
        this.calendar2.clear();
        Calendar currentCalendar = Calendar.getInstance();
        currentCalendar.setTime(new Date());
        this.day1.setSelectedIndex(currentCalendar.get(5) - 1);
        this.month1.setSelectedIndex(currentCalendar.get(2));
        this.year1.setText(Integer.toString(currentCalendar.get(1)));
        this.hour1.setSelectedIndex(12);
        this.minute1.setSelectedIndex(0);
        this.second1.setSelectedIndex(0);
        this.day2.setSelectedIndex(currentCalendar.get(5) - 1);
        this.month2.setSelectedIndex(currentCalendar.get(2));
        this.year2.setText(Integer.toString(currentCalendar.get(1)));
        this.hour2.setSelectedIndex(12);
        this.minute2.setSelectedIndex(0);
        this.second2.setSelectedIndex(0);
    }

    public void setSelectedValues(List values) {
        this.setDefaults();
        if (values != null && (values.size() == 1 || values.size() == 2)) {
            this.initializeFieldsWithDate(values.get(0), 3);
            if (values.size() == 2) {
                this.initializeFieldsWithDate(values.get(1), 5);
            }
        }
    }

    public List getSelectedValues() {
        ArrayList<Date> values = new ArrayList<Date>();
        values.add(this.getDate(3));
        if (this.isEndDateVisible) {
            values.add(this.getDate(5));
        }
        return values;
    }

    private Date getDate(int startOrEndDate) {
        Calendar cal;
        Calendar calendar = cal = startOrEndDate == 3 ? this.calendar1 : this.calendar2;
        if (!(this.dateType != 4L && this.dateType != 6L || cal.isSet(1))) {
            return null;
        }
        return cal.getTime();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (this.ignoreDateFieldEvents || source instanceof JComboBox && ((JComboBox)source).getSelectedIndex() == -1) {
            return;
        }
        if (source == this.day1 || source == this.month1 || source == this.hour1 || source == this.minute1 || source == this.second1) {
            this.updateDate(this.calendar1);
        } else if (source == this.day2 || source == this.month2 || source == this.hour2 || source == this.minute2 || source == this.second2) {
            this.updateDate(this.calendar2);
        }
        List values = this.getSelectedValues();
        this.firePropertyChange("selectionChanged", null, values);
        if (this.filterDefinitionPanel != null) {
            this.filterDefinitionPanel.doValuesSelected(values);
        }
    }

    private void updateDate(Calendar cal) {
        boolean isStartDate = cal == this.calendar1;
        int day = isStartDate ? this.day1.getSelectedIndex() + 1 : this.day2.getSelectedIndex() + 1;
        int month = isStartDate ? this.month1.getSelectedIndex() : this.month2.getSelectedIndex();
        int hour = isStartDate ? this.hour1.getSelectedIndex() : this.hour2.getSelectedIndex();
        int minute = isStartDate ? this.minute1.getSelectedIndex() : this.minute2.getSelectedIndex();
        int second = isStartDate ? this.second1.getSelectedIndex() : this.second2.getSelectedIndex();
        cal.set(5, day);
        cal.set(2, month);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
    }

    private class SingleDigitValueRenderer
    extends JLabel
    implements ListCellRenderer {
        public SingleDigitValueRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Integer && (Integer)value < 10) {
                String text = "0" + value.toString();
                this.setText(text);
            } else {
                this.setText(value == null ? "" : value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }

    class NumberDocument
    extends PlainDocument {
        NumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] strSource = str.toCharArray();
            for (int i = 0; i < strSource.length; ++i) {
                if (Character.isDigit(strSource[i])) continue;
                return;
            }
            super.insertString(offs, str, a);
        }
    }

    private class InnerDocumentListener
    implements DocumentListener {
        private InnerDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processDocumentEvent(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processDocumentEvent(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processDocumentEvent(e);
        }

        protected void processDocumentEvent(DocumentEvent e) {
            if (DateTimeValuePanel.this.ignoreDateFieldEvents) {
                return;
            }
            Document document = e.getDocument();
            if (document == DateTimeValuePanel.this.year1.getDocument() || document == DateTimeValuePanel.this.year2.getDocument()) {
                String year;
                boolean isStartYear = document == DateTimeValuePanel.this.year1.getDocument();
                Calendar cal = isStartYear ? DateTimeValuePanel.this.calendar1 : DateTimeValuePanel.this.calendar2;
                String string = year = isStartYear ? DateTimeValuePanel.this.year1.getText() : DateTimeValuePanel.this.year2.getText();
                if (year == null || year.length() == 0) {
                    if (isStartYear) {
                        DateTimeValuePanel.this.calendar1.clear(1);
                    } else {
                        DateTimeValuePanel.this.calendar2.clear(1);
                    }
                    DateTimeValuePanel.this.firePropertyChange("selectionComplete", false, DateTimeValuePanel.this.isSelectionComplete());
                } else {
                    try {
                        int y = Integer.parseInt(year);
                        if (isStartYear) {
                            DateTimeValuePanel.this.calendar1.set(1, y);
                            DateTimeValuePanel.this.updateDate(DateTimeValuePanel.this.calendar1);
                        } else {
                            DateTimeValuePanel.this.calendar2.set(1, y);
                            DateTimeValuePanel.this.updateDate(DateTimeValuePanel.this.calendar2);
                        }
                        DateTimeValuePanel.this.firePropertyChange("selectionComplete", false, true);
                    }
                    catch (NumberFormatException y) {
                        // empty catch block
                    }
                }
                List values = DateTimeValuePanel.this.getSelectedValues();
                DateTimeValuePanel.this.firePropertyChange("selectionChanged", null, values);
                if (DateTimeValuePanel.this.filterDefinitionPanel != null) {
                    DateTimeValuePanel.this.filterDefinitionPanel.doValuesSelected(values);
                }
            }
        }
    }
}

